<?php
/* Welcome to Bones :)
This is the core Bones file where most of the
main functions & features reside. If you have
any custom functions, it's best to put them
in the functions.php file.

Developed by: Eddie Machado
URL: http://themble.com/bones/
*/

/*********************
LAUNCH BONES
Let's fire off all the functions
and tools. I put it up here so it's
right up top and clean.
*********************/

add_action( 'after_switch_theme', 'cbt_after_switch_theme');

function cbt_after_switch_theme()
{
	update_option('cbt_do_auto_redux_compiler', 'yes');
}

// we're firing all out initial functions at the start
add_action( 'after_setup_theme', 'bones_ahoy', 16 );



function bones_ahoy() 
{
	//update_option('cbt_theme_version', '1.0' );

	// ------------------------------------------------------
	//  Handles all updating tasks
	// ------------------------------------------------------
	new Cbt_update();
	
	//echo '<pre>'.print_r( $theme->display('Version') , TRUE).'</pre>';
	//echo '<pre>'.print_r( get_option('cbt_theme_version') , TRUE).'</pre>';
	
    // launching operation cleanup
    add_action( 'init', 'bones_head_cleanup' );
    // remove WP version from RSS
    add_filter( 'the_generator', 'bones_rss_version' );
    // remove pesky injected css for recent comments widget
    add_filter( 'wp_head', 'bones_remove_wp_widget_recent_comments_style', 1 );
    // clean up comment styles in the head
    add_action( 'wp_head', 'bones_remove_recent_comments_style', 1 );
    // clean up gallery output in wp
    add_filter( 'gallery_style', 'bones_gallery_style' );

    // enqueue base scripts and styles
    add_action( 'wp_enqueue_scripts', 'bones_scripts_and_styles', 999 );
    // ie conditional wrapper

    // launching this stuff after theme setup
    bones_theme_support();

    // adding sidebars to Wordpress (these are created in functions.php)
    add_action( 'widgets_init', 'bones_register_sidebars' );
    // adding the bones search form (created in functions.php)
    // add_filter( 'get_search_form', 'bones_wpsearch' );

    // cleaning up random code around images
    add_filter( 'the_content', 'bones_filter_ptags_on_images' );
    // cleaning up excerpt
    add_filter( 'excerpt_more', 'bones_excerpt_more' );
    
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

} /* end bones ahoy */


/*********************
WP_HEAD GOODNESS
The default wordpress head is
a mess. Let's clean it up by
removing all the junk we don't
need.
*********************/

function bones_head_cleanup() 
{
	add_filter('st_preview_css', 'cbt_shortcode_preview_css');
	add_filter('st_preview_js', 'cbt_shortcode_preview_js');
	
	// category feeds
	// remove_action( 'wp_head', 'feed_links_extra', 3 );
	// post and comment feeds
	// remove_action( 'wp_head', 'feed_links', 2 );
	// EditURI link
	remove_action( 'wp_head', 'rsd_link' );
	// windows live writer
	remove_action( 'wp_head', 'wlwmanifest_link' );
	// index link
	remove_action( 'wp_head', 'index_rel_link' );
	// previous link
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
	// start link
	remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
	// links for adjacent posts
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
	// WP version
	remove_action( 'wp_head', 'wp_generator' );
	// remove WP version from css
	add_filter( 'style_loader_src', 'bones_remove_wp_ver_css_js', 9999 );
	// remove Wp version from scripts
	add_filter( 'script_loader_src', 'bones_remove_wp_ver_css_js', 9999 );

} /* end bones head cleanup */

// remove WP version from RSS
function bones_rss_version() { return ''; }

// remove WP version from scripts
function bones_remove_wp_ver_css_js( $src ) 
{
    if ( strpos( $src, 'ver=' ) )
        $src = remove_query_arg( 'ver', $src );
    return $src;
}

// remove injected CSS for recent comments widget
function bones_remove_wp_widget_recent_comments_style() 
{
   if ( has_filter( 'wp_head', 'wp_widget_recent_comments_style' ) ) {
      remove_filter( 'wp_head', 'wp_widget_recent_comments_style' );
   }
}

// remove injected CSS from recent comments widget
function bones_remove_recent_comments_style() 
{
  global $wp_widget_factory;
  if (isset($wp_widget_factory->widgets['WP_Widget_Recent_Comments'])) {
    remove_action( 'wp_head', array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style') );
  }
}

// remove injected CSS from gallery
function bones_gallery_style($css) 
{
  return preg_replace( "!<style type='text/css'>(.*?)</style>!s", '', $css );
}


function cbt_get_css()
{
  $cache_string = get_option('cbt_cache_string');
  if(! $cache_string) $cache_string = time();
  
	$css = get_template_directory_uri() . '/library/css/style.css';	
	if(is_multisite())
	{
		if(file_exists(get_template_directory() . '/library/css/style-blog-'.get_current_blog_id().'.css'))
		{
			$css = get_template_directory_uri() . '/library/css/style-blog-'.get_current_blog_id().'.css';
		}
	}
	
	//echo '<pre>'.print_r($css, TRUE).'</pre>';
	
	return $css.'?'.$cache_string;
}


// ------------------------------------------------------
//  Used in Page builder for shortcode preview
// ------------------------------------------------------
function cbt_shortcode_preview_js($js='')
{
	return array(
	  
	  // modernizr (without media query polyfill)
	  'bones-modernizr' => array(
		'src'  => get_template_directory_uri() . '/library/js/libs/modernizr.custom.min.js',
		'ver'  => '2.5.3',
		'deps' => array( 'jquery' ),
		'in_footer' => false,
	  ),
	  
	  // Youtube Video background
	  'YTPlayer-js' => array(
		'src'  => get_template_directory_uri() . '/library/js/libs/YTPlayer/jquery.mb.YTPlayer.js',
		'ver'  => '',
		'deps' => array( 'jquery' ),
		'in_footer' => true,
	  ),
	  
	  // Hosted video background
	  'Videojs-n-BigVideo-js' => array(
		'src'  => get_template_directory_uri() . '/library/js/libs/BigVideo/Videojs-n-BigVideo.js',
		'ver'  => '',
		'deps' => array( 'jquery' ),
		'in_footer' => true,
	  ),
	  
	  // Adding scripts file in the footer
	  'bones-js' => array(
		'src'  => get_template_directory_uri() . '/library/js/scripts.min.js',
		'ver'  => '',
		'deps' => array( 'jquery' ),
		'in_footer' => true,
	  ),
	);
}

// ------------------------------------------------------
//  Used in Page builder for shortcode preview
// ------------------------------------------------------
function cbt_shortcode_preview_css($css='')
{
	return cbt_get_css();
}

/*********************
SCRIPTS & ENQUEUEING
*********************/

// loading modernizr and jquery, and reply script
function bones_scripts_and_styles() 
{
  global $wp_styles; // call global $wp_styles variable to add conditional wrapper around ie stylesheet the WordPress way

  
  	if (is_admin()) return;
  
  	foreach(cbt_shortcode_preview_js() as $key=>$val)
  	{
	  	wp_register_script( $key, $val['src'], $val['deps'], $val['ver'], $val['in_footer'] );
  	}

    // modernizr (without media query polyfill)
    //wp_register_script( 'bones-modernizr', get_template_directory_uri() . '/library/js/libs/modernizr.custom.min.js', array('jquery'), '2.5.3', false );

    // register main stylesheet
    wp_register_style( 'bones-stylesheet', cbt_get_css(), array(), '', 'all' );
    
 //    if ( class_exists( 'WooCommerce' ) )
 //    {
	//     wp_register_style( 'cbt-woocommerce', get_template_directory_uri() . '/library/css/woocommerce.css', array('bones-stylesheet'), '', 'all' );
	// }

    // ie-only style sheet
    wp_register_style( 'bones-ie-only', get_template_directory_uri() . '/library/css/ie.css', array(), '' );

    // ------------------------------------------------------
    //  Youtube Video background
    // ------------------------------------------------------
    //wp_register_script( 'YTPlayer-js', get_template_directory_uri() . '/library/js/libs/YTPlayer/jquery.mb.YTPlayer.js', array('jquery'), '', TRUE );
    wp_register_style( 'YTPlayer-css', get_template_directory_uri() . '/library/js/libs/YTPlayer/YTPlayer.css', array(), '' );
    
    // ------------------------------------------------------
    //  Hosted video background
    // ------------------------------------------------------
    //wp_register_script( 'Videojs-n-BigVideo-js', get_template_directory_uri() . '/library/js/libs/BigVideo/Videojs-n-BigVideo.js', array('jquery'), '', TRUE );
    wp_register_style( 'BigVideo-css', get_template_directory_uri() . '/library/js/libs/BigVideo/bigvideo.css', array(), '' );


    // comment reply script for threaded comments
    if ( is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
		wp_enqueue_script( 'comment-reply' );
    }

    //adding scripts file in the footer
    //wp_register_script( 'bones-js', get_template_directory_uri() . '/library/js/scripts.min.js', array( 'jquery' ), '', true );


    // enqueue styles and scripts
    wp_enqueue_script( 'bones-modernizr' );
    wp_enqueue_style( 'bones-stylesheet' );
    if ( class_exists( 'WooCommerce' ) )
    {
	    wp_enqueue_style( 'cbt-woocommerce' );
	    wp_dequeue_style( 'wcqi-css' );
	}
    wp_enqueue_style( 'bones-ie-only' );

    $wp_styles->add_data( 'bones-ie-only', 'conditional', 'lt IE 9' ); // add conditional wrapper around ie stylesheet

    /*
    I recommend using a plugin to call jQuery
    using the google cdn. That way it stays cached
    and your site will load faster.
    */
    wp_enqueue_script( 'jquery' );
    wp_enqueue_script( 'bones-js' );


}


/*********************
THEME SUPPORT
*********************/

// Adding WP 3+ Functions & Theme Support
function bones_theme_support() 
{
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );


	// wp thumbnails (sizes handled in functions.php)
	add_theme_support( 'post-thumbnails' );

	// default thumb size
	set_post_thumbnail_size(125, 125, true);

	// rss thingy
	add_theme_support('automatic-feed-links');

	// to add header image support go here: http://themble.com/support/adding-header-background-image-support/

	// adding post format support
	add_theme_support( 'post-formats',
		array(
			'aside',             // title less blurb
			'gallery',           // gallery of images
			'link',              // quick link to other site
			'image',             // an image
			'quote',             // a quick quote
			'status',            // a Facebook like status update
			'video',             // video
			'audio',             // audio
			'chat'               // chat transcript
		)
	);

	// wp menus
	add_theme_support( 'menus' );
	
	$menus = array(
			'main-nav' => __( 'The Main Menu', 'cbt' ),   // main nav in header
			'footer-nav' => __( 'Footer Menu', 'cbt' ),   // 
		);

	$custom_menus = get_option('cbb_custom_menus');
	if($custom_menus && is_array($custom_menus))
	{
		$menus = array_merge($menus, $custom_menus);
	}

	// registering wp3+ menus
	register_nav_menus($menus);
} /* end bones theme support */


/*********************
MENUS & NAVIGATION
*********************/

// the main menu
function bones_main_nav($align = 'right') 
{
	global $cbt_options;

	// display the wp3 menu if available
    wp_nav_menu(array(
    	'container' => false,                           			// remove nav container
    	'container_class' => 'menu clearfix',           			// class of container (should you choose to use it)
    	'menu' => __( 'The Main Menu', 'cbt' ),  			// nav name
    	'menu_class' => 'nav navbar-nav navbar-'.$align,  			// adding custom nav class
    	'theme_location' => 'main-nav',                 			// where it's located in the theme
    	'before' => '',                                 			// before the menu
      'after' => '',                                  			// after the menu
      'link_before' => '',                            			// before each link
      'link_after' => '',                             			// after each link
      'depth' => 12,                                   			// limit the depth of the nav
      'fallback_cb' => 'wp_bootstrap_navwalker::fallback',	// fallback
    	'walker' => new wp_bootstrap_navwalker()        			// for bootstrap nav
	));
} /* end bones main nav */

// this is the fallback for header menu
function bones_main_nav_fallback() 
{
	wp_page_menu( array(
		'show_home' => true,
    	'menu_class' => 'nav top-nav clearfix',      // adding custom nav class
		'include'     => '',
		'exclude'     => '',
		'echo'        => true,
        'link_before' => '',                            // before each link
        'link_after' => ''                             // after each link
	) );
}

// this is the fallback for footer menu
function bones_footer_links_fallback() 
{
	/* you can put a default here if you like */
}

/*********************
RELATED POSTS FUNCTION
*********************/

// Related Posts Function (call using bones_related_posts(); )
function bones_related_posts() 
{
	echo '<ul id="bones-related-posts">';
	global $post;
	$tags = wp_get_post_tags( $post->ID );
	if($tags) {
		foreach( $tags as $tag ) { 
			$tag_arr .= $tag->slug . ',';
		}
        $args = array(
        	'tag' => $tag_arr,
        	'numberposts' => 5, /* you can change this to show more */
        	'post__not_in' => array($post->ID)
     	);
        $related_posts = get_posts( $args );
        if($related_posts) {
        	foreach ( $related_posts as $post ) : setup_postdata( $post ); ?>
	           	<li class="related_post"><a class="entry-unrelated" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></li>
	        <?php endforeach; }
	    else { ?>
            <?php echo '<li class="no_related_post">' . __( 'No Related Posts Yet!', 'cbt' ) . '</li>'; ?>
		<?php }
	}
	wp_reset_query();
	echo '</ul>';
} /* end bones related posts function */

/*********************
PAGE NAVI
*********************/

// Numeric Page Navi (built into the theme by default)
function bones_page_navi() 
{
	global $wp_query;
	$bignum = 999999999;
	if ( $wp_query->max_num_pages <= 1 )
	return;
	
	echo '<nav class="pagination">';
	
		echo paginate_links( array(
			'base' 			=> str_replace( $bignum, '%#%', esc_url( get_pagenum_link($bignum) ) ),
			'format' 		=> '',
			'current' 		=> max( 1, get_query_var('paged') ),
			'total' 		=> $wp_query->max_num_pages,
			'prev_text' 	=> '&larr;',
			'next_text' 	=> '&rarr;',
			'type'			=> 'list',
			'end_size'		=> 3,
			'mid_size'		=> 3
		) );
	
	echo '</nav>';
} /* end page navi */

/*********************
RANDOM CLEANUP ITEMS
*********************/

// remove the p from around imgs (http://css-tricks.com/snippets/wordpress/remove-paragraph-tags-from-around-images/)
function bones_filter_ptags_on_images($content)
{
   return preg_replace('/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content);
}

// This removes the annoying […] to a Read More link
function bones_excerpt_more($more) 
{
	global $post;
	// edit here if you like
	return '...</p><p><a class="excerpt-read-more btn btn-primary" href="'. get_permalink($post->ID) . '" title="'. __( 'Read', 'cbt' ) . get_the_title($post->ID).'">'. __( 'Read More', 'cbt' ) .'</a>';
}

/*
 * This is a modified the_author_posts_link() which just returns the link.
 *
 * This is necessary to allow usage of the usual l10n process with printf().
 */
function bones_get_the_author_posts_link() 
{
	global $authordata;
	if ( !is_object( $authordata ) )
		return false;
	$link = sprintf(
		'<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
		get_author_posts_url( $authordata->ID, $authordata->user_nicename ),
		esc_attr( sprintf( __( 'Posts by %s' ), get_the_author() ) ), // No further l10n needed, core will take care of this one
		ucwords(get_the_author())
	);
	return $link;
}



/**
 * Custom callback for outputting comments 
 *
 * @return void
 * @author Keir Whitaker
 */
function bones_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment; 
	?>
	<?php if ( $comment->comment_approved == '1' ): ?>
	<li class="media">
		<div class="media-left">
			<?php echo get_avatar( $comment ); ?>
		</div>
		<div class="media-body">
			<h4 class="media-heading"><?php comment_author_link() ?></h4>
			<time><a href="#comment-<?php comment_ID() ?>" pubdate><?php comment_date() ?> at <?php comment_time() ?></a></time>
			<?php comment_text() ?>
		</div>
	<?php endif;
}
