// ------------------------------------------------------
//  yunus edit - replaced icons with font awesome
// ------------------------------------------------------
(
    function ($) {
        var JSNIconSelector = function (params) {

        }
        JSNIconSelector.prototype = {
            GenerateSelector:function (container, actionSelector, value) {
                var self = this;
                var resultsFilter = $("<ul/>", {"class":"jsn-items-list"});
                $("#jsn-quicksearch-icons").val("");
                $(container).find(".jsn-reset-search").hide();
                self.renderListIconSelector(resultsFilter, self.Icomoon(), actionSelector, value);
                $.fn.delayKeyup = function (callback, ms) {
                    var timer = 0;
                    var el = $(this);
                    $(this).keyup(function () {
                        clearTimeout(timer);
                        timer = setTimeout(function () {
                            callback(el)
                        }, ms);
                    });
                    return $(this);
                };
                var oldIconFilter = "";
                return $("<div/>", {"class":"jsn-iconselector"}).append(
                    $("<div/>", {"class":"jsn-fieldset-filter"}).append(
                        $("<fieldset/>").append(
                            $("<div/>", {"class":"jsn-quick-search"}).append(
                                $("<input/>", {"class":"input input-sm search-query form-control", "type":"text","id":"jsn-quicksearch-icons", "placeholder":"Search..."}).delayKeyup(function (el) {
                                    if ($(el).val() != oldIconFilter) {
                                        oldIconFilter = $(el).val();
                                        self.filterResults($(el).val(), resultsFilter);
                                    }
                                    if($(el).val() == ""){
                                        $(el).parents(".jsn-iconselector").find(".jsn-reset-search").hide();
                                    }else{
                                        $(el).parents(".jsn-iconselector").find(".jsn-reset-search").show();
                                    }
                                }, 500)
                            ).append(
                                $("<a/>",{"href":"javascript:void(0);","title":"Clear Search","class":"jsn-reset-search"}).append($("<i/>",{"class":"icon-remove"})).click(function(){
                                    $(this).parents(".jsn-iconselector").find("#jsn-quicksearch-icons").val("");
                                    oldIconFilter = "";
                                    self.filterResults("", resultsFilter);
                                    $(this).hide();
                                })
                            )
                        )
                    )
                ).append(resultsFilter);

            },
            filterResults:function (value, resultsFilter) {
                $(resultsFilter).find("li").hide();
                if (value != "") {
                    $(resultsFilter).find("li").each(function () {
                        var textField = $(this).find("a").attr("data-value").toLowerCase();
                        textField = textField.replace('icon-', '');
                        if (textField.search(value.toLowerCase()) == -1) {
                            $(this).hide();
                        } else {
                            $(this).fadeIn(1200);
                        }
                    });
                } else {
                    $(resultsFilter).find("li").each(function () {
                        $(this).fadeIn(1200);
                    });
                }
            },
            renderListIconSelector:function ( container, list, actionSelector, valueDefault) {
                $(container).find("li").removeClass("active");
                $(container).html("");

                var _nonIconClass   = 'jsn-item';
                if (!valueDefault) {
                    _nonIconClass   = 'jsn-item active';
                }
                $(container).append(
                        $("<li/>", {'class': _nonIconClass}).append(
                            $("<a/>", {"href":"javascript:void(0)", "class":"icons-item st-tooltip-icon", "data-value":'', "data-original-title": ''}).append($("<i/>", {"class":'icon-'})).append('None').click(function () {
                                actionSelector(this);
                                $('[data-title-prepend]').trigger('change');
                            })
                        )
                );

                $.each(list, function (value, title) {
                    var classActive = {"class":"jsn-item"};
                    if (value == valueDefault) {
                        classActive = {"class":"jsn-item active"};
                    }
                    $(container).append(
                        $("<li/>", classActive).append(
                            $("<a/>", {"href":"javascript:void(0)", "class":"icons-item st-tooltip-icon", "data-value":value, "data-original-title": title}).append($("<i/>", {"class":value})).click(function () {
                                actionSelector(this);
                                $('[data-title-prepend]').trigger('change');
                            })
                        )
                    );
                });
            },
            Icomoon:function () {
                return {
'fa fa-glass':'glass',
'fa fa-music':'music',
'fa fa-search':'search',
'fa fa-envelope-o':'envelope-o',
'fa fa-heart':'heart',
'fa fa-star':'star',
'fa fa-star-o':'star-o',
'fa fa-user':'user',
'fa fa-film':'film',
'fa fa-th-large':'th-large',
'fa fa-th':'th',
'fa fa-th-list':'th-list',
'fa fa-check':'check',
'fa fa-times':'times',
'fa fa-search-plus':'search-plus',
'fa fa-search-minus':'search-minus',
'fa fa-power-off':'power-off',
'fa fa-signal':'signal',
'fa fa-gear':'gear',
'fa fa-cog':'cog',
'fa fa-trash-o':'trash-o',
'fa fa-home':'home',
'fa fa-file-o':'file-o',
'fa fa-clock-o':'clock-o',
'fa fa-road':'road',
'fa fa-download':'download',
'fa fa-arrow-circle-o-down':'arrow-circle-o-down',
'fa fa-arrow-circle-o-up':'arrow-circle-o-up',
'fa fa-inbox':'inbox',
'fa fa-play-circle-o':'play-circle-o',
'fa fa-rotate-right':'rotate-right',
'fa fa-repeat':'repeat',
'fa fa-refresh':'refresh',
'fa fa-list-alt':'list-alt',
'fa fa-lock':'lock',
'fa fa-flag':'flag',
'fa fa-headphones':'headphones',
'fa fa-volume-off':'volume-off',
'fa fa-volume-down':'volume-down',
'fa fa-volume-up':'volume-up',
'fa fa-qrcode':'qrcode',
'fa fa-barcode':'barcode',
'fa fa-tag':'tag',
'fa fa-tags':'tags',
'fa fa-book':'book',
'fa fa-bookmark':'bookmark',
'fa fa-print':'print',
'fa fa-camera':'camera',
'fa fa-font':'font',
'fa fa-bold':'bold',
'fa fa-italic':'italic',
'fa fa-text-height':'text-height',
'fa fa-text-width':'text-width',
'fa fa-align-left':'align-left',
'fa fa-align-center':'align-center',
'fa fa-align-right':'align-right',
'fa fa-align-justify':'align-justify',
'fa fa-list':'list',
'fa fa-dedent':'dedent',
'fa fa-outdent':'outdent',
'fa fa-indent':'indent',
'fa fa-video-camera':'video-camera',
'fa fa-photo':'photo',
'fa fa-image':'image',
'fa fa-picture-o':'picture-o',
'fa fa-pencil':'pencil',
'fa fa-map-marker':'map-marker',
'fa fa-adjust':'adjust',
'fa fa-tint':'tint',
'fa fa-edit':'edit',
'fa fa-pencil-square-o':'pencil-square-o',
'fa fa-share-square-o':'share-square-o',
'fa fa-check-square-o':'check-square-o',
'fa fa-arrows':'arrows',
'fa fa-step-backward':'step-backward',
'fa fa-fast-backward':'fast-backward',
'fa fa-backward':'backward',
'fa fa-play':'play',
'fa fa-pause':'pause',
'fa fa-stop':'stop',
'fa fa-forward':'forward',
'fa fa-fast-forward':'fast-forward',
'fa fa-step-forward':'step-forward',
'fa fa-eject':'eject',
'fa fa-chevron-left':'chevron-left',
'fa fa-chevron-right':'chevron-right',
'fa fa-plus-circle':'plus-circle',
'fa fa-minus-circle':'minus-circle',
'fa fa-times-circle':'times-circle',
'fa fa-check-circle':'check-circle',
'fa fa-question-circle':'question-circle',
'fa fa-info-circle':'info-circle',
'fa fa-crosshairs':'crosshairs',
'fa fa-times-circle-o':'times-circle-o',
'fa fa-check-circle-o':'check-circle-o',
'fa fa-ban':'ban',
'fa fa-arrow-left':'arrow-left',
'fa fa-arrow-right':'arrow-right',
'fa fa-arrow-up':'arrow-up',
'fa fa-arrow-down':'arrow-down',
'fa fa-mail-forward':'mail-forward',
'fa fa-share':'share',
'fa fa-expand':'expand',
'fa fa-compress':'compress',
'fa fa-plus':'plus',
'fa fa-minus':'minus',
'fa fa-asterisk':'asterisk',
'fa fa-exclamation-circle':'exclamation-circle',
'fa fa-gift':'gift',
'fa fa-leaf':'leaf',
'fa fa-fire':'fire',
'fa fa-eye':'eye',
'fa fa-eye-slash':'eye-slash',
'fa fa-warning':'warning',
'fa fa-exclamation-triangle':'exclamation-triangle',
'fa fa-plane':'plane',
'fa fa-calendar':'calendar',
'fa fa-random':'random',
'fa fa-comment':'comment',
'fa fa-magnet':'magnet',
'fa fa-chevron-up':'chevron-up',
'fa fa-chevron-down':'chevron-down',
'fa fa-retweet':'retweet',
'fa fa-shopping-cart':'shopping-cart',
'fa fa-folder':'folder',
'fa fa-folder-open':'folder-open',
'fa fa-arrows-v':'arrows-v',
'fa fa-arrows-h':'arrows-h',
'fa fa-bar-chart-o':'bar-chart-o',
'fa fa-twitter-square':'twitter-square',
'fa fa-facebook-square':'facebook-square',
'fa fa-camera-retro':'camera-retro',
'fa fa-key':'key',
'fa fa-gears':'gears',
'fa fa-cogs':'cogs',
'fa fa-comments':'comments',
'fa fa-thumbs-o-up':'thumbs-o-up',
'fa fa-thumbs-o-down':'thumbs-o-down',
'fa fa-star-half':'star-half',
'fa fa-heart-o':'heart-o',
'fa fa-sign-out':'sign-out',
'fa fa-linkedin-square':'linkedin-square',
'fa fa-thumb-tack':'thumb-tack',
'fa fa-external-link':'external-link',
'fa fa-sign-in':'sign-in',
'fa fa-trophy':'trophy',
'fa fa-github-square':'github-square',
'fa fa-upload':'upload',
'fa fa-lemon-o':'lemon-o',
'fa fa-phone':'phone',
'fa fa-square-o':'square-o',
'fa fa-bookmark-o':'bookmark-o',
'fa fa-phone-square':'phone-square',
'fa fa-twitter':'twitter',
'fa fa-facebook':'facebook',
'fa fa-github':'github',
'fa fa-unlock':'unlock',
'fa fa-credit-card':'credit-card',
'fa fa-rss':'rss',
'fa fa-hdd-o':'hdd-o',
'fa fa-bullhorn':'bullhorn',
'fa fa-bell':'bell',
'fa fa-certificate':'certificate',
'fa fa-hand-o-right':'hand-o-right',
'fa fa-hand-o-left':'hand-o-left',
'fa fa-hand-o-up':'hand-o-up',
'fa fa-hand-o-down':'hand-o-down',
'fa fa-arrow-circle-left':'arrow-circle-left',
'fa fa-arrow-circle-right':'arrow-circle-right',
'fa fa-arrow-circle-up':'arrow-circle-up',
'fa fa-arrow-circle-down':'arrow-circle-down',
'fa fa-globe':'globe',
'fa fa-wrench':'wrench',
'fa fa-tasks':'tasks',
'fa fa-filter':'filter',
'fa fa-briefcase':'briefcase',
'fa fa-arrows-alt':'arrows-alt',
'fa fa-group':'group',
'fa fa-users':'users',
'fa fa-chain':'chain',
'fa fa-link':'link',
'fa fa-cloud':'cloud',
'fa fa-flask':'flask',
'fa fa-cut':'cut',
'fa fa-scissors':'scissors',
'fa fa-copy':'copy',
'fa fa-files-o':'files-o',
'fa fa-paperclip':'paperclip',
'fa fa-save':'save',
'fa fa-floppy-o':'floppy-o',
'fa fa-square':'square',
'fa fa-navicon':'navicon',
'fa fa-reorder':'reorder',
'fa fa-bars':'bars',
'fa fa-list-ul':'list-ul',
'fa fa-list-ol':'list-ol',
'fa fa-strikethrough':'strikethrough',
'fa fa-underline':'underline',
'fa fa-table':'table',
'fa fa-magic':'magic',
'fa fa-truck':'truck',
'fa fa-pinterest':'pinterest',
'fa fa-pinterest-square':'pinterest-square',
'fa fa-google-plus-square':'google-plus-square',
'fa fa-google-plus':'google-plus',
'fa fa-money':'money',
'fa fa-caret-down':'caret-down',
'fa fa-caret-up':'caret-up',
'fa fa-caret-left':'caret-left',
'fa fa-caret-right':'caret-right',
'fa fa-columns':'columns',
'fa fa-unsorted':'unsorted',
'fa fa-sort':'sort',
'fa fa-sort-down':'sort-down',
'fa fa-sort-desc':'sort-desc',
'fa fa-sort-up':'sort-up',
'fa fa-sort-asc':'sort-asc',
'fa fa-envelope':'envelope',
'fa fa-linkedin':'linkedin',
'fa fa-rotate-left':'rotate-left',
'fa fa-undo':'undo',
'fa fa-legal':'legal',
'fa fa-gavel':'gavel',
'fa fa-dashboard':'dashboard',
'fa fa-tachometer':'tachometer',
'fa fa-comment-o':'comment-o',
'fa fa-comments-o':'comments-o',
'fa fa-flash':'flash',
'fa fa-bolt':'bolt',
'fa fa-sitemap':'sitemap',
'fa fa-umbrella':'umbrella',
'fa fa-paste':'paste',
'fa fa-clipboard':'clipboard',
'fa fa-lightbulb-o':'lightbulb-o',
'fa fa-exchange':'exchange',
'fa fa-cloud-download':'cloud-download',
'fa fa-cloud-upload':'cloud-upload',
'fa fa-user-md':'user-md',
'fa fa-stethoscope':'stethoscope',
'fa fa-suitcase':'suitcase',
'fa fa-bell-o':'bell-o',
'fa fa-coffee':'coffee',
'fa fa-cutlery':'cutlery',
'fa fa-file-text-o':'file-text-o',
'fa fa-building-o':'building-o',
'fa fa-hospital-o':'hospital-o',
'fa fa-ambulance':'ambulance',
'fa fa-medkit':'medkit',
'fa fa-fighter-jet':'fighter-jet',
'fa fa-beer':'beer',
'fa fa-h-square':'h-square',
'fa fa-plus-square':'plus-square',
'fa fa-angle-double-left':'angle-double-left',
'fa fa-angle-double-right':'angle-double-right',
'fa fa-angle-double-up':'angle-double-up',
'fa fa-angle-double-down':'angle-double-down',
'fa fa-angle-left':'angle-left',
'fa fa-angle-right':'angle-right',
'fa fa-angle-up':'angle-up',
'fa fa-angle-down':'angle-down',
'fa fa-desktop':'desktop',
'fa fa-laptop':'laptop',
'fa fa-tablet':'tablet',
'fa fa-mobile-phone':'mobile-phone',
'fa fa-mobile':'mobile',
'fa fa-circle-o':'circle-o',
'fa fa-quote-left':'quote-left',
'fa fa-quote-right':'quote-right',
'fa fa-spinner':'spinner',
'fa fa-circle':'circle',
'fa fa-mail-reply':'mail-reply',
'fa fa-reply':'reply',
'fa fa-github-alt':'github-alt',
'fa fa-folder-o':'folder-o',
'fa fa-folder-open-o':'folder-open-o',
'fa fa-smile-o':'smile-o',
'fa fa-frown-o':'frown-o',
'fa fa-meh-o':'meh-o',
'fa fa-gamepad':'gamepad',
'fa fa-keyboard-o':'keyboard-o',
'fa fa-flag-o':'flag-o',
'fa fa-flag-checkered':'flag-checkered',
'fa fa-terminal':'terminal',
'fa fa-code':'code',
'fa fa-mail-reply-all':'mail-reply-all',
'fa fa-reply-all':'reply-all',
'fa fa-star-half-empty':'star-half-empty',
'fa fa-star-half-full':'star-half-full',
'fa fa-star-half-o':'star-half-o',
'fa fa-location-arrow':'location-arrow',
'fa fa-crop':'crop',
'fa fa-code-fork':'code-fork',
'fa fa-unlink':'unlink',
'fa fa-chain-broken':'chain-broken',
'fa fa-question':'question',
'fa fa-info':'info',
'fa fa-exclamation':'exclamation',
'fa fa-superscript':'superscript',
'fa fa-subscript':'subscript',
'fa fa-eraser':'eraser',
'fa fa-puzzle-piece':'puzzle-piece',
'fa fa-microphone':'microphone',
'fa fa-microphone-slash':'microphone-slash',
'fa fa-shield':'shield',
'fa fa-calendar-o':'calendar-o',
'fa fa-fire-extinguisher':'fire-extinguisher',
'fa fa-rocket':'rocket',
'fa fa-maxcdn':'maxcdn',
'fa fa-chevron-circle-left':'chevron-circle-left',
'fa fa-chevron-circle-right':'chevron-circle-right',
'fa fa-chevron-circle-up':'chevron-circle-up',
'fa fa-chevron-circle-down':'chevron-circle-down',
'fa fa-html5':'html5',
'fa fa-css3':'css3',
'fa fa-anchor':'anchor',
'fa fa-unlock-alt':'unlock-alt',
'fa fa-bullseye':'bullseye',
'fa fa-ellipsis-h':'ellipsis-h',
'fa fa-ellipsis-v':'ellipsis-v',
'fa fa-rss-square':'rss-square',
'fa fa-play-circle':'play-circle',
'fa fa-ticket':'ticket',
'fa fa-minus-square':'minus-square',
'fa fa-minus-square-o':'minus-square-o',
'fa fa-level-up':'level-up',
'fa fa-level-down':'level-down',
'fa fa-check-square':'check-square',
'fa fa-pencil-square':'pencil-square',
'fa fa-external-link-square':'external-link-square',
'fa fa-share-square':'share-square',
'fa fa-compass':'compass',
'fa fa-toggle-down':'toggle-down',
'fa fa-caret-square-o-down':'caret-square-o-down',
'fa fa-toggle-up':'toggle-up',
'fa fa-caret-square-o-up':'caret-square-o-up',
'fa fa-toggle-right':'toggle-right',
'fa fa-caret-square-o-right':'caret-square-o-right',
'fa fa-euro':'euro',
'fa fa-eur':'eur',
'fa fa-gbp':'gbp',
'fa fa-dollar':'dollar',
'fa fa-usd':'usd',
'fa fa-rupee':'rupee',
'fa fa-inr':'inr',
'fa fa-cny':'cny',
'fa fa-rmb':'rmb',
'fa fa-yen':'yen',
'fa fa-jpy':'jpy',
'fa fa-ruble':'ruble',
'fa fa-rouble':'rouble',
'fa fa-rub':'rub',
'fa fa-won':'won',
'fa fa-krw':'krw',
'fa fa-bitcoin':'bitcoin',
'fa fa-btc':'btc',
'fa fa-file':'file',
'fa fa-file-text':'file-text',
'fa fa-sort-alpha-asc':'sort-alpha-asc',
'fa fa-sort-alpha-desc':'sort-alpha-desc',
'fa fa-sort-amount-asc':'sort-amount-asc',
'fa fa-sort-amount-desc':'sort-amount-desc',
'fa fa-sort-numeric-asc':'sort-numeric-asc',
'fa fa-sort-numeric-desc':'sort-numeric-desc',
'fa fa-thumbs-up':'thumbs-up',
'fa fa-thumbs-down':'thumbs-down',
'fa fa-youtube-square':'youtube-square',
'fa fa-youtube':'youtube',
'fa fa-xing':'xing',
'fa fa-xing-square':'xing-square',
'fa fa-youtube-play':'youtube-play',
'fa fa-dropbox':'dropbox',
'fa fa-stack-overflow':'stack-overflow',
'fa fa-instagram':'instagram',
'fa fa-flickr':'flickr',
'fa fa-adn':'adn',
'fa fa-bitbucket':'bitbucket',
'fa fa-bitbucket-square':'bitbucket-square',
'fa fa-tumblr':'tumblr',
'fa fa-tumblr-square':'tumblr-square',
'fa fa-long-arrow-down':'long-arrow-down',
'fa fa-long-arrow-up':'long-arrow-up',
'fa fa-long-arrow-left':'long-arrow-left',
'fa fa-long-arrow-right':'long-arrow-right',
'fa fa-apple':'apple',
'fa fa-windows':'windows',
'fa fa-android':'android',
'fa fa-linux':'linux',
'fa fa-dribbble':'dribbble',
'fa fa-skype':'skype',
'fa fa-foursquare':'foursquare',
'fa fa-trello':'trello',
'fa fa-female':'female',
'fa fa-male':'male',
'fa fa-gittip':'gittip',
'fa fa-sun-o':'sun-o',
'fa fa-moon-o':'moon-o',
'fa fa-archive':'archive',
'fa fa-bug':'bug',
'fa fa-vk':'vk',
'fa fa-weibo':'weibo',
'fa fa-renren':'renren',
'fa fa-pagelines':'pagelines',
'fa fa-stack-exchange':'stack-exchange',
'fa fa-arrow-circle-o-right':'arrow-circle-o-right',
'fa fa-arrow-circle-o-left':'arrow-circle-o-left',
'fa fa-toggle-left':'toggle-left',
'fa fa-caret-square-o-left':'caret-square-o-left',
'fa fa-dot-circle-o':'dot-circle-o',
'fa fa-wheelchair':'wheelchair',
'fa fa-vimeo-square':'vimeo-square',
'fa fa-turkish-lira':'turkish-lira',
'fa fa-try':'try',
'fa fa-plus-square-o':'plus-square-o',
'fa fa-space-shuttle':'space-shuttle',
'fa fa-slack':'slack',
'fa fa-envelope-square':'envelope-square',
'fa fa-wordpress':'wordpress',
'fa fa-openid':'openid',
'fa fa-institution':'institution',
'fa fa-bank':'bank',
'fa fa-university':'university',
'fa fa-mortar-board':'mortar-board',
'fa fa-graduation-cap':'graduation-cap',
'fa fa-yahoo':'yahoo',
'fa fa-google':'google',
'fa fa-reddit':'reddit',
'fa fa-reddit-square':'reddit-square',
'fa fa-stumbleupon-circle':'stumbleupon-circle',
'fa fa-stumbleupon':'stumbleupon',
'fa fa-delicious':'delicious',
'fa fa-digg':'digg',
'fa fa-pied-piper-square':'pied-piper-square',
'fa fa-pied-piper':'pied-piper',
'fa fa-pied-piper-alt':'pied-piper-alt',
'fa fa-drupal':'drupal',
'fa fa-joomla':'joomla',
'fa fa-language':'language',
'fa fa-fax':'fax',
'fa fa-building':'building',
'fa fa-child':'child',
'fa fa-paw':'paw',
'fa fa-spoon':'spoon',
'fa fa-cube':'cube',
'fa fa-cubes':'cubes',
'fa fa-behance':'behance',
'fa fa-behance-square':'behance-square',
'fa fa-steam':'steam',
'fa fa-steam-square':'steam-square',
'fa fa-recycle':'recycle',
'fa fa-automobile':'automobile',
'fa fa-car':'car',
'fa fa-cab':'cab',
'fa fa-taxi':'taxi',
'fa fa-tree':'tree',
'fa fa-spotify':'spotify',
'fa fa-deviantart':'deviantart',
'fa fa-soundcloud':'soundcloud',
'fa fa-database':'database',
'fa fa-file-pdf-o':'file-pdf-o',
'fa fa-file-word-o':'file-word-o',
'fa fa-file-excel-o':'file-excel-o',
'fa fa-file-powerpoint-o':'file-powerpoint-o',
'fa fa-file-photo-o':'file-photo-o',
'fa fa-file-picture-o':'file-picture-o',
'fa fa-file-image-o':'file-image-o',
'fa fa-file-zip-o':'file-zip-o',
'fa fa-file-archive-o':'file-archive-o',
'fa fa-file-sound-o':'file-sound-o',
'fa fa-file-audio-o':'file-audio-o',
'fa fa-file-movie-o':'file-movie-o',
'fa fa-file-video-o':'file-video-o',
'fa fa-file-code-o':'file-code-o',
'fa fa-vine':'vine',
'fa fa-codepen':'codepen',
'fa fa-jsfiddle':'jsfiddle',
'fa fa-life-bouy':'life-bouy',
'fa fa-life-saver':'life-saver',
'fa fa-support':'support',
'fa fa-life-ring':'life-ring',
'fa fa-circle-o-notch':'circle-o-notch',
'fa fa-ra':'ra',
'fa fa-rebel':'rebel',
'fa fa-ge':'ge',
'fa fa-empire':'empire',
'fa fa-git-square':'git-square',
'fa fa-git':'git',
'fa fa-hacker-news':'hacker-news',
'fa fa-tencent-weibo':'tencent-weibo',
'fa fa-qq':'qq',
'fa fa-wechat':'wechat',
'fa fa-weixin':'weixin',
'fa fa-send':'send',
'fa fa-paper-plane':'paper-plane',
'fa fa-send-o':'send-o',
'fa fa-paper-plane-o':'paper-plane-o',
'fa fa-history':'history',
'fa fa-circle-thin':'circle-thin',
'fa fa-header':'header',
'fa fa-paragraph':'paragraph',
'fa fa-sliders':'sliders',
'fa fa-share-alt':'share-alt',
'fa fa-share-alt-square':'share-alt-square',
'fa fa-bomb':'bomb'
                }
            }
        }

        $(document).ready(function() {
            var bind_icon_picker = function( wrapper ){
                var elm = (wrapper != null) ? $(".icon_selector", wrapper) : $(".icon_selector");
                var selector;
                
                // ------------------------------------------------------
                //  YUNUS EDIT
                // ------------------------------------------------------
                $(elm).each(function ()
                {
                    selector = $(this);
                    if(selector.first().children('.jsn-iconselector').length){
                        return false;
                    }
                    selector.first().each(function(){
                        var inputIcon  = $(this).find(":hidden").first()
                        var iconSelector = new JSNIconSelector()
                        var actionSelector = $.proxy(function (_this) {
                            $(_this).parents(".jsn-items-list").find(".active").removeClass("active");
                            $(_this).parent().addClass("active");
                            inputIcon.val($(_this).attr("data-value"));
                        }, this);
                        $(this).append(iconSelector.GenerateSelector($(this), actionSelector, inputIcon.val()));
                    });
                });

            };

            // Add tooltip for icons
            var add_tooltip = function () {
                if ( typeof ( $.fn.tooltip ) == 'function' ) {
                    $('.st-tooltip-icon').each(function () {
                        $(this).tooltip({
                            placement: 'top'
                        });
                    });
                }
            };

            if($(".icon_selector").length){
                bind_icon_picker();
                add_tooltip();
            }

            // init Icon selector for Inline edit Sub item
            $('body').on( 'trigger_icon_selector', function(e, wrapper){
                bind_icon_picker( wrapper );
                add_tooltip();
            } );
        })
    })(jQuery)