/**
 * @version    $Id$
 * @package    IGPGBLDR
 * @author     WooRockets Team <support@www.woorockets.com>
 * @copyright  Copyright (C) 2012 WooRockets.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.www.woorockets.com
 * Technical Support: Feedback - http://www.www.woorockets.com/contact-us/get-support.html
 */

(function($) {
    "use strict";

    $.HandleSetting = $.HandleSetting || {};
    $.IGModal = $.IGModal || {};
    $.ST_ImageElement = $.ST_ImageElement || {};
    $.ST_ImageElement.setImageSize = $.ST_ImageElement.setImageSize || {};

    // mobile tab preview toggle
    var mobile_preview_on = false;
    $('body').on("click", "#st_option_tab > li", function(e) {
        if ($(this).hasClass('st-options-tab-mobile')) {
            $('.st-preview-responsive-size li[data-size="mobile"]').click();
            mobile_preview_on = true;
        } else if (mobile_preview_on) {
            $('.st-preview-responsive-size li[data-size="desktop"]').click();
            mobile_preview_on = false;
        }
    });

    // Gradient picker for row
    $.HandleSetting.gradientPicker = function() {
        var gradientPicker = function() {
            var val = $('#param-background').val();

            if (val == 'gradient') {
                $("input.jsn-grad-ex").each(function(i, e) {
                    $(e).next('.classy-gradient-box').first().ClassyGradient({
                        gradient: $(e).val(),
                        width: 218,
                        orientation: $('#param-gradient_direction').val(),
                        onChange: function(stringGradient, cssGradient, arrayGradient) {
                            $(e).val() == stringGradient || $(e).val(stringGradient);

                            $('#param-gradient_color_css').val(cssGradient);

                            $.HandleSetting.shortcodePreview();
                        }
                    });
                });
            }
        };

        $(document).ready(function() {
            setTimeout(function() {
                gradientPicker();
            }, 500);
        });

        $('#param-background').change(function() {
            gradientPicker();
        });

        // Control orientation
        $('#param-gradient_direction').on('change', function() {
            var orientation = $(this).val();

            $('.classy-gradient-box').data('ClassyGradient').setOrientation(orientation);

            // Update gradient background
            if (orientation == 'horizontal') {
                $('#param-gradient_color_css').val($('#param-gradient_color_css').val().replace('left top, left bottom', 'left top, right top').replace(/\(top/g, '(left'));
            } else {
                $('#param-gradient_color_css').val($('#param-gradient_color_css').val().replace('left top, right top', 'left top, left bottom').replace(/\(left/g, '(top'));
            }
        });

    };

    // Check radio button when click button in btn-group
    $.HandleSetting.buttonGroup = function() {
        var data_value;

        $('.st-btn-group .btn').click(function(i) {
            data_value = $(this).attr('data-value');

            $(this).parent().next('.st-btn-radio').find('input:radio[value="' + data_value + '"]').prop('checked', true);

            $.HandleSetting.shortcodePreview();
        });
    };

    // Validate input of text field with regular expression
    $.HandleSetting.regexTestInput = function(event, regex_str) {
        var regex = new RegExp(regex_str),
            key = String.fromCharCode(!event.charCode ? event.which : event.charCode);

        if (!regex.test(key) && key != ' ') {
            event.preventDefault();

            return false;
        }

        return true;
    };

    // Validator input field
    $.HandleSetting.inputValidator = function() {
        var input_action = 'change paste';

        // Disable special characters, limit length of title
        $("#param-el_title, input:text[name$='[title]'], [data-role='title'], .st-pb-limit-length", '#modalOptions').each(function() {
            $(this).prop('maxlength', 50);
        });

        // Number field: allow typing number only
        $("#modalOptions input[type='number']").bind(input_action, function(event) {
            $.HandleSetting.regexTestInput(event, "^[0-9\b\-]+$");
        });

        // Doesn't allow 0 in items_per_ input field
        $("#modalOptions input[id*='items_per']").bind(input_action, function(event) {
            var regex = /^[1-9\b]+$/g,
                val = regex.test($(this).val());

            if (!val) {
                $(this).val('1');
            }
        });

        // Positive value
        $('.positive-val').bind(input_action, function(event) {
            var this_val = $(this).val();

            if (parseInt(this_val) <= 0) {
                $(this).val(1);
            }
        });
    };

    $.HandleSetting.selectImage = function() {
        var _custom_media = true;

        $('#modalOptions .select-media-remove').on('click', function() {
            var _input = $(this).closest('div').find('input[type="text"]');

            _input.attr('value', '');
            _input.trigger('change');
        });

        $('body').on('click', '#modalOptions .select-media', function(e) {
            var button = $(this),
                id = button.attr('id').replace('_button', ''),
                jqueryParent = window.parent.jQuery.noConflict(),
                filter_type = $(this).attr('filter_type'),
                object = {};

            if (typeof(filter_type) != undefined) {
                object.type = filter_type;
            } else {
                object.type = '';
            }

            jqueryParent('#st-select-media').val(JSON.stringify(object));
            jqueryParent('#st-select-media').trigger('change');

            var timer = setInterval(function() {
                var currentValue = jqueryParent('#st-select-media').val();

                if (currentValue) {
                    var jsonObject = JSON.parse(currentValue);

                    switch (jsonObject.type) {
                        case 'media_selected':
                            if (typeof($.ST_ImageElement.setImageSize) == 'function') {
                                $.ST_ImageElement.setImageSize(jsonObject.select_prop);
                            }

                            var input_img = button.prev("#" + id);
                            var $field = input_img.closest('.control-group');

                            if (typeof(filter_type) != undefined && filter_type=='image')
                                $('.st_select_media_preview', $field).html('<img src="'+ jsonObject.select_url +'" />');

                            input_img.val(jsonObject.select_url);
                            input_img.trigger('change');

                            clearInterval(timer);
                            break;
                    }
                }
            }, 500);
        });

        $('#modalOptions .add_media').on('click', function() {
            _custom_media = false;
        });
    };

    $.HandleSetting.updateState = function(state) {
        if (state != null) {
            $.HandleSetting.doing = state;
        } else {
            if ($.HandleSetting.doing == null || $.HandleSetting.doing) {
                $.HandleSetting.doing = 0;
            } else {
                $.HandleSetting.doing = 1;
            }
        }
    };

    $.HandleSetting.renderModal = function() {
        if ($("#modalOptions").length == 0) {
            return false;
        }

        $("#modalOptions").modal('toggle');

        // Sortable sub-elements
        var group_elements = $("#group_elements");

        if (group_elements.length) {
            group_elements.sortable({
                handle: '.heading',
                sort: function(event, ui) {
                    var item = $(ui.item);
                    item.css('height', '38px');
                    item.children('.sub-element-settings').addClass('item-drag-hidden');

                    group_elements.sortable("refreshPositions");
                },
                stop: function(event, ui) {
                    var item = $(ui.item);
                    item.children('.sub-element-settings').removeClass('item-drag-hidden');
                },
                update: function(event, ui) {
                    $.HandleSetting.shortcodePreview();

                    var item = $(ui.item);
                    item.css('height', 'auto');
                    item.children('.sub-element-settings').removeClass('item-drag-hidden');

                    $('body').trigger('on_after_reorder_element');
                }
            });

            $('body').trigger('on_remove_handle_reorder');
        }

        $.HandleSetting.setColorPicker('#modalOptions .color-selector');
        $.HandleElement.initTooltip('#modalOptions [data-toggle="tooltip"]');

        $('body').trigger('toggleDependencyAll');

    };

    $.HandleSetting.setColorPicker = function(selector) {
        if (!selector) {
            return false;
        }

        $(selector).each(function() {
            var self = $(this),
                colorInput = self.siblings('input').last(),
                inputId = colorInput.attr('id'),
                inputValue = inputId.replace(/_color/i, '') + '_value';

            if ($('#' + inputValue).length) {
                $('#' + inputValue).val($(colorInput).val());
            }

            self.ColorPicker({
                color: $(colorInput).val(),
                onShow: function(colpkr) {
                    $(colpkr).fadeIn(500);

                    return false;
                },
                onHide: function(colpkr) {
                    $(colpkr).fadeOut(500);

                    $.HandleSetting.shortcodePreview();

                    return false;
                },
                onChange: function(hsb, hex, rgb) {
                    $(colorInput).val('#' + hex);

                    if ($('#' + inputValue).length) {
                        $('#' + inputValue).val('#' + hex);
                    }

                    self.children().css('background-color', '#' + hex);
                }
            });
        });
    };

    $.HandleSetting.selector = function(curr_iframe, element) {
        var $selector = (curr_iframe != null && curr_iframe.contents() != null) ? curr_iframe.contents().find(element) : $(element);

        return $selector;
    };


    var shortcodePreview_shortcode_elm = null;
    $.HandleSetting.delay_preview = true;
    $.HandleSetting.child_element_preserve = 0;
    $.HandleSetting.shortcodePreview = function(params, shortcode, curr_iframe, callback, stop_reload_iframe, child_element, selector_group) {

        function st_shortcodePreviewPerform() {
            // for some variables which are lost when waiting for final event
            if ($.HandleSetting.child_element_preserve) {
                child_element = $.HandleSetting.child_element_preserve;
                $.HandleSetting.child_element_preserve = 0;
            }

            if (($.HandleSetting.selector(curr_iframe, "#modalOptions").length == 0 || $.HandleSetting.selector(curr_iframe, "#modalOptions").hasClass('submodal_frame')) && curr_iframe == null) {
                return true;
            }


            // Change state to ACTIVE
            $.HandleSetting.updateState(1);

            var tmp_content = '',
                shortcode_name, shortcode_type;

            if (params == null) {
                shortcode_name = $.HandleSetting.selector(curr_iframe, '#modalOptions #shortcode_name').val();
                shortcode_type = $.HandleSetting.selector(curr_iframe, '.st-pb-form-container #shortcode_type').val();

                if (shortcode_type == 'widget') {
                    // Widget
                    var form_serialize = $.HandleSetting.selector(curr_iframe, '#modalOptions #st-widget-form').serialize();

                    $('input[type=checkbox]', '#modalOptions #st-widget-form').each(function() {
                        if (!this.checked) {
                            form_serialize += '&' + this.name + '=0';
                        }
                    });

                    tmp_content = '[st_widget widget_id="' + shortcode_name + '"]' + form_serialize + '[/st_widget]';
                } else {
                    var data = $.HandleSetting.traverseParam(selector_group ? selector_group : $.HandleSetting.selector(curr_iframe, '#modalOptions .control-group').not(".sub-element-settings .control-group"), child_element);
                    var sc_content = data.sc_content;
                    var params_arr = data.params_arr;

                    if (child_element && $.HandleSetting.selector(curr_iframe, '.sub-element-settings:visible').length) {
                        var related_textarea = $.HandleSetting.selector(curr_iframe, '.sub-element-settings:visible').parent().children("[name^='shortcode_content']");

                        var obj = { sc_content: sc_content, related_textarea: related_textarea };
                        $('#modalOptions').trigger('update_sub_shortcode_content', [obj]);
                        var tmp_content_ = $.HandleSetting.generateShortcodeContent(obj.related_textarea.attr('shortcode-name'), params_arr, obj.sc_content);

                        related_textarea.text(tmp_content_).trigger('change');
    
                        st_waitForFinalEvent(function () {
                            $.HandleElement.inlineContentPreview( $.HandleSetting.selector(curr_iframe, '.sub-element-settings:visible').closest('.jsn-item'), data );
                        }, 1000, "st_subelement_content_preview");

                        return false;
                    }

                    // Get tinymce content
                    tinyMCE.triggerSave();
                    if ($('.st_pb_editor').length > 0) sc_content = '';
                    $('.st_pb_editor').each(function() {
                        if (!$(this).closest('.form-group').parent().hasClass('sub-element-settings')) {
                            var tinymce_content = $(this).val();
                            sc_content += (tinymce_content != null) ? tinymce_content : '';

                            return false;
                        }
                    });


                    // Update TinyMCE content to #st_share_data
                    window.parent.jQuery.noConflict()('#jsn_view_modal').contents().find('#st_share_data').text(sc_content);

                    // For shortcode which has sub-shortcode
                    if ($.HandleSetting.selector(curr_iframe, "#modalOptions").find('.has_submodal').length > 0 || $.HandleSetting.selector(curr_iframe, '#modalOptions').find('.submodal_frame_2').length > 0) {
                        var sub_items_content = [];

                        $.HandleSetting.selector(curr_iframe, "#modalOptions [name^='shortcode_content']").each(function() {

                            var sc_content = $(this).text();
                            var obj = { sc_content: sc_content };
                            $('#modalOptions').trigger('st_get_sub_sc', [obj]);
                            if (obj.sc_content != '') {
                                sub_items_content.push(obj.sc_content);
                            }
                        });
                        sc_content += sub_items_content.join('');
                    }


                    // Get shortcode content
                    tmp_content = $.HandleSetting.generateShortcodeContent(shortcode_name, params_arr, sc_content);
                }
            } else {
                shortcode_name = shortcode;
                tmp_content = params;
            }

            // step_to_track(5, tmp_content);
            // Update shortcode content
            $.HandleSetting.selector(curr_iframe, '#shortcode_content').text(tmp_content).trigger('change');

            if (!child_element) {
                // Update content of Shortcode tab
                $('#shortcode_content', '#shortcode-content').text(tmp_content);
            } else {
                setTimeout(function() {
                    // Rescan parent shortcode, to update content of "Shortcode" tab
                    $.HandleElement.rescanShortcode();
                }, 300);
            }

            if (callback) {
                callback();
            }

            // Change state to inactive
            $.HandleSetting.updateState(0);


            // Dont reload preview iframe
            if (stop_reload_iframe) {
                return false;
            }

            var url = St_Ajax.st_preview_url + '&st_shortcode_preview=1' + '&st_shortcode_name=' + shortcode_name + '&st_nonce_check=' + St_Ajax._nonce;


            if ($('#shortcode_preview_iframe:visible').length > 0) {

                var patt = new RegExp('^(st_row|st_subrow|st_column)', 'i');
                if (!sc_content && shortcode_name.match(patt)) {
                    var current_element = $('.active-shortcode').last();

                    var tmp_sc_content = '';

                    current_element.find("textarea[name='shortcode_content[]']")
                        .not(':first')
                        .not(':last')
                        .each(function() {
                            tmp_sc_content += $(this).text();
                        });

                    tmp_content = tmp_content.replace('][', ']' + tmp_sc_content + '[');
                }

                tmp_content = $.HandleSetting.generatePreviewContent(tmp_content);

                // Asign value to a variable (for show/hide preview)
                $.HandleSetting.previewData = {
                    curr_iframe: curr_iframe,
                    url: url,
                    tmp_content: tmp_content
                };

                // Load preview iframe
                $.HandleSetting.loadIframe(curr_iframe, url, tmp_content);
            }

            return false;
        }

        if ($.HandleSetting.doCSSPreview) {
            stop_reload_iframe = true;
            st_waitForFinalEvent(function() {
                $.HandleSetting.previewCSS(curr_iframe);
            }, 10, "st_shortcodePreviewCSS");
        }

        if ($.HandleSetting.delay_preview) {
            if (child_element) {
                $.HandleSetting.child_element_preserve = 1;
            }

            // delay preview so we can stop too many requests
            st_waitForFinalEvent(st_shortcodePreviewPerform, 210, "st_shortcodePreview");
        } else {
            // dont delay for cases like save button
            st_shortcodePreviewPerform();
        }

    };


    /**
     * Wraps current shortcode content with whole row till eldest row for preview
     * @param  {string} shortcode_content shortcode data in wordpress shortcode format
     * @return {string}                   complete row shortcode with current element
     */
    $.HandleSetting.generatePreviewContent = function(shortcode_content) {
        var current_element = $('.active-shortcode').last();
        if (current_element.length < 1) return shortcode_content;

        var $top_parent_row = current_element.parents('.jsn-row-container:last');
        if ($top_parent_row.length < 1) return shortcode_content;

        var preview_content = '',
            shortcode_content_added = false;

        $top_parent_row.find("textarea[name^='shortcode_content']").each(function() {

            // if active shortcode then add given shortcode_content
            if ($(this).parents('.shortcode-container.active-shortcode').length > 0) {
                // do this only if data not already added
                // if it has, then its possible this textarea belongs to nested shortcodes so we skip
                if (false == shortcode_content_added) {
                    preview_content += shortcode_content;
                    shortcode_content_added = true;
                    return;
                }

                return;
            }
            preview_content += $(this).val();
        });

        // if shortcode content wasnt added then simply return original content
        if (false == shortcode_content_added)
            return shortcode_content;

        return preview_content;
    }


    /**
     * Traverse parameters, get theirs values
     */
    $.HandleSetting.traverseParam = function($selector, child_element, get_data_tag) {
        var sc_content = '';
        var params_arr = {};
        var encode,
            title_prepend,
            title_prepend_type;
        var default_val;

        $selector.each(function() {
            if (!$(this).hasClass('st_hidden_depend')) {
                $(this).find('[id^="param-"]').each(function() {
                    // Bypass the Copy style group
                    if ($(this).attr('id') == 'param-copy_style_from') {
                        return;
                    }

                    // Bypass the slider input wrapper
                    if ($(this).hasClass('st-slider')) {
                        return;
                    }

                    // FOR COLUMNS: Fill span input with span class
                    if ($(this).hasClass('st_col_span_param')) {
                        params_arr['span'] = $('.jsn-column-container.active-shortcode .jsn-column-content:first').attr('data-column-class');
                        return;
                    }

                    // yunus edit - modified to support wp editor on child elements
                    if (
                        (child_element && $(this).hasClass('st_pb_editor')) ||
                        (
                            $(this).parents(".tmce-active").length == 0 && !$(this).hasClass('tmce-active') && $(this).parents(".html-active").length == 0 && !$(this).hasClass('html-active') && !$(this).parents("[id^='parent-param']").hasClass('st_hidden_depend') && (child_element || !$(this).closest('.form-group').parent().hasClass('sub-element-settings')) && $(this).attr('id').indexOf('parent-') == -1
                        )
                    ) {
                        var id = $(this).attr('id');


                        if ($(this).attr('data-role') == 'content' || (child_element && $(this).hasClass('st_pb_editor'))) {
                            sc_content = $(this).val(); //.replace(/\[/g,"&#91;").replace(/\]/g,"&#93;");
                        } else {
                            if (($(this).is(":radio") || $(this).is(":checkbox")) && !$(this).is(":checked"));
                            else {
                                

                                if (!params_arr[id.replace('param-', '')] || id.replace('param-', '') == 'title_font_face_type' || id.replace('param-', '') == 'title_font_face_value' || id.replace('param-', '') == 'font_face_type' || id.replace('param-', '') == 'font_face_value' || id.replace('param-', '') == 'image_type_post' || id.replace('param-', '') == 'image_type_page' || id.replace('param-', '') == 'image_type_category') {

                                    // skips if default val = current val
                                    default_val = $(this).closest('.st_default_val');
                                    if (default_val.length > 0 
                                        && default_val.is('[data-std]') 
                                        && $(this).val() == default_val.data('std') ) {

                                        // dont skip checkboxes as they merge into __#__
                                        if( $(this).is(":checkbox") && $('[name="'+id+'"]').length > 1 )
                                        {

                                        }
                                        else
                                        {
                                            return;
                                        }

                                    }

                                    // ------------------------------------------------------
                                    //  yunus edit - encodes entities to support tags
                                    // ------------------------------------------------------
                                    encode = String($(this).val())
                                        .replace(/"/g, '{st-quote}');

                                    params_arr[id.replace('param-', '')] = encode;

                                } else {
                                    params_arr[id.replace('param-', '')] += '__#__' + $(this).val();
                                }

                                if ($(this).attr('data-role') == 'title_prepend') {
                                    title_prepend = $(this).val();
                                    title_prepend_type = $(this).attr('data-title-prepend');
                                }

                            }
                        }

                        if (get_data_tag == null || get_data_tag) {
                            // data-share
                            if ($(this).attr('data-share')) {
                                var share_element = $('#' + $(this).attr('data-share'));
                                var share_data = share_element.text();
                                if (share_data == "" || share_data == null)
                                    share_element.text($(this).val());
                                else {
                                    share_element.text(share_data + ',' + $(this).val());
                                    var arr = share_element.text().split(',');
                                    $.unique(arr);
                                    share_element.text(arr.join(','));
                                }

                            }

                            // data-merge
                            if ($(this).parent().hasClass('merge-data')) {
                                var st_merge_data = window.parent.jQuery.noConflict()('#jsn_view_modal').contents().find('#st_merge_data');
                                st_merge_data.text(st_merge_data.text() + $(this).val());
                            }

                            // table
                            if ($(this).attr("data-role") == "extract") {
                                var extract_holder = window.parent.jQuery.noConflict()('#jsn_view_modal').contents().find('#st_extract_data');
                                extract_holder.text(extract_holder.text() + $(this).attr("id") + ':' + $(this).val() + '#');
                            }
                        }
                    }

                });
            }
        });


        return { sc_content: sc_content, params_arr: params_arr, title_prepend: title_prepend, title_prepend_type: title_prepend_type };
    }

    /**
     * Generate shortcode content
     */
    $.HandleSetting.generateShortcodeContent = function(shortcode_name, params_arr, sc_content) {
        var tmp_content = [];

        tmp_content.push('[' + shortcode_name);
        // wrap key, value of params to this format: key = "value"
        $.each(params_arr, function(key, value) {
            if (value) {
                if (value instanceof Array) {
                    value = value.toString();
                }
                tmp_content.push(key + '="' + value.replace(/\"/g, "&quot;").replace(/\[/g, "").replace(/\]/g, "") + '"');

            }
            // ------------------------------------------------------
            //  yunus edit - include empty values so they are not filled with std value
            // ------------------------------------------------------
            else {
                tmp_content.push(key + '=""');
            }
        });


        // step_to_track(6,tmp_content);
        tmp_content.push(']' + sc_content + '[/' + shortcode_name + ']');
        tmp_content = tmp_content.join(' ');

        return tmp_content;
    }

    // Load preview iframe
    var iframe_in_progress;
    $.HandleSetting.loadIframe = function(curr_iframe, url, tmp_content) {

        //st_waitForFinalEvent(function ()
        //{
        $('.cbb-preview-loading').stop().fadeIn('fast');
        $('#st_preview_data').remove();

        iframe_in_progress = url;

        var tmp_form = $(
            '<form action="' + url + '" id="st_preview_data" name="st_preview_data" method="post" target="shortcode_preview_iframe">' +
            '<input type="hidden" id="st_preview_params" name="params" value="' + encodeURIComponent(tmp_content) + '">' +
            '</form>'
        ).appendTo($('body'));

        $.HandleSetting.selector(curr_iframe, '.cbb-preview #st_overlay_loading').fadeIn('fast');

        $('#st_preview_data').submit();

        var content_width;
        $('#shortcode_preview_iframe').off().bind('load', function() {
            $('#shortcode_preview_iframe').fadeIn('fast');
            $('.cbb-preview-loading').stop().fadeOut('fast');

            $('#st_previewing').val('0');

            iframe_in_progress = null;
        });

        tmp_form.remove();

        //}, 200, "st_preview"); // end st_waitForFinalEvent
    };

    // Hide/show preview
    $.HandleSetting.togglePreview = function() {
        /*$('#previewToggle *').click(function() {
        	if ($(this).attr('id') == 'hide_preview') {
        		$(this).addClass('hidden');
        		$('#show_preview').removeClass('hidden');

        		// Remove iframe
        		$('#preview_container iframe').remove();
        	} else {
        		$(this).addClass('hidden');
        		$('#hide_preview').removeClass('hidden');

        		$('#preview_container').append(
        			"<iframe scrolling='no' id='shortcode_preview_iframe' name='shortcode_preview_iframe' class='shortcode_preview_iframe'></iframe>"
        		);

        		if ($.HandleSetting.previewData != null) {
        			var data = $.HandleSetting.previewData;

        			$.HandleSetting.loadIframe(data.curr_iframe, data.url, data.tmp_content);
        		}
        	}
        });*/
    };

    $.HandleSetting.toggleDependencyAll = function() {
        // Toggle dependency params
        var st_HasDepend = $('#modalOptions .st_has_depend');

        st_HasDepend.each(function() {
            if (($(this).is(":radio") || $(this).is(":checkbox")) && !$(this).is(":checked")) {
                return;
            }

            var this_id = $(this).attr('id'),
                this_val = $(this).val();
            $.HandleSetting.toggleDependency(this_id, this_val);
        });
    }

    // Show/hide dependency params
    $.HandleSetting.toggleDependency = function(this_id, this_val) {
        if (!this_id) {
            return;
        }

        $('#modalOptions .st_depend_other.cbb-depends-on-' + this_id).each(function() {
            var _this = this,
                dependencies = $(this).data('depend-multi'),
                operator = $(this).attr('data-depend-operator'),
                compare_value = $(this).attr('data-depend-value'),
                againist,
                againist_val;

            if (!dependencies) {
                dependencies = [{
                    'againist': this_id,
                    'operator': operator,
                    'compare_value': compare_value
                }];
            }

            var show = true;
            $.each(dependencies, function(i, val) {
                show = $.HandleSetting.processEachDependency(show, {
                    compare_value: val['compare_value'],
                    operator: val['operator'],
                    againist: val['againist']
                });
            }); // end each dependency array


            if (show) $(this).removeClass('st_hidden_depend');
            else $(this).addClass('st_hidden_depend');

            $.HandleSetting.secondDependency($(this).attr('id'), $(this).hasClass('st_hidden_depend'), $(this).find('select').hasClass('no_plus_depend'));
        });
    };

    $.HandleSetting.processEachDependency = function(show, data) {
        data.againist_val = $('#' + data.againist.replace('parent-', ''));
        if (data.againist_val.is(":radio")) {
            data.againist_val = $('#' + data.againist.replace('parent-', '') + ':checked');
        }

        data.againist_val = data.againist_val.val();

        switch (data.operator) {
            case "=":
                var check_ = 0;

                if (data.compare_value.indexOf('__#__') > 0) {
                    var values_ = data.compare_value.split('__#__');

                    check_ = ($.inArray(data.againist_val, values_) >= 0);
                } else {
                    check_ = (data.againist_val == data.compare_value);
                }
                if (check_) {

                } else {
                    show = false;
                }
                break;

            case ">":
                if (data.againist_val > data.compare_value) {

                } else {
                    show = false;
                }
                break;

            case "<":
                if (data.againist_val < data.compare_value) {

                } else {
                    show = false;
                }
                break;

            case "!=":
                if (data.againist_val != data.compare_value) {

                } else {
                    show = false;
                }
                break;
        }

        return show;
    }

    // Show/hide 2rd level dependency elements
    $.HandleSetting.secondDependency = function(this_id, hidden, allow) {
        if (!this_id) {
            return;
        }

        this_id = this_id.replace('parent-', '');

        $('#modalOptions .st_depend_other.cbb-depends-on-' + this_id).each(function() {
            if (hidden) {
                $(this).addClass('st_hidden_depend2');
            } else {
                $(this).removeClass('st_hidden_depend2');
            }
        });

        if (!allow) {
            $('#modalOptions .st_depend_other.cbb-depends-on-' + this_id).each(function() {
                $(this).removeClass('st_hidden_depend2');
            });
        }

        // Hide label if all options in .controls div have 'st_hidden_depend' class
        $('#modalOptions .controls').each(function() {
            var hidden_div = 0;

            $(this).children().each(function() {
                if ($(this).hasClass('st_hidden_depend')) {
                    hidden_div++;
                }
            });

            if (hidden_div > 0 && hidden_div == $(this).children().length) {
                $(this).parent('.control-group').addClass('margin0');
                $(this).prev('.control-label').hide();
            } else {
                $(this).parent('.control-group').removeClass('margin0');
                $(this).prev('.control-label').show();
            }
        });
    };

    // Set change event of dependency elements
    $.HandleSetting.changeDependency = function(dp_selector) {
        if (!dp_selector) {
            return false;
        }

        $('#modalOptions').delegate(dp_selector, 'change', function() {
            var this_id = $(this).attr('id'),
                this_val = $(this).val();

            $.HandleSetting.toggleDependency(this_id, this_val);
        });
    };

    // Show tab in Modal Options
    $.HandleSetting.tab = function() {
        if ($('.jsn-tabs').length && !$('.jsn-tabs').find("#Notab").length) {
            //$('.jsn-tabs').tabs();
            $(".jsn-tabs").tabs().addClass("ui-tabs-vertical ui-helper-clearfix");
            $(".jsn-tabs > .ui-tabs-nav > li").removeClass("ui-corner-top").addClass("ui-corner-left");

            $('#st_option_tab a[data-toggle="tab"]').on('click', function() {
                var href = $(this).attr('href');

                if (href == '#shortcode-content') {
                    $('#shortcode_content').attr('disabled', 'disabled');
                } else {
                    $('#shortcode_content').removeAttr('disabled');
                }
            });

            if ($('#st_previewing').val() == '1') {
                return;
            }
            $('#st_previewing').val('1');

            $('#shortcode_content').removeAttr('disabled');
        }

        return true;
    };

    $.HandleSetting.select2 = function() {
        $(".select2").each(function() {
            var share_element = window.parent.jQuery.noConflict()('#jsn_view_modal').contents().find('#' + $(this).attr('data-share')),
                share_data = [];

            if (share_element && share_element.text() != "") {
                share_data = share_element.text().split(',');
                share_data = $.unique(share_data);
            }

            $(this).css('width', '300px');

            $(this).select2({
                tags: share_data,
                maximumInputLength: 10
            });
        });

        $('.select2-select').each(function() {
            if ($(this).is('select')) {
                var id = $(this).attr('id');

                if ($('#' + id + '_select_multi').val()) {
                    var arr_select_multi = $('#' + id + '_select_multi').val().split('__#__');

                    $(this).val(arr_select_multi).select2({
                        minimumResultsForSearch: -1
                    });
                } else {
                    var parent_selector = '';
                    parent_selector = $(this).parent('div[id^="parent-param-"]');
                    // Only show select2 search textbox for post and page listing
                    if ($(parent_selector).attr('data-depend-value') == 'post' || $(parent_selector).attr('data-depend-value') == 'page') {
                        $(this).select2();
                    } else {
                        $(this).select2({
                            minimumResultsForSearch: -1
                        });
                    }
                }
            }
        });

        $.HandleSetting.select2_color();
    };

    $.HandleSetting.select2_color = function() {
        function format(state) {
            if (!state.id) {
                // optgroup
                return state.text;
            }

            var type = state.id.toLowerCase().split('-');

            type = type[type.length - 1];

            // yunus edit - changed it to class so we can change them colors via css
            return "<span class='cbb-select2-color cbb-select2-color-" + type + "'></span>" + state.text;
        }

        $('.color_select2').not('.hidden').each(function() {
            $(this).find('select').each(function() {
                $(this).select2({
                    minimumResultsForSearch: -1,
                    formatResult: format,
                    formatSelection: format,
                    escapeMarkup: function(m) {
                        return m;
                    }
                });
            });
        });
    };

    // Handle icon change action in Modal box
    $.HandleSetting.icons = function() {
        // Icon type: handle icon click
        $('body').on("click", ".st-pb-form-container [data-type='st-icon-item']", function() {
            $(".controls .icon-selected").each(function() {
                $(this).removeClass('icon-selected');
            });

            // Update selected icon
            var $selected_icon = $(this).attr('class').replace('icon-selected', '').replace(' ', ''),
                icon = $(this).parent('li').parent('ul').next("input[id^='param']");

            icon.val($selected_icon);
            icon.trigger('change');

            $(this).addClass('icon-selected');
        });
    };

    // Handle click action on Button in Modal: Convert action/ Add Row, Column / ...
    $.HandleSetting.actionHandle = function() {
        // Handle Convert To ... button
        $('body').on("click", ".st-pb-form-container .st_action_btn a", function(e) {
            e.preventDefault();

            var action_type = $(this).attr('data-action-type'),
                relation = $(this).attr('data-action');

            if (action_type && relation) {

                // Mark the element to be converted
                $('.active-shortcode').addClass('st_to_convert');

                // Save data to convert
                $.PbDoing.action_data = { 'action': action_type, 'relation': relation };

                $('button#selected', '.st-dialog').trigger('click');
            }
        });
    };

    $.HandleSetting.closeAllSelect2WhenClickModal = function() {
        $('.st-dialog').on("click", function(e) {
            var el = $(e.target);
            if (el.parents(".select2-container").length == 0) {
                $(".select2-dropdown-open").select2("close");
            }
        });
    };

    // Handle Copy to Clipboard action
    $.HandleSetting.copyToClipboard = function() {
        var textarea = $("#shortcode_content"),
            button = $("#copy_to_clipboard"),
            text_change = button.data('textchange');

        if (textarea.length && button.length) {
            ZeroClipboard.config({ moviePath: St_Ajax.assets_url + '/assets/3rd-party/zeroclipboard/ZeroClipboard.swf' });

            var client = new ZeroClipboard(button);

            client.on("datarequested", function() {
                // Copy shortcode content to clipboard
                client.setText(textarea.val());

                // Show message
                button.addClass("disabled").attr("disabled", "disabled");

                // get current text
                var cache_text = button.text();

                // Change text button
                button.text(text_change);

                // Schedule hiding the message
                setTimeout(function() {
                    button.removeClass("disabled").removeAttr("disabled");
                    $("i", button).animate({ "opacity": "0" }, 500, function() { $(this).hide(); });
                    button.text(cache_text);
                }, 1000);
            });
        }
    };

    /**
     * Copy Style from other same-type element
     */
    $.HandleSetting.initCopyStyle = function() {
        if ($('#modalOptions #param-copy_style_from').length <= 0) {
            return;
        }
        var copy_style_from = $('#modalOptions #param-copy_style_from').select2({ minimumResultsForSearch: -1 });
        var shortcode_name = $('#modalOptions #shortcode_name').val();

        if (copy_style_from.length > 0) {
            // Append Copy action button

            var copy_button = $('<button/>', {
                'class': 'btn btn-default btn-sm',
                'id': 'copy_style_button',
                'html': St_Translate.take_style,
                'style': 'margin-left: 10px'
            });
            copy_style_from.after(copy_button);
        }
        copy_style_from.parents('.control-group').after($('<hr/>'));
        // Init action for copy style button
        copy_button.on('click', function(e) {
            e.preventDefault();

            var shortcode_content = $('#shortcode_content').val();
            var new_style_content = copy_style_from.val();
            var setting_form = $('#frm_shortcode_settings');
            var loading;




            // Init loading overlay inside modal
            loading = $('<div/>');
            loading.append($('<div/>', {
                    'class': 'jsn-modal-overlay',
                    'style': 'z-index: 1000; display: block;'
                }))
                .append(
                    $('<div/>', {
                        'class': 'jsn-modal-indicator',
                        'style': 'display:block'
                    })
                );

            if (typeof(st_pb_modal_ajax) != 'undefined') {
                if (st_pb_modal_ajax == 1) {
                    setting_form.parents('#modalOptions').css('visibility', 'hidden');
                    setting_form.parents('.jsn-modal').append(loading);
                }
            } else {
                $('body').append(loading);
            }

            $.post(
                St_Ajax.ajaxurl, {
                    action: 'merge_style_params',
                    content: shortcode_content,
                    new_style_content: new_style_content,
                    shortcode_name: shortcode_name,
                    st_nonce_check: St_Ajax._nonce
                },
                function(data) {

                    $('#frm_shortcode_settings #hid-params').val(data);

                    if (typeof(st_pb_modal_ajax) != 'undefined') {
                        if (st_pb_modal_ajax == 1) {
                            // If the modal was initted from ajax
                            // then load the modal content by ajax
                            $.ajax({
                                url: St_Ajax.st_modal_url + '&st_modal_type=' + shortcode_name + '&form_only=1',
                                data: setting_form.serializeArray(),
                                type: 'POST',
                                dataType: 'html',
                                complete: function(data, status) {
                                    if (status == 'success') {
                                        setting_form.parents('.jsn-modal').html(data.responseText);
                                    }


                                    // yunus edit - preview pane was not refreshing and was not sized correctly
                                    var wait = setInterval(function() {
                                        var modal_width = $('#modalOptions').width();
                                        var panel_width = $('.st-setting-resize').first().width();
                                        $('.st-preview-resize').width(modal_width - panel_width - 18);
                                        $('.st-pb-setting-tab input:not(.select2-focusser)').first().trigger('change');

                                        window.clearInterval(wait)

                                    }, 500); //wait 1 seconds so colorpicker palette changes are applied
                                }
                            });
                        }
                    } else {
                        // If the modal was initted by iframe
                        // just only pass data by submitting the form
                        setting_form.submit();
                    }

                }
            );
        });
        // Get the same type elements list.
        $.post(
            St_Ajax.ajaxurl, {
                action: 'get_same_elements',
                content: window.parent.jQuery.HandleElement.getContent(true),
                shortcode_name: shortcode_name,
                st_nonce_check: St_Ajax._nonce
            },
            function(data) {
                if (data) {
                    copy_style_from.html(data);
                } else {
                    copy_style_from.parents('.control-group').hide();
                    copy_style_from.parents('.control-group').next('hr').hide();
                }

            }
        );
    }

    // Function to handling resize modal setting
    $.HandleSetting.handleResizeModal = function() {
        if (typeof($('.st-setting-resize').resizable) == 'function') {
            $('.st-setting-resize').resizable({
                handles: 'e',
                minWidth: 430, // yunus edit - changed from 400
                start: $.proxy(function(event, ui) {
                    $('.st-preview-resize #st_overlay_loading').show();
                }, this),
                resize: $.proxy(function(event, ui) {
                    var resize_handle_width = ui.element.find('.ui-resizable-e').first().width() + 5;
                    var thisWidth = ui.element.width() + resize_handle_width;
                    var remain_width = $('#modalOptions').width() - thisWidth - 3;
                    $('.st-preview-resize').css('width', remain_width + 'px');
                }, this),
                stop: $.proxy(function(event, ui) {
                    $('.st-preview-resize #st_overlay_loading').fadeOut();
                }),
            });
        }

        // Only set width default on main modal
        if ($('.jsn-modal').last().attr('id') == 'jsn_view_modal') {
            setTimeout(function() {
                $('.st-setting-resize').css({ 'width': '45%' });
            }, 100);
        }
    }

    // Use bootstrap js instead of use bootstrap markup html.
    $.HandleSetting.useBootstrapJS = function() {
        // For dropdown
        $('.st-dialog .st-dropdown-toggle').each(function() {
            $(this).on('click', function(e) {
                e.preventDefault();
                $(this).dropdown('toggle');
            });
        });
    }

    // Add tooltip for element settings
    $.HandleSetting.addTooltip = function() {
        if (typeof($.fn.tooltip) == 'function') {
            $('.st-tooltip-toggle').tooltip({
                placement: 'bottom',
                html: true
            });
            $('[data-original-title]').not('.st-tooltip-toggle').tooltip({
                placement: 'bottom'
            });
        }
    }

    // Styling for border type
    $.HandleSetting.addStyleBorderType = function() {
        if (typeof($.fn.select2) == 'function') {
            var format = function(state) {
                if (!state.id) return state.text;

                var border_type = state.id.toLowerCase();
                if (!border_type)
                    border_type = 'solid';
                return state.text + "<div class='st-border-line' style='border-top: 4px " + border_type + " #C3C3C3'></div>";
            };
            $('.st-border-type').select2('destroy');
            $('.st-border-type').select2({
                formatResult: format,
                formatSelection: format,
                escapeMarkup: function(m) {
                    return m; }
            });
        }
    }

    // Styling for heading type
    $.HandleSetting.addStyleHeadingType = function() {
        if (typeof($.fn.select2) == 'function') {
            var format = function(state) {
                if (!state.id) return state.text;

                var type = state.id.toLowerCase();
                if (!type)
                    type = 'h1';
                return "<" + type + " style='margin: 0px'>" + type + " example</" + type + ">";
            };
            $('.st-heading-type:last').select2('destroy').select2({
                formatResult: format,
                //formatSelection: format,
                escapeMarkup: function(m) {
                    return m; }
            });
        }
    }


    // YUNUS EDIT - bootstrap DATE PICKER
    $.HandleSetting.datepicker = function() {
        if (typeof($.fn.datepicker) == 'function') {
            $('.ST_wr_datepicker').datepicker();
        }
    }

    // YUNUS EDIT - bootstrap TIME PICKER
    $.HandleSetting.timepicker = function() {
        if (typeof($.fn.datetimepicker) == 'function') {
            $('.ST_wr_timepicker').datetimepicker();
        }
    }

    $.HandleSetting.addSelectEditor = function() {
        if (typeof($.fn.select2) == 'function') {

            var onSelectionItem = function(current_id) {
                var new_term = $('.select2-results:last .st-new-term').text();
                $('<option value="' + new_term + '">' + new_term + '</option>').appendTo('#' + current_id);
                $('#' + current_id).select2('val', new_term);
                $('#' + current_id).select2('close');
                $('#' + current_id + ' option').removeAttr('selected');
                $('#' + current_id + ' option[value="' + new_term + '"]').attr('selected', 'selected');
                $('#' + current_id).change();
            };

            $('.st-select2-editor').each(function() {
                var current_id = $(this).attr('id');
                $(this).select2({
                    allowClear: true,
                    formatNoMatches: function(term) {
                        term = parseInt(term);
                        return "<div class='select2-result-label st-new-term'><span class='select2-match'>" + term + "</span></div>";
                    },
                }).parent().find('.select2-with-searchbox').on('keyup', function(e) {
                    if (e.keyCode === 13) {
                        onSelectionItem(current_id);
                    }
                }).on('click', '.st-new-term', function() {
                    onSelectionItem(current_id);
                });
            });
        }
    }


    // ------------------------------------------------------
    //  YUNUS EDIT - kill previous editor
    // ------------------------------------------------------
    $.HandleSetting.kill_editors = function() {
        if (!_.isUndefined(window.tinyMCE)) {
            $('.st_pb_editor').each(function() {
                var id = $(this).attr('id');
                if (tinymce.majorVersion === "4") {
                    window.tinyMCE.execCommand('mceRemoveEditor', true, id);
                } else {
                    window.tinyMCE.execCommand("mceRemoveControl", true, id);
                }
            });
        }
    }

    // ------------------------------------------------------
    //  YUNUS EDIT - FIX FOR WP 4.3
    // ------------------------------------------------------
    $.HandleSetting.editor = function() {
        if ($('.st_pb_editor').length == 0) return;

        $.HandleSetting.kill_editors();


        var textfield_id;
        $('.st_pb_editor').each(function() {
            textfield_id = $(this).attr('id');

            var str = st_tinyMCEPreInit.replace(/st_dummy_editor_id/gi, textfield_id);
            tinyMCEPreInit = JSON.parse(str);


            tinyMCEPreInit.mceInit[textfield_id] = _.extend({},
                tinyMCEPreInit.mceInit[textfield_id], {
                    setup: function(ed) {
                        ed.on('blur', function(ed) {
                            tinyMCE.triggerSave();
                            jQuery('.st_pb_editor').first().trigger('change');
                        });
                    }
                }
            );


            quicktags(tinyMCEPreInit.qtInit[textfield_id]);
            QTags._buttonsInit();


            if (window.tinymce) {
                // open visual editor by default
                window.switchEditors && window.switchEditors.go(textfield_id, 'tmce');
            }


            $(this).closest('#st_tiny_mce').find('.quicktags-toolbar .ed_button').click(function() {
                _.delay(function() {
                    tinyMCE.triggerSave();
                    jQuery('.st_pb_editor').first().trigger('change');
                }, 200);
            });

        });

    }


    /**	
     * 
     * @pTO-DO
     * - get opacity from
     * - check on sub elements
     * - Check Ticket Ticket #158
     * - send zip file
     *  - handle color functions e.g lighten darken etc
     *  - change viewport size to 830ish px
     */
    $.HandleSetting.doCSSPreview = 0; // flag to stop preview iframe reload
    /**
     * Beings the CSS Generation process
     * @param  {element} curr_iframe iframe element given by caller
     * @return {void}             simply injects the css to element's iframe style tag
     */
    $.HandleSetting.previewCSS = function(curr_iframe) {   
        var cssData = {};
        var $previewFrame = $('#shortcode_preview_iframe:visible');

        if ($previewFrame.length < 1)
            return;

        $.HandleSetting.css_elements = { mediaQuery: {} };
        $.HandleSetting.cssContext = $('#modalOptions #param-id_wrapper').val();

        $.HandleSetting.selector(curr_iframe, '#modalOptions .control-group').each(function() {
            if (!$(this).hasClass('st_hidden_depend')) {
                $(this).find('[id^="param-"]').each(function() {

                    var $dataProvider = $(this).closest('.st_default_val.st_css_data');
                    if ($dataProvider.length > 0) {
                        $.HandleSetting.paramsToCSSElements(
                            $(this).attr('id'),
                            $(this),
                            $dataProvider.data('css'),
                            $dataProvider);

                        return;
                    }
                }); // end for each param
            } // end if has st_hidden_depend
        }); // end $selector each

        var css = $.HandleSetting.generateCSS();
        $.HandleSetting.doCSSPreview = 0;

        var $style_container = $previewFrame.contents().find('#style-' + $.HandleSetting.cssContext);
        if($style_container.length < 1)
        {
            // create new tag
            $previewFrame.contents().find('#' + $.HandleSetting.cssContext).after('<style id="style-' + $.HandleSetting.cssContext + '"></style>');
            $style_container = $previewFrame.contents().find('#style-' + $.HandleSetting.cssContext);
        }
        $style_container.html(css);

        $.HandleSetting.previewTriggerAdjustment();
    }

    $.HandleSetting.previewTriggerAdjustment = function () {
        // trigger iframe window resize event so layout can adjust
        var iframe = document.getElementById("shortcode_preview_iframe")
        if(iframe.length < 1 
            || typeof iframe.contentWindow == 'undefined'
            || typeof iframe.contentWindow.st_preview_adjustment == 'undefined') return;

        setTimeout(function () {
            iframe.contentWindow.st_preview_adjustment();
        }, 10);
    }


    /**
     * Constructs css_elements object from Each param
     * to be later processed into CSS
     * @param  {string} paramId       Param ID
     * @param  {object} $param        jQuery object of param
     * @param  {array} data          array of css items of param
     * @param  {object} $dataProvider jQuery object of where the data came from
     * @param  {string} mediaQuery    CSS Media Query e.g "(max-width: 829px)"
     * @return {void}               injects each result to $.HandleSetting.css_elements
     */
    $.HandleSetting.paramsToCSSElements = function(paramId, $param, data, $dataProvider, mediaQuery) {
        var property;
        var element;
        var valPlaceholder;
        var val;

        // skip unselected radio
        if($param.is(':radio')
            && ! $param.is(':checked'))
        {
            return;
        }

        //if(data.length < 1) return '';

        // if not multiple css then create multi array so loop works normally
        if (typeof data[0] !== 'undefined' && !$.isArray(data[0])) {
            data = [data];
        }

        // for each param's CSS Items
        $.each(data, function(key, item) {

            // if media query
            if (typeof item.query !== 'undefined') {
                // recursively call this method to generate inside elements
                $.HandleSetting.paramsToCSSElements(paramId, $param, item.css, $dataProvider, item.query);
                return;
            }

            // to avoid undefined
            item = $.extend(['', '', '', ''], item);
            // set main properties
            element = item[0];
            property = item[1];
            valPlaceholder = item[2];
            val = $param.val();

            // validation
            if (!property || !val) {
                return;
            }

            // dependency for each css item
            if (item[3]) {
                var show = true;
                $.each(item[3], function(depKey, depItem) {
                    show = $.HandleSetting.processEachDependency(show, {
                        compare_value: depItem[2],
                        operator: depItem[1],
                        againist: 'param-' + depItem[0]
                    });
                })

                // if any of above fails, skip this property
                if (show == false) {
                    return;
                }
            }


            // check padding and margin types
            if ($dataProvider.hasClass('st_css_data_padding_margin')) {
                var parentId = $dataProvider.parents('[id^="parent-param-"]');
                if (parentId) {
                    // get parent id
                    parentId = parentId.attr('id').replace('parent-', '');
                    // subtract parent id from current param id to get orientation of css property 
                    // (-top, -bottom, -left, -right)
                    property += '-' + paramId.replace(parentId + '_', '');
                }
            }

            // if append value is mentioned for the param then append to value
            var append = $dataProvider.data('css-append');
            if (append) {
                val += append;
            }

            // apply value to placeholder and set to value
            if (valPlaceholder)
            {
                if(  "undefined" !== typeof valPlaceholder.opacity_from  )
                {
                    var opacity = $('#param-' + valPlaceholder.opacity_from );
                    if( opacity.length > 0 )
                    {
                        opacity = opacity.val();
                        val = $.HandleSetting.hexToRGBA(val, opacity);
                    }
                }
                else
                {
                    val = valPlaceholder.replace(new RegExp('%value%', 'g'), val);
                    // WIP
                    // // param placeholders e.g %text_color%
                    // val = val.replace(/%(.+?)%/g, function(match, contents, offset, s)
                    // {
                    //     return ($('#param-' + contents ).length > 0) ? $('#param-' + contents ).val() : '';
                    // });

                    // // apply placeholder opacity / fade
                    // val = val.replace(/fade\(#(.*),.*([0-9]+)%\)/g, function(match, contents, offset, s)
                    // {
                    //     console.log('match', match);
                    //     console.log('contents', contents);
                    //     //return $.HandleSetting.hexToRGBA(val, opacity);
                    // });
                }
            }




            // for media queries add to mediaQuery key
            if (mediaQuery) {
                $.HandleSetting.css_elements['mediaQuery'][mediaQuery] = $.HandleSetting.css_elements['mediaQuery'][mediaQuery] || {}; // init object if not already
                $.HandleSetting.css_elements['mediaQuery'][mediaQuery][element] = $.HandleSetting.css_elements['mediaQuery'][mediaQuery][element] || []; // init object if not already
                $.HandleSetting.css_elements['mediaQuery'][mediaQuery][element].push(property + ': ' + val + ';');
                return;
            }

            // for elements
            $.HandleSetting.css_elements[element] = $.HandleSetting.css_elements[element] || []; // init object if not already
            $.HandleSetting.css_elements[element].push(property + ': ' + val + ';');

        });
    }

    $.HandleSetting.hexToRGBA = function (hex, opacity) 
    {
        hex = hex.replace('#','');
        var r = parseInt(hex.substring(0,2), 16);
        var g = parseInt(hex.substring(2,4), 16);
        var b = parseInt(hex.substring(4,6), 16);

        if(opacity)
            opacity = opacity/100;
        else
            opacity = '0';

        return 'rgba('+r+','+g+','+b+','+opacity+')';
    }

    /**
     * Generates CSS from given items if provided otherwise $.HandleSetting.css_elements
     * @param  {object} items array with prepared CSS properties
     * @return {string}       prepared CSS including media queries
     */
    $.HandleSetting.generateCSS = function(items) {
        if (!items)
            items = $.HandleSetting.css_elements;

        var css = '';
        var mediaQueryCSS = '';
        $.each(items, function(element, cssArray) {
            if (element == 'mediaQuery') {
                $.each(cssArray, function(query, cssItems) {
                    mediaQueryCSS += '@media ' + query + ' {';
                    mediaQueryCSS += $.HandleSetting.generateCSS(cssItems);
                    mediaQueryCSS += '}';
                });
                return;
            }
            css += '#' + $.HandleSetting.cssContext + ' ' + element + ' {';
            $.each(cssArray, function(index, property) {
                css += property;
            });
            css += '}';
        });

        return css + mediaQueryCSS;
    }


    $.HandleSetting.init = function() {
        //$.HandleSetting.togglePreview();

        $.HandleSetting.updateState();

        $.HandleSetting.tab();

        // Trigger action of element which has dependency elements
        $.HandleSetting.changeDependency('.st_has_depend');



        // Change option of Inline-edit sub element
        var editing_sub_element = 0;
        $('#modalOptions').on('change keyup mouseup', '.sub-element-settings [id^="param"]', function(e) {
            e.stopPropagation();

            // since stopPropagation doesnt work on delegates
            editing_sub_element = 1;

            $.HandleSetting.shortcodePreview(null, null, null, null, 0, 1, $('.control-group', '.sub-element-settings:visible'));

            return false;
        });

        // Update preview when change param in Modal Box/Styling //mouseup
        $('#modalOptions').delegate('[id^="param"]', 'change keyup', function() {

            // since stopPropagation doesnt work on delegates
            if(editing_sub_element)
            {
                editing_sub_element = 0;
                return;
            }


            if ($(this).attr('data-role') == 'no_preview') {
                return false;
            }
            if ($(this).attr('id') == 'param-copy_style_from') {
                return false;
            }

            var stop_reload_iframe = 0;

            var default_val = $(this).closest('.st_default_val.st_css_data');
            if (default_val.length > 0) {
                $.HandleSetting.doCSSPreview = 1;
            }

            $.HandleSetting.shortcodePreview(null, null, null, null, stop_reload_iframe);
        });


        // Trigger preview for parameters of Widget
        $('#modalOptions #st-widget-form').delegate('input, select, textarea', 'change', function() {
            $.HandleSetting.shortcodePreview();
        });

        if ($('#shortcode_name').val() != 'st_image') {
            $('select option[value="large_image"]').hide();
        }

        $('body').on('trigger_select2', function(e) {
            $.HandleSetting.select2();
        });

        $('body').on('toggleDependencyAll', function(e) {
            $.HandleSetting.toggleDependencyAll();
        });

        // Send Ajax request for loading shortcode html at first time
        $.HandleSetting.renderModal();

        $.HandleSetting.select2();

        $.HandleSetting.icons();

        $.HandleSetting.actionHandle();

        $.HandleSetting.selectImage();

        $.HandleSetting.gradientPicker();

        $.HandleSetting.buttonGroup();

        $.HandleSetting.inputValidator();

        $.HandleSetting.initCopyStyle();

        // Init Copy to Clipboard action
        $.HandleSetting.copyToClipboard();

        $.HandleSetting.closeAllSelect2WhenClickModal();

        $.HandleSetting.handleResizeModal();

        $.HandleSetting.useBootstrapJS();

        $.HandleSetting.addTooltip();

        $.HandleSetting.addStyleBorderType();

        $.HandleSetting.addStyleHeadingType();

        $.HandleSetting.addSelectEditor();

        $.HandleSetting.datepicker();
        $.HandleSetting.timepicker();
        $.HandleSetting.editor();
        $.HandleElement.initAsyncPreviewMediaLoad();


        $('body').on('trigger_inline_edit', function(e) {
            $.HandleSetting.addTooltip();
        });
    };
})(jQuery);


var st_waitForFinalEvent = (function() {
    var timers = {};
    return function(callback, ms, uniqueId) {
        if (!uniqueId) {
            uniqueId = "Don't call this twice without a uniqueId";
        }
        if (timers[uniqueId]) {
            clearTimeout(timers[uniqueId]);
        }

        timers[uniqueId] = setTimeout(callback, ms);
    };
})();

function st_isObject(val) {
    if (val === null) {
        return false; }
    return ((typeof val === 'function') || (typeof val === 'object'));
}
