/**
 * Root wrapper div .st-pb-form-container, contains all content
 * Columns are seperated by a 12px seperators
 * HTML structure: .st-pb-form-container [.jsn-row-container [.jsn-column-container]+]+
 *
 */

function JSNLayoutCustomizer() { }

(function ($) {

	// Add flag for tracking event switching to pagebuilder tab
	var is_pagebuilder_tab = false;

	

	var spans_to_percent = {
		span1: '8.33%',
		span2: '16.66%',
		span3: '25%',
		span4: '33.33%',
		span5: '41.66%',
		span6: '50%',
		span7: '58.33%',
		span8: '66.66%',
		span9: '75%',
		span10: '83.33%',
		span11: '91.66%',
		span12: '100%',
	}

	JSNLayoutCustomizer.prototype = {
		init:function (_this) {
			// Get necessary elements
			this.main_wrapper = $("#form-design-content");
			this.wrapper = $(".st-pb-form-container.jsn-layout");
			this.wrapper_width = 0;
			this.columns = $(_this).find('.jsn-column-container');
			this.addcolumns = '.add-container';
			this.addsubrows = '.add-sub-row';
			this.clonerow = '.clone-row';
			this.addRowAbove = '.st-add-row-above';
			this.unnest_row_btn = '.item-row-unnest';
			this.addelements = '.st-more-element';
			//this.mainAddElement = '#st-add-element-btn-container a';
			this.resizecolumns = '.ui-resizable-e';
			this.deletebtn = '.item-delete';
			this.moveItemEl = "[class^='jsn-move-']";
			this.resize = 1;
			this.effect = 'easeOutCubic';

			// Initialize variables
			this.maxWidth = $('.st-pb-form-container.jsn-layout').width();

			// Do this to prevent columns drop
			//$('.st-pb-form-container.jsn-layout').css('width', this.maxWidth + 'px');
			this.spacing = 12;
			var self	= this;

			// Has not inited before, so call all functions
			this.addRow(this, this.wrapper);
			//this.updateSpanWidthPBDL(this, this.wrapper, this.maxWidth);
			this.initResizable();
			this.addColumn($("#tmpl-st_column").html());
			this.addSubrow($("#tmpl-st_subrow").html(), this.wrapper);
			this.clone_row();
			this.unnest_row();
			this.removeItem();
			this.moveItem();
			this.resizeHandle(this);
			this.addElement();
			this.showAddLayoutBox();
			this.showSaveLayoutBox();
			this.searchElement();
			this.rebuildSortable();
			this.on_drag_scroll();
			this.closeFilterElementOnPopover();
			this.event();

			//this.nesting_popout();

		},


		/**
		 * [WIP]
		 * Clicking on column which is very narrow
		 * opens it in isolation with full width for easy editing
		 * @return none
		 */
		nesting_popout: function ()
		{
			var timeout,
				elm,
				row,
				active = false;

			// vars for width and center
			var main_area,
				full_width,
				main_area_offset;

			// clicking on a column
			this.main_wrapper.delegate('.jsn-column-container', 'click', function(event)
			{
				elm = $(this);
				if(elm.width() > 100) return;

				// so parent rows etc are ignored
				event.stopPropagation();

				active = true;
				row = elm.closest('.jsn-row-container');

				elm.parents('.jsn-element-container').addClass('st_overflow_visible');
				row.addClass('st_row_popout');

				/*========================================
				=            Width and center            =
				========================================*/
				main_area = $('body');
				full_width = main_area.width();
				main_area_offset = $('body').offset().left;
				row.css('margin-left', 0);
				margin_left = row.offset().left - main_area_offset - (full_width  * 10 / 100);

				full_width = full_width  * 80 / 100;
				row.width(full_width).css('margin-left', '-'+margin_left+'px');
				/*=====  End of Width and center  ======*/


				$('<div></div>').attr('class', 'st_row_popup_overlay').appendTo('body').show();
			});

			// close btn click
			this.main_wrapper.delegate('.jsn-column-container .st_row_popout_close', 'click', function(event)
			{
				st_nesting_popout_close();
			});

			// outside row click
			$('body').delegate('.st_row_popup_overlay', 'click', function(event)
			{
				st_nesting_popout_close();
			});

			/**
			 * Closes the row popup and resets css
			 * @return
			 */
			function st_nesting_popout_close()
			{
				if(active != true) return;

				$('.jsn-element-container.st_overflow_visible').removeClass('st_overflow_visible');
				$('.jsn-row-container.st_row_popout').removeClass('st_row_popout').css({
					'margin-left':'0',
					'width':'100%'
				});
				$('.st_row_popup_overlay').remove();
			}
		},

		nesting: function ()
		{
			// for nested layouts add _[number] according to number of same parents

			var self = this,
				tag;

			// backwards compatibility for st_subrows
			self.convert_st_subrow();

			// for rows
			$('.jsn-row-container').removeClass('cbb-no-more-rows');
			$('.jsn-row-container').each(function ()
			{
				tag = 'st_row';
				if($(this).hasClass('jsn-subrow'))
				{
					tag = 'st_subrow';
				}

				if( self.apply_nesting(this, tag) === false)
				{
					// stop nesting check
					return false;
				}
			});

			// for columns
			$('.jsn-column-container > .jsn-column > .thumbnail').each(function ()
			{
				if( self.apply_nesting(this, 'st_column') == false)
				{
					// stop nesting check
					return false;
				}
			});
		},

		apply_nesting: function (elm, tag)
		{
			var self = this;
			var nest_level, data, patt;

			// get number of parents, starts from 0 so we had 1
			nest_level = $(elm).parents('.jsn-row-container').length + 1;

			// minus the direct parent from column and st_subrow
			if(tag == 'st_column' || tag == 'st_subrow') nest_level--;

			// maximum levels allowed
			// for rows higher than 3rd level
			if(tag == 'st_row' && nest_level > 3)
			{
				// if row is even above 4th level than push it out and show warning
				if(nest_level > 4)
				{
					console.log('nesting max reached');
					setTimeout(function ()
					{
						console.log('nesting error');

						$(elm).parents('.jsn-row-container:first').after( $(elm).clone() );
						$(elm).remove();

						console.log('Sorry! maximum of 4 nested rows are allowed.');

						// restart the process
						$(document).trigger('cbb-layout-changed');
					}, 1000);

					return false;
				}

				$(elm).addClass('cbb-no-more-rows');
			}

			// add underscore if more than 1 parents
			if(nest_level > 1) nest_level = '_' + nest_level;
			else nest_level = '';

			// opening tag
			patt = new RegExp('^\\['+ tag +'\\S*','i');
			data = $('> textarea:first', elm).val();
			data = data.slice(0, -1); // remove last bracket
			data = data.replace(patt, '['+tag+nest_level) + ']';

			$('> textarea:first', elm).text( data )

			// closing tag
			$('> textarea:last', elm).text( '[/'+ tag+nest_level +']' );

			// Edit button class
			$('.jsn-iconbar:first .element-edit', elm).attr('data-shortcode', tag+nest_level );
		},


		/**
		 * Converts old st_subrow to st_row when when possible
		 * such as when dragged to out of row or dragged into a column
		 */
		convert_st_subrow: function ()
		{
			var self = this,
				elm,
				tag = 'st_row'; // new tag to replace old

			$('.jsn-layout > .jsn-subrow, .jsn-element-container > .jsn-subrow').each(function ()
			{
				elm = this;

				// opening tag
				patt = new RegExp('^\\[st_subrow\\S*','i');
				data = $('> textarea:first', elm).val();
				data = data.slice(0, -1); // remove last bracket
				data = data.replace(patt, '['+tag) + ']';

				$('> textarea:first', elm).text( data )

				// closing tag
				$('> textarea:last', elm).text( '[/'+ tag +']' );

				// remove subrow indentification class so its not mistaken for subrow on later methods
				$(elm).removeClass('jsn-subrow')
			});
		},


		event: function ()
		{
			var self = this;
			$(document).on('st_pb_after_edit_element', function ()
			{
				self.initResizable();
				self.rebuildSortable();
			});

			// only runs when col, rows are added, duplicated and if rows are moved
			// unlike event "st-pagebuilder-layout-changed"
			$(document).on('cbb-layout-changed', function ()
			{
				self.nesting();
			});
		},

		// Make click outside to close the dropdown on popover.
		closeFilterElementOnPopover: function() {
			$('.popover').on("click", function(e) {
				var el = $(e.target);
				if (el.parents("#s2id_jsn_filter_element").length == 0) {
					$("#jsn_filter_element").select2("close");
				}
			});
		},

		// http://ejohn.org/blog/comparing-document-position/
		contains: function (a, b){
		  return a.contains ?
		    a != b && a.contains(b) :
		    !!(a.compareDocumentPosition(b) & 16);
		},

		// mouse move event when dragging
		on_drag_scroll_flag: false,
		on_drag_scroll_interval: null,
		on_drag_scroll_height: 0,
		on_drag_scroll: function (){
			var self = this;
	        $(document).mousemove(function(e) {
	        	if(self.on_drag_scroll_flag == false)
	        	{
	        		return true;
	        	}

	        	//self.on_drag_scroll_flag = false;
	        	var h = self.on_drag_scroll_height;
	            var mousePosition = e.pageY - $(window).scrollTop();
	            var topRegion = 100;
	            var bottomRegion = h - 100;
	            if(e.which == 1 && (mousePosition < topRegion || mousePosition > bottomRegion)){    // e.wich = 1 => click down !
	                var distance = e.clientY - h / 2;
	                distance = distance * 0.02; // <- velocity
	                $(document).scrollTop( distance + $(document).scrollTop());
	            }
	        });
		},

		on_drag_scroll_START: function (){
			var self = this;
			self.on_drag_scroll_height = $(window).height();
	        self.on_drag_scroll_flag = true;
		},

		on_drag_scroll_STOP: function (){
			var self = this;
	        self.on_drag_scroll_flag = false;
		},

		// Update sortable event for row and column layout
		rows_dragula: null,
		column_dragula: null,

		rebuildSortable_already_done: false,
		rebuildSortable: function() {
			var self = this;

			// Sortable for rows and elements. ONLY FIRE ONCE
			if(self.rebuildSortable_already_done == false)
			{
				self.rebuildSortable_already_done = true;

				self.rows_dragula = dragula({
				    accepts: function (el, target, container, sibling) {

				    	// dont accept elements outside rows
				    	if($(target).hasClass('st-pb-form-container') && $(el).hasClass('jsn-element'))
				    	{
				    		return false;
				    	}

				        // prevent dragged containers from trying to drop inside itself
				        return ! self.contains(el,target);
				    },
					moves: function (el, container, handle) {

						// allow item to be dragged without any specific handle - for elements
						if(el.classList.contains('jsn-element'))
						{
							return true;
						}

						// if handle within icon bar - for rows
						if( $(handle).closest( '.cbb-sort-handle' ).length > 0 )
							return true;

						// if handle is icon bar - for rows
						return handle.classList.contains('cbb-sort-handle');
					},
				    mirrorContainer: document.querySelector('.st-pb-form-container')
				}).on('drop', function (el, container) {

					// delete cache for rows as sub rows have width hidden
					if(el.classList.contains('jsn-row-container'))
						$.HandleElement.cache_delete( $(el).attr('data-cache-id') );

					self.on_drag_scroll_STOP();

					$(document).trigger('st_pb_after_edit_element');
					self.wrapper.trigger('st-pagebuilder-layout-changed');
					$(document).trigger('cbb-layout-changed');

  				}).on('drag',function(el,source){

			        self.on_drag_scroll_START();

			        if(el.classList.contains('jsn-item'))
			        	$('.st-preview-tooltip', el).tooltip('hide');

			    });



  				self.column_dragula = dragula({

				    accepts: function (el, target, container, sibling)
				    {
				    	// only move within same container/target
				    	if( $(el).parent().is( $(target) ) )
				    	{
				    		return true;
				    	}

				    	return false;
				    },
					moves: function (el, container, handle)
					{
						// dont allow if less than 2 columns
						if(container.childElementCount < 2)
						{
							return false;
						}


						// if handle within icon bar
						if( $(handle).closest( '.jsn-handle-drag' ).length > 0 )
							return true;


						// if handle is icon bar
						return handle.classList.contains('jsn-handle-drag');
					},

				    direction: 'horizontal',
				    mirrorContainer: document.querySelector('.st-pb-form-container')
				}).on('drop', function (el, container) {
					$(document).trigger('st_pb_after_edit_element');
					self.wrapper.trigger('st-pagebuilder-layout-changed');
					$(document).trigger('cbb-layout-changed');
  				});
			}

			//self.column_dragula.containers.push(container);
			self.rows_dragula.containers = [].slice.apply(document.querySelectorAll('.cbb-sortable-container'));
			self.column_dragula.containers = [].slice.apply(document.querySelectorAll('.st-row-content'));

			return;

			// columns sorting
			// Selector checks if it has 2nd column to verify there are more than 1 cols
			// $(".st-row-content:has(> div:nth-child(2))").sortable({
			$(".st-row-content").sortable({
				axis:'x',
				handle: "> .jsn-column > .thumbnail > .jsn-column-content > .jsn-handle-drag",
				placeholder: "cbb-drag-placeholder-vertical",
				tolerance: "pointer",
				cursorAt: { top:10, left: 10 },
				cursor: "move",
				distance: 5,
				start: $.proxy(function(event, ui) {

					ui.item.addClass("cbb-sorting-item");
					$('body').addClass("cbb-sorting-engaged");

					// Hide resizable handle
					ui.item.parents(".st-row-content").find(".ui-resizable-handle").hide();

				}, this),
				update: function(event, ui) {
					ui.item.removeClass("cbb-sorting-item");
					$('body').removeClass("cbb-sorting-engaged");
				},
				stop: $.proxy(function(event, ui) {
					$('body').removeClass("cbb-sorting-engaged");
					ui.item.removeClass("cbb-sorting-item");

					// Show resizable handle
					ui.item.parents(".st-row-content").find(".ui-resizable-handle").show();

					self.wrapper.trigger('st-pagebuilder-layout-changed', [ui.item]);
				}, this)
			});

			$(".st-row-content").disableSelection();

			// for rows with less then 2 columns, disable col sorting
			$(".st-row-content").each(function ()
			{
				if( $('> .jsn-column-container', this).length < 2 )
				{
					$(this).sortable("destroy"); //call widget-function destroy
				}
			});
		},

		// Update column width when window resize
		resizeHandle:function (self)
		{
			var _self = self;
			$(window).resize(function()
			{
				st_waitForFinalEvent(function() {
					var _rows	= $('.jsn-row-container', _self.wrapper);
					_self.wrapper.trigger('st-pagebuilder-column-size-changed', [_rows]);
				}, 100, "st_resizeHandle-window");
			});
		},

		// Reset when resize window/pagebuilder
		fnReset:function(self, trigger)
		{
			if((self.resize || trigger) && $("#form-design-content").width())
			{
				if ( is_pagebuilder_tab == true )
				{
					// Set 500 miliseconds when switching to pagebuilder tab.
					var timerId = setTimeout(function ()
					{
						// self.initResizable();

						// Close indicator loading in pagebuiler wrapper
						if(false == st_loader_running())
						{
							$.HandleElement.hideLoading();
						}
						$(".st-pb-form-container.jsn-layout").show();

						is_pagebuilder_tab = false;
						clearTimeout(timerId);
					}, 500);
				}
				else
				{
					// self.update_cols();
				}
			}

			// Sortable elements
			// this.sortableElement();
		},


		// Resize columns
		initResizable: function(countColumn, getStep, no_auto_update_cols)
		{
			var self = this;

			if(! no_auto_update_cols)
			{
				_.delay(function ()
				{
					self.update_cols();
				}, 100);
			}

			var tot_width;
			var min_width = 0;
			var spans, span, next_col, current_width;

			var sibTotalWidth, container, px_width_spans;
		    $(".jsn-column-container").resizable({
		        handles: 'e',
		        start: function(event, ui){
					// Disable resize handle
					self.resize = 0;

					container = ui.originalElement.parent();

					px_width_spans = self.percent_width_spans_to_px(container);

					$(this).resizable('option', 'grid', [px_width_spans.span1, 0]);
					//$(this).resizable('option', 'minWidth', px_width_spans.span1);
					$(this).resizable('option', 'maxWidth', container.innerWidth() - px_width_spans.span1);

			        self.col_percent('show', ui.originalElement);
		            sibTotalWidth = ui.originalSize.width + ui.originalElement.next().outerWidth();
		        },
		        resize: function(event, ui){
		            ui.originalElement.next().width(sibTotalWidth - ui.size.width);
		            self.col_percent('update', ui.originalElement);
		        },
		        stop: function(event, ui){
					$(this).resizable('option', 'maxWidth', '');
					//$(this).resizable('option', 'minWidth', '');

					// current col
		            var cellPercentWidth=100 * ui.originalElement.outerWidth()/ container.innerWidth();
					span = self.width_to_span( cellPercentWidth );
					self.apply_span_to_col(ui.originalElement, span);

					// next col
		            var nextCell = ui.originalElement.next();
		            var nextPercentWidth=100 * nextCell.outerWidth()/container.innerWidth();
					span = self.width_to_span( nextPercentWidth );
					self.apply_span_to_col(nextCell, span);

					// hide % tooltips
					self.col_percent('hide');

					// Re-enable resize handle
					self.resize = 1;
		        }
		    });

/*
			$(".jsn-column-container:not(:last-child)").each($.proxy(function (i, e)
			{
				$(e).resizable({
					grid : min_width,
					minWidth : min_width,
					handles : 'e',
					start : function(event, ui)
					{
						spans = self.make_spans('', $(this).parent('.st-row-content'));

						min_width = spans.span1;
						$(this).resizable('option', 'grid', min_width);
						$(this).resizable('option', 'minWidth', min_width);

						next_col = $(this).next();
						tot_width = $(this).width() + next_col.width();
						$(this).resizable('option', 'maxWidth', (tot_width - min_width));

						// Disable resize handle
						self.resize = 0;

						self.col_percent('show', $(this), spans);
					},
					resize : function()
					{
						current_width = $(this).width();
						$(this).width( self.width_to_span( spans, current_width, true ) );

						$(this).next().width(tot_width - $(this).width());

						self.col_percent('update', $(this), spans);
					},
					stop: function ()
					{
						$(this).resizable('option', 'maxWidth', '');
						$(this).resizable('option', 'minWidth', '');

						span = self.width_to_span( spans, $(this).width() );
						self.apply_span_to_col(this, span);


						span = self.width_to_span( spans, next_col.width() );
						self.apply_span_to_col(next_col, span);

						// Re-enable resize handle
						self.resize = 1;

						self.col_percent('hide', $(this));
					}
				});
			}, this));

*/
			// Remove duplicated resizable-handle div
			$(".jsn-column-container").each(function()
			{
				if ($(this).find('> .ui-resizable-handle').length > 1) {
					$(this).find('> .ui-resizable-handle').last().remove();
				}
			});
		},

		percent_width_spans_to_px: function (container)
		{
			var container_width = container.innerWidth(),
				px_spans = {};
			$.each(spans_to_percent, function (span, i)
			{
				 // convert to px
				px_spans[ span ] = (parseFloat(i) * container_width) / 100;
				px_spans[ span ] = px_spans[ span ].toFixed(2);
			});

			return px_spans;
		},


		col_percent: function (action, col, spans)
		{
			var self = this;

			if(action=='show' || action=='update')
			{
				var width;
				col.closest('.st-row-content').find('> .jsn-column-container').each(function ()
				{
					width = ($(this).outerWidth() / $(this).parent().innerWidth()) * 100;
					$('.cbb-col-percent:first', this).text( width.toFixed(2) + '%' );

					if(action=='show') $('.cbb-col-percent:first', this).show();
				});
			}
			else
			{
				$('.cbb-col-percent').hide();
			}
		},


		apply_span_to_col: function ($col, span)
		{
			// apply width
			$( $col ).css('width', spans_to_percent[ span ]);

			// apply data attr
			$('> .jsn-column > .thumbnail > .jsn-column-content', $col).attr('data-column-class', span);
			// apply to textarea
			$('textarea[name="shortcode_content[]"]', $col).first().html($('textarea[name="shortcode_content[]"]', $col).first().html().replace(/span[0-9]{1,2}/g, span));
		},

		// (re)apply column widths
		update_cols: function (target)
		{
			if(! target) target = document;

			var self = this;
			var row_content, row_content_width, col_span_class;

			//$('.st-row-content > .jsn-column-container', target).width(0);

			$('.st-row-content', target).each(function ()
			{
				$('> .jsn-column-container', this).each(function ()
				{
					col_span_class = $('> .jsn-column > .thumbnail > .jsn-column-content', this).attr('data-column-class');
					$(this).css('width', spans_to_percent[ col_span_class ] );
				});

			});
		},

		make_spans: function (total_width, target)
		{
			if(! total_width) total_width = $(target).width();

			var spans = {};

			for (var i = 1; i < 13; i++)
			{
				spans["span"+i] = (total_width / 12) * i;
				// convert to %
				spans["span"+i] = (spans["span"+i] / total_width) * 100;

				spans["span"+i] = parseInt( this.toFixed(spans["span"+i]) ) + '%';
			}
			return spans;
		},

		width_to_span: function(width, get_span_width)
		{
			var currentDiff,
				lowestSpan = {},
				closestDiff = 10000;

			$.each(spans_to_percent, function (span, i)
			{
			    currentDiff = Math.abs(width - parseFloat(i) );
			    if(currentDiff < closestDiff)
			    {
				    closestDiff = currentDiff;
			        lowestSpan['width'] = i;
			        lowestSpan['span'] = span;
			    }
			});

			if(get_span_width) return lowestSpan['width'];

			return lowestSpan['span'];
		},

		toFixed:function(value, precision){
			var power = Math.pow(10, precision || 0);
			return String(Math.round(value * power) / power);
		},

		getSpan:function(this_){
			return $(this_).find('.jsn-column-content').first().attr('data-column-class').replace('span', '');
		},



		// Add Row
		addRow: function(self, this_wrapper){
			this.main_wrapper.delegate('#jsn-add-container', 'click', function(event, get_chosen_layout) {
				event.preventDefault();

				self._addRow(this_wrapper, '', null, null, get_chosen_layout);
				$(this).blur();
			});

			// sub row add btn
			this.main_wrapper.delegate('.jsn-add-row', 'click', function(event) {
				event.preventDefault();

				self._addRow( $(this).closest('.jsn-column-container').find('.jsn-element-container:first') , '');
				$(this).blur();
			});

			// above row add btn
			this.main_wrapper.delegate(this.addRowAbove, 'click', function(event) {
				event.preventDefault();

				self._addRow( '' , '', '', '', '', $(this).closest('.jsn-row-container'));
				$(this).blur();
			});

			this.main_wrapper.delegate('.st-layout-thumbs .thumb-wrapper', 'click', function(event) {
				event.stopPropagation();
				$(this).parent().find('.active').removeClass('active');
				$(this).addClass('active');

				$('#jsn-add-container').trigger('click', [true]);
			});

			// Set animation on hover "Add Row" button
			// this.main_wrapper.delegate('#jsn-add-container', 'mouseover', function(event) {
			// 	$('.st-layout-thumbs').addClass('st-mouse-over');
	  //           st_waitForFinalEvent(function() {
			// 		if ( $('.st-layout-thumbs').hasClass('st-mouse-over') && ! $('.st-layout-thumbs').hasClass('open') ) {
			// 			$('.st-layout-thumbs').addClass('open');
			// 			$('.st-layout-thumbs').css({'height': 'auto', 'max-height': '150px'});
			// 		}
	  //           }, 200, "st-layout-thumbs-show");
			// });

			// this.main_wrapper.delegate('#jsn-add-container', 'mouseleave', function(e) {
			// 	e.preventDefault();
			// 	$('.st-layout-thumbs').removeClass('st-mouse-over');
			// });

			// $('#form-design-content').on('mouseleave', function (e) {
			// 	e.preventDefault();
			// 	$('.st-layout-thumbs').removeClass('open');
			// 	$('.st-layout-thumbs').css({'max-height': '1px'});
			// });

		},

		_addRow: function(this_wrapper, target, row_html, position, get_chosen_layout, insert_before) {
			var self = this;

			if ($('.st-pb-form-container.jsn-layout').find('.jsn-row-container').last().is(':animated')) return;

			if (row_html && position)
			{
				row_html = $(row_html).css('display', '');

				var rows = $('#st_page_builder .jsn-row-container');

				if (rows.length) {
					if (position.row >= rows.length) {
						rows.last().after(row_html);
					} else {
						for (var i = 0; i < rows.length; i++) {
							if (i == position.row) {
								rows.eq(i).before(row_html);

								break;
							}
						}
					}
				} else {
					this_wrapper.prepend(row_html);
				}
			} else {
				// if not choose any layout
				row_html = $(st_pb_remove_placeholder($('#tmpl-st_row').html(), 'custom_style', 'style="opacity:0"'));
				var full_row_html = row_html.find('.st-row-content').html();

				var html = '';
				if( get_chosen_layout && $('.st-layout-thumbs .active').length > 0 ) {
					var columns = $('.st-layout-thumbs .active').attr('data-columns');
					columns = columns.split(',');
					$.each( columns, function( i, v ) {
						html += full_row_html.replace( /\bspan\d+\b/g, 'span' + v );
					});
				}
				if ( html !== '' )
					row_html.find('.st-row-content').html( html );

				if(insert_before)
				{
					$(row_html).insertBefore(insert_before);
				}
				else if(! target) this_wrapper.append(row_html);
				else $(target).prepend(row_html);

				// Trigger an event after adding an element
				$(document).trigger('st_pb_after_add_element', row_html);


				setTimeout(function () {
					$(row_html).css('opacity', '1');
				}, 1);
			}

			// Update width for column of this new row
			self.update_cols();

			self.initResizable();
			self.rebuildSortable();
			self.wrapper.trigger('st-pagebuilder-layout-changed');
			$(document).trigger('cbb-layout-changed');
		},

		// Wrap content of row
		swapContentRow: function(a, b, direction) {
			if (a.is(':animated') || b.is(':animated')) {
				return;
			}

			var self = this,
				this_wrapper = self.wrapper,
				stylea = self.getBoxStyle(a),
				styleb = self.getBoxStyle(b),
				time = 500,
				extra1 = 16,
				extra2 = 16,
				effect = self.effect,
				before = [a.outerHTML(), b.outerHTML()];

			if (direction > 0) {
				a.animate({top: '-' + (styleb.height + extra1) + 'px'}, time, effect);

				b.animate({top: '' + (stylea.height + extra2) + 'px'}, time, effect, function() {
					a.css('top', '0px');
					b.css('top', '0px');
					a.insertBefore(b);

					// Trigger an event after swapping elements
					$(document).trigger('st_pb_after_edit_element', [$([b[0], a[0]]), before]);
				});
			} else {
				a.animate({top: '' + (styleb.height + extra2) + 'px'}, time, effect);

				b.animate({top: '-' + (stylea.height + extra1) + 'px'}, time, effect, function() {
					a.css('top', '0px');
					b.css('top', '0px');
					a.insertAfter(b);

					// Trigger an event after swapping elements
					$(document).trigger('st_pb_after_edit_element', [$([b[0], a[0]]), before]);
				});
			}
		},

		clone_row: function ()
		{
			var self = this;
			this.wrapper.delegate(this.clonerow, "click",function()
			{
				var row = $(this).closest(".jsn-row-container");
				var clone_item = row.clone();

				// removes cache, id wrapper etc to make it unique
				$.HandleElement.element_to_unique(clone_item);

				clone_item.insertAfter(row);

				self.initResizable();
				self.rebuildSortable();
				self.wrapper.trigger('st-pagebuilder-layout-changed');
				$(document).trigger('cbb-layout-changed');
			});
		},

		unnest_row: function ()
		{
			var self = this;
			this.wrapper.delegate(this.unnest_row_btn, "click",function()
			{
				var row = $(this).closest(".jsn-row-container");

				// remove cache id from cloned item
				row.removeAttr('data-cache-id');

				row.css('opacity', '0');

				// wait for opacity zero animation
				setTimeout(function () {
					row.insertAfter( row.parents(".jsn-row-container:first") );

					// fake wait before apply new opacity
					setTimeout(function () {
						row.css('opacity', '1');
						$(document).trigger('cbb-layout-changed');
					}, 30);

				}, 300);

				return false;
			});
		},

		// Handle when click Up/Down Row Icons
		moveItem:function(){
			var self = this;

		},

		// Add Column
		addColumn: function(column_html) {
			var self = this;

			this.wrapper.delegate(this.addcolumns, 'click', function() {
				self._addColumn(column_html, this);
			});
		},

		_addColumn: function(column_html, target, position) {
			var self = this, parentForm, countColumn;

			parentForm = $(target).closest(".jsn-row-container");


			countColumn = parentForm.find("> .st-row-content > .jsn-column-container").length;

			if (countColumn >= 12)
			{
				// max amount of cols reached
				return false;
			}

			countColumn++;

			var span = parseInt(12 / countColumn);
			var exclude_span = (12 % countColumn != 0) ? span + (12 % countColumn) : span;

			// Update span old columns
			parentForm.find("> .st-row-content > .jsn-column-container").each(function()
			{
				self.apply_span_to_col(this, 'span'+span);
			});


			// Update span new column
			column_html = $(column_html.replace(/span[0-9]{1,2}/g, 'span' + exclude_span));

			// Add new column
			var rowContent = parentForm.find("> .st-row-content");

			// update current cols widths so no jumps happen
			self.update_cols(parentForm);

			rowContent.append(column_html);

			// Trigger an event after adding an element
			$(document).trigger('st_pb_after_add_element', column_html);


			// Actiave resizable for columns
			self.initResizable();
			self.rebuildSortable();
			self.wrapper.trigger('st-pagebuilder-layout-changed', [parentForm]);
			$(document).trigger('cbb-layout-changed');
		},


		// Add sub row
		addSubrow: function(subrow_html, this_wrapper) {
			var self = this;

			this.wrapper.delegate(this.addsubrows, 'click', function() {
				self._addSubrow(subrow_html, this, this_wrapper);
			});
		},

		_addSubrow: function(column_html, target, this_wrapper, position) {
			var self = this, parentForm;

			parentForm = $(target).parents(".jsn-row-container");


			// Add new column
			var rowContent = parentForm.find(".st-row-content-subrows");


			if (typeof position != 'undefined') {
				if (typeof position == 'number') {
					if (position < columns.length) {
						columns.eq(position).before(column_html);
					} else {
						columns.last().after(column_html);
					}
				} else {
					position.prepend(column_html);
				}
			} else {
				rowContent.append(column_html);
				// Trigger an event after adding an element
				$(document).trigger('st_pb_after_add_element', $(column_html));
			}

			// Animation
			var height_ = $(column_html).height();

			$(column_html)
				.css({opacity: 0, height: 0, display: 'block'})
				.addClass('overflow_hidden')
				.show()
				.animate({height: height_}, 300, self.effect, function() {
					$(this).animate({opacity:1}, 300, self.effect, function() {
						$(column_html)
							.css({opacity: '', height: '', display: ''})
							.removeClass('overflow_hidden');
					});
				});

			// Update width for column of this new row
			var parentForm = $(column_html);
			self.update_cols(rowContent);

			// Enable/disable move icons
			self.rebuildSortable();
			$(document).trigger('cbb-layout-changed');
		},


		// Remove Row/Column/Element Handle
		removeItem: function(){
			var self = this, this_wrapper = this.wrapper;

			this.wrapper.delegate(this.deletebtn, 'click', function() {
				self._removeItem(this_wrapper, this);
			});
		},

		_removeItem: function(this_wrapper, target, silent) {
			var self = this;

			if ($(target).hasClass('row')) {
				$.HandleCommon.removeConfirmMsg($(target).closest(".jsn-row-container"), 'row', null, null, silent);
				self.wrapper.trigger('st-pagebuilder-layout-changed', [parentForm]);
			} else if ($(target).hasClass('column'))
			{
				var	totalWidth = this_wrapper.width(),
					parentForm = $(target).closest(".jsn-row-container"),
					countColumn = parentForm.find(".jsn-column-container").length,
					countDirectColumn = parentForm.find("> .st-row-content > .jsn-column-container").length;
					//countColumn = parentForm.find("> .st-row-content > .jsn-column-container").length;

				countColumn--;
				countDirectColumn--;

				if (countColumn == 0)
				{
					// if has sub row then dont delete
					//if(countAllColumn > 1) return false;

					// Remove this row
					$.HandleCommon.removeConfirmMsg(parentForm, 'column', $(target).closest(".jsn-column-container"), null, silent);
					self.wrapper.trigger('st-pagebuilder-layout-changed', [parentForm]);
					return true;
				}

				var	span = parseInt(12 / countDirectColumn),
					exclude_span = (12 % countDirectColumn != 0) ? span + (12 % countDirectColumn) : span;

				// Remove current column
				if (!$.HandleCommon.removeConfirmMsg($(target).closest(".jsn-column-container"), 'column', null, function() {
					// Update span remain columns
					parentForm.find("> .st-row-content > .jsn-column-container").each(function () {
						self.apply_span_to_col(this, 'span'+span);
					});

					// Update span last column
					self.apply_span_to_col(parentForm.find("> .st-row-content > .jsn-column-container").last(), 'span'+exclude_span);

					// Update width for all columns
					self.update_cols();

					// Actiave resizable for columns
					self.initResizable();
					self.rebuildSortable();
					self.wrapper.trigger('st-pagebuilder-layout-changed', [parentForm]);
				}, silent)) {
					return false;
				}
			}

			self.update_cols();
			$(document).trigger('cbb-layout-changed');
		},

		// Get element's dimension
		getBoxStyle:function(element){
			var style = {
				width:element.width(),
				height:element.height(),
				outerHeight:element.outerHeight(),
				outerWidth:element.outerWidth(),
				offset:element.offset(),
				margin:{
					left:parseInt(element.css('margin-left')),
					right:parseInt(element.css('margin-right')),
					top:parseInt(element.css('margin-top')),
					bottom:parseInt(element.css('margin-bottom'))
				},
				padding:{
					left:parseInt(element.css('padding-left')),
					right:parseInt(element.css('padding-right')),
					top:parseInt(element.css('padding-top')),
					bottom:parseInt(element.css('padding-bottom'))
				}
			};

			return style;
		},

		// Sortable Element
		sortableElement: function() {
			var self = this;


			$(".jsn-element-container").disableSelection();
		},

		// Show popover box
		showPopover:function(box, e, self, this_, callback1, callback2){
			$(document).trigger('click');
			if(box.is(':animated')) return;
			e.stopPropagation();
			box.hide();
			box.fadeIn(500);

			if(callback1)
				callback1();

			// Show popover
			var elmStylePopover = self.getBoxStyle(box.find(".popover")),
			parentStyle = self.getBoxStyle(this_),
			offset_ = {};
			offset_.left = parentStyle.offset.left - elmStylePopover.outerWidth / 2 + parentStyle.outerWidth / 2;
			offset_.top = parentStyle.offset.top - elmStylePopover.height;

			// Check if is first row or not
			var row_idx= $(".st-pb-form-container.jsn-layout .jsn-row-container").index(this_.parents('.jsn-row-container'));
			var element_in_col= this_.parent('.jsn-column-content').find('.jsn-element').length;
			offset_.top = (row_idx == 0 && element_in_col < 3) ? (offset_.top + 30) : offset_.top;
			box.offset(offset_).click(function (e) {
				e.stopPropagation();
			});
			if($(window).height() > elmStylePopover.height){
				// yunus edit
				//$('html, body').animate({scrollTop: offset_.top - 60}, 'fast');
			}
			$(document).click(function(e){
				if (e.button == 0) {
					box.hide();
				}
			});

			if(callback2)
				callback2();
		},

		// Show Add Elements Box
		addElement:function(){

			var self = this;
			var report_modal;

			// [WIP] DRAG ELEMENTS FROM ADD DIALOG
			self.elements_dragula = dragula({
			    accepts: function (el, target, container, sibling) {
			    	// dont accept elements outside rows
			    	// if($(target).hasClass('st-pb-form-container') && $(el).hasClass('jsn-item'))
			    	// {
			    	// 	return false;
			    	// }

			        // prevent dragged containers from trying to drop inside itself
			        return ! self.contains(el,target);
			    },
				moves: function (el, container, handle) {

					// allow item to be dragged without any specific handle - for elements
					if(el.classList.contains('jsn-element'))
					{
						return false;
					}

					return true;
				},
				copy: true,
				revertOnSpill: true,
			    mirrorContainer: document.querySelector('#form-design-content')
			}).on('drop', function (el, container) {

				self.on_drag_scroll_STOP();
				self.elements_dragula.containers = [];

				var this_ = $('.shortcode-item', el);

				var $shortcode = $(this_).attr('data-shortcode');
				var $type = $(this_).parent().attr('data-type');

				if($.PbDoing.addElement)
					return;
				$.PbDoing.addElement = 1;

				$('.jsn-modal:last').trigger('close');
				//$.HandleElement.showLoading();
				//report_modal.unhide();

				// Get title of clicked element
				clk_title_el = $.trim($(this_).html().replace(/<i\sclass.*><\/i>/, ''));

		    	if( $(el).hasClass('jsn-item-row') )
		    	{
		    		self._addRow( '' , '', '', '', '', $(el));
		    		$(el).remove();
		    		$.PbDoing.addElement = 0;
		    		return true;
		    	}
		    	else if($(container).hasClass('st-pb-form-container') && $(el).hasClass('jsn-item'))
		    	{
		    		// create new row in position
		    		self._addRow( '' , '', '', '', '', $(el));
		    		$.PbDoing.addElementWithRow = $(el).prev();
		    		// insert the new element inside the row's column's element area
		    		$.HandleElement.appendToHolder($shortcode, null, $type, null, null, $.PbDoing.addElementWithRow.find('.cbb-sortable-container') );
		    		$(el).remove();
		    		return true;
		    	}

				// Append element to PageBuilder
				$.HandleElement.appendToHolder($shortcode, null, $type, null, null, $(container), $(el) );
				//el.remove();

			}).on('drag',function(el,source){

		        self.on_drag_scroll_START();
		        report_modal.hide(110);

			}).on('cancel',function(el,source){
		        self.on_drag_scroll_STOP();
		        report_modal.unhide();		        
		    });


			var self = this;
			var template_elements = wp.template( "wgb-elements" );
			this.main_wrapper.delegate(this.addelements,"click",function(e){
				// check if modal aleady being used then close it
				if($.IGModal_existing_check(this) == false) return false;


				// Show loading icon
            	$.HandleElement.showLoading();


				var frame_id  = 'st-report-bug-modal';
				var frame_url = St_Ajax.st_modal_url + '&st_add_element=1';
				var $elm = $(this);

				report_modal = new $.IGModal_new({
					iframe: false,
					dialogClass: 'st-dialog jsn-bootstrap3',
					jParent: window.parent.jQuery.noConflict(),
					title: St_Translate.select_element_title,
					//url: frame_url,
					//data: template_elements(),
					buttons: [{
						'text'	: '<i class="fa fa-times"></i>',
						'id'	: 'close',
						'class' : 'cbb-btn-icon',
						'click'	: function()
						{
							report_modal.close();
						}
					}],
					
					after_close: function (instance) {
						self.elements_dragula.containers = [];
					},

					loaded: function (obj, iframe) {


					},

					fadeIn:200,
					scrollable: true,
				});
				report_modal.show(function (modal)
				{
					$.HandleElement.hideLoading();
					modal.container.html( template_elements() );
					modal.open();

					if ( $('#st-add-element-modal').length == 0 ) {
						report_modal.container.attr('id', 'st-add-element-modal');
					}

					var jParent  = modal.container.contents();
					var html_box = jParent.find(".jsn-elementselector").clone();

					var html_box = $("<div />").append('<div id="st-shortcodes" class="st-add-element add-field-dialog jsn-bootstrap3">' + html_box.html() + '</div>').html();
					$("#st-add-element").remove();
					$('.jsn-modal').html(html_box);


					$('.jsn-modal .jsn-fieldset-filter').prependTo(".cbb-p-buttons");

					var box = $("#st-add-element");
					$(box).show();

					// clickable shortcodes to append on current column or drag only
					if($elm.parent().hasClass('st-main-btn'))
					{
						// only drag
						$('.st-add-element').removeClass('st-appendable');

					}
					else
					{
						// clickable
						$('.st-add-element').addClass('st-appendable');
					}

					$.HandleCommon.setFilterFields('.cbb-panel');
			        $.HandleCommon.setQuickSearchFields('.cbb-panel');

					self.update_cols();

					// [WIP] DRAG ELEMENTS FROM ADD DIALOG
					self.elements_dragula.containers = [].slice.apply(document.querySelectorAll('.cbb-sortable-container'));
					self.elements_dragula.containers.push( document.querySelector('#st-add-element-modal .jsn-items-list') );

					$.HandleElement.__changed = false;
				});
			})
		},

		// re-calculate sizes for modal select elements
		reCalculateSize: function (box) {

			//return;

			if ( $('.jsn-modal:last').attr('id') == 'st-add-element-modal' ) {
				var width = $.HandleElement.resetModalSize(0, 'w');
				var height = $(window.parent).height() - 100;
				$(box).width(width);
				$(box).height(height);
				$('#st-add-element-modal').height('100%');
				$('.jsn-items-list', $(box)).height(height - 160);
			}
		},

		// Show Add Layout Box
		showAddLayoutBox:function(){
			var self = this;
			var box = $("#st-add-layout");
			$('#premade-layout').click(function(e){
				self.showPopover(box, e, self, $(this));
			});

			// Toggle Save/Upload layout form
			$('.layout-action').click(function(e){
				$(this).toggleClass('hidden');
				$(this).next('.layout-toggle-form').toggleClass('hidden');
			});
		},

		// Save layout
		showSaveLayoutBox:function(){
			$('#st-pb-save-layout').click(function(e){
				$(this).toggle();
				$('#st-pb-layout-form').toggleClass('hidden');
			});
		},

		// Search elements in "Add Element" Box
		searchElement:function(){
			var self = this;
			$.HandleCommon.setQuickSearchFields('#st-add-element');
		},

		// Animation filter
		elementFilter:function(id_parent, value, data){
			var $container = $(id_parent + ' .jsn-items-list');
			var selector = '.jsn-item';
			var item = selector;
            if(data == null) {
				data = 'data-value';
			}
            if(value == '' || value == 'all') {
				selector += '['+data+'!="shortcode"]';
			}
			if(value != '' && value != 'all')
				selector += '['+data+'*="'+value+'"]';
			var data_sort = $(id_parent + ' select.jsn-filter-button').val();
			if(data == 'data-value' && data_sort != 'all'){
				selector += '[data-sort="'+data_sort+'"]';
			}
			// Process for case is 'all'
			if ( data_sort == 'all' ) {
				var new_selector = '';
				// Get all options in option group contain 'all' case
				var option_selected = $(id_parent + ' select.jsn-filter-button option:selected');
				if ( $(option_selected).parent('optgroup').length > 0 ) {
					var option_selector_arr = [];
					$(option_selected).parent('optgroup').find('option').each(function () {
						option_selector_arr.push( selector + '[data-sort="'+$(this).val()+'"]' );
					});
					new_selector = option_selector_arr.join(',');
				}
				// Build selector with all cases.
				selector = new_selector;
			}
			$container.find(item).stop().fadeOut(100);

			var categories_visible = true;
			if(value != '' && value != 'all' && value != 'standardelements')
			{
				categories_visible = false;
				$container.find('.jsn-items-cat').stop().fadeOut(100);
			}
			else if(value == 'standardelements' || value == '')
			{
				categories_visible = true;
				$container.find('.jsn-items-cat').stop().fadeIn();
			}

			var found = [],
				found_name; 
			
			$container.find(selector).each(function () {
				found_name = $(this).data('value');		

				if(categories_visible == false && found.length > 0 && $.inArray(found_name, found) !== -1)
				{
					return true;
				}

				$(this).stop().fadeIn();

				found.push( found_name );
			});

			if (value == 'shortcode') {
				$(id_parent + ' .jsn-quicksearch-field').hide(100);
			}else{
				if ($(id_parent + ' .jsn-quicksearch-field').css('display') == 'none') {
					$(id_parent + ' .jsn-quicksearch-field').show(100);
				}
			}
		},

		// Filter elements in "Add Element" Box
		filterElement:function(value, filter_data){
			var resultsFilter = $('#st-add-element .jsn-items-list');
			if (value != "all") {
				$(resultsFilter).find("li").hide();
				$(resultsFilter).find("li").each(function () {
					var textField = (filter_data == 'value') ? $(this).attr("data-value").toLowerCase() : $(this).attr("data-sort").toLowerCase();
					if (textField.search(value.toLowerCase()) === -1) {
						$(this).hide();
					} else {
						$(this).fadeIn(500);
					}
				});
			}
			else $(resultsFilter).find("li").show();
		}
	};

	// Separate become common functions to call directly.
	$.HandleCommon = $.HandleCommon || {};

	// Confirm message when delete item
	$.HandleCommon.removeConfirmMsg = function(item, type, column_to_row, callback, silent) {
		var self = this, msg = '', show_confirm = !silent;

		if (show_confirm) {
			switch (type) {
				case 'row':
					if(item.find('.jsn-column-content').find('.shortcode-container').length == 0)
						show_confirm = 0;
					msg = St_Translate.delete_row;
					break;
				case 'column':
					var check_item = (column_to_row != null) ? column_to_row : item;
					if(check_item.find('.shortcode-container').length == 0)
						show_confirm = 0;
					msg = St_Translate.delete_column;
					break;
				default:
					msg = St_Translate.delete_element;
			}
		}

		var confirm_ = show_confirm ? confirm(msg) : true;

		if (confirm_) {
			if (!silent) {
				// Trigger an event before deleting an element
				$(document).trigger('st_pb_before_delete_element', item);
			}

			if (silent) {
				item.remove();

				if (type == 'column') {
					if (callback != null) {
						callback();
					}
				}
			} else {
				if (type == 'row') {
					item.animate({opacity:0}, 300, JSNLayoutCustomizer.prototype.effect, function() {
						item.animate({height:0}, 300, JSNLayoutCustomizer.prototype.effect, function() {
							item.remove();
						});
					});
				} else if (type == 'column') {
					item.animate({height:0}, 500, JSNLayoutCustomizer.prototype.effect, function() {
						item.remove();

						if (callback != null) {
							callback();
						}
					});
				} else {
					item.remove();
				}
			}

			return true;
		}

		return false;
	};

	// Add event for filter field after load select element popover
	$.HandleCommon.setFilterFields = function (id_parent) {
		// Filter
		var filter_select = $(id_parent + " select.jsn-filter-button");
		filter_select.select2({
			minimumResultsForSearch:-1
		});

		if($(id_parent + " .jsn-quicksearch-field").val() != ''){
			$(id_parent + " #reset-search-btn").trigger("click");
		}
		else
			JSNLayoutCustomizer.prototype.elementFilter(id_parent, filter_select.val(), 'data-sort');

		$(id_parent + " .jsn-quicksearch-field").focus();
	};

	/**
	 * Preserve formating html entities (such as &nbsp; etc) while getting textarea value
	 * @param  {jquery element} $textarea get value from
	 * @return {string}           textarea content with html
	 */
	$.HandleCommon.textareaDecode = function ($textarea) {
		//var html = $('<div>'+ $textarea.html() +'</div>').text();
		var html = $textarea.text();
		return html;
	};

	$.HandleCommon.setQuickSearchFields = function (id_parent) {
		$.fn.delayKeyup = function (callback, ms) {
			var timer = 0;
			var el = $(this);
			$(this).keyup(function () {
				clearTimeout(timer);
				timer = setTimeout(function () {
					callback(el)
				}, ms);
			});
			return $(this);
		};
		$(id_parent + ' .jsn-quicksearch-field').keydown(function (e) {
			if(e.which == 13 && $('.jsn-item.el_button button:visible').first().length > 0 )
			{
				$('.jsn-item.el_button button:visible').first().click();
				return false;
			}
		});
		$(id_parent + ' .jsn-quicksearch-field').delayKeyup(function(el) {
			if($(el).val() != '')
				$(id_parent + " #reset-search-btn").show();
			else
				$(id_parent + " #reset-search-btn").hide();

			///self.filterElement($(el).val(), 'value');
			JSNLayoutCustomizer.prototype.elementFilter(id_parent, $(el).val().toLowerCase());
		}, 200);
		$(id_parent + ' .jsn-filter-button').change(function() {
			///self.filterElement($(this).val(), 'type');
			JSNLayoutCustomizer.prototype.elementFilter(id_parent, $(this).val(), 'data-sort');
		})
		$(id_parent + ' #reset-search-btn').click(function(){
			///self.filterElement("all");
			JSNLayoutCustomizer.prototype.elementFilter(id_parent, '');
			$(this).hide();
			$(id_parent + " .jsn-quicksearch-field").val("");
		})

	};

	$(document).ready(function() {
		// ProStyler Builder: get textarea content
		var st_pg_html = '';
		// ProStyler Builder: check if content has changed
		var _change_pagebuilder = 1;
		// Classic Editor: check if content has changed
		var _change_editor = 1;
		// Classic Editor: get content of Text tab
		var text_content = $('#st_editor_tab1 #content').val();

		// Trigger when Text tab of Classic Editor is changed
		$('#st_editor_tab1 #content').bind('input propertychange', function(){
			_change_editor = 1;
			text_content = $(this).val();
		});

		// Switch tab: Classic editor , ProStyler Builder
		$('#st_editor_tabs a').click(function (e, init_layout) {
			// Prevent click tab activated
			if ( $(this).parent('li').attr('class') == 'active' )
				return;
			e.preventDefault();

			var hash = this.hash;

			// Check if this is first time run
			init_layout = (init_layout != null) ? init_layout : false;

			$(this).tab('show');

			// Init ProStyler Builder
			if(this.hash == '#st_editor_tab2' && ! $.ST_PB_Layout){
				$.ST_PB_Layout = new JSNLayoutCustomizer();
				$.ST_PB_Layout.init($(".st-pb-form-container.jsn-layout .jsn-row-container"));
			}

			// If it is first time run, don't sync content
			if(init_layout)
				return;

			// ProStyler Builder is deactivate, stop processing
			if($('#st_deactivate_pb').val() == "1")
				return;

			// Store content of current Tab
			var tab_content = '';

			switch (hash) {

				// ProStyler Builder -> Classic Editor
				case '#st_editor_tab1':
					// Check if content of ProStyler Builder is changed
					var old_wr_pg_html = st_pg_html;

					// Get Raw shortcodes content in ProStyler Builder tab
					var st_pb_textarea_content = $('.st-pb-form-container.jsn-layout textarea').serialize();

					// Update value for st_pg_html
					if(st_pg_html == '' || st_pg_html != st_pb_textarea_content){
						st_pg_html = st_pb_textarea_content;
					}

					// Check if value is changed
					if(old_wr_pg_html != st_pg_html){
						_change_pagebuilder = 1;
					}

					// Check if content of 2 tabs are same
					if($("#st_editor_tab1 #content").val() == tab_content) {
						_change_pagebuilder = 0;
					}

					// Get nice shortcodes content in ProStyler Builder tab
					$(".st-pb-form-container.jsn-layout textarea[name^='shortcode_content']").each(function(){
						tab_content += $(this).val();
					});

					// Synchronize content of classic editor with ProStyler Builder
					var text_content_ = ( window.tinymce && tinymce.get('content') ) ? tinymce.get('content').getContent() : $('#st_editor_tab1 #content').val();

					if (tab_content != text_content_) {
						_change_pagebuilder = 1;
					}

					// If changed
					if(_change_pagebuilder){
						// Disable WP Update button
						$('#publishing-action #publish').attr('disabled', true);

						// Remove placeholder text which was inserted to &lt; and &gt;
						tab_content = st_pb_remove_placeholder(tab_content, 'wrapper_append', '');

						// Update Classic Editor content
						$.HandleElement.updateClassicEditor(tab_content, function(){

							// Reset global variable
							tab_content = '';
							_change_pagebuilder = 0;

							// Reset condition variables
							_change_editor = 0;
							text_content = tab_content;
						});
					}

					break;

				// Classic Editor -> ProStyler Builder
				case '#st_editor_tab2':
					if ($('.data-conversion-dialog').length) {
						return;
					}

					// Show loading icon when switching to Pagebuilder tab
					if ( is_pagebuilder_tab == false ) {
						// Show loading indicator in Pagebuilder wrapper
						$("#form-container").css('opacity',0);
						$(".st-pb-form-container.jsn-layout").hide();
						$.HandleElement.showLoading();
						is_pagebuilder_tab = true;
					}

					// Synchronize content of classic editor with ProStyler Builder
					tinyMCE.triggerSave();
					text_content = $('#st_editor_tab1 #content').val();

					// Remove Shortcode content which is not wrapped in row & column
					var remove_div = $('.st-pb-form-container.jsn-layout #st-select-media').nextAll( ".jsn-item" );

					if (tab_content !== text_content) {
						_change_editor = 1;
					} else {
						// Get shortcode content inside unexpected items
						var extra_sc_ct = '';
						remove_div.each(function(){
							extra_sc_ct += remove_div.find('[name^="shortcode_content"]').first().text();
						});

						if ( extra_sc_ct !== '' ) {
							text_content = extra_sc_ct;
							_change_editor = 1;
						}
					}

					// Remove unexpected items
					remove_div.remove();

					// Check if content of Classic Editor Text / Visual has changed
					if(_change_editor){


						// Update latest content value
						tab_content = text_content;

						// Update ProStyler Builder content
						$.HandleElement.updatePageBuilder(tab_content, function(){
							// Reset ProStyler Builder Layout manager
							$.ST_PB_Layout.fnReset($.ST_PB_Layout, true);
						});

						// Reset condition variables
						text_content = tab_content = '';
						_change_editor = 0;
					}
					break;
			}
		})
	})


})(jQuery);
