/**
 * @version	$Id$
 * @package	IGPGBLDR
 * @author	 WooRockets Team <support@www.woorockets.com>
 * @copyright  Copyright (C) 2012 WooRockets.com. All Rights Reserved.
 * @license	GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.www.woorockets.com
 * Technical Support: Feedback - http://www.www.woorockets.com/contact-us/get-support.html
 */
(function($) {
    "use strict";
    // Do not re-declare modal class
    if (typeof $.IGModal != 'undefined') {
        return;
    }
    var st_pb_scrollTop = 0;
    $.IGModal = function(options) {
        this.options = $.extend({
            iframe: true,
            frameId: '',
            jParent: $,
            dialogClass: 'st-dialog',
            position: {
                my: "center",
                at: "center",
                of : window
            }, // yunus edit
            url: 'about:blank',
            scrollable: false,
            width: 500,
            height: 300,
            modal: false,
            resizable: false,
            draggable: false,
            loaded: null,
            context: null,
            filter: null,
            open: function(event, ui) {
                return false;
            }
        }, options);
        this.extendedOptions = ['iframe', 'scrollable', 'context', 'frameId', 'url'];
        this.overlay = this.options.jParent('.jsn-modal-overlay');
        if (this.overlay.size() == 0) {
            this.overlay = $('<div/>', {
                'class': 'jsn-modal-overlay'
            });
        }
        this.indicator = this.options.jParent('#st-pbd-loading');
        this.container = this.options.jParent('<div/>', {
            'class': 'jsn-modal'
        });
        this.body = this.options.jParent('body').append(this.overlay).append(this.indicator).append(this.container);
        if (this.options.iframe) {
            this.iframe = this.options.jParent('<iframe/>', {
                'src': 'about:blank',
                'scrolling': this.options.scrollable == false ? 'no' : 'yes',
                'frameborder': '0'
            });
            this.iframe.appendTo(this.container);
            if (this.options.frameId != '') {
                this.iframe.attr('id', this.options.frameId);
            }
            this.iframe.css({
                width: '100%',
                height: '100%'
            });
            this.iframe.load(function() {
                if (options.filter) {
                    var search = $('<input type="text"/>');
                    var searchWrapper = $('<span class="jsn-bootstrap3 ui-window-searchbar-wrapper"/>');
                    searchWrapper.appendTo($('.ui-dialog-titlebar'));
                    search.appendTo(searchWrapper);
                    var opSearch = $.extend({
                        text: '',
                        css: {},
                        classSet: '',
                        attrs: {},
                        onChange: undefined,
                        onKeyup: undefined,
                        onKeydown: undefined,
                        onBlur: undefined,
                        onFocus: undefined,
                        onClick: undefined,
                        ondblClick: undefined,
                        onKeypress: undefined,
                        closeTextKeyword: false,
                        defaultText: '',
                        afterAddTextCloseSearch: function(obj) {},
                        closeTextClick: function(obj, searchbox) {}
                    }, options.filter);
                    search.val(opSearch.text);
                    search.css(opSearch.css);
                    search.addClass(opSearch.classSet);
                    for (name in opSearch.attrs) {
                        search.attr(name, opSearch.attrs[name]);
                    }
                    search.change(opSearch.onChange);
                    search.keyup(opSearch.onKeyup);
                    search.keydown(opSearch.onKeydown);
                    search.blur(opSearch.onBlur);
                    search.focus(opSearch.onFocus);
                    search.click(opSearch.onClick);
                    search.dblclick(opSearch.ondblClick);
                    search.keypress(opSearch.onKeypress);
                    search.mouseup(function() {
                        search.focus();
                    });
                    if (opSearch.closeTextKeyword) {
                        var closeTextKeyword = $('<a />', {
                            'class': 'ui-window-closetext-keyword',
                            'id': 'ui-window-closetext-keyword',
                            'href': 'javascript:void(0);'
                        }).click(function() {
                            opSearch.closeTextClick($(this), search);
                        });
                        opSearch.afterAddTextCloseSearch(closeTextKeyword);
                        search.after(closeTextKeyword);
                        search.change(function() {
                            if ($(this).val().trim() == opSearch.defaultText || $(this).val().trim() == '') {
                                closeTextKeyword.hide();
                            } else {
                                closeTextKeyword.show();
                            }
                        });
                    }
                }
            });
        } else if (this.options.scrollable) {
            this.container.css('overflow', 'auto');
        }
        // Initial modal box
        this.dialog = this.container.dialog($.extend({
            autoOpen: false
        }, this.options));
        // Register all needed events
        this.registerEvents();
    };
    $.IGModal.prototype = {
        /**
         * Register events for all controls
         * @return void
         */
        registerEvents: function() {
            if (this.options.iframe) {
                // Frame loaded event
                this.iframe.load({
                    modal: this
                }, this.onIFrameLoaded);
            }
            // Modal events
            this.container.bind('dialogclose', {
                modal: this
            }, this.onDialogClosed);
        },
        /**
         * Method to display modal box on screen
         * @return void
         */
        show: function(callback) {
            //st_pb_scrollTop = $(window).scrollTop();
            this.overlay.css('z-index', 1000).show();
            $.HandleElement.showLoading();
            if (this.options.iframe) {
                this.iframe.attr('src', this.options.url);
            }
            if (callback) {
                callback(this);
            }
        },
        /**
         * Set size for opened modal window
         * @param int width
         * @param int height
         * @return void
         */
        setSize: function(width, height) {
            this.container.dialog('option', 'width', width);
            this.container.dialog('option', 'height', height);
            this.container.dialog('option', 'position', 'center');
        },
        /**
         * This method use to change src property of the iframe
         * @param string url
         * @param function callback
         * @return void
         */
        navigateTo: function(url, callback) {
            if (callback !== undefined && $.isFunction(callback)) {
                this.options.loaded = callback;
            }
            this.container.parent().addClass('jsn-loading');
            if (this.options.iframe) {
                this.iframe.attr('src', url);
            }
        },
        /**
         * Add buttons to existing modal window
         * @param mixed buttons
         * @return void
         */
        addButtons: function(buttons) {
            this.container.dialog('option', 'buttons', buttons);
        },
        /**
         * Set option for the modal window
         * @param name
         * @param value
         * @return void
         */
        setOption: function(name, value) {
            if (this.extendedOptions.indexOf(name) != -1) {
                this.options[name] = value;
                this.update();
            } else {
                this.container.dialog('option', name, value);
            }
        },
        /**
         * Refresh UI for the modal window
         * @return void
         */
        update: function() {
            if (this.options.iframe) {
                (this.options.scrollable !== undefined && this.options.scrollable == true) ? this.iframe.attr('scrolling', 'yes'): this.iframe.attr('scrolling', 'no');
            }
        },
        /**
         * Submit a form inside iframe of the modal window
         * @param selector
         * @param params
         * @return void
         */
        submitForm: function(selector, params) {
            this.container.parent().addClass('jsn-loading');
            if (this.options.iframe) {
                this.frameDocument = this.iframe.contents();
                var form = $(selector, this.frameDocument),
                    formAction = form.attr('action');
                if (params !== undefined && $.isPlainObject(params)) {
                    $.map(params, function(value, key) {
                        var input = form.find('[name="' + key + '"]');
                        (input.size() > 0) ? input.val(value): formAction = formAction + (formAction.indexOf('?') !== -1 ? '&' : '?') + key + '=' + value;
                    });
                }
                form.attr('action', formAction);
                form.submit();
            }
        },
        /**
         * Closed the opened dialog
         * @return void
         */
        close: function() {
            this.container.dialog('close').dialog("destroy").remove();
            //$(window).scrollTop(st_pb_scrollTop);
        },
        /**
         * Scroll back to previous position
         */
        scrollBack: function() {
            //$(window).scrollTop(st_pb_scrollTop);
        },
        /**
         * Handle dialog close event to hide overlay layer
         * @param Event e
         * @return void
         */
        onDialogClosed: function(e) {
            e.data.modal.overlay.hide();
        },
        /**
         * Handle loaded event for iframe element
         * @param Event e
         * @return void
         */
        onIFrameLoaded: function(e) {
            var modal = e.data.modal;
            // Remove loading class for modal window
            modal.container.parent().removeClass('jsn-loading');
            //modal.indicator.hide();
            $.HandleElement.showLoading();
            // Call loaded event
            if (modal.options.loaded !== undefined && $.isFunction(modal.options.loaded)) {
                modal.options.loaded(modal, this);
            }
            if (modal.options.fadeIn) {
                modal.container.dialog({
                    show: function() {
                        $(this).fadeIn(modal.options.fadeIn)
                    }
                });
            }
            modal.container.dialog('open').dialog('moveToTop');
            // yunus edit - centers the dialog and prevents scrolling to top crap
            //$('.st-dialog').center(false);
        }
    };
    // $.widget( "cbb.builderPane", $.ui.dialog,
    // {
    // 	open: function()
    // 	{
    // 		this.uiDialog.show();
    //     }
    // });
})(jQuery);
// ------------------------------------------------------
//  yunus edit - jquery center plugin from http://andreaslagerkvist.com/jquery/center/
// ------------------------------------------------------
jQuery.fn.center = function(absolute) {
    return this.each(function() {
        var t = jQuery(this);
        t.css({
            position: absolute ? 'absolute' : 'fixed',
            left: '50%',
            top: '50%',
            zIndex: '99'
        }).css({
            marginLeft: '-' + (t.outerWidth() / 2) + 'px',
            marginTop: '-' + (t.outerHeight() / 2) + 'px'
        });
        if (absolute) {
            t.css({
                marginTop: parseInt(t.css('marginTop'), 10) + jQuery(window).scrollTop(),
                marginLeft: parseInt(t.css('marginLeft'), 10) + jQuery(window).scrollLeft()
            });
        }
    });
};
var IGModal_isOpen, IGModal_isHidden, IGModal_height;
(function($) {
    "use strict";
    // Do not re-declare modal class
    if (typeof $.IGModal_new != 'undefined') {
        return;
    }
    IGModal_isOpen = false,
        IGModal_isHidden = false,
        IGModal_height = $(window).height() * 0.45;
    if (IGModal_height < 250) IGModal_height = 250;
    $.IGModal_new = function(options) {
        this.options = $.extend({
            iframe: true,
            frameId: '',
            jParent: $,
            dialogClass: 'st-dialog',
            position: {
                my: "center",
                at: "center",
                of : window
            }, // yunus edit
            url: 'about:blank',
            scrollable: false,
            width: 500,
            height: 300,
            modal: false,
            resizable: 'n',
            draggable: false,
            loaded: null,
            after_close: null,
            context: null,
            filter: null,
            title: '',
            title_icon: '',
            is_sub_item: false,
        }, options);
        if (this.options.is_sub_item) {
            return new $.IGModal(options);
        }
        this.initialized = false;
        this.element = this.options.jParent('.cbb-panel');
        this.indicator = this.options.jParent('#st-pbd-loading');
        this.content_area = this.options.jParent('.cbb-panel .cbb-p-content');
        this.resizable_area = this.element; // element to act as the basis for animation, height etc (either this.element or this.content_area). if changed, make sure to reflect it on css
        // check if modal aleady being used then close it and only initialize if closed immidiatly otherwise dont, let show method initialize the modal after checking
        if (IGModal_isOpen) {
            if (this.element.find('.cbb-p-buttons #close').size() > 0) {
                this.element.find('.cbb-p-buttons #close').click();
            }
            return;
        }
        this.initialize();
    };
    $.IGModal_new.prototype = {
        initialize: function() {
            this.initialized = true;
            // remove old container if exisits
            //this.options.jParent('.jsn-modal').off().remove();
            this.container = this.options.jParent('<div/>', {
                'class': 'jsn-modal'
            }).appendTo(this.content_area);
            this.buttons_area = this.element.find('.cbb-p-buttons');
            this.title = this.element.find('.cbb-p-title');
            this.set_title();
            this.extendedOptions = ['iframe', 'scrollable', 'context', 'frameId', 'url'];
            this.overlay = this.options.jParent('.jsn-modal-overlay');
            if (this.overlay.size() == 0) {
                this.overlay = $('<div/>', {
                    'class': 'jsn-modal-overlay'
                });
            }
            this.indicator = this.options.jParent('#st-pbd-loading');
            this.body = this.options.jParent('body').append(this.overlay);
            var that = this;
            this.container.on("remove, close", function(e) {
                // only way i could find to stop propogation for on events
                if ($(e.target).is(that.container)) {
                    that.close();
                }
            })
            if (this.options.iframe) {
                this.iframe = this.options.jParent('<iframe/>', {
                    'src': 'about:blank',
                    'scrolling': this.options.scrollable == false ? 'no' : 'yes',
                    'frameborder': '0'
                });
                this.iframe.appendTo(this.container);
                if (this.options.frameId != '') {
                    this.iframe.attr('id', this.options.frameId);
                }
                this.iframe.css({
                    width: '100%',
                    height: '100%'
                });
                this.iframe.load(function() {
                    if (that.options.filter) {
                        var search = $('<input type="text"/>');
                        var searchWrapper = $('<span class="jsn-bootstrap3 ui-window-searchbar-wrapper"/>');
                        searchWrapper.appendTo($('.ui-dialog-titlebar'));
                        search.appendTo(searchWrapper);
                        var opSearch = $.extend({
                            text: '',
                            css: {},
                            classSet: '',
                            attrs: {},
                            onChange: undefined,
                            onKeyup: undefined,
                            onKeydown: undefined,
                            onBlur: undefined,
                            onFocus: undefined,
                            onClick: undefined,
                            ondblClick: undefined,
                            onKeypress: undefined,
                            closeTextKeyword: false,
                            defaultText: '',
                            afterAddTextCloseSearch: function(obj) {},
                            closeTextClick: function(obj, searchbox) {}
                        }, that.options.filter);
                        search.val(opSearch.text);
                        search.css(opSearch.css);
                        search.addClass(opSearch.classSet);
                        for (name in opSearch.attrs) {
                            search.attr(name, opSearch.attrs[name]);
                        }
                        search.change(opSearch.onChange);
                        search.keyup(opSearch.onKeyup);
                        search.keydown(opSearch.onKeydown);
                        search.blur(opSearch.onBlur);
                        search.focus(opSearch.onFocus);
                        search.click(opSearch.onClick);
                        search.dblclick(opSearch.ondblClick);
                        search.keypress(opSearch.onKeypress);
                        search.mouseup(function() {
                            search.focus();
                        });
                        if (opSearch.closeTextKeyword) {
                            var closeTextKeyword = $('<a />', {
                                'class': 'ui-window-closetext-keyword',
                                'id': 'ui-window-closetext-keyword',
                                'href': 'javascript:void(0);'
                            }).click(function() {
                                opSearch.closeTextClick($(this), search);
                            });
                            opSearch.afterAddTextCloseSearch(closeTextKeyword);
                            search.after(closeTextKeyword);
                            search.change(function() {
                                if ($(this).val().trim() == opSearch.defaultText || $(this).val().trim() == '') {
                                    closeTextKeyword.hide();
                                } else {
                                    closeTextKeyword.show();
                                }
                            });
                        }
                    }
                });
            } else if (this.options.scrollable) {
                this.container.css('overflow', 'auto');
            }
            // Register all needed events
            this.registerEvents();
        },
        /**
         * (WIP) Register events for all controls
         * @return void
         */
        registerEvents: function() {
            var that = this;
            this.title.click(function() {
                if (!IGModal_isOpen) return false;
                if (IGModal_isHidden) that.unhide();
                else that.hide();
            });
            if (this.options.iframe) {
                // Frame loaded event
                this.iframe.load({
                    modal: this
                }, this.onIFrameLoaded);
            }
        },
        /**
         * (WIP) This method use to change src property of the iframe
         * @param string url
         * @param function callback
         * @return void
         */
        navigateTo: function(url, callback) {
            if (callback !== undefined && $.isFunction(callback)) {
                this.options.loaded = callback;
            }
            this.container.parent().addClass('jsn-loading');
            if (this.options.iframe) {
                this.iframe.attr('src', url);
            }
        },
        /**
         * (WIP) Add buttons to existing modal window
         * @param mixed buttons
         * @return void
         */
        addButtons: function(buttons) {
            this.buttons_area.append(buttons);
        },
        /**
         * (WIP) Set option for the modal window
         * @param name
         * @param value
         * @return void
         */
        setOption: function(name, value) {
            if (this.extendedOptions.indexOf(name) != -1) {
                this.options[name] = value;
                this.update();
            } else {
                //this.container.builderPane('option', name, value);
            }
        },
        /**
         * (WIP) Refresh UI for the modal window
         * @return void
         */
        update: function() {
            if (this.options.iframe) {
                (this.options.scrollable !== undefined && this.options.scrollable == true) ? this.iframe.attr('scrolling', 'yes'): this.iframe.attr('scrolling', 'no');
            }
        },
        /**
         * (WIP) Submit a form inside iframe of the modal window
         * @param selector
         * @param params
         * @return void
         */
        submitForm: function(selector, params) {
            this.container.parent().addClass('jsn-loading');
            if (this.options.iframe) {
                this.frameDocument = this.iframe.contents();
                var form = $(selector, this.frameDocument),
                    formAction = form.attr('action');
                if (params !== undefined && $.isPlainObject(params)) {
                    $.map(params, function(value, key) {
                        var input = form.find('[name="' + key + '"]');
                        (input.size() > 0) ? input.val(value): formAction = formAction + (formAction.indexOf('?') !== -1 ? '&' : '?') + key + '=' + value;
                    });
                }
                form.attr('action', formAction);
                form.submit();
            }
        },
        /**
         * (WIP) Handle loaded event for iframe element
         * @param Event e
         * @return void
         */
        onIFrameLoaded: function(e) {
            var modal = e.data.modal;
            // Remove loading class for modal window
            modal.container.parent().removeClass('jsn-loading');
            //modal.indicator.hide();
            $.HandleElement.hideLoading();
            // Call loaded event
            if (modal.options.loaded !== undefined && $.isFunction(modal.options.loaded)) {
                modal.options.loaded(modal, this);
            }
            modal.open();
        },
        createButtons: function() {
            var that = this,
                buttons = this.options.buttons;
            $.each(buttons, function(name, props) {
                var click, buttonOptions;
                props = $.isFunction(props) ? {
                    click: props,
                    html: name
                } : props;
                // Default to a non-submitting button
                props = $.extend({
                    type: "button"
                }, props);
                props.html = props.text
                props.text = null;
                // Change the context for the click callback to be the main element
                click = props.click;
                buttonOptions = {
                    icon: props.icon,
                    iconPosition: props.iconPosition,
                    showLabel: props.showLabel
                };
                delete props.click;
                delete props.icon;
                delete props.iconPosition;
                delete props.showLabel;
                $("<button></button>", props).button(buttonOptions).appendTo(that.buttons_area).on("click", function() {
                    click.apply(that.container, arguments);
                });
            });
        },
        set_title: function() {
            this.title.html('<span class="cbb-p-title-icon">' + this.options.title_icon + '</span><span class="cbb-p-title-text">' + this.options.title + '</span><span class="cbb-p-title-hider"><i class="fa fa-chevron-down"></i></span>');
        },
        open: function(callback) {
            if (IGModal_isOpen) return this.after_open_animation();
            this.overlay.fadeOut('fast');
            $.HandleElement.hideLoading();
            //this.element.show();
            var that = this;
            that.resizable_area.css('height', '0').addClass('st_ui_animate');
            setTimeout(function() {
                that.resizable_area.css('height', IGModal_height);
                // wait for animation
                setTimeout(function() {
                    that.after_open_animation();
                }, 300);
            }, 1);
            return;
        },
        moveContentActionButtons: function() {
            //$('.jsn-modal .jsn-fieldset-filter').prependTo(".cbb-p-buttons");
            //$('.jsn-modal .st_action_btn').prependTo(".cbb-p-buttons");
        },
        after_open_animation: function(callback) {
            var that = this;
            IGModal_isOpen = true;
            if (callback) {
                callback(this);
            }
            that.createButtons();
            that.moveContentActionButtons();
            that.resizable_area.append('<div class="ui-resizable-handle ui-resizable-n cbb-panel-resize-handle"><i class="fa fa-arrows-v"></i></div>');
            that.resizable_area.resizable({
                handles: {
                    n: '.cbb-panel-resize-handle'
                },
                minHeight: 268,
                start: function(event, ui) {
                    that.resizable_area.removeClass('st_ui_animate');
                },
                resize: function(event, ui) {
                    // TO-DO: OPTIMIZE FOR PERFORMANCE
                    that.reset_preview_height();
                },
                stop: function(event, ui) {
                    that.resizable_area.addClass('st_ui_animate');
                }
            });
        },
        show: function(callback) {
            var that = this;
            // if not initalized, then intervally check if modal closed, then initialize the modal and rerun the method
            if (!this.initialized) {
                var check_if_closed_yet = setInterval(function() {
                    if (!IGModal_isOpen) {
                        clearInterval(check_if_closed_yet);
                        that.initialize();
                        that.show(callback);
                    }
                }, 300);
                return false;
            }
            if (this.options.iframe) {
                this.iframe.attr('src', this.options.url);
            }
            if (callback) {
                callback(this);
            }
        },
        hide: function(hiddenHeight) {
            IGModal_height = this.resizable_area.height();
            if (IGModal_height < 250) IGModal_height = 250;
            this.element.addClass('cbb-panel-hidden');
            $('.cbb-p-title-hider', this.title).html('<i class="fa fa-chevron-up"></i>');
            //this.close_preview();
            if (!hiddenHeight) hiddenHeight = 34;
            this.resizable_area.css('height', hiddenHeight);
            IGModal_isHidden = true;
        },
        unhide: function() {
            var that = this;
            this.element.removeClass('cbb-panel-hidden');
            $('.cbb-p-title-hider', this.title).html('<i class="fa fa-chevron-down"></i>');
            //this.open_preview();
            this.resizable_area.css('height', IGModal_height, 'IGModal_isHidden2', IGModal_isHidden);
            IGModal_isHidden = false;
            // wait for animation
            setTimeout(function() {
                that.reset_preview_height();
            }, 310);
        },
        close: function() {
            var that = this;
            $('.jsn-modal').off(); // remove close,remove event so its not duplicated
            
            // if NOT hidden
            if (! this.element.hasClass('cbb-panel-hidden')) {
                if (!IGModal_height) IGModal_height = this.resizable_area.height();
                if (IGModal_height < 250) IGModal_height = 250;
            }

            $.HandleElement.enablePageScroll();
            this.close_preview();
            that.resizable_area.css('height', '0');

            // delay to wait for animation and help with render performance
            setTimeout(function() {
                that.reset();
            }, 300);

            // Call after_close event if available
            if (that.options.after_close !== undefined && $.isFunction(that.options.after_close)) {
                that.options.after_close(that);
            }
        },
        reset: function() {
            IGModal_isOpen = false;
            IGModal_isHidden = false;
            this.close_preview();
            this.element.removeClass('cbb-panel-hidden');
            if (this.resizable_area.is('.ui-resizable')) {
                this.resizable_area.resizable("destroy");
            }
            this.container.remove();
            this.title.unbind('click');
            //this.element.hide();
            this.buttons_area.html('');
            has_preview = false;
        },
        // ------------------------------------------------------
        //  Preview modal
        // ------------------------------------------------------
        preview_button: function() {},
        open_preview: function(first_time, preview_size) {
            var that = this;
            if (IGModal_isOpen == false) {
                window.setTimeout(function() {
                    that.open_preview(first_time, preview_size);
                }, 100);
                return;
            }
            // get preview modal width
            preview_size = this.apply_preview_size(preview_size);
            // set preview button on panel
            if (first_time) {
                has_preview = true;
                st_preview_modal_button();
            }
            if (preview_off || !has_preview) return;
            //that.html( preview_template() );
            preview_modal.dialog("open");
        },
        // apply size to preview window
        // old is a deprecated argument
        saved_preview_size: 'desktop',
        apply_preview_size: function(old, preview_size) {
            var that = this;
            // save for next use
            if (preview_size) that.saved_preview_size = preview_size;
            // if not provided, use from last set option
            if (!preview_size) preview_size = that.saved_preview_size;
            if (!preview_size || preview_size == 'desktop') {
                preview_size = $('body').width() * 0.95;
            } else if (preview_size == 'mobile') {
                preview_size = 414; // iphone 6 plus just as example
            }
            that.reset_preview_height();
            // set width using dialog api
            preview_modal.dialog("option", "width", preview_size);
            // set again for animation and keeping centered
            preview_modal.parents('.ui-dialog:first').css({
                width: preview_size + 'px',
                left: '50%',
                marginLeft: '-' + (preview_size / 2) + 'px',
            });
            setTimeout(function() {
                $.HandleSetting.previewTriggerAdjustment();
            }, 400);
            return preview_size;
        },
        reset_preview_height: function() {
            //var that = this;
            var preview_height = $(window).height() - $('.cbb-panel').outerHeight() - 25;
            if (preview_height < 200) preview_height = 200;
            preview_modal.dialog("option", "height", preview_height);
        },
        close_preview: function() {
            if (preview_modal.length < 1 || !preview_modal.dialog("isOpen")) return false;
            if (!preview_off) {
                preview_off = 'turn on';
            }
            preview_modal.dialog("close");
            $.HandleElement.enablePageScroll();
        }
    };
    var preview_template = wp.template("cbb-preview-template");
    $('body').on('mouseenter', '.cbb-panel, .cbb-preview-dialog, .st_fonticons_panel, .mce-toolbar-grp, .mce-edit-area iframe, .st-dialog.ui-dialog', function(event) {
        $.HandleElement.disablePageScroll();
    }).on('mouseleave', '.cbb-panel, .cbb-preview-dialog, .st_fonticons_panel, .mce-toolbar-grp, .mce-edit-area iframe, .st-dialog.ui-dialog', function(event) {
        $.HandleElement.enablePageScroll();
    });
    $.IGModal_existing_check = function(that) {
        // check if modal aleady being used then close it
        if (IGModal_isOpen) {
            if ($.HandleElement.__changed) {
                var txt;
                var r = confirm(St_Ajax.st_edit_confirm);
                if (r == true) {} else {
                    return false;
                }
            }
            if ($('.cbb-panel .cbb-p-buttons #close').size() > 0) {
                $('.cbb-panel .cbb-p-buttons #close').click();
            }
            // make sure its closed by rechecking intervally and then re-invoke the click
            var check_if_closed_yet2 = setInterval(function() {
                if (!IGModal_isOpen) {
                    clearInterval(check_if_closed_yet2);
                    $(that).trigger('click');
                }
            }, 300);
            return false;
        }
        return true;
    };
    // ------------------------------------------------------
    //  create preview modal window
    // ------------------------------------------------------
    var preview_off, has_preview = false;
    var preview_modal = $('.cbb-preview');
    var preview_modal_height = $(window).height() - IGModal_height - 150;
    if (preview_modal_height < 160) preview_modal_height = 160;
    if (preview_modal.length < 1) {
        return;
    }
    preview_modal.html(preview_template());
    preview_modal.dialog({
        autoOpen: false,
        dialogClass: "cbb-preview-dialog",
        title: "Preview",
        width: 500,
        height: preview_modal_height,
        position: {
            my: "center top",
            at: "center top",
            of : window
        },
        minWidth: 250,
        overlay: null,
        draggable: false,
        resizable: false,
        show: {
            effect: "fade",
            duration: 500
        },
        hide: {
            effect: "fade",
            duration: 300
        },
        open: function(event, ui) {
            // create overlay
            if (this.overlay == null) {
                this.overlay = $('<div/>', {
                    'class': 'cbb-preview-overlay'
                });
                $('body').append(this.overlay);
            }
            $('body').addClass('cbb-preview-active');
            $('#modalOptions [id^="param"]:first').trigger('change');
            preview_off = false;
            st_preview_modal_button();
            //$('.cbb-preview-dialog').css('margin-top', '39px');
            // when modal reaches its width limit then add class
            if ($('.cbb-preview-dialog').width() < 375) {
                $('.cbb-preview-dialog').addClass('cbb-preview-dialog-small');
            } else $('.cbb-preview-dialog').removeClass('cbb-preview-dialog-small');
        },
        close: function(event, ui) {
            if (preview_off == 'turn on') {
                preview_off = false;
            } else preview_off = true;
            
            $('body').removeClass('cbb-preview-active');// body...

            // DELAY FOR PERFORMANCE - wait after settings panel closes
            setTimeout(function () {
                $('.cbb-preview-dialog').css('margin-top', '0');
                st_preview_modal_button( (IGModal_isOpen) ? false : true );
                $('iframe', preview_modal).attr('src', '').contents().find("body").html('');
               
            }, 500);
        }
    });
    $('#preview_container .cbb-preview-bg-colors', preview_modal).appendTo('.cbb-preview-dialog > .ui-dialog-titlebar');
    $('#preview_container .st-preview-responsive-size', preview_modal).appendTo('.cbb-preview-dialog > .ui-dialog-titlebar');

    function st_preview_modal_button(remove_only) {
        var buttons_area = $('.cbb-panel .cbb-p-buttons');


        $('#cbb-show-preview', buttons_area).remove();
        if(remove_only)
            return;

        if (preview_off) {
            $('<button type="button" id="cbb-show-preview" class="btn btn-default cbb-show-preview">Show Preview</button>').prependTo(buttons_area);
            return;
        }
        $('<button type="button" id="cbb-show-preview" class="btn btn-default cbb-hide-preview">Hide Preview</button>').prependTo(buttons_area);
    }
    $('body').on("click", "#cbb-show-preview", function(e) {
        e.stopPropagation();
        if ($(this).hasClass('cbb-show-preview')) {
            $.IGModal_new.prototype.apply_preview_size($.HandleElement.preview_size);
            preview_modal.dialog("open");
            return;
        }
        preview_modal.dialog("close");
        preview_off = true;
    });
    // ------------------------------------------------------
    //  Preview modal background selector
    // ------------------------------------------------------
    var preview_bg;
    $(document).delegate('.cbb-preview-bg-colors ul li', 'click', function() {
        $('.cbb-preview-bg-colors ul li').removeClass('cbb-active-preview-bg');
        $('#shortcode_preview_iframe').attr('style', $(this).attr('style') );
        $(this).addClass('cbb-active-preview-bg');
    });
    // ------------------------------------------------------
    //  Preview modal view size selector
    // ------------------------------------------------------
    $(document).delegate('.st-preview-responsive-size ul li', 'click', function() {
        $('.st-preview-responsive-size ul li').removeClass('st-active-item');
        $.IGModal_new.prototype.apply_preview_size(null, $(this).data('size'));
        $(this).addClass('st-active-item');
    });
    /*
    	function make_template_preview()
    	{
    		var output = '';
    		$('.jsn-layout > .jsn-row-container').each(function ()
    		{
    			output += "\n row start \n";

    			$('> .st-row-content > .jsn-column-container', this).each(function ()
    			{
    				output += "\n - col start \n";

    				$('> .jsn-column > .thumbnail > .jsn-column-content > .jsn-element-container > .shortcode-container', this).each(function ()
    				{
    					output += "-- shortcode \n";
    				});

    				output += "\n - col end \n";
    			});

    			output += "\n row end \n";
    		});

    		console.log(output);
    	}
    */
})(jQuery);
// ------------------------------------------------------
//  calculate object memory
// ------------------------------------------------------
function st_sizeof(_1) {
    var _2 = [_1];
    var _3 = 0;
    for (var _4 = 0; _4 < _2.length; _4++) {
        switch (typeof _2[_4]) {
            case "boolean":
                _3 += 4;
                break;
            case "number":
                _3 += 8;
                break;
            case "string":
                _3 += 2 * _2[_4].length;
                break;
            case "object":
                if (Object.prototype.toString.call(_2[_4]) != "[object Array]") {
                    for (var _5 in _2[_4]) {
                        _3 += 2 * _5.length;
                    }
                }
                for (var _5 in _2[_4]) {
                    var _6 = false;
                    for (var _7 = 0; _7 < _2.length; _7++) {
                        if (_2[_7] === _2[_4][_5]) {
                            _6 = true;
                            break;
                        }
                    }
                    if (!_6) {
                        _2.push(_2[_4][_5]);
                    }
                }
        }
    }
    return _3;
};