

/**
 * javascript for widget pagebuilder element
 */
(function ($) {
	'use strict';

	$.ST_Widget_PageBuilder = $.ST_Widget_PageBuilder || {};

	$.ST_Widget_Refresh = $.ST_Widget_Refresh || {};

	$.ST_Widget_PageBuilder = function () {
		$('.st_shortcode_widget').each(function () {
			$(this).closest('.widget-content').find('.st-pb-form-container').html('');
			if ( $(this).attr('value') ) {
				var shortcode_data = $(this).attr('value');
				shortcode_data = shortcode_data.replace(/--quote--/g, '"');
				shortcode_data = shortcode_data.replace(/--open_square--/g, '[');
				shortcode_data = shortcode_data.replace(/--close_square--/g, ']');
				var shortcode = $(this).closest('.widget-content').find('#st_widget_edit_btn').attr('data-shortcode');
				var html = '';
				if ( shortcode ) {
					var title = shortcode.replace('st_', '');
					title = title.replace('_', ' ');

					var html_preview = St_Preview_Html;
					html_preview = html_preview.replace(/ST_SHORTCODE_CONTENT/g, shortcode);
					html_preview = html_preview.replace(/ST_SHORTCODE_DATA/g, shortcode_data);

					html += '<input id="st-select-media" type="hidden" value="">';
					html += html_preview;
					html += '<div class="shortcode-preview-container" style="display: none">';
					html += '<div class="shortcode-preview-fog"></div>';
					html += '<div class="jsn-overlay jsn-bgimage image-loading-24"></div>';
					html += '</div>';
					html += '</div> ';
				}
				$(this).closest('.widget-content').find('.st-pb-form-container').html(html);
			}
			
			//console.log(html);
		});
	}

	$.ST_Widget_Refresh = function () {
		$.ST_Widget_PageBuilder();
		$('.st_widget_select_elm').each(function () {
			var selected = $(this).val();
			if ( selected ) {
				$(this).closest('.widget-content').find('#st_widget_edit_btn').attr('data-shortcode', selected);
				$(this).closest('.widget-content').find('.st-pb-form-container').html('<input type="hidden" id="st-select-media" value="" />');
			}
		});
		$('body').delegate('.st_widget_select_elm', 'change', function (e) {
			var selected = $(this).val();
			if ( selected ) {
				$(this).closest('.widget-content').find('#st_widget_edit_btn').attr('data-shortcode', selected);
				$(this).closest('.widget-content').find('.st-pb-form-container').html('<input type="hidden" id="st-select-media" value="" />');
			}
			$(this).closest('.widget-content').find('.st_shortcode_widget').attr('value', '');
		});

		$('body').delegate('.st_widget_edit_btn', 'click', function () {
			var elm_title = '';
			elm_title = $(this).closest('.widget-content').find('.st_widget_select_elm option:selected').text();
			$.ST_Widget_PageBuilder();
			// find parent for set active element
			$('.widget-content').removeClass('active_element');
			$(this).closest('.widget-content').addClass('active_element');
			$(this).closest('.widget-content').find('#st-widget-loading').show();
			$(this).closest('.widget-content').find('.icon-pencil').hide();
			
			//console.log('here');
			//console.log(jQuery('.active_element .st-pb-form-container .jsn-item').length);
			if ( $('.active_element .st-pb-form-container .jsn-item').length ) 
			{
				$('.active_element .st-pb-form-container .jsn-item').addClass('st-selected-element');
				//console.log('here 2');
				var sc_html = $('.active_element .st-pb-form-container').html();
				var $shortcode = $(this).attr('data-shortcode');
	            var $type = $(this).parent().attr('data-type');
				$.HandleElement.appendToHolder($shortcode, null, $type, sc_html, elm_title);
			} else {
	            var $shortcode = $(this).attr('data-shortcode');
	            var $type = $(this).parent().attr('data-type');
	            //console.log($shortcode); console.log($type);
	            $.HandleElement.appendToHolder($shortcode, null, $type, '', elm_title);
			}
		});

		// set event update shortcode
		$('body').bind('on_update_shortcode_widget', function (e, shortcode_content) {
			if ( shortcode_content ) {
				if ( shortcode_content == 'is_cancel' ) {
					$('.active_element #form-design-content .st-pb-form-container').html('');
				} else {
					$('.active_element #form-design-content .st-pb-form-container').find("[data-sc-info^='shortcode_content']").text(shortcode_content);
					var json_shortcode = shortcode_content;
					json_shortcode = json_shortcode.replace(/"/g, '--quote--');
					json_shortcode = json_shortcode.replace(/\[/g, '--open_square--');
					json_shortcode = json_shortcode.replace(/\]/g, '--close_square--');
					$('.active_element .st_shortcode_widget').val(json_shortcode);
					$('.active_element #form-design-content .st-pb-form-container').html('');
				}
				$('.jsn-icon-loading').hide();
				$('.icon-pencil').show();
			}
		});
	}

	$(document).ready(function () {
		$.ST_Widget_Refresh();
	});

})(jQuery)