<?php
/**
 * @version    $Id$
 * @package    WPGlow_Builder
 * @author     WooRockets Team <support@www.woorockets.com>
 * @copyright  Copyright (C) 2012 WooRockets.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.www.woorockets.com
 * Technical Support:  Feedback - http://www.www.woorockets.com/contact-us/get-support.html
 */

/**
 * Init WooRockets's plugins.
 *
 * @package  ST_Plugin_Framework
 * @since    1.0.0
 */
class ST_Pb_Assets_Register {
	/**
	 * Assets to be registered.
	 *
	 * @var  array
	 */
	protected static $assets = array(
		/**
		 * Third party assets.
		 */
		'st-pb-bootstrap-css' => array(
			'src' => 'assets/3rd-party/bootstrap3/css/bootstrap.min.css',
			'ver' => '3.1.1',
			'site' => 'admin',
		),

		'st-pb-bootstrap-responsive-css' => array(
			'src' => 'assets/3rd-party/bootstrap3/css/bootstrap-responsive.min.css',
			'deps' => array('st-pb-bootstrap-css'),
			'ver' => '3.1.1',
			'site' => 'admin',
		),

		'st-pb-bootstrap-js' => array(
			'src' => 'assets/3rd-party/bootstrap3/js/bootstrap.min.js',
			'deps' => array('jquery'),
			'ver' => '3.1.1',
			'site' => 'admin',
		),

		'st-pb-bootstrap-paginator-js' => array(
			'src' => 'assets/3rd-party/bootstrap-paginator/bootstrap-paginator.js',
			'deps' => array('st-pb-bootstrap-js'),
			'ver' => '0.5',
		),

		'st-pb-classygradient-css' => array(
			'src' => 'assets/3rd-party/classygradient/css/jquery.classygradient.css',
			'deps' => array('st-pb-colorpicker-css'),
			'ver' => '1.0.0',
		),

		'st-pb-classygradient-js' => array(
			'src' => 'assets/3rd-party/classygradient/js/jquery.classygradient.js',
			'deps' => array('jquery-ui-draggable', 'st-pb-colorpicker-js'),
			'ver' => '1.0.0',
		),

		// ------------------------------------------------------
		//  YUNUS EDIT
		// ------------------------------------------------------
		'cbb-frontend-js' => array(
			'src' => 'assets/frontend.min.js',
			'deps' => array('jquery'),
			'ver' => '1.2',
		),
		'cb-youtube-video-js' => array(
			'src' => 'assets/3rd-party/jquery-youtubebackground/jquery.youtubebackground.min.js',
			'deps' => array('jquery'),
			'ver' => '1.0.5',
		),
		'cbb-isotope-js' => array(
			'src' => 'assets/3rd-party/jquery-isotope/isotope.pkgd.min.js',
			'deps' => array('jquery'),
			'ver' => '2.0.1',
		),

		'cbb-prettyphoto-js' => array(
			'src' => 'assets/3rd-party/jquery-prettyphoto/main-script.js',
			'deps' => array('jquery'),
			'ver' => '3.1.4',
		),

		'cbb-prettyphoto-css' => array(
			'src' => 'assets/3rd-party/jquery-prettyphoto/css/prettyPhoto.css',
			'ver' => '3.1.4',
		),
		'st-pb-colorpicker-js' => array(
			'src' => 'assets/3rd-party/colorpicker/js/colorpicker.js',
		),

		'st-cbb-timepicker-js' => array(
			'src' => 'assets/3rd-party/jquery-timepicker/timepicker.js',
		),

		'st-cbb-timepicker-css' => array(
			'src' => 'assets/3rd-party/jquery-timepicker/timepicker.css',
		),
/*
'st-pb-font-icomoon-css' => array(
'src' => 'assets/3rd-party/font-icomoon/css/icomoon.css',
),
 */

		'st-pb-jsn-css' => array(
			'src' => 'assets/3rd-party/jsn/css/jsn-gui.css',
			'deps' => array('st-pb-bootstrap-css'),
		),

		'st-pb-joomlashine-fontselector-js' => array(
			'src' => 'assets/3rd-party/jsn/js/jsn-fontselector.js',
		),

		'st-pb-joomlashine-iconselector-js' => array(
			'src' => 'assets/3rd-party/jsn/js/jsn-iconselector.js',
			'ver' => '1.0',
		),

/*
'st-pb-joomlashine-modalresize-js' => array(
'src' => 'assets/3rd-party/jsn/js/jsn-modalresize.js',
),
 */

		'st-pb-jquery-easing-js' => array(
			'src' => 'assets/3rd-party/jquery-easing/jquery.easing.min.js',
			'ver' => '1.3',
		),

		'st-pb-jquery-fancybox-js' => array(
			'src' => 'assets/3rd-party/jquery-fancybox/jquery.fancybox-1.3.4.js',
			'ver' => '1.3.4',
		),

		'st-pb-jquery-fancybox-css' => array(
			'src' => 'assets/3rd-party/jquery-fancybox/jquery.fancybox-1.3.4.css',
			'ver' => '1.3.4',
		),

		'st-pb-jquery-lazyload-js' => array(
			'src' => 'assets/3rd-party/jquery-lazyload/jquery.lazyload.js',
			'deps' => array('jquery'),
			'ver' => '1.8.4',
		),

		'st-pb-jquery-resize-js' => array(
			'src' => 'assets/3rd-party/jquery-resize/jquery.ba-resize.js',
			'deps' => array('jquery'),
			'ver' => '1.1',
		),

		'st-pb-jquery-select2-css' => array(
			'src' => 'assets/3rd-party/jquery-select2/select2.css',
			'ver' => '3.3.2',
		),

		'st-pb-jquery-select2-bootstrap3-css' => array(
			'src' => 'assets/3rd-party/jquery-select2/select2-bootstrap3.css',
			'ver' => '3.3.2',
		),

		'st-pb-jquery-select2-js' => array(
			'src' => 'assets/3rd-party/jquery-select2/select2.js',
			'deps' => array('jquery'),
			'ver' => '3.3.2',
		),

		'st-pb-jquery-ui-css' => array(
			'src' => 'assets/3rd-party/jquery-ui/css/ui-bootstrap/jquery-ui-1.9.0.custom.css',
			'ver' => '1.9.0',
		),

		'st-zeroclipboard-js' => array(
			'src' => 'assets/3rd-party/zeroclipboard/ZeroClipboard.min.js',
			'ver' => '1.3.5',
		),

		'st-pb-convert-data-js' => array(
			'src' => 'assets/main/js/convert-data.js',
		),

	);

	/**
	 * Set hook prefix for loading assets.
	 *
	 * @param   string  $prefix  Current hook prefix.
	 *
	 * @return  string
	 */
	public static function hook_prefix($prefix = '') {
		if ('admin' == $prefix && class_exists('ST_Pb_Helper_Functions') && ST_Pb_Helper_Functions::is_modal()) {
			$prefix = 'pb_admin';
		}

		return $prefix;
	}

	/**
	 * Filter to apply supported assets.
	 *
	 * @param   array  $assets  Current assets.
	 *
	 * @return  array
	 */
	public static function apply_assets($assets = array()) {

		// ------------------------------------------------------
		//  YUNUS EDIT - enable icomoon for admin only since i disabled it for overall
		// ------------------------------------------------------
		if (is_admin()) {
			self::$assets['st-pb-font-icomoon-css'] = array(
				'src' => 'assets/3rd-party/font-icomoon/css/icomoon.css',
			);
		}

		foreach (self::$assets AS $key => $value) {
			if (!isset($assets[$key])) {
				// Fine-tune asset location
				if (!preg_match('#^(https?:)?/#', $value['src']) AND is_file(ST_PB_PATH . ltrim($value['src'], '/'))) {
					$value['src'] = ST_PB_URI . ltrim($value['src'], '/');

					$assets[$key] = $value;
				}
			}
		}

		return $assets;
	}

	/**
	 * Initialize WooRockets's plugins.
	 *
	 * @return  void
	 */
	public static function init() {
		// Add filters to register assets
		add_filter('st_pb_asset_hook_prefix', array(__CLASS__, 'hook_prefix'));
		add_filter('st_pb_register_assets', array(__CLASS__, 'apply_assets'));

		// Do 'st_pb_init_plugins' action
		do_action('st_pb_init_plugin');
	}
}
