<?php


if ( ! class_exists( 'ST_Pb_Gadget_Preview' ) ) :


class ST_Pb_Gadget_Preview {

	/**
	 * Hook into WordPress system.
	 *
	 * @return  void
	 */
	public static function hook() {

		if ( ! isset( $_REQUEST['st-gadget'] )
			OR ! isset( $_GET['st_shortcode_preview'] ) )
		{
			return;
		}

		if ( ! isset( $_GET['st_shortcode_name'] )
			OR ! isset( $_POST['params'] )
			OR ! isset($_GET[ST_NONCE] )
			OR ! wp_verify_nonce( $_GET[ST_NONCE], ST_NONCE ) )
		{
			echo __( 'empty shortcode name / parameters or corrupted request', ST_PBL );
			die();
			return;
		}

		global $cbt_options;
		
		// disable header
		$cbt_options['header-style'] = false;
		// disable builder cache
		$cbt_options['builder_cache'] = false;

		$shortcode = esc_sql( $_GET['st_shortcode_name'] );
		$params    = urldecode( $_POST['params'] );
		$params = stripslashes($params);
		
		$content = preg_replace_callback(
					'/\[st_widget\s+([A-Za-z0-9_-]+=\"[^"\']*\"\s*)*\s*\](.*)\[\/st_widget\]/Us', array( 'ST_Pb_Helper_Shortcode', 'widget_content' ), $params
		);


		// body class
		add_filter('body_class', array('ST_Pb_Gadget_Preview', 'body_class'));

		// render final content
		self::render($content);

		die();
		return;
	}

	public static function body_class($classes) 
	{
		$classes[] = 'st-pb-builder-preview';

		return $classes;
	}


	public static function render($content)
	{


		$script = '';
		$script .= "
			window.st_preview_adjustment = function(){
				jQuery(window).trigger('resize');
			};
			window.st_preview_adjustment();
		";

					get_header(); ?>

					<div class="container">
						<div id="content" class="clearfix row">
							<div id="main" class="col-md-12 clearfix" role="main">

								<?php echo cbt_text_shortcodes_process( do_shortcode($content) );  ?>

							</div> <!-- end #main -->
						</div> <!-- end #content -->
					</div> <!-- end .container -->


					<?php wp_footer(); ?>
					<?php ST_Pb_Init_Assets::print_inline( 'js', $script, true ); ?>

					<div class="mobile-nav-holder navbar"></div>
				</div> <!-- #full-wrapper -->

			</body>

		</html> <!-- end page. what a ride! -->
		<?php
	}

}

endif;
