<?php
/**
 * @version    $Id$
 * @package    WPGlow_Builder
 * @author     InnoThemes Team <support@innothemes.com>
 * @copyright  Copyright (C) 2012 InnoThemes.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.innothemes.com
 */

// Make sure response header is HTML document
@header( 'Content-Type: ' . get_option( 'html_type' ) . '; charset=' . get_option( 'blog_charset' ) );
// disable xss protection as previews can contain scripts
@header("X-XSS-Protection: 0");

// Check if requesting form only
$form_only = ( isset( $_GET['form_only'] ) && absint( $_GET['form_only'] ) );

// Print HTML structure if not requesting form only
if ( ! $form_only ) :
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en-US">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="viewport" content="width=device-width,initial-scale=1.0" />
<?php
endif;

// Do necessary actions for loading header assets
if ( $form_only ) {
	ob_start();
}

if ( ! $form_only ) {
	do_action( 'pb_admin_enqueue_scripts' );
}



do_action( 'admin_print_styles'  );
	
do_action( 'admin_print_scripts' );

if ( ! $form_only ) {
	do_action( 'pb_admin_head' );
}

if ( $form_only ) {
	ob_end_clean();

	// Do custom actions for loading assets
	do_action( 'pb_admin_enqueue_scripts' );
	do_action( 'pb_admin_print_styles'    );
	do_action( 'pb_admin_print_scripts'   );
	do_action( 'pb_admin_head'            );
}


global $cbt_options;

if($cbt_options['opt-typography']['google'])
{
	?>
	<link rel='stylesheet' id='redux-google-fonts-css'  href='//fonts.googleapis.com/css?family=<?php echo urlencode(''. $cbt_options['opt-typography']['font-family'].':400,700')?>' type='text/css' media='all' />
	<?php
}


if ( ! $form_only ) :
?>
<style>
	body
	{
		padding: 0px !important;
		
		font-family: <?php echo $cbt_options['opt-typography']['font-family']?>;
		
		background: transparent;
	}
	
	fieldset { border: 0; }
</style>

</head>
<body class="jsn-master contentpane">
<?php
endif;

if ( isset( $_GET['st_shortcode_preview'] ) && $_GET['st_shortcode_preview']=='1' ) {
	//echo '<pre>$data: '.htmlentities(print_r(stripslashes($data), TRUE)).'</pre>';
	//$data = stripslashes($data);
	$data = do_shortcode($data);
}


// Print HTML code for element settings
echo '' . $data;

// Do necessary actions for loading footer assets
do_action( 'pb_admin_footer'            );
do_action( 'admin_print_footer_scripts' );

// Register inline script if not previewing
if ( ! isset( $_GET['st_shortcode_preview'] ) || ! $_GET['st_shortcode_preview'] ) {
	$script = '
		if ($.HandleSetting && $.HandleSetting.init) $.HandleSetting.init();
';

	ST_Pb_Init_Assets::inline( 'js', $script, true );
}

// Print HTML structure if not requesting form only
if ( ! $form_only ) :
?>
</body>
</html>
<?php
endif;

// Exit immediately to prevent base gadget class from sending JSON data back
exit;
