<?php



/**
 * @todo : Common functions
 */

if ( ! class_exists( 'ST_Pb_Helper_Functions' ) ) {

	class ST_Pb_Helper_Functions {

		// Store how many times the action is executed
		static $run_time = 0;

		/**
		 * Translation for Javascript
		 *
		 * @return array
		 */
		static function js_translation() {
			$default = array(
				'site_url'              => site_url(),
				'delete_row'            => __( 'Are you sure you want to delete the whole row including all elements it contains?', ST_PBL ),
				'delete_column'         => __( 'Are you sure you want to delete the whole column including all elements it contains?', ST_PBL ),
				'delete_element'        => __( 'Are you sure you want to delete the element?', ST_PBL ),
				'delete_all'        => __( 'Are you sure you want to delete all elements and rows?', ST_PBL ),
				'table'                 => array(
					'table1' => __( "A table must has atleast 1 columns. You can't remove this column", ST_PBL ),
					'table2' => __( "A table must has atleast 2 rows. You can't remove this row", ST_PBL ),
					'table3' => __( "Row span/Column span can't be negative", ST_PBL ),
			),
				'saving'                => __( 'Saving content! Please wait a moment.', ST_PBL ),
				'error_tinymce'         => __( 'Having error on loading TinyMCE.', ST_PBL ),
				'settings'              => __( 'Settings', ST_PBL ),
				'page_modal'            => __( 'Page Modal', ST_PBL ),
				'convertText'           => __( 'Convert to ', ST_PBL ),
				'shortcodes'            => array(
					'audio1'     => __( 'No audio source selected', ST_PBL ),
					'googlemap1' => __( 'Select Destination Marker', ST_PBL ),
					'video1'     => __( 'No video file selected', ST_PBL ),
			),
				'noneTxt'               => __( 'None', ST_PBL ),
				'invalid_link'          => __( 'The link is invalid', ST_PBL ),
				'noItem'                => __( 'No %s found', ST_PBL ),
				'singleEntry'           => __( 'Single %s', ST_PBL ),
				'copy'                  => __( 'copy', ST_PBL ),
				'itemFilter'            => __( '%s Filter', ST_PBL ),
				'startFrom'             => __( 'Start From', ST_PBL ),
				'menu'                  => __( 'Menu', ST_PBL ),
				'filterBy'              => __( 'Filter By', ST_PBL ),
				'attributes'            => __( 'Attributes', ST_PBL ),
				'attribute'             => __( 'Attribute', ST_PBL ),
				'option_attribute'      => __( 'Option Attribute', ST_PBL ),
				'deactivatePb'          => __( 'After turning off, the content built with PageBuilder will be parsed to plain HTML code and inserted to default editor. Are you sure you want to turn PageBuilder off?', ST_PBL ),
				'no_title'              => __( '', ST_PBL ),
				'inno_shortcode'        => __( 'Add Page Element', ST_PBL ),
				'asset_url'             => ST_PB_URI . 'assets/main/',
				'limit_title'           => __( 'You used up to 50 characters', ST_PBL ),
				'select_layout'         => __( 'The whole content of current Post will be replaced by content of selected Page item. Do you want to continue?', ST_PBL ),
				'disabled'              => array(
					'deactivate' => __( 'Deactivate element', ST_PBL ),
					'reactivate' => __( 'Activate element', ST_PBL ),
			),
				'button'                => array(
					'select' => __( 'Select', ST_PBL ),
			),
				'layout'                => array(
					'modal_title'           => __( 'Select template', ST_PBL ),
					'upload_layout_success' => __( 'Upload successfully', ST_PBL ),
					'upload_layout_fail'    => __( 'Upload fail', ST_PBL ),
					'delete_layout_success' => __( 'Page is deleted successfully', ST_PBL ),
					'delete_layout_fail'    => __( 'Fail. Can\'t delete layout', ST_PBL ),
					'delete_group'          => __( 'All pages in this group will be remove. Do you want to continue ?', ST_PBL ),
					'delete_layout'         => __( 'This page will be remove. Do you want to continue ?', ST_PBL ),
					'no_layout_name'        => __( 'Template name can not be blank', ST_PBL ),
					'name_exist'            => __( 'Template name exists. Please choose another one.', ST_PBL )
			),
				'custom_css'            => array(
					'modal_title'    => __( 'Custom CSS', ST_PBL ),
					'file_not_found' => __( "File doesn't exist", ST_PBL ),
			),
				'report_bug'            => array(
					'modal_title'       => __( 'Submit a bug report', ST_PBL ),
					'submit'            => __( 'Submit', ST_PBL ),
					'send_mail_success' => __( 'Send report bug successfully!', ST_PBL ),
					'send_mail_fail'    => __( 'Fail to send report, please check again!', ST_PBL )
				),
				'element_not_existed'   => __( 'Element not existed!', ST_PBL ),
				'take_style'            => __( 'Take Style', ST_PBL ),
				'select_element_title'  => __( 'Select Element', ST_PBL ),
			);

			return apply_filters( 'st_pb_js_translation', $default );
		}


		/**
		 * inherits theme options
		 * @param  string $option option id
		 * @return unknown         options value, could be string, array anything
		 */
		public static function get_settings($option)
		{
			$options = apply_filters( 'st_builder_settings', $options );
			return (isset($options[ $option ])) ? $options[ $option ] : '';
		}


		/**
		 * Enqueue assets for shortcodes
		 *
		 * @global type $St_Sc_By_Providers
		 *
		 * @param type  $this_    :   current shortcode object
		 * @param type  $extra    :   frontend_assets/ admin_assets
		 * @param type  $post_fix :   _frontend/ ''
		 */
		public static function shortcode_enqueue_assets( $this_, $extra, $post_fix = '' ) {
			$extra_js = isset( $this_->config['exception'] ) && isset( $this_->config['exception'][$extra] ) && is_array( $this_->config['exception'][$extra] );
			$assets   = array_merge( $extra_js ? $this_->config['exception'][$extra] : array(), array( str_replace( 'st_', '', $this_->config['shortcode'] ) . $post_fix ) );

			foreach ( $assets as $asset ) {
				if ( ! preg_match( '/\.(css|js)$/', $asset ) ) {
					ST_Pb_Init_Assets::load( $asset );
				} else {
					global $St_Sc_By_Providers;

					if ( empty( $St_Sc_By_Providers ) ) {
						continue;
					}

					// load assets file in common assets directory of provider
					$default_assets = self::assets_default( $this_, $asset );

					// if can't find the asset file, search in /assets folder of the shortcode
					if ( ! $default_assets ) {

						// Get path of directory contains all shortcodes of provider
						$shortcode_dir = ST_Pb_Helper_Shortcode::get_provider_info( $this_->config['shortcode'], 'shortcode_dir' );

						if ( $shortcode_dir == ST_PB_LAYOUT_PATH ) {
							// this is core PB
							$sc_path = ST_PB_ELEMENT_PATH;
							$sc_uri  = ST_PB_URI . basename( $sc_path );
						} else {
							// Get directory of shortcodes of this provider
							$plugin_path       = ST_Pb_Helper_Shortcode::get_provider_info( $this_->config['shortcode'], 'path' );
							$plugin_uri        = ST_Pb_Helper_Shortcode::get_provider_info( $this_->config['shortcode'], 'uri' );
							$shortcode_dir_arr = (array) ST_Pb_Helper_Shortcode::get_provider_info( $this_->config['shortcode'], 'shortcode_dir' );
							$shortcode_dir     = reset( $shortcode_dir_arr );

							$sc_path = $plugin_path . basename( $shortcode_dir );

							if ( is_dir( $sc_path ) ) {
								$sc_uri = $plugin_uri . basename( $shortcode_dir );
							} else {
								$sc_path = $plugin_path;
								$sc_uri  = $plugin_uri;
							}
						}

						$ext_regex = '/(_frontend)*\.(js|css)$/';
						if ( preg_match( $ext_regex, $asset ) ) {
							// load assets in directory of shortcodes
							$require_sc = preg_replace( $ext_regex, '', $asset );
							self::assets_specific_shortcode( $require_sc, $asset, $sc_path, $sc_uri );
						} else {
							// load js/css file in directory of current shortcode
							$exts = array( 'js', 'css' );

							foreach ( $exts as $ext ) {
								$require_sc = $this_->config['shortcode'];
								$file       = $asset . ".$ext";

								// if this asset is processed, leave it
								self::assets_check( $file );

								// enqueue or add to cache file
								self::assets_specific_shortcode( $require_sc, $file, $sc_path, $sc_uri );

								// store it as processed asset
								self::assets_check( $file, true );
							}
						}
					}
				}
			}
		}

		/**
		 * Check if asset file is processed | or add asset file to processed list
		 *
		 * @param string $file
		 * @param bool   $assign
		 */
		static private function assets_check( $file, $assign = false ) {
			if ( self::$run_time == 0 ) {
				unset( $_SESSION );
			}
			self::$run_time ++;

			global $post;
			$post_id = ! empty( $post ) ? $post->ID : 0;

			// Check if this is backend or frontend
			$side = 'wp';

			if ( ! $assign ) {
				if ( isset($_SESSION)
						&& isset($_SESSION['processed-assets'][$post_id][$side]) 
						&& in_array( $file, (array) $_SESSION['processed-assets'][$post_id][$side]['assets'] ) ) {
					return;
				}
			} else {
				// store it as processed asset
				$_SESSION['processed-assets'][$post_id]['assets'][$side][] = $file;
			}
		}

		/**
		 * Get assest file in ProStyler Builder assets directory
		 *
		 * @param type $this_
		 * @param type $js_file
		 */
		static private function assets_default( $this_, $js_file ) {

			// if this asset is processed, leave it
			self::assets_check( $js_file );

			// Get js directory of WooRockets
			$inno_gears    = array_values( ST_Pb_Helper_Shortcode::register_provider() );
			$inno_gears_js = $inno_gears[0]['js_shortcode_dir'];

			// Get js directory of shortcodes
			$js_dir = ST_Pb_Helper_Shortcode::get_provider_info( $this_->config['shortcode'], 'js_shortcode_dir' );
			if ( empty( $js_dir ) || ! count( $js_dir ) ) {
				// if doesn't have a js dir, assign WooRockets js dir
				$js_dir = $inno_gears_js;
			}
			$file_path = $js_dir['path'] . '/' . $js_file;
			$file_uri  = $js_dir['uri'] . '/' . $js_file;

			// if file doesn't exist, try to get it in IGPB js dir
			if ( ! file_exists( $file_path ) ) {
				$file_path = $inno_gears_js['path'] . '/' . $js_file;
				$file_uri  = $inno_gears_js['uri'] . '/' . $js_file;
			}

			if ( file_exists( $file_path ) ) {
				self::asset_enqueue_( $file_uri, $js_file, $file_path );

				// store it as processed asset
				self::assets_check( $js_file, true );

				return true;
			}

			return false;
		}

		/**
		 * Get assets in specific shortcode folder
		 *
		 * @param type $require_sc
		 * @param type $js_file
		 * @param type $sc_path
		 * @param type $sc_uri
		 */
		static private function assets_specific_shortcode( $require_sc, $js_file, $sc_path, $sc_uri ) {
			$sc_path = rtrim( $sc_path, '/' );
			$sc_uri  = rtrim( $sc_uri, '/' );

			// Get parent shortcode name
			$require_sc = str_replace( '_', '-', preg_replace( '/(st_|item_)/', '', $require_sc ) );

			// Get type of asset file
			$type = strpos( $js_file, '.js' ) ? 'js/' : 'css/';

			// Get path & uri
			$file_path = $sc_path . "/$require_sc/assets/$type" . $js_file;
			$file_uri  = $sc_uri . "/$require_sc/assets/$type" . $js_file;

			if ( file_exists( $file_path ) ) {
				self::asset_enqueue_( $file_uri, $js_file, $file_path );
			}
		}

		/**
		 * Enqueue script/style
		 *
		 * @param unknown $file_uri
		 * @param unknown $js_file
		 */
		static private function asset_enqueue_( $file_uri, $js_file, $file_path ) {
			$enqueue = 0;
			$handle  = ST_Pb_Init_Assets::file_to_handle( $js_file );

			if ( is_admin() ) {
				$enqueue = 1;
			} else {

				if ( self::get_settings('builder_cache') == 1 ) {
					self::store_assets_info( $handle, $file_uri, $file_path );
				} else {
					$enqueue = 1;
				}
			}

			if ( $enqueue ) {
				ST_Pb_Init_Assets::load( $handle, $file_uri );
			}
		}

		/**
		 * Store handle to Session
		 *
		 * @global type $wp_scripts
		 *
		 * @param type  $handle
		 */
		static function store_assets_info( $handle, $src = '', $file_path = '' ) {
			global $wp_scripts, $post;
			$handle_object = array();

			if ( empty ( $_SESSION['st-pb-assets-frontend'] ) ) {
				$_SESSION['st-pb-assets-frontend'] = array();
			}
			if ( empty ( $_SESSION['st-pb-assets-frontend'][$post->ID] ) )
			$_SESSION['st-pb-assets-frontend'][$post->ID] = array();

			if ( ! ( empty ( $wp_scripts ) && empty ( $wp_scripts->registered ) ) ) {
				if ( array_key_exists( $handle, $wp_scripts->registered ) ) {
					$handle_object = $wp_scripts->registered[$handle];
					$src           = $handle_object['src'];
				}
			}

			$type = ( substr( $src, - 2 ) == 'js' ) ? 'js' : 'css';
			if ( empty ( $_SESSION['st-pb-assets-frontend'][$post->ID][$type] ) )
				$_SESSION['st-pb-assets-frontend'][$post->ID][$type] = array();

			if ( ! array_key_exists( $handle, $_SESSION['st-pb-assets-frontend'][$post->ID][$type] ) ) 
			{
				//				// Dependency
				//				if( isset ( $handle_object['deps'] ) ) {
				//					$deps = $handle_object['deps'];
				//					foreach ($deps as $other_handle) {
				//						self::store_assets_info( $other_handle );
				//					}
				//				}
				$modified_time = filemtime( $file_path );
				$_SESSION['st-pb-assets-frontend'][$post->ID][$type][$file_path] = $modified_time;
			}

		}

		/**
		 * Remove HTML/PHP tag & other tag in ID of an element
		 *
		 * @param type $string
		 *
		 * @return type
		 */
		static function remove_tag( $string ) {
			$string = strip_tags( $string );
			$string = str_replace( '-value-', '', $string );
			$string = str_replace( '-type-', '', $string );

			return $string;
		}

		/**
		 * Get post excerpt (can't use WP excerpt function, because post content contains IGPB shortcodes)
		 *
		 * @param type $post_content
		 *
		 * @return type
		 */
		static function post_excerpt( $post_content ) {
			$excerpt = ST_Pb_Helper_Shortcode::remove_wr_shortcodes( $post_content );

			return strip_tags( $excerpt );
		}

		/**
		 * Open item in new window
		 *
		 * @param type $selector
		 * @param type $options
		 */
		static function new_window( $selector, $options = array() ) {
			$script  = "<script type='text/javascript'>";
			$script .= "( function ($) {
				$( document ).ready( function () {
					$( '$selector' ).click( function(e){
						e.preventDefault();
						var url = $(this).attr('href');

						var width = screen.availWidth * 0.75;
						var height = screen.availHeight * 0.75;
						var left = parseInt((screen.availWidth/2) - (width/2));
						var top = parseInt((screen.availHeight/2) - (height/2));
						var windowFeatures = 'width=' + width + ',height=' + height + ',status,resizable,left=' + left + ',top=' + top + 'screenX=' + left + ',screenY=' + top;
						myWindow = window.open(url, 'subWind', windowFeatures);
					} );
				});
			})( jQuery )";
			$script .= '</script>';

			return $script;
		}

		/**
		 * Js for fancybox
		 *
		 * @param type $selector
		 *
		 * @return type
		 */
		static function fancybox( $selector, $options = array() ) {
			$default = array(
				'type'          => '',
				'autoScale'     => 'false',
				'transitionIn'  => 'elastic',
				'transitionOut' => 'elastic',
			);
			$options = array_merge( $default, $options );
			$data    = array();
			foreach ( $options as $key => $value ) {
				$value  = is_string( $value ) ? "'$value'" : $value;
				$data[] = "'$key' : $value";
			}
			$data = implode( ',', $data );

			$script  = "<script type='text/javascript'>";
			$script .= "( function ($ ) {
				$( document ).ready( function () {
					$( '$selector' ).fancybox( { $data } );
				});
			})( jQuery )";
			$script .= '</script>';

			return $script;
		}

		/**
		 * Social share links
		 *
		 * @param type $social_networks
		 *
		 * @return type
		 */
		static function social_links( $social_networks, $permalink, $title, $thumb, $excerpt ) {
			$all_socials     = array(
				'facebook'   => array( 'link' => 'http://www.facebook.com/sharer/sharer.php?s=100&p[url]=' . $permalink . '&p[images][0]=' . $thumb . '&p[title]=' . $title . '&p[summary]=' . $excerpt ),
				'twitter'    => array( 'link' => 'http://twitter.com/home/?status=' . $title . ' - ' . $permalink ),
				'googleplus' => array( 'link' => 'https://plus.google.com/share?url=' . $permalink ),
			);
			$links           = array();
			$social_networks = array_filter( $social_networks );
			foreach ( $social_networks as $network ) {
				if ( isset( $all_socials[$network] ) ) {
					$network_info = $all_socials[$network];
					$links[]      = "<li><a href='{$network_info['link']}' target='_blank' class='$network social-link'></a></li>";
				}
			}
			ob_start();
			?>
<script type='text/javascript'>
				(function ($) {
					$(document).ready(function () {
						$('.social-link').unbind('click').click(function (e) {
							e.preventDefault();
							var w = 600, h = 600;
							var left = (screen.width / 2) - (w / 2);
							var top = (screen.height / 2) - (h / 2);
							window.open($(this).attr('href'), "_blank", 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);
						});
					});
				})(jQuery);
			</script>
			<?php
			$script = ob_get_clean();

			return $script . '<ul class="st-social-links">' . implode( '', $links ) . '</ul>';
		}

		/**
		 * Modify value in array
		 *
		 * @param type $value
		 * @param type $key
		 * @param type $new_values
		 */
		static function st_arr_walk( &$value, $key, $new_values ) {
			if ( array_key_exists( $value['id'], $new_values ) )
			{
				$value['default_val'] = $value['std']; // save original val
				$value['std'] = $new_values[$value['id']];
			}
		}

		/**
		 * Modify value in array of sub-shortcode
		 *
		 * @param type $value
		 * @param type $key
		 * @param type $new_values
		 */
		static function st_arr_walk_subsc( &$value, $key, $new_values ) {
			//$value['default_val'] = $value['std']; // save original val
			$value['std'] = $new_values[$key];

			//echo '<pre>st_arr_walk_subsc: '.print_r($value, TRUE).'</pre>';
		}

		/**
		 * Get image id
		 *
		 * @global type $wpdb
		 *
		 * @param type  $image_url
		 *
		 * @return type
		 */
		public static function get_image_id( $image_url = '' ) {
			global $wpdb;
			$attachment_id = false;

			// If there is no url, return.
			if ( '' == $image_url )
				return;

			// Get the upload directory paths
			$upload_dir_paths = wp_upload_dir();

			// Make sure the upload path base directory exists in the attachment URL, to verify that we're working with a media library image
			if ( false !== strpos( $image_url, $upload_dir_paths['baseurl'] ) ) {

				// If this is the URL of an auto-generated thumbnail, get the URL of the original image
				$image_url = preg_replace( '/-\d+x\d+(?=\.(jpg|jpeg|png|gif)$)/i', '', $image_url );

				// Remove the upload path base directory from the attachment URL
				$image_url = str_replace( $upload_dir_paths['baseurl'] . '/', '', $image_url );

				// Finally, run a custom database query to get the attachment ID from the modified attachment URL
				$attachment_id = $wpdb->get_var( $wpdb->prepare( "SELECT wposts.ID FROM $wpdb->posts wposts, $wpdb->postmeta wpostmeta WHERE wposts.ID = wpostmeta.post_id AND wpostmeta.meta_key = '_wp_attached_file' AND wpostmeta.meta_value = '%s' AND wposts.post_type = 'attachment'", $image_url ) );
			}

			return $attachment_id;
		}

		/**
		 * Set post views
		 *
		 * @param int $postID
		 */
		public static function set_postview( $postID ) {
			$count_key = '_wr_post_view_count';
			$count     = get_post_meta( $postID, $count_key, true );
			if ( $count == '' ) {
				$count = 0;
				delete_post_meta( $postID, $count_key );
				add_post_meta( $postID, $count_key, '0' );
			} else {
				$count ++;
				update_post_meta( $postID, $count_key, $count );
			}
		}

		/**
		 * Count post views
		 *
		 * @param int $postID
		 */
		public static function get_postview( $postID ) {
			$count_key = '_wr_post_view_count';
			$count     = get_post_meta( $postID, $count_key, true );
			if ( empty( $count ) || intval( $count ) == 0 ) {
				delete_post_meta( $postID, $count_key );
				add_post_meta( $postID, $count_key, '0' );

				return '0 ' . __( 'View', ST_PBL );
			}

			return $count . ' ' . ( ( intval( $count ) == 1 ) ? __( 'View', ST_PBL ) : __( 'Views', ST_PBL ) );
		}

		/**
		 * Get current shortcode
		 *
		 * @return type
		 */
		public static function current_shortcode() {
			if ( ! empty( $_GET['st-gadget'] ) && $_GET['st-gadget'] == 'edit-element' ) 
			{
				$current_shortcode = ! empty( $_GET['st_modal_type'] ) ? $_GET['st_modal_type'] : ( ! empty( $_GET['st_shortcode_name'] ) ? $_GET['st_shortcode_name'] : '' );
				$current_shortcode = preg_replace( '/(st_|item_)/', '', $current_shortcode );

				return $current_shortcode;
			}

			return NULL;
		}

		/**
		 * Check if current page is modal page
		 *
		 * @return type
		 */
		public static function is_modal() {
			return ( ! empty( $_GET['st-gadget'] ) && $_GET['st-gadget'] == 'edit-element' );
		}

		/**
		 * Check if current page is modal page
		 *
		 * @param type $shortcode
		 *
		 * @return type
		 */
		public static function is_modal_of_element( $shortcode ) {
			if ( empty ( $shortcode ) ) {
				return false;
			}

			return ( ST_Pb_Helper_Functions::is_modal() && isset( $_GET['st_modal_type'] ) && $_GET['st_modal_type'] == $shortcode );
		}

		/**
		 * Check if current page is modal/ preview page
		 *
		 * @return type
		 */
		public static function is_preview() {
			return ( ! empty( $_GET['st_shortcode_preview'] ) && $_GET['st_shortcode_preview'] == '1' );
		}

		/**
		 * Get folder path
		 *
		 * @param type $folder
		 * @param type $uri
		 *
		 * @return type
		 */
		public static function path( $folder = '', $uri = '' ) {
			$uri = empty ( $uri ) ? ST_PB_URI : $uri;

			return $uri . $folder;
		}

		/**
		 * Common js/css file for ProStyler Builder/Ig Modal/Ig Preview Page
		 *
		 * @return type
		 */
		public static function localize_js() {
			return array(
				'ajaxurl'      => admin_url( 'admin-ajax.php' ),
				'adminroot'    => admin_url(),
				'_nonce'       => wp_create_nonce( ST_NONCE ),
				'st_modal_url' => ST_EDIT_ELEMENT_URL,
				'st_preview_url' => ST_PREVIEW_URL,
				'save'         => __( 'Save', ST_PBL ),
				'cancel'       => __( 'Cancel', ST_PBL ),
				'delete'       => __( 'Delete Element', ST_PBL ),
				'assets_url'   => ST_PB_URI,
				'st_edit_confirm'       => __( "You have not saved the changes to current element.\n\nPress OK to continue anyway.", ST_PBL ),
			);
		}

		/**
		 * Common scripts for ProStyler Builder
		 */
		public static function enqueue_scripts() {
			ST_Pb_Init_Assets::load(
			array(
					'jquery-ui-resizable',
					'jquery-ui-sortable',
					'jquery-ui-droppable',
					'jquery-ui-tabs',
					'jquery-ui-dialog',
					'jquery-ui-button',
					'jquery-ui-slider',
					'jquery-effects-core',
					'jquery-effects-fade',
					'st-pb-bootstrap-js',
					'st-pb-jquery-easing-js',
			)
			);
		}

		/**
		 * Common scripts for WR modal
		 */
		public static function enqueue_scripts_modal() {
			ST_Pb_Init_Assets::load( array( 'st-pb-bootstrap-js' ) );
			
			if ( self::is_preview() ) 
			{
				// load javascripts from theme (this is also in another function in this file)
				ST_Pb_Helper_Functions::$preview_js = apply_filters('st_preview_js', ST_Pb_Helper_Functions::$preview_js);
								
				if(!empty(ST_Pb_Helper_Functions::$preview_js))
				{
					$assets = array();
					foreach(ST_Pb_Helper_Functions::$preview_js as $key=>$val)
					{
						$assets[] = $key;
					}	
					
					ST_Pb_Init_Assets::load($assets);
				}
			}

			if ( ! self::is_preview() ) {
				ST_Pb_Init_Assets::load( array( 'jquery-ui-tabs', 'st-pb-jquery-easing-js' ) );
			}
		}

		/**
		 * Enqueue needed scripts to handle elements on PageBuilder
		 */
		public static function enqueue_scripts_end() {
			// Load necessary scripts if not previewing
			if ( ! self::is_preview() ) {
				ST_Pb_Init_Assets::load( 'st-pb-modal-js' );

				if ( isset($_GET['st_layout'])	
					&& $_GET['st_layout'] == 1 ) {
					// Load premade layout script
					ST_Pb_Init_Assets::load( 'st-pb-premade-pages-js' );
				} else {
					// Load element editor script
					ST_Pb_Init_Assets::load( 'st-pb-handleelement-js' );

					// Load element settings script
					ST_Pb_Init_Assets::load( 'st-pb-handlesetting-js' );

					// Load ZeroClipboard JavaScript library for Shortcode Content tab
					ST_Pb_Init_Assets::load( 'st-zeroclipboard-js' );
				}

				// Localize necessary scripts
				self::st_localize();
			}
		}

		/**
		 * Common styles
		 */
		public static function enqueue_styles() {
			add_filter( 'st_pb_register_assets', array( __CLASS__, 'register_assets' ) );
			$arr_before_load_pb = apply_filters( 'st_load_assets_before', array( 'st-pb-jquery-ui-css', 'st-pb-jquery-select2-css', 'st-pb-jquery-select2-bootstrap3-css', 'st-pb-admin-css', 'st-pb-element-font-css', 'st-pb-layout-font-css' ) );

			if ( is_admin() ) {
				ST_Pb_Init_Assets::load( array( 'st-pb-fontawesome-css', 'st-pb-bootstrap-css', 'st-pb-jsn-css', 'st-pb-font-icomoon-css' ) );

				if ( ! self::is_preview() ) {
					ST_Pb_Init_Assets::load( $arr_before_load_pb );
				}
			}
		}

		/* LOGO LOADER STYLES */
		public static function loader_styles() {
			?>
<style>
.st_logo_loading
{
    display: inline-block;
    vertical-align: text-top;
    width: 70px;
}

.st_logo_loading svg .ring1 {
  transform-origin: 50% 50%;
  -webkit-animation:st_spin 2s linear infinite;
  -moz-animation:st_spin 2s linear infinite;
  animation:st_spin 2s linear infinite;
}

.st_logo_loading svg .ring2 {
  transform-origin: 50% 50%;
  -webkit-animation:st_spin_reverse 2s linear infinite;
  -moz-animation:st_spin_reverse 2s linear infinite;
  animation:st_spin_reverse 2s linear infinite;
}

@-moz-keyframes st_spin { 100% { -moz-transform: rotate(360deg); } }
@-webkit-keyframes st_spin { 100% { -webkit-transform: rotate(360deg); } }
@keyframes st_spin { 100% { -webkit-transform: rotate(360deg); transform:rotate(360deg); } }

@-moz-keyframes st_spin_reverse { 100% { -moz-transform: rotate(-360deg); } }
@-webkit-keyframes st_spin_reverse { 100% { -webkit-transform: rotate(-360deg); } }
@keyframes st_spin_reverse { 100% { -webkit-transform: rotate(-360deg); transform:rotate(-360deg); } }

@keyframes st_fadein {
    from { opacity: 0; }
    to   { opacity: 1; }
}

/* Firefox < 16 */
@-moz-keyframes st_fadein {
    from { opacity: 0; }
    to   { opacity: 1; }
}

/* Safari, Chrome and Opera > 12.1 */
@-webkit-keyframes st_fadein {
    from { opacity: 0; }
    to   { opacity: 1; }
}

/* Internet Explorer */
@-ms-keyframes st_fadein {
    from { opacity: 0; }
    to   { opacity: 1; }
}

/* Opera < 12.1 */
@-o-keyframes st_fadein {
    from { opacity: 0; }
    to   { opacity: 1; }
}
</style>
			<?php
		}

		/**
		 * Register some custom assets
		 *
		 * @param array $assets
		 *
		 * @return string
		 */
		public static function register_assets( $assets ) {
			$assets['st-pb-modal-js'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/main' ) . '/js/modal.js',
				'ver' => '1.2.0',
			);

			$assets['st-pb-handleelement-js'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/main' ) . '/js/handle_element.js',
				'ver' => '1.2.0',
				'deps' => array( 'st-contextmenujs-js' ),
			);

			$assets['st-pb-handlesetting-js'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/main' ) . '/js/handle_setting.js',
				'ver' => '1.2.0',
			);

			$assets['st-pb-premade-pages-js'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/main' ) . '/js/premade-pages/premade.js',
				'ver' => '1.0.0',
			);

			$assets['st-pb-admin-css'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/main' ) . '/css/page_builder.css',
				'ver' => '1.2.0',
				'deps' => array( 'st-contextmenucss-css' ),
			);
			
			$assets['st-pb-fontawesome-css'] = array(
				'src' => '//maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css',
				'ver' => '4.1.0'
			);

			$assets['st-pb-element-font-css'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/3rd-party/st-element-font' ) . '/css/st-element-font.css',
				'ver' => '1.0.0'
			);

			$assets['st-pb-layout-font-css'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/3rd-party/st-layout-font' ) . '/css/st-layout-font.css',
				'ver' => '1.0.0'
			);

			// thirdparty jquery right click menu plugin.
			// added as dependency abpve to st-pb-handleelement-js and st-pb-admin-css
			$assets['st-contextmenujs-js'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/3rd-party/jquery-contextmenu' ) . '/jquery.contextMenu.min.js',
				'ver' => '2.4.3',
				'deps' => array( 'jquery-ui-position' ),
			);
			$assets['st-contextmenucss-css'] = array(
				'src' => ST_Pb_Helper_Functions::path( 'assets/3rd-party/jquery-contextmenu' ) . '/jquery.contextMenu.min.css',
				'ver' => '2.4.3',
			);

			return $assets;
		}

		/**
		 * Localize for js files
		 */
		public static function st_localize() {
			ST_Pb_Init_Assets::localize( 'st-pb-handleelement', 'St_Translate', ST_Pb_Helper_Functions::js_translation() );
			ST_Pb_Init_Assets::localize( 'st-pb-handleelement', 'St_Js_Html', ST_Pb_Helper_Shortcode::$item_html_template );
			ST_Pb_Init_Assets::localize( 'st-pb-handleelement', 'St_Ajax', ST_Pb_Helper_Functions::localize_js() );

			// Localize scripts for premade layout modal.
			ST_Pb_Init_Assets::localize( 'st-pb-premade-pages', 'St_Translate', ST_Pb_Helper_Functions::js_translation() );
			ST_Pb_Init_Assets::localize( 'st-pb-premade-pages', 'St_Ajax', ST_Pb_Helper_Functions::localize_js() );

			ST_Pb_Init_Assets::localize( 'st-pb-layout', 'St_Translate', ST_Pb_Helper_Functions::js_translation() );
			ST_Pb_Init_Assets::localize(
				'st-pb-widget', 'St_Preview_Html', ST_Pb_Helper_Functions::get_element_item_html(
			array(
						'element_wrapper' => 'div',
						'modal_title'     => '',
						'element_type'    => 'data-el-type="element"',
						'name'            => 'Widget Element Setting',
						'shortcode'       => 'ST_SHORTCODE_CONTENT',
						'shortcode_data'  => 'ST_SHORTCODE_DATA',
						'content_class'   => 'st-pb-element',
						'content'         => 'Widget Element Setting',
			)
			)
			);
		}

		/**
		 * Get list of defined widgets
		 *
		 * @global type $wp_widget_factory
		 * @return type
		 */
		public static function list_widgets() {
			global $wp_widget_factory;
			$results = array();
			foreach ( $wp_widget_factory->widgets as $class => $info ) {
				$results[$info->id_base] = array(
					'class'       => $class,
					'name'        => __( $info->name, ST_PBL ),
					'description' => __( ((isset($info->widget_options['description'])) ? $info->widget_options['description'] : ''), ST_PBL )
				);
			}

			return $results;
		}

		/**
		 * Get all neccessary widgets information
		 *
		 * @return type
		 */
		public static function widgets() {
			$St_Pb_Widgets = array();
			$widgets       = ST_Pb_Helper_Functions::list_widgets();
			foreach ( $widgets as $id => $widget ) {
				if ( $widget['class'] == 'ST_Pb_Objects_Widget' )
				continue;
				$config                          = array(
					'shortcode'     => $widget['class'],
					'name'          => $widget['name'],
					'identity_name' => __( 'Widget', ST_PBL ) . ' ' . $widget['name'],
					'extra_'        => sprintf( 'data-value="%1$s" data-type="%2$s" data-sort="%2$s"', esc_attr( $id ), 'widget' ),
					'description'   => $widget['description']
				);
				$St_Pb_Widgets[$widget['class']] = $config;
			}

			return $St_Pb_Widgets;
		}

		/**
		 * Get html item
		 *
		 * @param array $data
		 * @param bool $inlude_sc_structure print the data structure in
		 * a textarea or not
		 *
		 * @return string
		 */
		static function get_element_item_html( $data, $inlude_sc_structure = true ) {

			$default = array(
				'element_wrapper'       => '',
				'modal_title'           => '',
				'element_type'          => '',
				'name'                  => '',
				'shortcode'             => '',
				'shortcode_data'        => '',
				'content_class'         => '',
				'content'               => '',
				'action_btn'            => '',
				'has_preview'           => true,
				'this_'                 => '',
				'drag_handle'           => true,
				'is_sub_element'        => false,
				'edit_inline'			=> '',
				'edit_using_ajax'			=> '',
				'icon_html'			=> '',
				'type'			=> 'element',
				'extracted_params' => array()
			);
			$data = array_merge( $default, $data );
			extract( $data );

			$preview_html = '';
			if ( $has_preview ) {
				$preview_html = '<div class="shortcode-preview-container" style="display: none">
					<div class="shortcode-preview-fog"></div>
					<div class="jsn-overlay jsn-bgimage image-loading-24"></div>
				</div>';
			}

			$enable_inline_edit = $edit_inline;

			$extra_class  = ST_Pb_Utils_Placeholder::get_placeholder( 'extra_class' );
			$custom_style = ST_Pb_Utils_Placeholder::get_placeholder( 'custom_style' );
			$other_class  = '';

			// Check if this element is deactivate
			preg_match_all( '/\[' . $shortcode . '\s+([A-Za-z0-9_-]+=\"[^"\']*\"\s*)*\s*\]/', $shortcode_data, $rg_sc_params );
			if ( ! empty( $rg_sc_params[0] ) ) {
				$sc_name_params = ! empty( $rg_sc_params[0][0] ) ? $rg_sc_params[0][0] : $rg_sc_params[0];
				if( strpos( $sc_name_params , 'disabled_el="yes"') !== false ) {
					$other_class = 'disabled';
				}
			}





			// ------------------------------------------------------
			//  yunus edit - removed this as we dont want empty values to be inserted back with STD value
			// ------------------------------------------------------
			// Remove empty value attributes of shortcode tag.
			//$shortcode_data = preg_replace( '/\[*([a-z_]*[\n\s\t]*=[\n\s\t]*""\s)/', '', $shortcode_data );

			// Content
			$content = balanceTags( $content );
			
			$content = self::get_element_item_preview_html($content, $shortcode_data, $type, $extracted_params);
			$content = apply_filters( 'st_pb_content_in_pagebuilder', $content, $shortcode_data, $shortcode );

			// action buttons
			$edit_icon = 'icon-pencil';

			$edit_btn = apply_filters( 'edit_btn_class', 'element-edit', $shortcode );

			$buttons = array(
				'edit'       => '<a href="#" onclick="return false;" title="' . __( 'Edit element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="' . $edit_btn . ( $enable_inline_edit ? '-sub' : '' ) . '"><i class="' . $edit_icon . '"></i></a>',
				'clone'      => '<a href="#" onclick="return false;" title="' . __( 'Duplicate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-clone"><i class="icon-copy"></i></a>',
				'deactivate' => '<a href="#" onclick="return false;" title="' . __( 'Deactivate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-deactivate"><i class="icon-checkbox-unchecked"></i></a>',
				'delete'     => '<a href="#" onclick="return false;" title="' . __( 'Delete element', ST_PBL ) . '" class="element-delete"><i class="icon-trash"></i></a>'
				);

				if ( ! empty ( $other_class ) ) {
					$buttons = array_merge(
					$buttons, array(
						'deactivate' => '<a href="#" onclick="return false;" title="' . __( 'Activate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-deactivate"><i class="icon-checkbox-partial"></i></a>',
					)
					);
				}

				$action_btns = ( empty( $action_btn ) ) ? implode( '', $buttons ) : $buttons[$action_btn];
				$buttons     = apply_filters( 'st_pb_button_in_pagebuilder', "<div class='jsn-iconbar'>$action_btns</div>", $shortcode_data, $shortcode );

				// Exclude the shortcode structure in shortcode textarea if not required.
				if ( !$inlude_sc_structure ) {
					$shortcode_data   = '';
				}

				// Add drag handle
				$drag_handle_html = ( $drag_handle == true ) ? "<a class='element-drag'><i class=\"fa fa-bars\"></i></a>" : "";

				return "<$element_wrapper class='jsn-item jsn-element ui-state-default jsn-iconbar-trigger shortcode-container $extra_class $other_class' $modal_title $element_type $edit_using_ajax data-name='$name' $custom_style>
				<textarea class='hidden shortcode-content' shortcode-name='$shortcode' data-sc-info='shortcode_content' name='shortcode_content[]' >$shortcode_data</textarea>
				<div class='heading cbb-sort-handle'>
				$drag_handle_html
				<div class='$content_class'>$content</div>
				</div>
				$buttons
				$preview_html
			</$element_wrapper>";
		}


		static function get_element_item_preview_html($content, $shortcode_data, $type='', $extracted_params=array())
		{
	        if ($type && $type== 'widget') return $content;

            // if no params provided then we parse shortcode
            if (empty($extracted_params)) {
                $extracted_params = shortcode_parse_atts($shortcode_data);
            }

            if (! empty($extracted_params)) {

                // get images preview
                $preview_images = self::get_shortcode_images($shortcode_data);
                //echo '<pre>'.print_r($preview_images, TRUE).'</pre>';
                if(! empty($preview_images)) 
                {
                    $content .= '<ul class="cbb-elm-images-preview '.(count($preview_images) > 10 ? 'cbb-elm-gallery-preview' : '').'">';
                    
                    foreach ($preview_images as $preview_image) {
                    	$filename = basename($preview_image );
                    	$img = '<span class="st-async-load" data-img="'.esc_attr( $preview_image ).'"></span>';
                        $content .= '<li class="st-preview-tooltip" data-container="#st_page_builder" data-html="true" title="">'.$img.'</li>';
                    }
                    $content .= '</ul>';
                }
            
            //echo '<pre>'.print_r($images, TRUE).'</pre>';

                // remove shortcode brackets and everything between to get content
                $content_preview = preg_replace('/\[.*?\]/', '', $shortcode_data);
                $content_preview = trim(strip_tags($content_preview));
                if ($content_preview) {
                    // limit characters
                    if (strlen($content_preview) > 100) {
                        $content_preview = substr($content_preview, 0, 100).'...';
                    }

                    $content .= '<div class="cbb-elm-content-preview">'.$content_preview.'</div>';
                }
            }

	        return $content;
		}


		/**
		 * Get images in shortcode string using regex
		 * @param  string $raw_shortcode_data raw shortcode data
		 * @return array                     containing images or empty array
		 */
		static function get_shortcode_images($raw_shortcode_data)
		{
			if(! $raw_shortcode_data) return array();
			preg_match_all('/https?:\/\/[^ ]+?(?:\.jpg|\.png|\.gif)/i', $raw_shortcode_data, $images);

			// if images found
			if(isset($images[0]) && !empty($images[0]))
			{
				return $images[0];
			}

			return array();
		}

		/**
		 * Get basedir of subfolder in UPLOAD folder
		 *
		 * @param type $sub_dir
		 *
		 * @return type
		 */
		static function get_wp_upload_folder( $sub_dir = '', $auto_create = true ) {
			$upload_dir = wp_upload_dir();
			if ( is_array( $upload_dir ) && isset ( $upload_dir['basedir'] ) ) {
				$upload_dir = $upload_dir['basedir'];
			} else {
				$upload_dir = WP_CONTENT_DIR . '/uploads';
				if ( ! is_dir( $upload_dir ) ) {
					mkdir( $upload_dir );
				}
			}
			if ( $auto_create && ! is_dir( $upload_dir . $sub_dir ) ) {
				mkdir( $upload_dir . $sub_dir, 0777, true );
			}

			return $upload_dir . $sub_dir;
		}

		/**
		 * Get baseurl of subfolder in UPLOAD folder
		 *
		 * @param type $sub_dir
		 *
		 * @return type
		 */
		static function get_wp_upload_url( $sub_dir = '' ) {
			$upload_dir = wp_upload_dir();
			if ( is_array( $upload_dir ) && isset ( $upload_dir['basedir'] ) ) {
				return $upload_dir['baseurl'] . $sub_dir;
			} else {
				return WP_CONTENT_URL . '/uploads' . $sub_dir;
			}
		}

		/**
		 * Store relation: array(file1, file2) => compressed file
		 *
		 * @param type $handle_info
		 * @param type $file_name
		 *
		 * @return type
		 */
		static function compression_data_store( $handle_info, $file_name ) {
			$cache_dir      = ST_Pb_Helper_Functions::get_wp_upload_folder( '/igcache/pagebuilder' );
			$file_to_write_ = "$cache_dir/st-pb.cache";
			$fp             = fopen( $file_to_write_, 'a+' );
			if ( $fp ) {
				// Get stored data
				$str = '';
				while ( ! feof( $fp ) ) {
					$str .= fread( $fp, 1024 );
				}
				$stored_data = unserialize( $str );
				$stored_data = $stored_data ? $stored_data : array();
				// Check if $handle_info is existed in stored data
				$exist = '';
				foreach ( $stored_data as $handle_info_serialized => $compressed_file ) {
					$handle_info_old = unserialize( $handle_info_serialized );
					// Check if handle names are same
					if ( ! count( array_diff( array_keys( $handle_info ), array_keys( $handle_info_old ) ) ) ) {
						// Check if date modified are same
						if ( ! count( array_diff( $handle_info, $handle_info_old ) ) ) {
							$exist = $compressed_file;
							fclose( $fp );

							return array( 'exist', $compressed_file );
						}
					}
				}

				// close current handle
				fclose( $fp );

				// open new handle to write from beginning of file
				$fp                   = fopen( $file_to_write_, 'w' );
				$string               = serialize( $handle_info );
				$stored_data[$string] = $file_name;
				fwrite( $fp, serialize( $stored_data ) );

				fclose( $fp );

				return array( 'not exist', $file_name );
			}
		}

		/**
		 * Handle empty icon & heading for Carousel, ,Tab, Accordion, List item
		 *
		 * @param type $heading
		 * @param type $icon
		 */
		static function heading_icon( &$heading, &$icon, $heading_empty = false ) {
			if ( strpos( $heading, ST_Pb_Utils_Placeholder::get_placeholder( 'index' ) ) !== false ) {
				$heading = '';
			}
			if ( empty ( $icon ) && empty ( $heading ) )
				$heading = ! $heading_empty ? __( '(Untitled)', ST_PBL ) : '';
		}

		/**
		 * Show alert box
		 *
		 * @param unknown $mgs
		 */
		static function alert_msg( $mgs ) {
			?>
<div class="alert alert-<?php echo balanceTags( $mgs[0] ); ?>">
<?php echo balanceTags( $mgs[1] ); ?>
</div>
<?php
		}

		/**
		 * Load bootstrap 3, replace bootstrap 2
		 *
		 * @param type $assets
		 *
		 * @return string
		 */
		 // ------------------------------------------------------
		 //  yunus edit - use theme css if available
		 // ------------------------------------------------------
		static $preview_js = array();
		
		static function load_bootstrap_3( &$assets ) 
		{
			if ( ! is_admin() || ST_Pb_Helper_Functions::is_preview() ) 
			{
				if(ST_Pb_Helper_Functions::is_preview())
				{
					// load theme main css file
					$preview_css = apply_filters('st_preview_css', get_template_directory_uri() . '/library/css/style.css');
					
					// if its array then load all of them 
					// and make st-pb-bootstrap-css the dependecy of all except main
					if(is_array($preview_css))
					{
						$preview_css_dependency = array();
						foreach($preview_css as $preview_css_key => $preview_css_url)
						{
							$current_preview_css_dependency = array();
							if($preview_css_key == 'main') 
							{
								$preview_css_key = 'st-pb-bootstrap-css';
								$current_preview_css_dependency = $preview_css_dependency;
							}
							else 
							{
								$preview_css_key .= '-css';
								$preview_css_dependency[] = $preview_css_key;
							}
							
							$assets[ $preview_css_key ] = array(
								'src' => $preview_css_url,
								'ver' => '',
								'deps' => $current_preview_css_dependency,
							);
						}
					}
					else
					{
						$assets['st-pb-bootstrap-css'] = array(
							'src' => $preview_css,
							'ver' => '3.0.2',
						);
					}
					
					// load javascripts from theme (this is also in another function in this file)
					ST_Pb_Helper_Functions::$preview_js = apply_filters('st_preview_js', ST_Pb_Helper_Functions::$preview_js);
					
					if(!empty(ST_Pb_Helper_Functions::$preview_js))
					{
						foreach(ST_Pb_Helper_Functions::$preview_js as $key=>$val)
						{
							$assets[$key] = $val;
						}	
					}
				}
				else
				{
					$assets['st-pb-bootstrap-css'] = array(
						'src' => ST_Pb_Helper_Functions::path( 'assets/3rd-party/bootstrap3' ) . '/css/bootstrap_frontend.min.css',
						'ver' => '3.0.2',
					);
				}
				
				$assets['st-pb-bootstrap-js'] = array(
					'src'  => ST_Pb_Helper_Functions::path( 'assets/3rd-party/bootstrap3' ) . '/js/bootstrap_frontend.min.js',
					'ver'  => '3.0.2',
					'deps' => array( 'jquery' ),
				);
			}
		}

		/**
		 * Get custom CSS meta data of post
		 *
		 * @param type $post_id
		 * @param type $meta_key
		 * @param type $action : get / put
		 *
		 * @return type
		 */
		static function custom_css( $post_id, $meta_key, $action = 'get', $value = '' ) {
			switch ( $meta_key ) {

				case 'css_files':
					if ( $action == 'get' )
					$result = get_post_meta( $post_id, '_wr_page_builder_css_files', true );
					else {
						$result = update_post_meta( $post_id, '_wr_page_builder_css_files', $value );
					}
					break;

				case 'css_custom':
					if ( $action == 'get' )
					$result = get_post_meta( $post_id, '_wr_page_builder_css_custom', true );
					else
					$result = update_post_meta( $post_id, '_wr_page_builder_css_custom', $value );
					break;

				default:
					break;
			}
			return $result;
		}

		/**
		 * Get custom css data: Css files, Css code of a post
		 *
		 * @global type $post
		 *
		 * @param type  $post_id
		 *
		 * @return type
		 */
		static function custom_css_data( $post_id ) {

			$arr = array( 'css_files' => '', 'css_custom' => '' );
			if ( isset ( $post_id ) ) {
				$arr['css_files']  = ST_Pb_Helper_Functions::custom_css( $post_id, 'css_files' );
				$arr['css_custom'] = ST_Pb_Helper_Functions::custom_css( $post_id, 'css_custom' );
			}

			return $arr;
		}

		/**
		 * Get custom information of plugin
		 *
		 * @param string $plugin_file : main file of plugin
		 * @param string $custom_info : custom date key
		 *
		 * @return type
		 */
		static function get_plugin_info( $plugin_file, $custom_info = '' ) {

			$plugin_data = get_plugin_data( $plugin_file );

			if ( $custom_info ) {
				return isset ( $plugin_data[$custom_info] ) ? $plugin_data[$custom_info] : NULL;
			}

			return $plugin_data;
		}

		/**
		 * Add google link to header
		 *
		 * @param string $font
		 *
		 * @return string
		 */
		static function add_google_font_link_tag( $font ) {
			ob_start();
			?>
<script type="text/javascript">
	(function ($) {
		$(document).ready(function () {
			var font_val = '<?php echo esc_js( str_replace( ' ', '+', $font ) ); ?>';

			// Check if has a link tag of this font
			var exist_font = 0;
			$('link[rel="stylesheet"]').each(function (i, ele) {
				var href = $(this).attr('href');
				if (href.indexOf('fonts.googleapis.com/css?family=' + font_val) >= 0) {
					exist_font++;
				}
			});

			// if this font is not included at head, add it
			if (!exist_font) {
				$('head').append("<link rel='stylesheet' href='//fonts.googleapis.com/css?family=<?php echo esc_attr( $font ); ?>' type='text/css' media='all' />");
			}
		});
	})(jQuery)
</script>
			<?php
			return ob_get_clean();
		}

		/**
		 * Custom script tag
		 *
		 * @param string $content
		 *
		 * @return string
		 */
		static function script_box( $content = '' ) {
			ob_start();
			?><script type="text/javascript">
	(function ($) {
		$(document).ready(function () {
			<?php echo balanceTags( $content ); ?>
		});
	})(jQuery)</script><?php
			return ob_get_clean();
		}
		
		
		
		
		static function getImageBySize( $params = array( 'post_id' => NULL, 'attach_id' => NULL, 'thumb_size' => 'thumbnail', 'class' => '' ) ) 
		{
			//array( 'post_id' => $post_id, 'thumb_size' => $grid_thumb_size )
			if ( ( ! isset( $params['attach_id'] ) || $params['attach_id'] == NULL ) && ( ! isset( $params['post_id'] ) || $params['post_id'] == NULL ) ) return;
			$post_id = isset( $params['post_id'] ) ? $params['post_id'] : 0;

			if ( $post_id ) $attach_id = get_post_thumbnail_id( $post_id );
			else $attach_id = $params['attach_id'];
		
			$thumb_size = $params['thumb_size'];
			$thumb_class = ( isset( $params['class'] ) && $params['class'] != '' ) ? $params['class'] . ' ' : '';
		
			global $_wp_additional_image_sizes;
			$thumbnail = '';
		
			if ( is_string( $thumb_size ) && 
					( ( ! empty( $_wp_additional_image_sizes[$thumb_size] ) && is_array( $_wp_additional_image_sizes[$thumb_size] ) ) || in_array( $thumb_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) ) 
			{
				//$thumbnail = get_the_post_thumbnail( $post_id, $thumb_size );
				$thumbnail = wp_get_attachment_image( $attach_id, $thumb_size, false, array( 'class' => $thumb_class . 'attachment-' . $thumb_size ) );
				// TODO: APPLY FILTER
			} elseif ( $attach_id ) {
				if ( is_string( $thumb_size ) ) {
					preg_match_all( '/\d+/', $thumb_size, $thumb_matches );
					if ( isset( $thumb_matches[0] ) ) {
						$thumb_size = array();
						if ( count( $thumb_matches[0] ) > 1 ) {
							$thumb_size[] = $thumb_matches[0][0]; // width
							$thumb_size[] = $thumb_matches[0][1]; // height
						} elseif ( count( $thumb_matches[0] ) > 0 && count( $thumb_matches[0] ) < 2 ) {
							$thumb_size[] = $thumb_matches[0][0]; // width
							$thumb_size[] = $thumb_matches[0][0]; // height
						} else {
							$thumb_size = false;
						}
					}
				}
				if ( is_array( $thumb_size ) ) {
					// Resize image to custom size
					$p_img = self::resize( $attach_id, null, $thumb_size[0], $thumb_size[1], true );
					$alt = trim( strip_tags( get_post_meta( $attach_id, '_wp_attachment_image_alt', true ) ) );
		
					if ( empty( $alt ) ) {
						$attachment = get_post( $attach_id );
						$alt = trim( strip_tags( $attachment->post_excerpt ) ); // If not, Use the Caption
					}
					if ( empty( $alt ) )
						$alt = trim( strip_tags( $attachment->post_title ) ); // Finally, use the title
					if ( $p_img ) {
						$img_class = '';
						//if ( $grid_layout == 'thumbnail' ) $img_class = ' no_bottom_margin'; class="'.$img_class.'"
						$thumbnail = '<img class="' . $thumb_class . '" src="' . $p_img['url'] . '" width="' . $p_img['width'] . '" height="' . $p_img['height'] . '" alt="' . $alt . '" />';
						//TODO: APPLY FILTER
					}
				}
			}
		
			$p_img_large = wp_get_attachment_image_src( $attach_id, 'large' );
			return array( 'thumbnail' => $thumbnail, 'p_img_large' => $p_img_large );
		}
		
		
	
		// ------------------------------------------------------
		//  YUNUS EDIT - NEW FUNCTION
		// ------------------------------------------------------	
		/*
		* Resize images dynamically using wp built in functions
		* Victor Teixeira
		*
		* php 5.2+
		*
		* Exemplo de uso:
		*
		* <?php
		 * $thumb = get_post_thumbnail_id();
		 * $image = vt_resize( $thumb, '', 140, 110, true );
		 * ?>
		* <img src="<?php echo $image[url]; ?>" width="<?php echo $image[width]; ?>" height="<?php echo $image[height]; ?>" />
		*
		* @param int $attach_id
		* @param string $img_url
		* @param int $width
		* @param int $height
		* @param bool $crop
		* @return array
		*/
		static  function resize( $attach_id = null, $img_url = null, $width, $height, $crop = false ) {
			// this is an attachment, so we have the ID
			if ( $attach_id ) {
				$image_src = wp_get_attachment_image_src( $attach_id, 'full' );
				$actual_file_path = get_attached_file( $attach_id );
				// this is not an attachment, let's use the image url
			} else if ( $img_url ) {
				$file_path = parse_url( $img_url );
				$actual_file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];
				$actual_file_path = ltrim( $file_path['path'], '/' );
				$actual_file_path = rtrim( ABSPATH, '/' ) . $file_path['path'];
				$orig_size = getimagesize( $actual_file_path );
				$image_src[0] = $img_url;
				$image_src[1] = $orig_size[0];
				$image_src[2] = $orig_size[1];
			}
			$file_info = pathinfo( $actual_file_path );
			$extension = '.' . $file_info['extension'];
	
			// the image path without the extension
			$no_ext_path = $file_info['dirname'] . '/' . $file_info['filename'];
	
			$cropped_img_path = $no_ext_path . '-' . $width . 'x' . $height . $extension;
	
			// checking if the file size is larger than the target size
			// if it is smaller or the same size, stop right here and return
			if ( $image_src[1] > $width || $image_src[2] > $height ) {
	
				// the file is larger, check if the resized version already exists (for $crop = true but will also work for $crop = false if the sizes match)
				if ( file_exists( $cropped_img_path ) ) {
					$cropped_img_url = str_replace( basename( $image_src[0] ), basename( $cropped_img_path ), $image_src[0] );
					$vt_image = array(
						'url' => $cropped_img_url,
						'width' => $width,
						'height' => $height
					);
					//echo '<pre>'.print_r('still checking', TRUE).'</pre>';
					return $vt_image;
				}
	
				// $crop = false
				if ( $crop == false ) {
					// calculate the size proportionaly
					$proportional_size = wp_constrain_dimensions( $image_src[1], $image_src[2], $width, $height );
					$resized_img_path = $no_ext_path . '-' . $proportional_size[0] . 'x' . $proportional_size[1] . $extension;
	
					// checking if the file already exists
					if ( file_exists( $resized_img_path ) ) {
						$resized_img_url = str_replace( basename( $image_src[0] ), basename( $resized_img_path ), $image_src[0] );
	
						$vt_image = array(
							'url' => $resized_img_url,
							'width' => $proportional_size[0],
							'height' => $proportional_size[1]
						);
						
						
						return $vt_image;
					}
				}
	
				// no cache files - let's finally resize it
				$img_editor = wp_get_image_editor( $actual_file_path );
	
				if ( is_wp_error( $img_editor ) || is_wp_error( $img_editor->resize( $width, $height, $crop ) ) ) {
					return array(
						'url' => '',
						'width' => '',
						'height' => ''
					);
				}
	
				$new_img_path = $img_editor->generate_filename();
	
				if ( is_wp_error( $img_editor->save( $new_img_path ) ) ) {
					return array(
						'url' => '',
						'width' => '',
						'height' => ''
					);
				}
				if ( ! is_string( $new_img_path ) ) {
					return array(
						'url' => '',
						'width' => '',
						'height' => ''
					);
				}
	
				$new_img_size = getimagesize( $new_img_path );
				$new_img = str_replace( basename( $image_src[0] ), basename( $new_img_path ), $image_src[0] );
	
				// ------------------------------------------------------
				//  Generate attachment meta and add new size to it and put it back in database
				// ------------------------------------------------------
/*
				$attachment_meta = wp_get_attachment_metadata($attach_id);
				if($attachment_meta)
				{
					foreach ($attachment_meta['sizes'] as $size => $size_data ) 
					{
						$mime = $size_data['mime-type'];
						break;     
					}
					$attachment_meta['sizes'][ $new_img_size[0].'x'.$new_img_size[1] ] = array(
						'file' => basename($new_img),
						'width' => $new_img_size[0],
						'height' => $new_img_size[1],
						'mime-type' => $mime
					);
					echo '<pre>'.print_r($attachment_meta, TRUE).'</pre>';
					wp_update_attachment_metadata($attach_id, $attachment_meta);
				}
*/
	
				// resized output
				$vt_image = array(
					'url' => $new_img,
					'width' => $new_img_size[0],
					'height' => $new_img_size[1]
				);
				return $vt_image;
			}
	
			// default output - without resizing
			$vt_image = array(
				'url' => $image_src[0],
				'width' => $image_src[1],
				'height' => $image_src[2]
			);
			
			return $vt_image;
		}


		// ------------------------------------------------------
		//  YUNUS EDIT - NEW FUNCTION
		// ------------------------------------------------------
		static function make_shortcode_params($params, $values)
		{
			$string = '';	
				
			foreach($params as $param)
			{
				$value = '';
				if(isset($values[$param])) $value = $values[$param];
				
				$string .= ' '.$param.'="'.$value.'"';	
			}
			
			return $string;
		}
		
			
		// ------------------------------------------------------
		//  YUNUS EDIT - NEW FUNCTION
		// ------------------------------------------------------
		/* Convert hexdec color string to rgb(a) string */
		static function hex2rgba($color, $opacity = false) {
		
			$default = 'rgb(0,0,0)';
		
			//Return default if no color provided
			if(empty($color))
		          return $default; 
		
			//Sanitize $color if "#" is provided 
		        if ($color[0] == '#' ) {
		        	$color = substr( $color, 1 );
		        }
		
		        //Check if color has 6 or 3 characters and get values
		        if (strlen($color) == 6) {
		                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
		        } elseif ( strlen( $color ) == 3 ) {
		                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
		        } else {
		                return $default;
		        }
		
		        //Convert hexadec to rgb
		        $rgb =  array_map('hexdec', $hex);
		
		        //Check if opacity is set(rgba or rgb)
		        if($opacity !== false){
		        	if(abs($opacity) > 1)
		        		$opacity = 1.0;
		        	$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
		        } else {
		        	$output = 'rgb('.implode(",",$rgb).')';
		        }
		
		        //Return rgb(a) color string
		        return $output;
		}
		
		
		static function st_entities_decode($val, $normalize=false)
		{
			if($normalize)
			{
				$val = str_replace('{st-quote}', '&quot;', $val);

				return $val;
			}

			$val = str_replace('{st-quote}', '"', $val);

			return $val;
		}
		
		static function st_entities($val)
		{
			$val = str_replace('"', '{st-quote}', $val);

			return $val;
		}


		/**
		 * Cache enabled - Makes all pages array
		 * @param  boolean $uncache to not load from cache
		 * @return array           pages array
		 */
		static function pages_array($uncache=false)
		{
			static $cache;

			if($uncache == false && ! empty($cache))
			{
				return $cache;
			}

			$out = array();
			
			$out[''] = __( '----- Select Page ----', 'cbt' );
			
			$args = array(
				'post_type'=>'page',
			);
			$pages = get_pages( $args );
			
			if(! $pages) return $out;
			
			foreach($pages as $page)
			{
				$out[$page->post_name] = (trim($page->post_title))?$page->post_title .' (ID: '.$page->ID.')' : 'No title (ID: '.$page->ID.')';
			}
			
			$cache = $out;
			
			return $out;
		}


        static function get_file_uri( $file ) 
        {
            $dir = trailingslashit( dirname( $file ) );
            $count = 0;

            // sanitize for Win32 installs
            $dir = str_replace('\\' ,'/', $dir);
           
            // if file is in plugins folder
            $wp_plugin_dir = str_replace( '\\' ,'/', WP_PLUGIN_DIR );
            $dir = str_replace( $wp_plugin_dir, plugins_url(), $dir, $count );

            if ( $count < 1 ) {
                    // if file is in wp-content folder
                    $wp_content_dir = str_replace( '\\' ,'/', WP_CONTENT_DIR );
                    $dir = str_replace( $wp_content_dir, content_url(), $dir, $count );
            }

            if ( $count < 1 ) {
                    // if file is in ??? folder
                    $wp_dir = str_replace( '\\' ,'/', ABSPATH );
                    $dir = str_replace( $wp_dir, site_url( '/' ), $dir );
            }
           
            return $dir;
        }

		static function get_video_type($url) {
		    if (strpos($url, 'youtube') > 0) {
		        return 'youtube';
		    } elseif (strpos($url, 'vimeo') > 0) {
		        return 'vimeo';
		    } else {
		        return 'unknown';
		    }
		}


        /**
         * Converts percentage string to
         * number in relation to 12 columns
         * @param  string $str 	set of percentages string e.g 50% 40% space seperated
         * @return array/bool      numbers array for each %
         */
		static function string2columnSizes($str) 
		{
			$str = explode(' ', $str);
			if(empty($str))
			{
				return false;
			}

			$col_sizes = array();
			foreach($str as $col_size)
			{
				$col_size = trim($col_size);
				if(! $col_size) continue;

				$col_size = self::string2fraction($col_size);
				if($col_size == false) 
				{
					return false;
				}

				// round to nearest int
				$col_size_original = 12 * $col_size;
				$col_size = round( $col_size_original );


				if($col_size > 12) $col_size = 12;

				// if the sum is bigger than 12 we substract 1 to make up for rounding issue
				if( (array_sum($col_sizes) + $col_size) > 12 )
				{
					$col_size--;
				}

				$col_sizes[] = $col_size;
			}

			if(! $col_sizes) return false;


			return $col_sizes;
		}

		/**
		 * Converts string to ratio
		 * @param  string $str single percentage e.g 50%
		 * @return float      ratio
		 */
		static function string2fraction($str)
		{
			// remove % sign
			$str = str_replace('%', '', $str);

			$str = (int) $str;

			// validation
			if(! is_numeric($str) )
			{
				return false;
			}

			// convert to ratio
			$str = $str / 100;

			return $str;
		}

		
		
	}
}
