<?php



/**
 * @todo : Define HTML output of element types
 */

if ( ! class_exists( 'ST_Pb_Helper_Html' ) ) {

	class ST_Pb_Helper_Html {

		/**
		 * Get dependency information of an element
		 * @param array $element
		 */
		static function get_dependency( $element ) {
			$depend_info = array( 'data' => '', 'class' => '' );
			$dependency = ! empty( $element['dependency'] ) ? $element['dependency'] : '';
			if ( $dependency ) {
				
				// check if multiple depencides
				if(is_array($dependency[0]))
				{
					$dependencies = array();
					$depend_info['class'] = ' st_hidden_depend st_depend_other';
					
					foreach($dependency as $val)
					{
						$dependencies[] = array(
							'againist'=> 'param-'.$val[0],
							'operator'=> $val[1],
							'compare_value'=> $val[2],
						);
						$depend_info['class'] .= ' cbb-depends-on-param-'.$val[0];
					}	
					
					$depend_info['data'] = ' data-depend-multi="'.htmlspecialchars(json_encode($dependencies), ENT_QUOTES, 'UTF-8').'"';
					
					
					return $depend_info;
				}
				
				$depend_info['data']  = " data-depend-operator='{$dependency[1]}' data-depend-value='{$dependency[2]}'";
				$depend_info['class'] = ' st_hidden_depend st_depend_other cbb-depends-on-param-'.$dependency[0];
			}
			return $depend_info;
		}

		/**
		 * Get depend class & data to show/hide this option
		 *
		 * @param array $element
		 * @return type
		 */
		static function get_extra_info( $element ) {
			// check if element has dependened elements
			if ( ! isset( $element['class'] ) )
			$element['class'] = '';
			$element['class'] .= ' form-control input-sm';
			$element['class'] .= ( ! empty($element['has_depend'] ) && $element['has_depend'] == '1') ? ' st_has_depend' : '';
			if ( isset( $element['exclude_class'] ) && is_array( $element['exclude_class'] ) ) {
				foreach ( $element['exclude_class'] as $i => $class ) {
					$element['class'] = str_replace( $class, '', $element['class'] );
				}
			}

			$depend_info = self::get_dependency( $element );
			$element['depend_class'] = $depend_info['class'];
			$element['depend_data']  = $depend_info['data'];
			return $element;
		}

		/**
		 * Add parent class for option/ group of options
		 *
		 * @param type $output
		 * @return type
		 */
		static function bound_options( $output, $element=array() ) {

			return '<div class="controls">' . $output . '</div>';
		}

		/**
		 * Add data attributes for element
		 *
		 * @param array $element
		 * @param type $output
		 * @return type
		 */
		static function get_data_info( $element, $output ) {
			$role   = ! empty( $element['role'] ) ? "data-role='{$element['role']}'" : '';
			$role  .= ! empty( $element['title_prepend_type'] ) ? "data-title-prepend='{$element['title_prepend_type']}'" : '';
			$role  .= ! empty( $element['related_to'] ) ? "data-related-to='{$element['related_to']}'" : '';
			$output = str_replace( 'DATA_INFO', $role, $output );
			return $output;
		}

		/**
		 * Get style info
		 *
		 * @param array $element
		 * @param type $output
		 * @return type
		 */
		static function get_style( $element, $output ) {
			$style = ! empty( $element['style'] ) ? $element['style'] : '';
			if ( is_array( $element['style'] ) ) {
				$styles = array();
				foreach ( $element['style'] as $att_name => $att_value ) {
					$styles[] = "$att_name : $att_value";
				}
				$styles = "style = '" . implode( ';', $styles ) . "'";
			}else
			$styles = '';
			$output  = ST_Pb_Utils_Placeholder::remove_placeholder( $output, 'custom_style', $styles );
			return $output;
		}

		/**
		 * Output final HTML of a element
		 * Also, adds data to fields for passing to JS
		 *
		 * @param array $element
		 * @param type $output
		 * @return type
		 */
		static function final_element( $element, $output, $label, $no_id = false ) {

			// so we can avoid isset
			$element = wp_parse_args( $element, array(
					'type' => '',
				) );

			// data info settings
			$output = self::get_data_info( $element, $output );
			// custom style settings
			//$output = self::get_style( $element, $output );
			// parent class
			if ( ! empty( $element['parent_class'] ) ) {
				$output = "<div class='{$element['parent_class']}'>" . $output . '</div>';
			}
						
			// default value to be checked by js before adding to shortcode
			$attr = '';
			$st_default_val_classes = '';
			if(isset($element['default_val']) 
				&& ! preg_match('/_ST_/', $element['default_val']) // exclude placeholder values like tab titles etc
				&& $element['type']!='tiny_mce'
				&& (! isset($element['default_avoid']) 
					OR $element['default_avoid'] === true)
			) 
			{
				$attr .= ' data-std="'.esc_attr($element['default_val']).'"';
			}
			
			// pass data to JS for dynamic css in preview window
			
			if( isset($element['css']) )
			{
				//$item['get_opacity_from'] <= think about that
				$attr .= ' data-css="'.esc_attr( json_encode($element['css']) ).'"';
				$css_data_identifier .= ' st_css_data';

	            // if append is specified then pass on
	            if (isset($element['append'])) {
	                $attr .= ' data-css-append="'.esc_attr( $element['append'] ).'"';
	            }

				if (isset($element['extended_ids'])
			        && $element['extended_ids']
			        && ($element['type']=='margin' || $element['type']=='padding')) {
			    
			    	$css_data_identifier .= ' st_css_data_padding_margin';
					// $attr .= ' data-css-padding-margin="'.esc_attr( json_encode(array(
					// 	'mainId'=>$element['extended_ids']
					// )) ).'"';
			    }

			}

			//echo '<pre>'.print_r($element, TRUE).'</pre>';
			
			// Wrap all fields with data attributes. 
			// Also prevents JS from keep searching parents and mixing default values with other fields
			$output = "<div class='st_default_val $css_data_identifier' $attr>" . $output . '</div>';
							

			
			if ( isset( $element['blank_output'] ) )
				return $output;
			else if ( isset($element['bound'] ) && $element['bound'] == '0')
				return $label . $output;
			else {
				$id = ( isset($element['id'] ) && ! $no_id) ? "id='parent-{$element['id']}'" : '';
				if ( ! ( isset($element['wrap'] ) && $element['wrap'] == '0' ) ) {
					$output = self::bound_options( $output, $element );
				}
				$wrap_class = ( ! isset( $element['wrap_class'] ) ) ? 'control-group form-group clearfix' : $element['wrap_class'];
				$container_class   = isset( $element['container_class'] ) ? $element['container_class'] : '';
				$depend_class      = isset( $element['depend_class'] ) ? $element['depend_class'] : '';
				$depend_data       = isset( $element['depend_data'] ) ? $element['depend_data'] : '';
				$data_wrap_related = isset( $element['data_wrap_related'] ) ? "data-related-to='{$element['data_wrap_related']}'" : '';
				
				// yunus edit - added before & after field
				$before_field = isset( $element['before_field'] ) ? $element['before_field'] : '';
				$after_field = isset( $element['after_field'] ) ? $element['after_field'] : '';
					

				if(isset( $element['type'] ))
				{
					$short_tags_supported = array(
						'text_area',
						'text_field',
						//'tiny_mce', <= this is now done using tinymce
					);
					
					$short_tags = '';
					if(in_array($element['type'], $short_tags_supported))
					{
						if($element['id']!='param-el_title')
						{
							$short_tags .= self::short_tags_dropdown($element['id']);
						}
					}
					$output = '<div class="st_shorttags_wrapper">' . $short_tags . $output . '</div>';

					//echo '<pre>'.print_r($element, TRUE).'</pre>';
				}


				return "<div $id class='$wrap_class $container_class $depend_class' $depend_data $data_wrap_related $attr> $before_field $label $output $after_field </div>";
			}
		}

		/**
		 * Show/Hide label for a type element
		 * @param array $element
		 * @return type
		 */
		static function get_label( $element ) {
			// Generate HTML code for label
			$label = '';

			if ( ( ! isset( $element['showlabel'] ) || $element['showlabel'] != '0' ) && isset( $element['name'] ) ) {
				// Generate attributes for tooltip
				$tooltip = '';

				if ( isset( $element['tooltip'] ) ) {
					$tooltip = '<i class="icon-help st-tooltip-toggle" data-html="true" title = "' . $element['tooltip'] . '"></i>';
				}

				$label = "<label class='control-label st-label-left'><span >{$element['name']}</span>{$tooltip} {$short_tags}</label>";
			}

			return $label;
		}
		
		
		// ------------------------------------------------------
		//  yunus edit - new function
		// ------------------------------------------------------
		static public function short_tags_dropdown($id='')
		{
			$short_tags = apply_filters('st_available_short_tags', array());
			if(! is_array($short_tags) OR empty($short_tags)) return '';

			$out = '<div class="st_short_tags"><div class="st_short_tags_btn">View supported short tags</div>
			<ul class="st_short_tags_list">';
			foreach($short_tags as $key)
			{
				$out .= '<li>{'.$key.'}</li>';
			}
			$out .= '</ul></div>';
			
			return $out;
		}
			
			
		/**
		* Creates html element from array
		*
		* @author Yunus J
		* @since 0.0.1
		* @version 0.0.1
		*/
		static function html_tag($c)
		{
			if(! $c) return '';

			// merges defined with defaults. We use this so we dont have to use isset
			$c = wp_parse_args( $c, array(
					'tag'=>'', 
					'content'=>'', 
					'style'=>'', 
					'before'=>'', 
					'after'=>'',
					'before_content'=>'', 
					'after_content'=>'',
			));
					
			$content = $c['content'];
			$tag = $c['tag'];
			$before = $c['before'];
			$after = $c['after'];
			$before_content = $c['before_content'];
			$after_content = $c['after_content'];
			$atts = ' '.$c['attr']; // string attributes
			
			// unset so they are not treated as attributes
			unset($c['before']);
			unset($c['after']);
			unset($c['before_content']);
			unset($c['after_content']);
			unset($c['content']);
			unset($c['tag']);
			unset($c['attr']);
			
			// if any content is array then we make it into child element by recrussion
			if(is_array($content))
			{
				$content = self::html_tag($content);
			}
			
			// if style is array then we implode them to a string
			if(is_array($c['style']))
			{
				$c['style'] = implode(';', $c['style']);
			}
			
			// all remaining items in array are converted to attributes string
			if(! empty($c)) foreach($c as $key=>$val)
			{
				if($val == '') continue;
				
				// if values are array then convert them to spaced string
				if(is_array($val))
				{
					$glue = ' ';
					// for styles, seperator should be ";"
					if($key=='style') $glue = ';';
					
					$val = implode($glue, $val);
				}
				
				$atts .= ' '.$key.'="'.$val.'"';
			}
			
			// create final markup
			$output = $before.'<'.$tag.''.$atts.'>'.$before_content."\n".$content."\n".$after_content.'</'.$tag.'>'.$after."";
			return $output;
		}

		

	}// end class
} // end if ! class_exists