<?php

class ST_Pb_Helper_Html_Border_radius extends ST_Pb_Helper_Html {
	/**
	 * Option to Define top/right/bottom/left margin for element
	 * @param type $element
	 * @param type $input_params
	 * @return type
	 */
	static function render( $element, $input_params ) {
		$element = parent::get_extra_info( $element );
		$label = parent::get_label( $element );
		$_no_prefix_id = str_replace( 'param-', '', $element['id'] );
		// Set default margin element
		// t: top
		// r: right
		// b: bottom
		// l: left
		$element['border_elements'] = isset( $element['border_elements'] ) ? explode( ',', str_replace( ' ', '', ($element['border_elements']) ) ) : array( 'tl', 'br', 'bl', 'tr' );

		$output = '';
		$_br    = false;
		if ( in_array( 'tl', $element['border_elements'] ) ) {
			$_idx_topleft = $_no_prefix_id . '_topleft';
			$_br = true;
			$element['top_std'] = isset( $element[$_idx_topleft] ) ? $element[$_idx_topleft]['std'] : '';
			$element['default_top_std'] = $element['top_std'];
			$element['top_std'] = isset( $input_params[$_idx_topleft] ) ? $input_params[$_idx_topleft] : $element['top_std'];
			$_topleft = array(
				'id' => $element['id'] . '_topleft',
				'type' => 'text_append',
				'type_input' => 'number',
				'class' => 'jsn-input-number input-mini',
				'parent_class' => 'input-group-inline',
				'std' => $element['top_std'],
				'default_val' => $element['default_top_std'],
				//'append_before' => '<i class="icon-arrow-up"></i>',
				'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Top', ST_PBL ) . '</i>',
				'append' => 'px',
				'validate' => 'number',
				'bound' => '0',
			);
			$output .= ST_Pb_Helper_Shortcode::render_parameter( 'text_append', $_topleft );
		}
		
		if ( in_array( 'tr', $element['border_elements'] ) ) {
			$_idx_topright = $_no_prefix_id . '_topright';
			$element['left_std'] = isset( $element[$_idx_topright] ) ? $element[$_idx_topright]['std'] : '';
			$element['default_left_std'] = $element['left_std'];
			$element['left_std'] = isset( $input_params[$_idx_topright] ) ? $input_params[$_idx_topright] : $element['left_std'];
			$_topright = array(
				'id' => $element['id'] . '_topright',
				'type_input' => 'number',
				'class' => 'jsn-input-number input-mini',
				'parent_class' => 'input-group-inline',
				'std' => $element['left_std'],
				'default_val' => $element['default_left_std'],
				//'append_before' => '<i class="icon-arrow-left"></i>',
				'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Left', ST_PBL ) . '</i>',
				'append' => 'px',
				'validate' => 'number',
				'bound' => '0',
			);
			$output .= ST_Pb_Helper_Shortcode::render_parameter( 'text_append', $_topright );
		}

		$output .= $_br ? '<div class="clearbreak"></div>' : '';

		if ( in_array( 'bl', $element['border_elements'] ) ) {
			$_idx_bottomleft = $_no_prefix_id . '_bottomleft';
			$element['bottom_std'] = isset( $element[$_idx_bottomleft] ) ? $element[$_idx_bottomleft]['std'] : '';
			$element['default_bottom_std'] = $element['bottom_std'];
			$element['bottom_std'] = isset( $input_params[$_idx_bottomleft] ) ? $input_params[$_idx_bottomleft] : $element['bottom_std'];
			$_bottomleft = array(
				'id' => $element['id'] . '_bottomleft',
				'type_input' => 'number',
				'class' => 'jsn-input-number input-mini',
				'parent_class' => 'input-group-inline',
				'std' => $element['bottom_std'],
				'default_val' => $element['default_bottom_std'],
				//'append_before' => '<i class="icon-arrow-down"></i>',
				'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Bottom', ST_PBL ) . '</i>',
				'append' => 'px',
				'validate' => 'number',
				'bound' => '0',
			);
			$output .= ST_Pb_Helper_Shortcode::render_parameter( 'text_append', $_bottomleft );
		}
		
		if ( in_array( 'br', $element['border_elements'] ) ) {
			$_idx_bottomright = $_no_prefix_id . '_bottomright';
			$_br = true;
			$element['right_std'] = isset( $element[$_idx_bottomright] ) ? $element[$_idx_bottomright]['std'] : '';
			$element['default_right_std'] = $element['right_std'];
			$element['right_std'] = isset( $input_params[$_idx_bottomright] ) ? $input_params[$_idx_bottomright] : $element['right_std'];
			$_bottomright = array(
				'id' => $element['id'] . '_bottomright',
				'type_input' => 'number',
				'class' => 'jsn-input-number input-mini',
				'parent_class' => 'input-group-inline',
				'std' => $element['right_std'],
				'default_val' => $element['default_right_std'],
				//'append_before' => '<i class="icon-arrow-right"></i>',
				'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Right', ST_PBL ) . '</i>',
				'append' => 'px',
				'validate' => 'number',
				'bound' => '0',
			);
			$output .= ST_Pb_Helper_Shortcode::render_parameter( 'text_append', $_bottomright );
		}

		return parent::final_element( $element, $output, $label );
	}
}