<?php

/*
class ST_Pb_Helper_Html_Color_Picker extends ST_Pb_Helper_Html {

	static function render( $element ) {
		$element  = parent::get_extra_info( $element );
		$label    = parent::get_label( $element );
		$bg_color = ( $element['std'] ) ? $element['std'] : '#000';
		$_hidden  = ( isset( $element['hide_value'] ) && $element['hide_value'] == false ) ? 'type="text"' : 'type="hidden"';
		$output   = '<input ' . $_hidden . " size='10' id='{$element['id']}' class='input-mini' disabled='disabled' name='{$element['id']}' value='{$element['std']}'  DATA_INFO />";
		$output  .= "<div id='color-picker-{$element['id']}' class='color-selector'><div style='background-color: {$bg_color}'></div></div>";

		add_filter( 'st-edit-element-required-assets', array( __CLASS__, 'enqueue_assets_modal' ), 9 );

		return parent::final_element( $element, $output, $label );
	}

	static function enqueue_assets_modal( $scripts ){
		$scripts = array_merge( $scripts, array( 'st-pb-colorpicker-js', 'st-pb-colorpicker-css', ) );

		return $scripts;
	}
}
*/


class ST_Pb_Helper_Html_Color_Picker extends ST_Pb_Helper_Html {

	static function render( $element ) {
		$element  = parent::get_extra_info( $element );
		$label    = parent::get_label( $element );
		$bg_color = ( $element['std'] ) ? $element['std'] : '#000';
		$_hidden  = ( isset( $element['hide_value'] ) && $element['hide_value'] == false ) ? 'type="text"' : 'type="hidden"';

		$class = 'ST_wr_colorpicker';
		if(isset( $element['in_popover'] ) && $element['in_popover']) $class .= ' ST_wr_colorpicker_in_popover';

		$output = '<input class="'.$class.'" type="text" id="'.$element['id'].'" name="'.$element['id'].'" value="'.$element['std'].'" DATA_INFO />';

		// if(! is_numeric($element['std']) && empty($element['std'])) 
		// 	$output .= '<div class="">Default</div>';

		add_filter( 'st-edit-element-required-assets', array( __CLASS__, 'enqueue_assets_modal' ), 9 );

		return parent::final_element( $element, $output, $label );
	}


	static function enqueue_assets_modal( $scripts ){
		$scripts = array_merge( $scripts, array( 'st-pb-colorpicker-js', 'wp-color-picker-js', 'wp-color-picker-css', ) );

		return $scripts;
	}
}