<?php

class ST_Pb_Helper_Html_Icons extends ST_Pb_Helper_Html {
	/**
	 * Icons
	 * @param type $element
	 * @return string
	 */
	static function render( $element ) {
		$element = parent::get_extra_info( $element );
		$label   = parent::get_label( $element );
		$output  = "<div id='icon_selector' class='icon_selector'>
			<input type='hidden' value='{$element['std']}' id='{$element['id']}' name='{$element['id']}'  DATA_INFO />
		</div>";

		add_filter( 'st-edit-element-required-assets', array( __CLASS__, 'enqueue_assets_modal' ), 0 );

		return parent::final_element( $element, $output, $label );
	}

	/**
	 * Enqueue icon selector assets
	 *
	 * @param array $scripts
	 * @return array
	 */
	static function enqueue_assets_modal( $scripts ){
		$scripts = array_merge( $scripts, array( 'st-pb-joomlashine-iconselector-js', ) );

		return $scripts;
	}
}