<?php

class ST_Pb_Helper_Html_Preview extends ST_Pb_Helper_Html {
	/**
	 * Preview Box of shortcode
	 * @return type
	 */
	static function render() {
		
		$default = 'white';
		$frame_bg = 'transparent';
		

		$colors = array(
			'transparent'=>'transparent url('.ST_PB_URI.'stencilor/assets/admin/images/checkerboard.png) repeat top left',
			'white'=>'#fff',
			'black'=>'#000',
		);
		
		global $cbt_options;
		if($cbt_options)
		{
			if(isset($cbt_options['dark-mode']) && $cbt_options['dark-mode']=='1')
			{
				$default = 'black';
			}
			elseif(isset($cbt_options['content-bg']) && $cbt_options['content-bg'] && $cbt_options['content-bg']!='#fff' && $cbt_options['content-bg']!='#ffffff')
			{
				$default = 'site-bg';
				$colors['site-bg'] = $cbt_options['content-bg'];
			}
		}
		
		$selector = '';
		foreach($colors as $color_name=>$color)
		{
			$class = '';
			if($color_name==$default) 
			{
				$frame_bg = $color;
				$class = 'cbb-active-preview-bg';
			}
			$selector .= '<li class="cbb-btn-preview-bg-'.$color_name.' '.$class.'" style="background: '.$color.';"></li>';
		}
	
		return "<div class='st-preview-resize'><div id='preview_container' class='st-preview-container'>
			<div class='st-preview-title-actions cbb-preview-bg-colors'>
				<h3>" . __( 'Preview background', ST_PBL ) . "</h3>
				<ul>
					{$selector}
				</ul>
			</div>
			<div class='st-preview-title-actions st-preview-responsive-size'>
				<h3>" . __( '', ST_PBL ) . "</h3>
				<ul>
					<li data-size='mobile'><i class='fa fa-mobile'></i></li>
					<li class='st-active-item' data-size='desktop'><i class='fa fa-desktop'></i></li>
				</ul>
			</div>
		<div class='cbb-preview-loading'></div>
		<iframe style='background: {$frame_bg};' id='shortcode_preview_iframe' name='shortcode_preview_iframe' class='shortcode_preview_iframe'></iframe>
		</div></div>";
	}
}