<?php

class ST_Pb_Helper_Html_Radio_Button_Group extends ST_Pb_Helper_Html {
	/**
	 * Radio Button group
	 * @param type $element
	 * @return string
	 */
	static function render( $element ) {
		$element = parent::get_extra_info( $element );
		$label   = parent::get_label( $element );

		$group_class = (isset($element['group_class'])) ? $element['group_class'] : 'btn-group st-btn-group';
		$btn_class = (isset($element['btn_class'])) ? $element['btn_class'] : 'btn btn-default';

		$output = "<div class='{$group_class}' data-toggle='buttons'>";
		foreach ( $element['options'] as $key => $text ) {
			$active  = ( $key == $element['std'] ) ? 'active' : '';
			$checked = ( $key == $element['std'] ) ? 'checked' : '';
			$output .= "<label class='{$btn_class} {$active}'>";
			$output .= "<input type='radio' name='{$element['id']}' $checked id='{$element['id']}' value='$key'/>";
			$output .= $text;
			$output .= "</label>";
		}
		$output .= '</div>';

		return parent::final_element( $element, $output, $label );
	}
}