<?php

class ST_Pb_Helper_Html_Select_Media extends ST_Pb_Helper_Html {
	/**
	 * Input field to select Media
	 * @param type $element
	 * @return type
	 */
	static function render($element) {
		$element = parent::get_extra_info($element);
		$label = parent::get_label($element);
		$_filter_type = isset($element['filter_type']) ? $element['filter_type'] : 'image';
		$placeholder = isset($element['placeholder']) ? "placeholder='{$element['placeholder']}'" : '';

		$preview = '';

		switch ($_filter_type) {
		case 'video':
			$button = '<i class="fa fa-video-camera" aria-hidden="true"></i> Select video';
			break;

		case 'audio':
			$button = '<i class="fa fa-volume-up" aria-hidden="true"></i> Select audio';
			break;

		case 'image':
			$button = '<i class="fa fa-picture-o" aria-hidden="true"></i> Select image';

			if ($element['std']) {
				$preview = '<img src="' . $element['std'] . '" alt="' . basename($element['std']) . '" />';
			}

			break;

		default:
			$button = '<i class="fa fa-plus" aria-hidden="true"></i> Select';
			break;
		}

		$output = '<span class="st_select_media_preview">' . $preview . '</span>';
		$output .= '<div class="input-append row-fluid input-group">
							<input type="text" class="' . $element['class'] . '" value="' . $element['std'] . '" id="' . $element['id'] . '" ' . $placeholder . '>
							<span class="input-group-addon select-media btn btn-default" filter_type="' . $_filter_type . '" id="' . $element['id'] . '_button">' . $button . '</span>
							<span class="input-group-addon select-media-remove btn btn-default"><i class="icon-remove"></i></span>
						</div>';
		return parent::final_element($element, $output, $label);
	}
}