<?php


if ( ! class_exists( 'ST_Pb_Helper_Premade' ) ) {

	class ST_Pb_Helper_Premade {

		function button($id, $data, $btn_id='')
		{
			$vars_with_no_button = array(
				'button_single_item',
				'button_open_in',
				'button_link_type',
				'button_icon',
				
				'button_lb_width',
				'button_lb_height',
				'button_lb_width_unit',
				'button_lb_height_unit',
				'button_style',
			);
			
			$arr_params = array();
			foreach($data as $key=>$val)
			{
				$key = str_replace($id.'', 'button', $key);
				if(in_array($key, $vars_with_no_button))
					$key = str_replace('button_', '', $key);
				
				$arr_params[$key] = $val;
			}
			
			//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';
			
			extract( $arr_params );

			
			$button_text  = ( ! $button_text ) ? '' : $button_text;
			$button_size  = ( ! $button_size || strtolower( $button_size ) == 'default' ) ? '' : $button_size;
			$button_color = ( ! $button_color || strtolower( $button_color ) == 'default' ) ? '' : $button_color;
			$button_icon  = ( ! $icon ) ? '' : "<i class='{$icon}'></i> ";
			$tag          = 'a';
			$href         = '';
			$single_item  = explode( '__#__', $single_item );
			$single_item  = $single_item[0];
			
			
			if(isset($lb_width_unit) && $lb_width_unit=='px') $lb_width_unit = '';
			if(isset($lb_height_unit) && $lb_height_unit=='px') $lb_height_unit = '';
					
			$lightbox_w = (isset($lb_width) && $lb_width) ? $lb_width.$lb_width_unit : '100%';
			$lightbox_h = (isset($lb_height) && $lb_height) ? $lb_height.$lb_height_unit : '100%';
		
			
			if ( ! empty( $link_type ) ) {
				$taxonomies = ST_Pb_Helper_Type::get_public_taxonomies();
				$post_types = ST_Pb_Helper_Type::get_post_types();
				// single post
				if ( array_key_exists( $link_type, $post_types ) ) {
					$permalink      = get_permalink($single_item);
					
					if($open_in == 'lightbox') $permalink .= '?iframe=true&width='.$lightbox_w.'&height='.$lightbox_h;
					
					$href      = ( ! $single_item ) ? ' href="#"' : " href='{$permalink}'";
				}
				// taxonomy
				else if ( array_key_exists( $link_type, $taxonomies ) ) {
					$permalink = get_term_link( intval( $single_item ), $link_type );
					if ( ! is_wp_error( $permalink ) )
					{
						if($open_in == 'lightbox') $permalink .= '?iframe=true&width='.$lightbox_w.'&height='.$lightbox_h;
						
						$href = ( ! $single_item ) ? ' href="#"' : " href='{$permalink}'";
					}
				}
				else {
					switch ( $link_type ) {
						case 'no_link':
							$tag = 'button';
							break;
						case 'url':
						
							if($open_in == 'lightbox') $button_type_url .= '?iframe=true&width='.$lightbox_w.'&height='.$lightbox_h;
						
							$href = ( ! $button_type_url ) ? ' href="#"' : " href='{$button_type_url}'";
							break;
					}
				}
			}
			$target = '';
			if ( $open_in ) {
				switch ( $open_in ) {
					case 'current_browser':
						$target = '';
						break;
					case 'new_browser':
						$target = ' target="_blank"';
						break;
					case 'new_window':
						$cls_button_fancy = 'st-button-new-window';
						$script = ST_Pb_Helper_Functions::new_window( ".$cls_button_fancy", array( 'width' => '75%', 'height' => '75%' ) );
						break;
					case 'lightbox':
						$cls_button_fancy = 'prettyphoto';
						break;
				}
			}
			$button_type      = ( $tag == 'button' ) ? " type='button'" : '';
			$cls_button_fancy = ( ! isset( $cls_button_fancy ) ) ? '' : $cls_button_fancy;
			$script           = ( ! isset( $script ) ) ? '' : $script;
	
			$cls_alignment = $custom_style = '';
			if ( strtolower( $arr_params['button_alignment'] ) != 'inherit' ) {
				if ( strtolower( $arr_params['button_alignment'] ) == 'left' )
					$cls_alignment = 'pull-left';
				if ( strtolower( $arr_params['button_alignment'] ) == 'right' )
					$cls_alignment = 'pull-right';
				if ( strtolower( $arr_params['button_alignment'] ) == 'center' )
					$custom_style = ';text-align:center;';
			}
	
			if ( isset( $arr_params['button_margin_top'] ) )
				$arr_params['div_margin_top'] = $arr_params['button_margin_top'];
			if ( isset( $arr_params['button_margin_left'] ) )
				$arr_params['div_margin_left'] = $arr_params['button_margin_left'];
			if ( isset( $arr_params['button_margin_right'] ) )
				$arr_params['div_margin_right'] = $arr_params['button_margin_right'];
			if ( isset( $arr_params['button_margin_bottom'] ) )
				$arr_params['div_margin_bottom'] = $arr_params['button_margin_bottom'];
				
			if($button_icon && $button_text) $cls_alignment .= ' btn-icon-text';
			if(isset($style) && $style) $cls_alignment .= ' btn-style-'.$style;
			
			if($btn_id) $btn_id = 'id="'.$btn_id.'"';

			$html_element      = $script . "<{$tag} {$btn_id} class='cbb-button btn {$cls_alignment} {$button_size} {$button_color} {$cls_button_fancy}'{$href}{$target}{$button_type}>{$button_icon}{$button_text}</{$tag}>";
			
			if(strtolower( $arr_params['button_alignment'] ) == 'center')
			{
				$html_element = '<div class="text-center">'.$html_element.'</div>';
			}
			
			return $html_element;
		}
		
		
		function icon($id, $data)
		{
			$vars = array(
				$id.'_type',
				$id.'_icon',
				$id.'_image',
				$id.'_image_width',
				$id.'_image_height',
				$id.'_size',
				$id.'_color',
				$id.'_style',
				$id.'_bg',
			);


			
			$arr_params = array();
			foreach($data as $key=>$val)
			{
				if(! in_array($key, $vars)) continue; // proceed only for icon var
				
				$key = str_replace($id.'_', '', $key);
				
				$arr_params[$key] = $val;
			}
			
			//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';
			
			extract( $arr_params );
			
			if(! $icon && (!isset($image) OR ! $image)) return;
			
			$wrap_style = $i_styles = '';
			
			if($size) $wrap_style .= 'font-size:'.$size.'px;';
			if($color) $wrap_style .= 'color:'.$color.';';
			
			if($style == 'circle' OR $style == 'square') 
			{
				$padding_sides = $size / 2.666;
				$padding_top =  ($padding_sides * 1.25) + 2;
				$padding_bottom = ($padding_sides * 2) - $padding_top;
				
				if($bg) $wrap_style .= 'background-color: '.$bg.';';
				$wrap_style .= 'padding: '.$padding_top.'px '.$padding_sides.'px '.$padding_bottom.'px;';
				$i_styles .= 'width: '.($size * 1.3).'px; height: '.($size * 1.3).'px;';
			}
			
			$item = '';
			
			if(isset($type) && $type == 'image')
			{
				$img_style = '';
				
				if(isset($image_width) && is_numeric($image_width))
				{
					$img_style .= 'width: 100%;';
					$wrap_style .= 'width: '.$image_width.'px;';
				}
				
				if(isset($image_height) && is_numeric($image_height))
				{
					$img_style .= 'height: '.$image_height.'px;';
					$wrap_style .= 'height: '.$image_height.'px;';
				}
				
				if($image) $item = '<img src="'.$image.'" alt="image" style="'.$img_style.'max-width: 100%;" />';
			}
			else
			{
				$item = '<i style="'.$i_styles.'" class="'.$icon.'"></i>';
			}

			$output = '<div style="'.$wrap_style.'" class="cbb-icon cbb-icon-style-'.$style.'">'.$item.'</div>';
			
			return $output;
		}

	}

}