<?php



/**
 * @todo : Defines values of setting options
 */

if ( ! class_exists( 'ST_Pb_Helper_Type' ) ) {

	class ST_Pb_Helper_Type {

		/**
		 * Use by fields to delay the execution of functions
		 * required by the field type html
		 * @param  array $data containing callback and args arguments
		 * @return array       unchanged data
		 */
		public static function field_data_source($data)
		{
			return $data;
		}

		/**
		 * Runs field params, exchanging data source
		 * where available with actual data from callback
		 * @param  array $field_params field params
		 * @return array               field params with real data
		 */
		public static function apply_field_data_source($field_params)
		{
			if(empty($field_params) OR ! is_array($field_params))
			{
				return $field_params;
			}

			foreach ($field_params as $key => $value) {
				if(is_array($value) 
					&& isset($value['callback']) )
				{
					$field_params[ $key ] = ST_Pb_Helper_Type::apply_function($value);
				}
			}

			return $field_params;
		}

		/**
		 * Apply a function with given params
		 * @param  array $value containing callback and args
		 * @return mixed        return from function
		 */
		public static function apply_function($value)
		{
			return call_user_func_array( $value['callback'], $value['args'] );
		}


		/**
		 ** Google map type options
		 *
		 * @return array
		 */
		static function get_gmap_type() {
			return array(
				'HYBRID'    => __( 'Hybrid', ST_PBL ),
				'ROADMAP'   => __( 'Roadmap', ST_PBL ),
				'SATELLIGE' => __( 'Satellite', ST_PBL ),
				'TERRAIN'   => __( 'Terrain', ST_PBL ),
			);
		}

		/**
		 ** Zoom level options for google element
		 *
		 * @return array
		 */
		static function get_zoom_level() {
			return array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
				'7' => '7',
				'8' => '8',
				'9' => '9',
				'10' => '10',
				'11' => '11',
				'12' => '12',
				'13' => '13',
				'14' => '14',
			);
		}

		/**
		 * Container style options
		 *
		 * @return array
		 */
		static function get_container_style() {
			return array(
				'no-styling'    => __( 'No Styling', ST_PBL ),
				'img-rounded'   => __( 'Rounded', ST_PBL ),
				'img-circle'    => __( 'Circle', ST_PBL ),
				'img-thumbnail' => __( 'Thumbnail', ST_PBL )
			);
		}

		/**
		 ** Zoom level options for QRCode element
		 *
		 * @return array
		 */
		static function get_qr_container_style() {
			return array(
				'no-styling'    => __( 'No Styling', ST_PBL ),
				'img-thumbnail' => __( 'Thumbnail', ST_PBL )
			);
		}

		/**
		 * * Table design options
		 *
		 * @return array
		 */
		static function get_table_row_color() {
			return array(
				'default' => __( 'Default', ST_PBL ),
				'active'  => __( 'Active (Grey)', ST_PBL ),
				'success' => __( 'Success (Green)', ST_PBL ),
				'warning' => __( 'Warning (Orange)', ST_PBL ),
				'danger'  => __( 'Danger (Red)', ST_PBL ),
			);
		}

		/**
		 ** alert type options
		 *
		 * @return array
		 */
		static function get_alert_type() {
			return array(
				'alert-warning' => __( 'Warning', ST_PBL ),
				'alert-success' => __( 'Success', ST_PBL ),
				'alert-info'    => __( 'Info', ST_PBL ),
				'alert-danger'  => __( 'Danger', ST_PBL ),
			);
		}

		/**
		 ** progress bar color options
		 *
		 * @return array
		 */
		static function get_progress_bar_color() {
			return array(
				'progress-bar-primary' => __( 'Primary (theme default color)', ST_PBL ),
				'progress-bar-info'    => __( 'Light Blue', ST_PBL ),
				'progress-bar-success' => __( 'Green', ST_PBL ),
				'progress-bar-warning' => __( 'Orange', ST_PBL ),
				'progress-bar-danger'  => __( 'Red', ST_PBL ),
			);
		}

		/**
		 ** progress bar style options
		 *
		 * @return array
		 */
		static function get_progress_bar_style() {
			return array(
				'multiple-bars' => __( 'Multiple bars', ST_PBL ),
				'multiple-bars-within-bars' => __( 'Multiple bars (Info within bars)', ST_PBL ), // YUNUS EDIT
				'stacked' 		=> __( 'Stacked', ST_PBL ),
			);
		}

		/**
		 ** progress bar item options
		 *
		 * @return array
		 */
		static function get_progress_bar_item_style() {
			return array(
				'solid'   => __( 'Solid', ST_PBL ),
				'striped' => __( 'Striped', ST_PBL ),
			);
		}

		/**
		 * Static function to get button color Options
		 *
		 * @return array
		 */
		 // ------------------------------------------------------
		 //  yunus edit - color names changed
		 // ------------------------------------------------------
		static function get_button_color() {
			return array(
				'btn-default' => __( 'Default (Theme)', ST_PBL ),
				'btn-primary' => __( 'Primary (Theme)', ST_PBL ),
				'btn-secondry'    => __( 'Secondry (Theme)', ST_PBL ),
				'btn-blue' => __( 'Blue', ST_PBL ),
				'btn-success' => __( 'Green', ST_PBL ),
				'btn-warning' => __( 'Orange', ST_PBL ),
				'btn-danger'  => __( 'Red', ST_PBL ),
				'btn-link'    => __( 'Link (No color)', ST_PBL )
			);
		}

		/**
		 * Button size options
		 *
		 * @return array
		 */
		static function get_button_size() {
			return array(
				'default' => __( 'Default', ST_PBL ),
				'btn-xs'  => __( 'Mini', ST_PBL ),
				'btn-sm'  => __( 'Small', ST_PBL ),
				'btn-lg'  => __( 'Large', ST_PBL ),
				//'custom'  => __( 'Custom', ST_PBL ), // yunue edit - removed as not needed
			);
		}

		/**
		 * "Open in" option for anchor
		 *
		 * @return array
		 */
		static function get_open_in_options() {
			return array(
				'current_browser' => __( 'Current Tab', ST_PBL ),
				'new_browser' 	  => __( 'New Tab', ST_PBL ),
				'new_window' 	  => __( 'New Window', ST_PBL ),
				'lightbox' 		  => __( 'Lightbox', ST_PBL ),
			);
		}

		/**
		 * Icon position for List shortcode
		 *
		 * @return array
		 */
		static function get_icon_position() {
			return array(
				'left'    => __( 'Left', ST_PBL ),
				'right'   => __( 'Right', ST_PBL ),
				'center'   => __( 'Center', ST_PBL ),
			);
		}

		/**
		 * Position options
		 *
		 * @return array
		 */
		static function get_full_positions() {
			return array(
				'top'    => __( 'Top', ST_PBL ),
				'bottom' => __( 'Bottom', ST_PBL ),
				'left'   => __( 'Left', ST_PBL ),
				'right'  => __( 'Right', ST_PBL ),
			);
		}

		/**
		 * Icon size options
		 *
		 * @return array
		 */
		static function get_icon_sizes() {
			return array(
				'16' => '16',
				'24' => '24',
				'32' => '32',
				'48' => '48',
				'64' => '64',
			);
		}

		/**
		 * Icon style for List shortcode
		 *
		 * @return array
		 */
		static function get_icon_background() {
			return array(
				'circle' => __( 'Circle', ST_PBL ),
				'square' => __( 'Square', ST_PBL )
			);
		}

		/**
		 * Font options
		 *
		 * @return array
		 */
		static function get_fonts() {
			return array(
				'standard fonts' => __( 'Standard fonts', ST_PBL ),
				'google fonts'   => __( 'Google fonts', ST_PBL )
			);
		}

		/**
		 * Standard align options
		 *
		 * @return array
		 */
		static function get_standard_align() {
			return array(
				'' => __( 'Default', ST_PBL ),
				'left'    => __( '<i class="st-icon-align-left" title="Left"></i>', ST_PBL ),
				'center'  => __( '<i class="st-icon-align-center" title="Center"></i>', ST_PBL ),
				'right'   => __( '<i class="st-icon-align-right" title="Right"></i>', ST_PBL )
			);
		}

		/**
		 * Text align options
		 *
		 * @return array
		 */
		static function get_text_align() {
			return array(
				'inherit' => __( 'Default', ST_PBL ),
				'left'    => __( '<i class="st-icon-align-left" title="Left"></i>', ST_PBL ),
				'center'  => __( '<i class="st-icon-align-center" title="Center"></i>', ST_PBL ),
				'right'   => __( '<i class="st-icon-align-right" title="Right"></i>', ST_PBL )
			);
		}

		/**
		 * Google map align options
		 *
		 * @return array
		 */
		static function get_map_align() {
			return array(
				'no'      => __( 'No Alignment', ST_PBL ),
				'left'    => __( '<i class="st-icon-align-left" title="Left"></i>', ST_PBL ),
				'center'  => __( '<i class="st-icon-align-center" title="Center"></i>', ST_PBL ),
				'right'   => __( '<i class="st-icon-align-right" title="Right"></i>', ST_PBL )
			);
		}

		/**
		 * Font size options
		 *
		 * @return array
		 */
		static function get_font_size_types() {
			return array(
				'px'   => 'px',
				'em'   => 'em',
				'inch' => 'inch',
			);
		}

		/**
		 * Border style options
		 *
		 * @return array
		 */
		static function get_border_styles() {
			return array(
				''  => __( 'Default', ST_PBL ),
				'solid'  => __( 'Solid', ST_PBL ),
				'dotted' => __( 'Dotted', ST_PBL ),
				'dashed' => __( 'Dashed', ST_PBL ),
				'double' => __( 'Double', ST_PBL ),
				'groove' => __( 'Groove', ST_PBL ),
				'ridge'  => __( 'Ridge', ST_PBL ),
				'inset'  => __( 'Inset', ST_PBL ),
				'outset' => __( 'Outset', ST_PBL )
			);
		}

		/**
		 * Font style options
		 *
		 * @return array
		 */
		static function get_font_styles($bold_italic=false) {
			$output = array(
				'inherit' => __( 'Default', ST_PBL ),
				'italic'  => __( 'Italic', ST_PBL ),
				'normal'  => __( 'Normal', ST_PBL ),
				'bold'    => __( 'Bold', ST_PBL )
			);

			if($bold_italic)
			{
				$output['bold-italic'] = __( 'Bold Italic', ST_PBL );
			}

			return $output;
		}

		/**
		 * Dummy content
		 *
		 * @return array
		 */
		static function lorem_text( $word_count = 50 ) {
			return ucfirst( ST_Pb_Utils_Common::lorem_text( $word_count ) );
		}

		/**
		 * Dummy person name
		 *
		 * @return array
		 */
		static function lorem_name() {
			$usernames = array( 'Jane Poe', 'Robert Roe', 'Mark Moe', 'Brett Boe', 'Carla Coe', 'Donna Doe', 'Juan Doe', 'Frank Foe', 'Grace Goe', 'Harry Hoe', 'Jackie Joe', 'Karren Koe', 'Larry Loe', 'Marta Moe', 'Norma Noe', 'Paula Poe', 'Quintin Qoe', 'Ralph Roe', 'Sammy Soe', 'Tommy Toe', 'Vince Voe', 'William Woe', 'Xerxes Xoe', 'Yvonne Yoe', 'Zachary Zoe', 'John Smith', 'Udin Sedunia', 'Mubarok Bau' );
			$index     = rand( 0, 27 );
			return $usernames[$index];
		}

		/**
		 * Get 1st option of array
		 *
		 * @param array $arr
		 * @return array
		 */
		static function get_first_option( $arr ) {
			foreach ( $arr as $key => $value ) {
				if ( ! is_array( $key ) )
				return $key;
			}
		}

		// ------------------------------------------------------
		//  yunus edit - added get x option function
		// ------------------------------------------------------
		/**
		 * Get 2nd option of array
		 *
		 * @param array $arr
		 * @return array
		 */
		static function get_x_option( $arr, $number ) {
			$i = 0;
			foreach ( $arr as $key => $value )
			{
				$i++;
				if($i<$number) continue;

				if ( ! is_array( $key ) )
					return $key;
			}
		}

		/**
		 * Method to get appearing animations
		 * @param $id DOM Id of genereted select box
		 * @return array Structure of Animations select box
		 */
		static function get_apprearing_animations( $id = 'appearing_animation' )
		{
			return array(
					'name'    => __( 'Appearing Animation', ST_PBL ),
					'id'      => $id,
					'type'    => 'select',
					'class'   => 'input-sm',
					'options' => array(
									'0'    => __( 'None', ST_PBL ),
									'slide_from_top'    => __( 'Slide in from Top', ST_PBL ),
									'slide_from_right'  => __( 'Slide in from Right', ST_PBL ),
									'slide_from_bottom' => __( 'Slide in from Bottom', ST_PBL ),
									'slide_from_left'   => __( 'Slide in from Left', ST_PBL ),
									'fade_in'   => __( 'Fade in', ST_PBL ),
								),
					'std'     => '0',
					'has_depend' => '1',
				);
		}

		/**
		 * Method to get Aminmation speeds list
		 * @param $id DOM ID of genereted select box
		 * @param $animations_select_id DOM ID of Animations select box
		 * @return array Structure of Speeds select box
		 */
		static function get_animation_speeds( $id = 'appearing_animation_speed', $animations_select_id = 'appearing_animation' )
		{
			return array(
					'name'    => __( 'Appearing Animation Speed', ST_PBL ),
					'id'      => $id,
					'dependency'      => array( $animations_select_id, '!=', '0' ),
					'type'    => 'select',
					'class'   => 'input-sm',
					'std'     => 'Medium',
					'options' => array( 'Slow' =>  __( 'Slow', ST_PBL ),
										'Medium' =>  __( 'Medium', ST_PBL ) ,
										'Fast' =>  __( 'Fast', ST_PBL ),
									),

				);

		}
		/**
		 * Static function to get category options
		 *
		 * @param bool $has_root
		 *
		 * @return array
		 */
		static function get_categories( $has_root = false ) {
			$categories = get_categories();
			$arr_return = array();
			$return     = array();
			if ( $categories ) {
				if ( $has_root )
				$return[] = __( 'Root', ST_PBL );
				foreach ( $categories as $i => $category ) {
					$arr_return[] = array( 'id' => $category->term_id, 'parent' => $category->parent, 'title' => $category->name );
				}
				$level = 0;
				foreach ( $arr_return as $i => $item ) {
					if ( $item['parent'] == 0 ) {
						$id = $item['id'];
						unset( $arr_return[$i] );
						if ( ! isset( $item['title'] ) OR ! $item['title'] ) {
							$item['title'] = __( '( no title )', ST_PBL );
						}
						$return[$item['id']] = $item['title'];
						self::_recur_tree( $return, $arr_return, $id, $level );
					}
				}
			}
			return $return;
		}

		/**
		 * Posts list
		 *
		 * @global type $wpdb
		 * @return array
		 */
		static function get_posts() {
			global $wpdb;
			$numposts = $wpdb->get_var( "SELECT COUNT(* ) FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post'" );
			if ( 0 < $numposts )
			$numposts = number_format( $numposts );
			$posts = get_posts( array( 'posts_per_page' => $numposts ) );
			$arr_return = array();
			$return     = array();
			if ( $posts ) {
				foreach ( $posts as $i => $post ) {
					$arr_return[] = array( 'id' => $post->ID, 'parent' => $post->post_parent, 'title' => $post->post_title );
				}

				foreach ( $arr_return as $i => $item ) {
					$return[$item['id']] = ( strlen( $item['title'] ) > 30 ) ? substr( $item['title'], 0, strrpos( substr( $item['title'], 0, 30 ), ' ' ) ) . '...' : $item['title'];
				}
			}
			return $return;
		}

		/**
		 * Pages list
		 *
		 * @param type $has_root
		 * @return array
		 */
		static function get_pages( $has_root = false ) {
			$pages = get_pages();
			$arr_return = array();
			$return     = array();
			if ( $pages ) {
				if ( $has_root )
				$return[] = __( 'Root', ST_PBL );
				foreach ( $pages as $i => $page ) {
					$arr_return[] = array( 'id' => $page->ID, 'parent' => $page->post_parent, 'title' => $page->post_title );
				}

				$level = 0;
				foreach ( $arr_return as $i => $item ) {
					if ( $item['parent'] == 0 ) {
						$id = $item['id'];
						unset( $arr_return[$i] );
						$return[$item['id']] = $item['title'];
						self::_recur_tree( $return, $arr_return, $id, $level );
					}
				}
			}

			return $return;
		}

		/**
		 * listing tree type using recursive
		 *
		 * @param array $return
		 * @param array $arr_return
		 * @param int $id
		 * @param int $level
		 * @param string $type
		 * @param string $prefix
		 */
		private static function _recur_tree( &$return, $arr_return, $id, $level, $type = '0', $prefix = '' ) {
			if ( $type == '0' ) {
				$level++;
				foreach ( $arr_return as $i => $item ) {
					if ( $item['parent'] == $id ) {
						unset( $arr_return[$i] );
						if ( ! isset( $item['title'] ) OR ! $item['title'] ) {
							$item['title'] = __( '( no title )', ST_PBL );
						}
						$return[$item['id']] = str_repeat( '&#8212; ', $level ) . $item['title'];
						self::_recur_tree( $return, $arr_return, $item['id'], $level, $type );
					}
				}
			} else if ( $type == '1' ) {
				$level++;
				foreach ( $arr_return as $i => $item ) {
					if ( $item->parent == $id ) {
						unset( $arr_return[$i] );
						if ( ! $item->name ) {
							$item->name = __( '( no name )', ST_PBL );
						}
						$return[$item->term_id] = str_repeat( '&#8212; ', $level ) . $item->name;
						self::_recur_tree( $return, $arr_return, $item->term_id, $level, $type );
					}
				}
			} else if ( $type == '-1' ) {
				$level++;
				foreach ( $arr_return as $i => $item ) {
					if ( $item->post_parent == $id ) {
						unset( $arr_return[$i] );
						if ( ! $item->post_title ) {
							$item->post_title = __( '( no title )', ST_PBL );
						}
						$return[$item->ID] = str_repeat( '&#8212; ', $level ) . $item->post_title;
						self::_recur_tree( $return, $arr_return, $item->ID, $level, $type );
					}
				}
			} else if ( $type == '-2' ) {
				$level++;
				foreach ( $arr_return as $i => $item ) {
					if ( $item->menu_item_parent == $id ) {
						unset( $arr_return[$i] );
						if ( ! $item->title ) {
							$item->title = __( '( no title )', ST_PBL );
						}
						if ( $prefix ) {
							$return[$prefix][$item->ID] = str_repeat( '&#8212; ', $level ) . $item->title;
							self::_recur_tree( $return, $arr_return, $item->ID, $level, $type, $prefix );
						}
					}
				}
			}
			return;
		}

		/**
		 * link type options
		 *
		 * @return multitype:
		 */
		static function get_link_types() {
			$taxonomies = self::get_public_taxonomies();
			$post_types = self::get_post_types();
			$arr = array(
				'no_link' => __( 'No Action', ST_PBL ),
				'url' => __( 'Go to URL', ST_PBL ),
				'single_entry' => array( 'text' => __( 'Go to Single Entry', ST_PBL ), 'type' => 'optiongroup' ),
			);
			$arr = array_merge( $arr, $post_types );
			$arr = array_merge( $arr, array( 'taxonomy' => array( 'text' => __( 'Go to Taxonomy Overview Page', ST_PBL ), 'type' => 'optiongroup' ) ) );
			$arr = array_merge( $arr, $taxonomies );
			return $arr;
		}

		/**
		 * Get single entry list: Post, Page, Product...
		 *
		 * @return array
		 */
		static function get_single_entry() {
			$post_types = self::get_post_types();
			return $post_types;
		}

		/**
		 ** content source options
		 *
		 * @return array
		 */
		static function get_content_source() {
			$taxonomies = self::get_public_taxonomies();
			$post_types = self::get_post_types();
			$arr = array(
				'nav_menu_item' => __( 'Menu', ST_PBL ),
				'single_entry' => array( 'text' => __( 'Single Entries', ST_PBL ), 'type' => 'optiongroup' ),
			);
			$arr = array_merge( $arr, $post_types );
			$arr = array_merge( $arr, array( 'taxonomy' => array( 'text' => __( 'Taxonomy Overview Page', ST_PBL ), 'type' => 'optiongroup' ) ) );
			$arr = array_merge( $arr, $taxonomies );
			return $arr;
		}

		/**
		 ** image link type options
		 *
		 * @return array
		 */
		static function get_image_link_types() {
			$imageLinkType = array();
			$linkTypes = self::get_link_types();
			$imageLinkType = array_slice( $linkTypes, 0, 1 );
			$imageLinkType['large_image'] = __( 'Show Large Image', ST_PBL );
			$imageLinkType['lightbox_video'] = __( 'Lightbox Video', ST_PBL );
			$imageLinkType = array_merge( $imageLinkType, array_slice( $linkTypes, 1 ) );
			return $imageLinkType;
		}

		/**
		 ** terms by taxonomies
		 *
		 * @param string $taxonomy
		 * @param string $allow_root
		 * @param string $order_by
		 *
		 * @return array
		 */
		static function get_term_taxonomies( $taxonomy = '', $allow_root = false, $order_by = 'count' ) {
			$taxonomies = self::get_public_taxonomies();
			$term_taxos = array();
			foreach ( $taxonomies as $taxo_slug => $taxo_name ) {
				if ( ! isset( $term_taxos[$taxo_slug] ) )
				$term_taxos[$taxo_slug] = array();
				if ( $allow_root ) {
					$exclude_taxo = self::_get_exclude_taxonomies();
					if ( in_array( $taxo_slug , $exclude_taxo ) ) {
						$term_taxos[$taxo_slug]['root'] = __( 'Root', ST_PBL );
					}
				}
				$terms = get_terms(
				$taxo_slug, array(
						'orderby' => $order_by,
						'hide_empty' => 0,
				)
				);

				if ( $order_by == 'name' ) {
					$return     = array();
					$level = 0;
					$arr_return = $terms;
					foreach ( $arr_return as $i => $item ) {
						if ( $item->parent == 0 ) {
							unset( $arr_return[$i] );
							if ( ! $item->name ) {
								$item->name = __( '( no name )', ST_PBL );
							}
							$return[$item->term_id] = $item->name;
							self::_recur_tree( $return, $arr_return, $item->term_id, $level, '1' );
						}
					}
					foreach ( $return as $id => $name ) {
						foreach ( $terms as $term ) {
							if ( $id == $term->term_id ) {
								$term_taxos[$taxo_slug][$term->term_id] = __( $name, ST_PBL );
							}
						}
					}
				} else {
					foreach ( $terms as $term ) {
						$term_taxos[$taxo_slug][$term->term_id] = __( $term->name, ST_PBL );
					}
				}
			}
			if ( $taxonomy )
			return $term_taxos[$taxonomy];
			return $term_taxos;
		}

		/**
		 * Static function get categories for Content Clips shortcode
		 *
		 * @param string $check_val
		 * @param array $attrs
		 *
		 * @return array
		 */
		static function get_categories_content_clips( $check_val, $attrs ) {
			$term_taxos = self::get_term_taxonomies();
			$result     = array();
			foreach ( $term_taxos as $taxo => $terms ) {
				$tmp_arr = array();
				$tmp_arr['options']    = $terms;
				$tmp_arr['dependency'] = array( $check_val, '=', $taxo );
				$result[] = array_merge( $attrs, $tmp_arr );
			}
			return $result;
		}

		/**
		 ** list of single item by post types: post, page, custom post type...
		 *
		 * @param string $posttype
		 *
		 * @return array
		 */
		static function get_single_by_post_types( $posttype = '' ) {
			$posttypes = self::get_post_types();
			$results   = array();
			foreach ( $posttypes as $slug => $name ) {
				if ( ! isset( $results[$slug] ) )
				$results[$slug] = array();
				// query post by post type
				$args = array( 'post_type' => $slug, 'posts_per_page' => -1, 'post_status' => ($slug == 'attachment' ) ? 'inherit' : 'publish' );
				$query = new WP_Query( $args );
				while ( $query->have_posts() ) {
					$query->the_post();
					$results[$slug][get_the_ID()] = __( get_the_title(), ST_PBL );
				}
				wp_reset_postdata();
			}
			if ( $posttype )
			return $results[$posttype];
			return $results;
		}

		/**
		 ** Single Entry options for Button Bar
		 *
		 * @param string $check_val
		 * @param array $attrs
		 *
		 * @return array
		 */
		static function get_single_item_button_bar( $check_val, $attrs ) {
			$post_singles = self::get_single_by_post_types();
			$term_taxos   = self::get_term_taxonomies();
			$result = array();
			foreach ( array_merge( $post_singles, $term_taxos ) as $taxo => $terms ) {
				$tmp_arr = array();
				$tmp_arr['options']    = $terms;
				$tmp_arr['dependency'] = array( $check_val, '=', $taxo );
				$result[] = array_merge( $attrs, $tmp_arr );
			}
			return $result;
		}

		/**
		 ** Single Entries options for Content List
		 *
		 * @param string $check_val
		 * @param array $attrs
		 *
		 * @return array
		 */
		static function get_single_entries_ctl( $check_val, $attrs, $post_types = array() ) {
			global $wpdb;
			$posttypes = array();
			$posttypes['nav_menu_item'] = __( 'Menu', ST_PBL );
			$posttypes = ! $post_types ? array_merge( $posttypes, self::get_post_types() ) : $post_types;
			$post_singles = $arr_post_has_parent = array();
			// Check taxonomies is parent type
			$exclude_taxo = self::_get_exclude_taxonomies();
			$public_taxs  = self::get_public_taxonomies( true );
			$term_taxos = self::get_term_taxonomies( '', true, 'name' );

			foreach ( $posttypes as $slug => $name ) {
				if ( ! isset( $post_singles[$slug] ) ) {
					$post_singles[$slug] = array();
					if ( in_array( $slug , $exclude_taxo ) AND $slug != 'nav_menu_item' ) {
						$post_singles[$slug]['root'] = __( 'Root', ST_PBL );
					}
				}

				$arr_posts = array();
				if ( $slug == 'page' ) {
					// process for page tree
					$sql   = $wpdb->prepare(
							"SELECT *
							FROM $wpdb->posts AS posts
							WHERE posts.post_type = %s AND posts.post_status = %s
							ORDER BY posts.post_parent ASC , posts.post_title ASC", 'page', 'publish'
							);
							$data  = $wpdb->get_results( $sql );
							$level = 0;

							foreach ( $data as $i => $item ) {
								if ( $item->post_parent == 0 ) {
									unset( $data[$i] );
									if ( ! $item->post_title ) {
										$item->post_title = __( '( no title )', ST_PBL );
									}
									$arr_posts[$item->ID] = __( $item->post_title, ST_PBL );
									self::_recur_tree( $arr_posts, $data, $item->ID, $level, '-1' );
								}
							}
				} else {
					// query post by post type
					$args = array( 'post_type' => $slug, 'posts_per_page' => -1, 'post_status' => ($slug == 'attachment' ) ? 'inherit' : 'publish' );
					$query = new WP_Query( $args );
					while ( $query->have_posts() ) {
						$query->the_post();
						$post_id = get_the_ID();
						$arr_posts[$post_id] = __( get_the_title(), ST_PBL );
					}

					wp_reset_postdata();
				}

				$arr_post_ids = array();
				foreach ( $arr_posts as $id => $title ) {
					if ( $id ) {
						$arr_post_ids[] = $id;
					}
				}

				$arr_post_ids	= implode( ',', $arr_post_ids );
				if ( $arr_post_ids ) {
					$sql = $wpdb->prepare(
							"SELECT term_rel.term_taxonomy_id AS term_taxonomy_id, name, object_id, taxonomy, term.term_id AS term_id
							FROM $wpdb->term_relationships AS term_rel
							INNER JOIN $wpdb->term_taxonomy as term_taxonomy
							ON term_taxonomy.term_taxonomy_id = term_rel.term_taxonomy_id
							INNER JOIN $wpdb->terms AS term
							ON term_taxonomy.term_id = term.term_id
							WHERE term_rel.object_id IN ( %s )", $arr_post_ids
					);

					$result = $wpdb->get_results( $sql );
				} else {
					$result = array();
				}
				$arr_taxonomy = array();
				if ( count( $result ) ) {
					foreach ( $result as $i => $item ) {
						if ( ! in_array( $item->taxonomy, $arr_taxonomy ) ) {
							$arr_taxonomy[] = $item->taxonomy;
						}
					}
				}

				if ( count( $result ) ) {
					if ( count( $arr_taxonomy ) >= 1 ) {
						foreach ( $arr_taxonomy as $j => $taxonomy ) {
							foreach ( $public_taxs as $tax_slug => $pb_tax ) {
								if ( $tax_slug == $taxonomy AND ! empty( $pb_tax ) ) {
									if ( $taxonomy == 'product_type' ) {
										$pb_tax = __( 'Product Type', ST_PBL );
									}
									$post_singles[$slug][$taxonomy] = array( 'text' => $pb_tax, 'type' => 'optiongroup' );

									if ( ! in_array( $slug, $arr_post_has_parent ) ) {
										$arr_post_has_parent[] = $slug;
									}

									$arr_cats = isset( $term_taxos[$taxonomy] ) ? (array) $term_taxos[$taxonomy] : array();
									foreach ( $arr_cats as $i => $cat ) {
										if ( $cat ) {
											$post_singles[$slug][$i] = $cat;
										}
									}
								}
							}
							foreach ( $result as $i => $item ) {
								foreach ( $arr_posts as $id => $title ) {
									if ( $item->object_id == $id AND $item->taxonomy == $taxonomy ) {
										$post_singles[$slug][$item->term_id] = __( $item->name, ST_PBL );

										if ( ! in_array( $slug, $arr_post_has_parent ) ) {
											$arr_post_has_parent[] = $slug;
										}
									}
								}
							}
							unset( $arr_taxonomy[$j] );
						}

					} else {
						foreach ( $arr_posts as $id => $title ) {
							foreach ( $result as $i => $item ) {
								if ( $item->object_id == $id ) {
									$post_singles[$slug][$item->term_id] = __( $item->name, ST_PBL );
								}
							}
						}
					}
				} else {
					foreach ( $arr_posts as $id => $title ) {
						$post_singles[$slug][$id] = $title;
					}
				}
			}

			$result     = array();

			foreach ( $posttypes as $_slug => $post ) {
				if ( in_array( $_slug, $exclude_taxo ) OR in_array( $_slug, $arr_post_has_parent ) ) {
					unset( $posttypes[$_slug] );
				}
			}

			foreach ( $post_singles as $taxo => $terms ) {
				$tmp_arr = array();
				if ( ! in_array( $taxo , $exclude_taxo ) ) {
					$tmp_arr['multiple'] = '1';
				}
				$allow = true;
				if ( count( $arr_post_has_parent ) ) {
					foreach ( $posttypes as $_slug => $post ) {
						if ( $_slug == $taxo ) {
							$allow = false;
							break;
						}
					}
				}
				if ( $allow ) {
					$tmp_arr['options'] = $terms;
				} else {
					$tmp_arr['options'] = array();
				}
				if ( $taxo == 'nav_menu_item' ) {
					$attrs['class'] = 'select2-select no_plus_depend';
				}
				$tmp_arr['no_order']   = '1';
				$tmp_arr['dependency'] = array( $check_val, '=', $taxo );
				$result[] = array_merge( $attrs, $tmp_arr );
			}
			return $result;
		}

		/**
		 ** exclude taxonomy and posttypes array for taxonomies parent-child type
		 *
		 * @return array
		 */
		static function _get_exclude_taxonomies() {
			global $wpdb;
			// set default exclude value
			$exclude_taxo   = array();
			$exclude_taxo[] = 'page';
			$exclude_taxo[] = 'nav_menu_item';

			$sql    = $wpdb->prepare( "SELECT DISTINCT( post_type ) FROM $wpdb->posts WHERE post_parent != %d", 0 );
			$result = $wpdb->get_results( $sql );

			foreach ( $result as $i => $item ) {
				if ( ! empty( $item->post_type ) AND ! in_array( $item->post_type, $exclude_taxo ) ) {
					$exclude_taxo[] = $item->post_type;
				}
			}

			$sql    = $wpdb->prepare(
					"SELECT term_taxonomy_id, taxonomy
					FROM $wpdb->term_taxonomy
					WHERE parent != %d", 0
			);
			$result = $wpdb->get_results( $sql );
			foreach ( $result as $i => $item ) {
				if ( ! in_array( $item->taxonomy , $exclude_taxo ) )
				$exclude_taxo[] = $item->taxonomy;
			}
			return $exclude_taxo;
		}

		/**
		 ** taxonomy without parent-child type
		 *
		 * @return string
		 */
		static function get_tax_no_parent() {
			global $wpdb;
			$arr_tax_no_parent = array();
			$sql = $wpdb->prepare( "SELECT taxonomy, parent FROM $wpdb->term_taxonomy WHERE 1 = %s", '1' );
			$result = $wpdb->get_results( $sql );

			$excluded = array();
			foreach ( $result as $i => $item ) {
				if ( ! in_array( $item->taxonomy, $excluded ) ) {
					if ( $item->parent == 0 AND ! in_array( $item->taxonomy, $arr_tax_no_parent ) ) {
						$arr_tax_no_parent[] = $item->taxonomy;
					} else if ( $item->parent != 0 AND in_array( $item->taxonomy, $arr_tax_no_parent ) ) {
						foreach ( $arr_tax_no_parent as $j => $_item ) {
							if ( $_item == $item->taxonomy ) {
								unset( $arr_tax_no_parent[$j] );
								$excluded[] = $item->taxonomy;
							}
						}
					}
				}
			}

			return implode( ',', $arr_tax_no_parent );
		}

		/**
		 ** public taxonomy options
		 *
		 * @param bool $is_full
		 *
		 * @return array
		 */
		static function get_public_taxonomies( $is_full = false ) {
			$arr_taxs = array();
			if ( ! $is_full ) {
				$taxs = get_taxonomies( array( 'public' => true, 'show_ui' => true ), 'objects' );
			} else {
				$taxs = get_taxonomies( null, 'objects' );
			}
			foreach ( $taxs as $i => $tax ) {
				if ( isset($tax->labels->singular_name ) && trim( $tax->labels->singular_name ) != '' ) {
					$arr_taxs[$tax->name] = __( $tax->labels->singular_name, ST_PBL );
				}
			}
			return $arr_taxs;
		}

		/**
		 * Static function get post type options
		 *
		 * @param bool $allow_filter
		 *
		 * @return array
		 */
		static function get_post_types( $allow_filter = false ) {
			$arr_posts = array();
			$posts     = get_post_types( array( 'public' => true, 'show_ui' => true ), 'objects' );
			foreach ( $posts as $i => $post ) {
				if ( ! $allow_filter ) {
					if ( $post->name == 'attachment' ) continue;
					if ( isset($post->labels->singular_name ) && trim( $post->labels->singular_name ) != '' ) {
						$arr_posts[$post->name] = __( $post->labels->singular_name, ST_PBL );
					}
				} else {
					$arr_posts[] = $post->name;
				}
			}
			return $arr_posts;
		}

		/**
		 * Private static function get exclude taxonomy array
		 *
		 * @return array
		 */
		private static function _get_exclude_tax() {
			global $wpdb;
			$exclude_taxo = array();

			$sql    = $wpdb->prepare( "SELECT DISTINCT( post_type ) FROM $wpdb->posts WHERE post_parent != 0", null );
			$result = $wpdb->get_results( $sql );

			foreach ( $result as $i => $item ) {
				if ( ! empty( $item->post_type ) AND ! in_array( $item->post_type, $exclude_taxo ) ) {
					$exclude_taxo[] = $item->post_type;
				}
			}
			return $exclude_taxo;
		}

		/**
		 * Private static function to get contentlist orderby array
		 *
		 * @return array
		 */
		private static function _get_ctl_order_by() {
			$arr_return = array();
			// setup for base post type
			$arr_return['post'] = array(
				'title'    => __( 'Title', ST_PBL ),
				'comment_count' => __( 'Comment Count', ST_PBL ),
				'date'     => __( 'Date', ST_PBL )
			);
			$arr_return['page'] = array(
				'title'    => __( 'Title', ST_PBL ),
				'comment_count' => __( 'Comment Count', ST_PBL ),
				'date'     => __( 'Date', ST_PBL )
			);

			$post_types = self::get_post_types();
			// setup for extend post type
			foreach ( $post_types as $slug => $post ) {
				if ( $slug ) {
					$arr_column = array();
					$arr_sort   = array(
						'title'    => 'title',
						'parent'   => 'parent',
						'comment_count' => 'comment_count',
						'date'     => array( 'date', true )
					);
					if ( has_filter( 'manage_edit-' . $slug . '_sortable_columns' ) ) {
						$arr_sort = array_merge( $arr_sort, apply_filters( 'manage_edit-' . $slug . '_sortable_columns', array() ) );
						if ( has_filter( 'manage_edit-' . $slug . '_columns' ) ) {
							$arr_column = apply_filters( 'manage_edit-' . $slug . '_columns', array() );
						}

						if ( $arr_sort AND $arr_column ) {
							$new_arr = array();
							foreach ( $arr_sort as $key => $value ) {
								foreach ( $arr_column as $_key => $_value ) {
									if ( $key == $_key ) {
										// process html
										if ( self::_is_html( $_value ) ) {
											$_value = substr( $_value, strpos( $_value, 'data-tip="' ) + 10 );
											$_value = substr( $_value, 0, strpos( $_value, '"' ) );
										}
										$new_arr[strtolower( $key )] = $_value;
									}
								}
							}
							$arr_return[$slug] = $new_arr;
						}
					}
				}
			}

			// setup for taxonomy
			$taxonomies = self::get_public_taxonomies();
			foreach ( $taxonomies as $slug => $tax ) {
				$arr_return[$slug] = array(
					'name'		=> __( 'Name', ST_PBL ),
					'description' => __( 'Description', ST_PBL ),
					'slug'		=> __( 'Slug', ST_PBL ),
					'count'       => __( 'Count', ST_PBL )
				);
			}

			return $arr_return;
		}

		/**
		 ** contentlist orderby options
		 *
		 * @param string $check_val
		 * @param array $attrs
		 * @return array
		 */
		static function get_list_ctl_order_by( $check_val, $attrs ) {
			$result = array();
			$data   = self::_get_ctl_order_by();
			foreach ( $data as $taxo => $terms ) {
				$tmp_arr = array();
				$tmp_arr['options'] = array_merge( array( 'no_order' => __( ' - No ordering - ', ST_PBL ) ), $terms );
				$tmp_arr['no_order']   = '1';
				$tmp_arr['dependency'] = array( $check_val, '=', $taxo );
				$result[] = array_merge( $attrs, $tmp_arr );
			}

			return $result;
		}

		/**
		 ** contentlist order
		 *
		 * @return array
		 */
		static function get_ctl_order() {
			return array(
				'asc'	=> __( 'Ascending', ST_PBL ),
				'desc'	=> __( 'Descending', ST_PBL )
			);
		}

		/**
		 * Private static function to check context string is html type
		 *
		 * @param string $string
		 *
		 * @return boolean
		 */
		private static function _is_html( $string = '' ) {
			if ( $string ) {
				if ( strlen( $string ) != strlen( strip_tags( $string ) ) ) {
					return true; // Contains HTML
				}
			}

			return false;
		}

		/**
		 * Private static function to get menu item options
		 *
		 * @return array
		 */
		private static function _get_menu_items() {
			$nav_menu_items = $arr_options = array();
			$nav_menus = wp_get_nav_menus();
			if ( count( $nav_menus ) ) {
				foreach ( $nav_menus as $i => $menu ) {
					$nav_menu_items[$menu->term_id] = wp_get_nav_menu_items( $menu, null );
				}
			}
			if ( count( $nav_menu_items ) ) {
				foreach ( $nav_menu_items as $term_id => $items ) {
					$arr_options[$term_id]['root'] = __( 'Root', ST_PBL );
					$level = 0;
					foreach ( $items as $i => $item ) {
						if ( $item->menu_item_parent == 0 ) {
							unset( $items[$i] );
							if ( ! $item->title ) {
								$item->title = __( '( no title )', ST_PBL );
							}
							$arr_options[$term_id][$item->ID] = __( $item->title, ST_PBL );
							self::_recur_tree( $arr_options, $items, $item->ID, $level, '-2', $term_id );
						}
					}
				}
			}
			return $arr_options;
		}

		/**
		 * menu item options
		 *
		 * @param string $check_val
		 * @param array $attrs
		 *
		 * @return array
		 */
		static function get_list_menu_items( $check_val, $attrs ) {
			$result = array();
			$data   = self::_get_menu_items();
			foreach ( $data as $taxo => $terms ) {
				$tmp_arr = array();
				$tmp_arr['options']    = $terms;
				$tmp_arr['no_order']   = '1';
				$tmp_arr['dependency'] = array( $check_val, '=', $taxo );
				$result[] = array_merge( $attrs, $tmp_arr );
			}

			return $result;
		}

		/**
		 * Static function to get pricing type of sub items
		 *
		 * @return array
		 */
		static function get_sub_item_pricing_type() {
			return array(
				'text' 		=> __( 'Free text', ST_PBL ),
				'checkbox' 	=> __( 'Yes / No', ST_PBL )
			);
		}

		/**
		 * Get posts by Term ID
		 *
		 * @param type $item_filter
		 * @param type $arr_ids
		 * @param type $source
		 */
		static function post_by_termid($item_filter, &$arr_ids, &$source) {
			global $wpdb;
			// Get list of Post ID by filter criteria
			$sql     = $wpdb->prepare(
                "SELECT DISTINCT(object_id), term_taxonomy_id
                FROM $wpdb->term_relationships AS term_rel
                WHERE term_rel.term_taxonomy_id IN ( %s )",
			$item_filter
			);
			$objlist = $wpdb->get_results( $sql );

			foreach ( $objlist as $i => $item ) {
				$arr_ids[] = $item->object_id;
				// get taxonomy
				$sqlx      = $wpdb->prepare(
                    "SELECT *
                    FROM $wpdb->term_taxonomy
                    WHERE term_taxonomy_id = %d",
				$item->term_taxonomy_id
				);
				$datax = $wpdb->get_results( $sqlx );
				foreach ( $datax as $i => $itemx ) {
					$source[] = $itemx->taxonomy;
				}
			}
		}





		/**
		 * YUNUS EDIT
		 * Creates fields for generating a button
		 */
		static function get_button_type( $id = 'button', $group_name='', $hide_fields = array('alignment') )
		{
			if(! $group_name)
			{
				$group_name = __( 'Click to configure button', ST_PBL );
			}


			$fields = array(

				array(
					'name'    => $group_name,
					'type'    => 'group_open',
				),

				array(
					'name'    => __( 'Button Title', ST_PBL ),
					'id'      => $id.'_text',
					'type'    => 'text_field',
					'class'   => 'input-sm',
					'std'     => 'Button Title',
				),
				array(
					'name'       => __( 'On Click', ST_PBL ),
					'id'         => $id.'_link_type',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => 'url',
					'options'    => ST_Pb_Helper_Type::get_link_types(),
					'has_depend' => '1',
					'tooltip' => __( 'Select link types: link to post, page, category...', ST_PBL ),
				),
				array(
					'name'       => __( 'URL', ST_PBL ),
					'id'         => $id.'_type_url',
					'type'       => 'text_field',
					'class'      => 'input-sm',
					'std'        => 'http://',
					'dependency' => array( $id.'_link_type', '=', 'url' ),
				),
				array(
							'name'  => __( 'Single Item', ST_PBL ),
							'id'    => $id.'_single_item',
							'type'  => 'type_group',
							'std'   => '',
							'items' => ST_Pb_Helper_Type::field_data_source(array(
								'callback' => 'ST_Pb_Helper_Type::get_single_item_button_bar',
								'args' => array(
									$id.'_link_type',
									array(
										'type' => 'items_list',
										'options_type' => 'select',
										'ul_wrap' => false,
									)
								)
							)),
				),
				array(
					'name'       => __( 'Open in', ST_PBL ),
					'id'         => $id.'_open_in',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_open_in_options() ),
					'options'    => ST_Pb_Helper_Type::get_open_in_options(),
					'dependency' => array( $id.'_link_type', '!=', 'no_link' ),
					'has_depend' => '1'
				),

				array(
							'name'                 => __( 'Lightbox size', ST_PBL ),
							'container_class'      => 'combo-group dimension-inline',
							'id'                   => $id.'_lb',
							'type'                 => 'dimension',
							'extended_ids'         => array( $id.'_lb_width', $id.'_lb_height', $id.'_lb_width_unit', $id.'_lb_height_unit' ),
							$id.'_lb_width'      => array( 'std' => '100' ),
							$id.'_lb_height'     => array( 'std' => '100' ),
							$id.'_lb_width_unit' => array(
								'options' => array( 'px' => 'px', '%' => '%' ),
								'std'     => '%',
							),
							$id.'_lb_height_unit' => array(
								'options' => array( 'px' => 'px', '%' => '%' ),
								'std'     => '%',
							),
							'tooltip' => __( 'Set width and height of lightbox window', ST_PBL ),
							'dependency' => array( $id.'_open_in', '=', 'lightbox' ),
				),

				array(
							'name'    => __( 'Size', ST_PBL ),
							'id'      => $id.'_size',
							'type'    => 'select',
							'class'   => 'input-sm',
							'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_size() ),
							'options' => ST_Pb_Helper_Type::get_button_size(),
				),
				array(
					'name'    => __( 'Style', ST_PBL ),
					'id'      => $id.'_style',
					'type'    => 'select',
					'std'     => 'default',
					'options' => array(
						'default' => __( 'Default', ST_PBL ),
						'default-no-fill' => __( 'Default No Fill', ST_PBL ),
						'rounded' => __( 'Rounded', ST_PBL ),
						'rounded-no-fill' => __( 'Rounded No Fill', ST_PBL ),
					),
				),
				array(
							'name'    => __( 'Color', ST_PBL ),
							'id'      => $id.'_color',
							'type'    => 'select',
							'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_color() ),
							'options' => ST_Pb_Helper_Type::get_button_color(),
							//'container_class'   => 'color_select2',
							'tooltip' => __( 'Select the color of the button', ST_PBL ),
							'has_depend' => '1',
				),

				array(
					'name'    => __( 'Custom color', ST_PBL ),
					'id'       => $id.'_custom_color',
					'type'     => 'color_picker',
					'std'      => '',
					'css' => array(
						array('.btn', 'background-color', '%value% !important', array(
							array($id.'_style', '!=', 'default-no-fill'),
							array($id.'_style', '!=', 'rounded-no-fill')
						)),
						array('.btn:hover', 'background-color', '%value% !important'),
						array('.btn', 'border-color', '%value% !important'),
					),
					'dependency'      => array( $id.'_color', '=', 'btn-default' ),
				),

				array(
					'name'    => __( 'Text color', ST_PBL ),
					'id'       => $id.'_text_color',
					'type'     => 'color_picker',
					'std'      => '',
					'css' => array(
						array('.btn', 'color', '%value% !important'),
						array('.btn .fa:before', 'color', '%value% !important'),
					),
					'dependency'      => array( $id.'_color', '=', 'btn-default' ),
				),

				array(
					'name'    => __( 'Custom hover color', ST_PBL ),
					'id'       => $id.'_custom_h_color',
					'type'     => 'color_picker',
					'std'      => '',
					'css' => array(
						array('.btn:hover', 'background-color', '%value% !important'),
						array('.btn:hover', 'border-color', '%value% !important'),
					),
				),

				array(
					'name'    => __( 'Hover Text color', ST_PBL ),
					'id'       => $id.'_h_text_color',
					'type'     => 'color_picker',
					'std'      => '',
					'css' => array(
						array('.btn:hover', 'color', '%value% !important'),
						array('.btn:hover .fa:before', 'color', '%value% !important'),
					),
					'dependency'      => array( $id.'_color', '=', 'btn-default' ),
				),



				array(
					'name'      => __( 'Icon', ST_PBL ),
					'id'        => $id.'_icon',
					'type'      => 'icons',
					'std'       => '',
					'role'      => 'title_prepend',
					'title_prepend_type' => 'icon',
				),

				array(
					'name'    => __( 'Alignment', ST_PBL ),
					'id'      => $id.'_alignment',
					'type'    => 'radio_button_group',
					'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_text_align() ),
					'options' => ST_Pb_Helper_Type::get_text_align(),
				),

				array(
					'type'    => 'group_close',
				),

			);

			// append id to each hide fields so we can match them later
			foreach ($hide_fields as &$value)
				$value = $id.'_'.$value;


			$ready_fields = array();
			foreach($fields as $field)
			{
				if(isset($field['id']) && in_array($field['id'], $hide_fields)) continue;
				$ready_fields[] = $field;
			}

			return $ready_fields;

		}


		/**
		 * YUNUS EDIT
		 * Creates fields for generating a button
		 */
		static function get_icon_type( $id = 'icon', $override_defaults=null, $extra_fields = array(), $section_name='', $allow_image=false)
		{
			//$allow_image=false;

			if(! $section_name) $section_name =  __( 'Click to configure icon', ST_PBL );

			$defaults_pre = array(
				'icon'=>'',
				'size'=>'32',
				'color'=>'#000000',
				'style'=>'simple',
				'bg'=>'#fff',
			);

			if($override_defaults && ! empty($override_defaults))
				$defaults_pre = array_merge($defaults_pre, $override_defaults);

			$defaults = array();
			foreach($defaults_pre as $key=>$val)
			{
				$defaults[ $id.'_'.$key ] = $val;
			}

			$fields[] = array(
					'name'    => $section_name,
					'type'    => 'group_open',
				);

/*
			$fields[] = array(
					'name'     => __( 'Icon', ST_PBL ),
					'id'       => $id.'_icon',
					'type'     => 'icons',
					'std'      => 'fa fa-star-o',
				);

			$fields[] = array(
					'name'    => __( 'Size of icon (px)', ST_PBL ),
					'id'           => $id.'_size',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '32',
					'append'       => 'px',
					'validate'     => 'number',
					//'parent_class' => 'combo-item input-append-inline',
				);

			$fields[] = array(
					'name'    => __( 'Icon color', ST_PBL ),
					'id'       => $id.'_color',
					'type'     => 'color_picker',
					'std'      => '#000000',
				);

			$fields[] = array(
					'name'    => __( 'Icon Style', ST_PBL ),
					'id'      => $id.'_style',
					'type'    => 'select',
					'std'     => 'simple',
					'options' => array(
						"simple"=>"Simple",
						"circle"=>"Circle Background",
						"square"=>"Square Background",
					),
					'has_depend' => '1',
				);

			$fields[] = array(
					'name'    => __( 'Icon background color', ST_PBL ),
					'id'       => $id.'_bg',
					'type'     => 'color_picker',
					'std'      => '#fff',
					'tooltip' => __( 'Background color for icon.', ST_PBL ),
					'dependency' => array( $id.'_style', '!=', 'simple' )
				);
*/





// ------------------------------------------------------
//
// ------------------------------------------------------

			if($allow_image)
				$fields[] = array(
					'name'     => __( 'Type', ST_PBL ),
					'id'       => $id.'_type',
					'type'     => 'radio',
					'std'      => '',
					'options'  => array( '' => __( 'Icon', ST_PBL ), 'image' => __( 'Image', ST_PBL ) ),
					'has_depend' => $allow_image ? 1 : 0,
				);

			$fields[] = array(
					'name'     => __( 'Icon', ST_PBL ),
					'id'       => $id.'_icon',
					'type'     => 'icons',
					'std'      => 'fa fa-star-o',
					'dependency' => $allow_image ? array( $id.'_type', '=', '' ) : false,
				);

			$fields[] = array(
					'name'    => __( 'Size of icon (px)', ST_PBL ),
					'id'           => $id.'_size',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '32',
					'append'       => 'px',
					'validate'     => 'number',
					'dependency' => $allow_image ? array( $id.'_type', '=', '' ) : false,
					//'parent_class' => 'combo-item input-append-inline',
				);

			$fields[] = array(
					'name'    => __( 'Icon color', ST_PBL ),
					'id'       => $id.'_color',
					'type'     => 'color_picker',
					'std'      => '#000000',
					'dependency' => $allow_image ? array( $id.'_type', '=', '' ) : false,
				);

			if($allow_image)
			{
				$fields[] = array(
							'name'    => __( 'Image File', ST_PBL ),
							'id'      => $id.'_image',
							'type'    => 'select_media',
							'std'     => '',
							'class'   => 'jsn-input-large-fluid',
							'dependency' => array( $id.'_type', '=', 'image' ),
				);

/*
				$fields[] = array(
					'name' => __( 'Image Dimensions (optional)', ST_PBL ),
					'type' => array(
						array(
							'id'           => $id.'_image_width',
							'type'         => 'text_append',
							'type_input'   => 'number',
							'class'        => 'input-mini',
							'std'          => '',
							'append'       => 'px',
							'validate'     => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id'           => $id.'_image_height',
							'type'         => 'text_append',
							'type_input'   => 'number',
							'class'        => 'input-mini',
							'std'          => '',
							'append'       => 'px',
							'validate'     => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
					),
					'container_class' => 'combo-group',
				);
*/
			}

			$fields[] = array(
					'name'    => __( 'Style', ST_PBL ),
					'id'      => $id.'_style',
					'type'    => 'select',
					'std'     => 'simple',
					'options' => array(
						"simple"=>"Simple",
						"circle"=>"Circle Background",
						"square"=>"Square Background",
					),
					'has_depend' => '1',
				);

			$fields[] = array(
					'name'    => __( 'Background color', ST_PBL ),
					'id'       => $id.'_bg',
					'type'     => 'color_picker',
					'std'      => '#fff',
					'tooltip' => __( 'Background color for icon.', ST_PBL ),
					'dependency' => array( $id.'_style', '!=', 'simple' )
				);


			$default_applied_fields = array();
			foreach($fields as $field)
			{
				$field['std'] = (isset($field['id']) && isset($defaults[ $field['id'] ])) ? $defaults[ $field['id'] ] : '';

				$default_applied_fields[] = $field;
			}


			$fields = array_merge($default_applied_fields, $extra_fields);

			$fields[] = array(
					'type'    => 'group_close',
			);


			return $fields;
		}



		static function get_shadow_type($id='wrapper_shadow', $css_element='', $css=array())
		{
			return array(
                    'name'    => __( 'Box shadow', ST_PBL ),
                    'id'      => $id,
                    'type'    => 'radio_button_group',
                    'group_class' => 'btn-group st-btn-group st-field-shadow',
                    'std'     => '',
                    'options' => array(
                        '' => __( '<span title="None"></span>', ST_PBL ),
                        '5' => __( '<span style="box-shadow: 0 0px 18px rgba(0, 0, 0, 0.35);" title="Softer"></span>', ST_PBL ),

                        '1' => __( '<span style="box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.24), 0 1px 1px 0 rgba(0, 0, 0, 0.48);" title="Low"></span>', ST_PBL ),
                        '2' => __( '<span style="box-shadow: 0 5px 10px 0 rgba(0, 0, 0, 0.26), 0 4px 5px 0 rgba(0, 0, 0, 0.46);" title="Medium"></span>', ST_PBL ),
                        '3' => __( '<span style="box-shadow: 0 11px 23px 0 rgba(0, 0, 0, 0.28), 0 6px 11px 0 rgba(0, 0, 0, 0.43);" title="High"></span>', ST_PBL ),
                        
                        // '4' => __( '<span style="box-shadow: 0 11px 23px 0 rgba(55, 0, 0, 0.28), 0 6px 11px 0 rgba(55, 0, 0, 0.43);" title="High"></span>', ST_PBL ),
                    ),
                    'css' => array_merge($css, array(
                        array($css_element, 'box-shadow', '0 1px 3px 0 rgba(0, 0, 0, 0.24), 0 1px 1px 0 rgba(0, 0, 0, 0.48)', array(
                            array($id, '=', '1'),
                        )),
                        array($css_element, 'box-shadow', '0 5px 10px 0 rgba(0, 0, 0, 0.26), 0 4px 5px 0 rgba(0, 0, 0, 0.46)', array(
                            array($id, '=', '2'),
                        )),
                        array($css_element, 'box-shadow', '0 11px 23px 0 rgba(0, 0, 0, 0.28), 0 6px 11px 0 rgba(0, 0, 0, 0.43)', array(
                            array($id, '=', '3'),
                        )),
                        array($css_element, 'box-shadow', '0 0px 40px rgba(0, 0, 0, 0.25)', array(
                            array($id, '=', '5'),
                        )),
                        // array('', 'border', '0 11px 23px 0 fade(%wrapper_bg_color%, 38%), 0 6px 11px 0 fade(%wrapper_bg_color%, 53%)', array(
                        //     array('wrapper_shadow', '=', '4'),
                        // )),
                    )),
                );
		}





	}

}
?>
