<?php

if (!class_exists('ST_Pb_Objects_Modal')) {

	class ST_Pb_Objects_Modal {

		private static $instance;

		public static function get_instance() {
			if (!self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		private function __construct() {
			add_filter('st_pb_register_assets', array(&$this, 'apply_assets'));
			$this->enqueue_admin_style();
			$this->enqueue_admin_script();

			// Localize script
			$this->st_localize();

			do_action('st_modal_init');
		}

		/**
		 * Register custom assets to use on Modal
		 *
		 * @param array $assets
		 *
		 * @return array
		 */
		public function apply_assets($assets) {
			ST_Pb_Helper_Functions::load_bootstrap_3($assets);
			$assets['st-pb-handlesetting-js'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/main') . '/js/handle_setting.js',
				'ver' => '1.1.1',
			);
			if (ST_Pb_Helper_Functions::is_preview()) {
				$assets['st-pb-frontend-css'] = array(
					'src' => ST_Pb_Helper_Functions::path('assets/main') . '/css/front_end.css',
					'ver' => '1.0.1',
				);
			}
			$assets['st-pb-modal-css'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/main') . '/css/modal.css',
				'ver' => '1.0.1',
			);
			$assets['st-pb-codemirror-css'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/3rd-party/') . '/codemirror/codemirror.css',
				'ver' => '1.0.1',
			);
			$assets['st-pb-codemirror-js'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/3rd-party/') . '/codemirror/codemirror.js',
				'ver' => '1.0.1',
			);
			$assets['st-pb-codemirrormode-css-js'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/3rd-party/') . '/codemirror/mode/css.js',
				'ver' => '1.0.1',
			);
			$assets['st-pb-scrollreveal'] = array(
				'src' => ST_Pb_Helper_Functions::path('assets/3rd-party/scrollreveal') . '/scrollReveal.js',
				'ver' => '0.1.2',
			);
			$assets = apply_filters('st_pb_assets_register_modal', $assets);

			return $assets;
		}

		/**
		 * Enqueue scripts
		 */
		public function enqueue_admin_script() {
			ST_Pb_Helper_Functions::enqueue_scripts_modal();

			wp_enqueue_media();

			ST_Pb_Helper_Functions::enqueue_scripts_end();

			ST_Pb_Init_Assets::load(array('st-pb-placeholder'));
		}

		/**
		 * Enqueue style
		 */
		public function enqueue_admin_style() {
			ST_Pb_Helper_Functions::enqueue_styles();

			if (!ST_Pb_Helper_Functions::is_preview()) {
				ST_Pb_Init_Assets::load(array('st-pb-modal-css'));
			} else {
				ST_Pb_Init_Assets::load(array('st-pb-frontend-css', 'st-pb-scrollreveal'));
				ST_Pb_Init_Assets::inline('js', "
					var revealObjects  = null;
					$(document).ready(function (){
						if($('[data-scroll-reveal]').length) {
							if (!revealObjects) {
								revealObjects = new scrollReveal({
								        reset: true
								    });
							}
						}
					});
				");
			}
		}

		/**
		 * Localize Script
		 */
		public function st_localize() {
			ST_Pb_Init_Assets::localize('st-pb-handlesetting-js', 'St_Ajax', ST_Pb_Helper_Functions::localize_js());
		}

		/**
		 * Get related content for each Modal
		 *
		 * @param type $page
		 */
		public function preview_modal($page = '') {
			add_action('st_pb_modal_page_content', array(&$this, 'content' . $page), 10);
		}

		/**
		 * HTML content for Shortcode editing Modal
		 */
		public function content() {
			include ST_PB_TPL_PATH . '/modal.php';

			// Load required assets
			$assets = apply_filters('st_pb_assets_enqueue_modal', array('st-pb-handlesetting-js'));

			ST_Pb_Init_Assets::load($assets);
		}

		/**
		 * HTML content for Page template Modal
		 */
		public function content_layout() {

			include ST_PB_TPL_PATH . '/layout/list.php';

			// load last assets: HandleSettings & hooked assets
			$assets = apply_filters('st_pb_assets_enqueue_modal', array('st-pb-handlesetting-js'));
			ST_Pb_Init_Assets::load($assets);
		}

		/**
		 * HTML content for Custom css Modal
		 */
		public function content_custom_css() {
			$assets = apply_filters('st_pb_assets_enqueue_modal', array('st-pb-codemirror-css', 'st-pb-codemirror-js', 'st-pb-codemirrormode-css-js'));
			ST_Pb_Init_Assets::load($assets);
			include ST_PB_TPL_PATH . '/custom-css.php';
		}

		/**
		 * HTML content for Reprt Bug Modal
		 *
		 * @return void
		 */
		public function content_report_bug() {
			$assets = apply_filters('st_pb_assets_enqueue_modal', array());
			ST_Pb_Init_Assets::load($assets);
			include ST_PB_TPL_PATH . '/report-bug.php';
		}

		public function content_add_element() {
			$assets = apply_filters('st_pb_assets_enqueue_modal', array());
			ST_Pb_Init_Assets::load($assets);
			include ST_PB_TPL_PATH . '/select-elements.php';
		}

		/**
		 * Ignore settings key in array
		 *
		 * @param array $options
		 *
		 * @return array
		 */
		static function ignore_settings($options) {
			if (array_key_exists('settings', $options)) {
				$options = array_slice($options, 1);
			}

			return $options;
		}

		/**
		 * Add setting data to a tag
		 *
		 * @param string $tag
		 * @param array  $data
		 * @param string $content
		 *
		 * @return string
		 */
		static function tab_settings($tag, $data, $content) {
			$tag_data = array();
			if (!empty($data)) {
				foreach ($data as $key => $value) {
					if (!empty($value)) {
						$tag_data[] = "$key = '$value'";
					}
				}
			}
			$tag_data = implode(' ', $tag_data);

			return "<$tag $tag_data>$content</$tag>";
		}

		/**
		 * get HTML of Modal Settings Box of Shortcode
		 *
		 * @param array $options
		 *
		 * @return string
		 */
		static function get_shortcode_modal_settings($settings, $shortcode = '', $input_params = null, $raw_shortcode = null, $has_preview = false, $no_tab = false) {
			$i = 0;
			$tabs = $contents = $actions = $general_actions = array();
			$icon_tab = array('content' => 'pencil-square-o', 'styling' => 'magic', 'mobile' => 'mobile', 'shortcode' => 'code');
			$tab_names = array(
				'mobile' => 'Mobile Styling',
			);

			// yunus edit - icon for help and advance tab
			$icon_tab['help'] = 'info-circle';
			$icon_tab['advance'] = 'cogs';

			foreach ((array) $settings as $tab => $options) {

				$options = self::ignore_settings($options);
				if ($tab == 'action') {
					foreach ($options as $option) {
						$actions[] = ST_Pb_Helper_Shortcode::render_parameter($option['type'], $option);
					}
				} else if ($tab == 'generalaction') {
					foreach ($options as $option) {
						$option['id'] = isset($option['id']) ? ('param-' . $option['id']) : '';
						$general_actions[] = ST_Pb_Helper_Shortcode::render_parameter($option['type'], $option);
					}
				} else {
					$active = ($i++ == 0) ? 'active' : '';
					if (strtolower($tab) != 'notab') {
						$data_ = isset($settings[$tab]['settings']) ? $settings[$tab]['settings'] : array();
						$data_['href'] = "#$tab";
						$data_['data-toggle'] = 'tab';
						$content_ = (isset($tab_names[$tab])) ? ucfirst($tab_names[$tab]) : ucfirst($tab);
						$icon = isset($icon_tab[$tab]) ? sprintf('<i class="fa fa-%s"></i>', $icon_tab[$tab]) : '';
						$tabs[] = "<li class='$active st-options-tab-$tab'>" . self::tab_settings('a', $data_, $icon . $content_) . '</li>';
					}

					$has_margin = 0;
					$param_html = array();
					foreach ($options as $idx => $option) {
						// check if this element has Margin param (1)
						if (isset($option['name']) && $option['name'] == __('Margin', ST_PBL) && $option['id'] != 'div_margin') {
							$has_margin = 1;
						}

						// if (1), don't use the 'auto extended margin ( top, bottom ) option'
						if ($has_margin && isset($option['id']) && $option['id'] == 'div_margin') {
							continue;
						}

						$type = $option['type'];

						if (isset($option['id'])) {
							$option['id'] = 'param-' . $option['id'];
						} elseif (!is_array($option['type'])) {
							$option['id'] = $option['type'] . "_$idx";
						} else {
							$option['id'] = "_$idx";
						}

						if (!is_array($type)) {
							// Exclude preview field
							if ($type != 'preview') {

								$st_key = $option['id'];
								if (isset($option['dependency'])
									&& $option['dependency']) {
									$st_key .= '_has_dependency';
								}

								$param_html[$st_key] = ST_Pb_Helper_Shortcode::render_parameter($type, $option, $input_params);
							}
						} else {
							$output_inner = '';
							foreach ($type as $sub_options) {
								$sub_options['id'] = isset($sub_options['id']) ? ('param-' . $sub_options['id']) : '';
								/* for sub option, auto assign bound = 0 {not wrapped by <div class='controls'></div> } */
								$sub_options['bound'] = '0';
								/* for sub option, auto assign 'input-small' class */
								$sub_options['class'] = isset($sub_options['class']) ? ($sub_options['class']) : '';
								$type = $sub_options['type'];
								$output_inner .= ST_Pb_Helper_Shortcode::render_parameter($type, $sub_options);
							}
							$option = ST_Pb_Helper_Html::get_extra_info($option);
							$label = ST_Pb_Helper_Html::get_label($option);
							$param_html[$option['id']] = ST_Pb_Helper_Html::final_element($option, $output_inner, $label);
						}
					}

					if (!empty($param_html['param-copy_style_from'])) {
						// move "auto extended margin ( top, bottom ) option" to top of output
						$style_copy = isset($param_html['param-copy_style_from']) ? $param_html['param-copy_style_from'] : '';

						if (!empty($param_html['param-div_margin'])) {
							$margin = $param_html['param-div_margin'];
							$param_html = array_merge(
								array(
									$style_copy,
									$margin,
								),
								$param_html
							);
							unset($param_html['param-copy_style_from']);
							unset($param_html['param-div_margin']);
						} else {
							$param_html = array_merge(
								array(
									$style_copy,
								),
								$param_html
							);
							unset($param_html['param-copy_style_from']);
						}
					}

/*
$len = count($param_html);
if($len>2)
{
// split params into 2 groups (left, right)
$firsthalf = array_slice($param_html, 0, $len / 2);
$secondhalf = array_slice($param_html, $len / 2);

$param_html  = '<div class="cbb-params-left">'.implode( '', $firsthalf ).'</div><div class="cbb-params-right">'. implode( '', $secondhalf ).'</div><div class="clearfix"></div>';
}
else
{
$param_html  = implode( '', $param_html );
}
 */
					// ------------------------------------------------------
					//  divide params into 2 sections (left, right), make sure group_open and group_close are are in same section
					// ------------------------------------------------------
					$len = count($param_html);
					if ($len > 2 && !preg_match('/^st_item_/i', $shortcode)) {
						$firsthalf = array();
						$secondhalf = array();

						$half = round($len / 2);
						$i = 0;
						$group_open = false;
						$skip = 0;
						foreach ($param_html as $key => $par) {
							if (strpos($key, 'group_open') !== false) {
								$group_open = true;
								$i++;
								//$i = $half + 1; // just jump to next section as we usually have groups at the end
							} elseif (strpos($key, 'group_close') !== false) {
								$group_open = 'close it';
							} elseif (strpos($key, 'skip_to_next_section') !== false) {
								$i = $half + 1;
								continue;
							}

							$has_dependency = strpos($key, '_has_dependency');
							if (!$group_open && $has_dependency === false) {
								$i += $skip + 1;
								$skip = 0;
							} else { $skip++;}

							if ($i <= $half) {
								$firsthalf[] = $par;
							} else {
								$secondhalf[] = $par;
							}

							if ($group_open === 'close it') {
								$group_open = false;
							}
						}

						if (!$secondhalf) {
							$param_html = implode('', $param_html);
						} else {
							$param_html = '<div class="cbb-params-left">' . implode('', $firsthalf) . '</div><div class="cbb-params-right">' . implode('', $secondhalf) . '</div><div class="clearfix"></div>';
						}

					} else {
						$param_html = implode('', $param_html);
					}

					$content_tab = "<div class='tab-pane $active st-pb-setting-tab' id='$tab'>$param_html</div>";
					$contents[] = $content_tab;
				}
			}

			if ($no_tab) {
				return $param_html;
			}

			// Auto-append `Shortcode Content` tab
			// ------------------------------------------------------
			//  yunus edit - changed to preg match to match nested layouts
			// ------------------------------------------------------
			if (!preg_match('/st_(row|column|subrow).*/i', $shortcode)) {
				self::shortcode_content_tab($tabs, $contents, $raw_shortcode);
			}

			return self::setting_tab_html($shortcode, $tabs, $contents, $general_actions, $settings, $actions, $has_preview);
		}

		/**
		 * Generate tab with content, use for generating Modal
		 *
		 * @return string
		 */
		static function setting_tab_html($shortcode, $tabs, $contents, $general_actions, $settings, $actions, $has_preview = false) {
			$output = '<input type="hidden" value="' . $shortcode . '" id="shortcode_name" name="shortcode_name" />';

			/* Tab Content - Styling */

			$output .= '<div class="jsn-tabs">';
			if (count($tabs) > 0) {
				$output .= '<ul class="" id="st_option_tab">';
				$output .= implode('', $tabs);
				$output .= '</ul>';
			}
			/* Tab Content */

			$output .= implode('', $contents);

			$output .= "<div class='jsn-buttonbar st_action_btn'>";

			/* Tab Content - General actions */
			if (count($general_actions)) {
				$data_ = $settings['generalaction']['settings'];
				$content_ = implode('', $general_actions);
				$output .= self::tab_settings('div', $data_, $content_);
			}

			$output .= implode('', $actions);
			$output .= '</div>';
			$output .= '</div>';

			if ($has_preview == true) {
				//$output = "<div class='st-setting-resize'>{$output}</div>";
			}

			return $output;
		}

		/**
		 * Append shortcode content tab to all element settings modal.
		 *
		 * @param   array  &$tabs         Current tabs array.
		 * @param   array  &$contents     Currnt content array.
		 * @param   string $raw_shortcode Raw shortcode content.
		 *
		 * @return  void
		 */
		public static function shortcode_content_tab(&$tabs, &$contents, $raw_shortcode) {
			// Auto-append `Shortcode Content` tab only if this is not a sub-modal
			if (!isset($_REQUEST['submodal']) || !$_REQUEST['submodal']) {
				// Generate tab for shortcode content
				$tabs[] = '<li><a href="#shortcode-content" data-toggle="tab">' . '<i class="fa fa-code"></i>' . __('Shortcode', ST_PBL) . '</a></li>';

				// Generate content for shortcode content tab
				$contents[] = '<div class="tab-pane clearfix" id="shortcode-content">'
				. '<textarea id="shortcode_content" class="form-control" rows="10" disabled="disabled">' . esc_textarea($raw_shortcode) . '</textarea>'
				. '<div class="text-center"><button class="btn btn-success" id="copy_to_clipboard" data-textchange="' . __('Done!', ST_PBL) . '">' . __('Copy to Clipboard', ST_PBL) . '</button></div>'
					. '</div>';
			} else {
				// Generate hidden text area to hold raw shortcode
				$contents[] = '<textarea class="hidden" id="shortcode_content">' . esc_textarea($raw_shortcode) . '</textarea>';
			}
		}

		/**
		 * Generate Setting HTML for each shortcode
		 *
		 * @global object $St_Pb
		 * @param string $shortcode The current shortcode
		 * @param array $params The shortcode content
		 * @param string $el_title Title of shortcode
		 * @param bool $no_tab
		 *
		 * @return string
		 */
		public static function shortcode_modal_settings($shortcode, $params, $el_title = '', $no_tab = false) {
			$html = '';

			// get shortcode class
			$class = ST_Pb_Helper_Shortcode::get_shortcode_class($shortcode);

			if (class_exists($class)) {
				global $St_Pb;
				$settings_html = '';
				$elements = $St_Pb->get_elements();
				$instance = isset($elements['element'][strtolower($class)]) ? $elements['element'][strtolower($class)] : null;

				if (!is_object($instance)) {
					$instance = new $class();
				}
				$instance->init_element();
				$has_preview = false;
				$preview_config['size'] = 'default';

				// Generate default params if they were not posted.
				if (empty($params)) {
					$params = $instance->config['shortcode_structure'];
				}

				if (!empty($params)) {
					$params = str_replace('#_EDITTED', '', $params);
					$extract_params = ST_Pb_Helper_Shortcode::extract_params($params, $shortcode);

					$extract_params = ST_Pb_Helper_Shortcode::check_and_assign_id($extract_params, $shortcode, true);

					// if have sub-shortcode, extract sub shortcodes content
					if (!empty($instance->config['has_subshortcode'])) {
						$sub_sc_data = ST_Pb_Helper_Shortcode::extract_sub_shortcode($params, true);
						$sub_sc_data = apply_filters('st_pb_sub_items_filter', $sub_sc_data, $shortcode, isset($_COOKIE['st_pb_data_for_modal']) ? $_COOKIE['st_pb_data_for_modal'] : '');
						$extract_params['sub_items_content'] = $sub_sc_data;
					}

					// Set auto title for the subitem if have
					$extract_title = (isset($el_title) && $el_title != __('(Untitled)', ST_PBL)) ? $el_title : '';

					// MODIFY $instance->items
					ST_Pb_Helper_Shortcode::generate_shortcode_params($instance->items, NULL, $extract_params, TRUE, FALSE, $extract_title, $has_preview, $preview_config);

					// if have sub-shortcode, re-generate shortcode structure
					if (!empty($instance->config['has_subshortcode'])) {
						$instance->shortcode_data();
					}

				}

				// get Modal setting box
				$settings = $instance->items;
				$settings_html .= ST_Pb_Objects_Modal::get_shortcode_modal_settings($settings, $shortcode, $extract_params, $params, $has_preview, $no_tab);

				// Add preview
				if ($has_preview) {
					//$settings_html .= ST_Pb_Helper_Shortcode::render_parameter( 'preview' );
					//$settings_html .= '<div style="display:none;" id="cbb-element-supports-preview" data-size="'.$preview_config['size'].'"></div>';

					$settings_html .= '<div style="display:none;" id="cbb-preview-config" ';
					foreach ($preview_config as $pre_key => $pre_val) {
						$settings_html .= 'data-' . $pre_key . '="' . $pre_val . '"';
					}
					$settings_html .= ' ></div>';
				}

				$html = balanceTags($settings_html);
			}

			return $html;
		}

		public static function _modal_footer() {

		}

	}
}
