<?php

if ( ! class_exists( 'ST_Pb_Objects_Widget' ) ) {

	class ST_Pb_Objects_Widget extends WP_Widget {

		var $st_widget_cssclass;
		var $st_widget_description;
		var $st_widget_idbase;
		var $st_widget_name;

		/**
		 * constructor
		 *
		 * @access public
		 * @return void
		 */
		function ST_Pb_Objects_Widget() {
			$this->st_widget_cssclass    = 'st-widget-pagebuilder';
			$this->st_widget_description = __( 'Presentation of any PageBuilder element', ST_PBL );
			$this->st_widget_idbase      = 'st_widget_pagebuilder';
			$this->st_widget_name        = __( 'PageBuilder Element', ST_PBL );

			/* Widget settings. */
			$widget_ops = array( 'classname' => $this->st_widget_cssclass, 'description' => $this->st_widget_description );

			/* Create the widget. */
			$this->WP_Widget( 'st_widget_pagebuilder', $this->st_widget_name, $widget_ops );
		}

		/**
		 * widget function
		 *
		 * @see WP_Widget::widget()
		 * @access public
		 * @param array $args
		 * @param array $instance
		 * @return void
		 */
		function widget( $args, $instance ) {
			extract( $args );
			$title = $shortcode = '';
			// process shortcode
			if ( isset( $instance['st_widget_shortcode'] ) ) {
				$shortcode = $instance['st_widget_shortcode'];
				if ( ! $title ) {
					$str_title = substr( $shortcode, strpos( $shortcode, 'el_title=--quote--' ) );
					$str_title = str_replace( 'el_title=--quote--', '', $str_title );
					$title     = substr( $str_title, 0, strpos( $str_title, '--quote--' ) );
				}
				$shortcode = str_replace( '--quote--', '"', $shortcode );
				$shortcode = str_replace( '--open_square--', '[', $shortcode );
				$shortcode = str_replace( '--close_square--', ']', $shortcode );
			}
			if ( ! $title ) {
				global $St_Pb;
				$elements = $St_Pb->get_elements();
				if ( isset( $elements['element'] ) ) {
					foreach ( $elements['element'] as $idx => $element ) {
						// don't show sub-shortcode
						if ( ! isset( $element->config['name'] ) )
						continue;
						if ( isset( $instance['st_element'] ) && $element->config['shortcode'] == $instance['st_element'] ) {
							$title = $element->config['name'];
						}
					}
				}
			}
			// process widget title
			$title = apply_filters( 'widget_title', empty($instance['st_element'] ) ? __( 'PageBuilder Element', ST_PBL ) : $title, $instance, $this->id_base );
			echo balanceTags( $before_widget );
			if ( $title ) {
				echo balanceTags( $before_title . $title . $after_title );
			}
			echo '<div class="jsn-bootstrap3">';
			echo balanceTags( do_shortcode( $shortcode ) );
			echo '</div>';
			echo balanceTags( $after_widget );
		}

		/**
		 * update pagebuilder widget element
		 *
		 * @see WP_Widget::update()
		 */
		function update( $new_instance, $old_instance ) {
			$instance                        = $old_instance;
			$instance['st_element']          = strip_tags( $new_instance['st_element'] );
			$instance['st_widget_shortcode'] = $new_instance['st_widget_shortcode'];

			return $instance;
		}

		/**
		 * form function.
		 *
		 * @see WP_Widget::form()
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		function form( $instance ) {
			// Default
			$instance            = wp_parse_args( (array ) $instance, array( 'st_element' => '', 'st_widget_shortcode' => '' ) );
			$title               = '';
			$selected_value      = esc_attr( $instance['st_element'] );
			$st_widget_shortcode = $instance['st_widget_shortcode'];

			global $St_Pb;
			$elements      = $St_Pb->get_elements();
			$elements_html = array();
			if ( $elements ) {
				foreach ( $elements['element'] as $idx => $element ) {
					// don't show sub-shortcode
					if ( ! isset( $element->config['name'] ) )
					continue;
					if ( $element->config['shortcode'] == $selected_value ) {
						$elements_html[] = '<option value="' . $element->config['shortcode'] . '" selected="selected">' . $element->config['name'] . '</option>';
						$title           = $element->config['name'];
					} else {
						$elements_html[] = '<option value="' . $element->config['shortcode'] . '">' . $element->config['name'] . '</option>';
					}
				}
			}
			?>
<div class="jsn-bootstrap3">

	<div class="st-widget-setting">
	<?php
	if ( ! $elements ) {
		echo '<p>' . sprintf( __( 'No elements have been created yet!  ', ST_PBL ) ) . '</p>';
		return;
	}
	?>
		<label
			for="<?php echo esc_attr( $this->get_field_id( 'st_element' ) ); ?>"><?php _e( 'Element', ST_PBL ) ?>
		</label>
		<div
			class="form-group control-group clearfix combo-group st-widget-box">
			<div class="controls">
				<div class="combo-item">
					<select class="st_widget_select_elm"
						id="<?php echo esc_attr( $this->get_field_id( 'st_element' ) ); ?>"
						name="<?php echo esc_attr( $this->get_field_name( 'st_element' ) ); ?>">
						<?php
						// shortcode elements
						foreach ( $elements_html as $idx => $element ) {
							echo balanceTags( $element );
						}
						?>
					</select>
				</div>
				<div class="combo-item">
					<a id="st_widget_edit_btn" class="st_widget_edit_btn btn btn-icon"
						data-shortcode="<?php echo esc_attr( $selected_value ) ?>"><i
						class="icon-pencil"></i><i class="jsn-icon16 jsn-icon-loading"
						id="st-widget-loading" style="display: none"></i> </a>
				</div>
				<input class="st_shortcode_widget" type="hidden"
					id="<?php echo esc_attr( $this->get_field_id( 'st_widget_shortcode' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'st_widget_shortcode' ) ); ?>"
					value="<?php echo esc_attr( $st_widget_shortcode ); ?>" />
				<div class="jsn-section-content jsn-style-light hidden"
					id="form-design-content">
					<div class="st-pb-form-container jsn-layout">
						<input type="hidden" id="st-select-media" value="" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
						<?php
		}

	}

}
