<?php

?>
<div class="wrap jsn-bootstrap3">
	<h2><?php _e( $plugin['Name'], ST_LIBRARY_TEXTDOMAIN ); ?> <?php _e( 'Add-ons', ST_LIBRARY_TEXTDOMAIN ); ?></h2>
	<p>
		<?php printf( __( 'Extend %s functionality with following add-ons', ST_LIBRARY_TEXTDOMAIN ), __( $plugin['Name'], ST_LIBRARY_TEXTDOMAIN ) ); ?>
	</p>
	<div id="st-product-addons">
		<ul id="<?php echo '' . $plugin['Identified_Name']; ?>-addons" class="thumbnails clearfix">
			<?php foreach ( $plugin['Addons'] as $identified_name => $details ) : ?>
			<li class="thumbnail pull-left">
				<a href="<?php echo esc_url( $details->url ); ?>" target="_blank">
					<img src="<?php echo esc_url( $details->thumbnail ); ?>" alt="<?php esc_attr_e( $details->name, ST_LIBRARY_TEXTDOMAIN ) ?>" />
				</a>
				<?php if ( ! $details->compatible ) : ?>
				<span class="label label-danger"><?php _e( 'Incompatible', ST_LIBRARY_TEXTDOMAIN ); ?></span>
				<?php elseif ( $details->installed ) : ?>
				<span class="label label-success"><?php _e( 'Installed', ST_LIBRARY_TEXTDOMAIN ); ?></span>
				<?php endif; ?>
				<div class="caption">
					<h3><?php _e( $details->name, ST_LIBRARY_TEXTDOMAIN ) ?></h3>
					<p><?php _e( $details->description, ST_LIBRARY_TEXTDOMAIN ) ?></p>
					<div class="actions clearfix">
						<div class="pull-left">
							<?php if ( ! $details->installed ) : ?>
							<a class="btn btn-primary <?php if ( ! $details->compatible ) echo 'disabled'; ?>" href="javascript:void(0);" <?php if ( $details->compatible ) : ?>data-action="install" data-authentication="<?php echo absint( $details->authentication ); ?>" data-identification="<?php echo '' . $details->identified_name; ?>"<?php endif; ?>>
								<?php _e( 'Install', ST_LIBRARY_TEXTDOMAIN ); ?>
							</a>
							<?php else : if ( $details->updatable ) : ?>
							<a class="btn btn-primary <?php if ( ! $details->compatible ) echo 'disabled'; ?>" href="javascript:void(0);" data-action="update" <?php if ( $details->compatible ) : ?>data-authentication="<?php echo absint( $details->authentication ); ?>" data-identification="<?php echo '' . $details->identified_name; ?>"<?php endif; ?>>
								<?php _e( 'Update', ST_LIBRARY_TEXTDOMAIN ); ?>
							</a>
							<?php endif; ?>
							<a class="btn <?php if ( ! $details->updatable ) echo 'btn-primary'; ?> <?php if ( ! $details->compatible ) echo 'incompatible'; ?>" href="javascript:void(0);" data-action="uninstall" data-authentication="<?php echo absint( $details->authentication ); ?>" data-identification="<?php echo '' . $details->identified_name; ?>">
								<?php _e( 'Uninstall', ST_LIBRARY_TEXTDOMAIN ); ?>
							</a>
							<?php endif; ?>
						</div>
						<a class="btn btn-info pull-right" href="<?php echo esc_url( $details->url ); ?>" target="_blank">
							<?php _e( 'More Info', ST_LIBRARY_TEXTDOMAIN ); ?>
						</a>
					</div>
				</div>
			</li>
			<?php endforeach; ?>
		</ul>
	</div>
</div>
<div class="jsn-bootstrap3 st-product-addons-authentication">
	<div class="modal fade" id="<?php echo '' . $plugin['Identified_Name']; ?>-authentication" tabindex="-1" role="dialog" aria-labelledby="<?php echo '' . $plugin['Identified_Name']; ?>-authentication-modal-label" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title" id="<?php echo '' . $plugin['Identified_Name']; ?>-authentication-modal-label">
						<?php _e( 'WooRockets Customer Account', ST_LIBRARY_TEXTDOMAIN ); ?>
					</h4>
				</div>
				<div class="modal-body">
					<form name="ST_Addons_Authentication" method="POST" class="form-horizontal" autocomplete="off">
						<div class="alert alert-danger hidden">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
							<span class="message"></span>
						</div>
						<div class="form-group clearfix">
							<label class="col-sm-3 control-label" for="username"><?php _e( 'Username', ST_LIBRARY_TEXTDOMAIN ); ?>:</label>
							<div class="col-sm-9">
								<input type="text" value="" class="form-control" id="username" name="username" autocomplete="off" />
							</div>
						</div>
						<div class="form-group clearfix">
							<label class="col-sm-3 control-label" for="password"><?php _e( 'Password', ST_LIBRARY_TEXTDOMAIN ); ?>:</label>
							<div class="col-sm-9">
								<input type="password" value="" class="form-control" id="password" name="password" autocomplete="off" />
							</div>
						</div>
						<div class="form-group clearfix">
							<div class="col-sm-9 pull-right">
								<div class="checkbox-inline">
									<label>
										<input type="checkbox" value="1" id="remember" name="remember" autocomplete="off" />
										<?php _e( 'Remember Me', ST_LIBRARY_TEXTDOMAIN ); ?>
									</label>
								</div>
							</div>
						</div>
					</form>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary"><?php _e( 'Install', ST_LIBRARY_TEXTDOMAIN ); ?></button>
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php _e( 'Cancel', ST_LIBRARY_TEXTDOMAIN ); ?></button>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
// Load inline script initialization
$script = '
		new $.ST_ProductAddons({
			base_url: "' . esc_url( admin_url( 'admin-ajax.php?action=st-addons-management' ) ) . '",
 			core_plugin: "' . $plugin['Identified_Name'] . '",
 			has_saved_account: ' . ( $has_customer_account ? 'true' : 'false' ) . ',
			language: {
				CANCEL: "' . __( 'Cancel', ST_LIBRARY_TEXTDOMAIN ) . '",
				INSTALL: "' . __( 'Install', ST_LIBRARY_TEXTDOMAIN ) . '",
				UNINSTALL: "' . __( 'Uninstall', ST_LIBRARY_TEXTDOMAIN ) . '",
				INSTALLED: "' . __( 'Installed', ST_LIBRARY_TEXTDOMAIN ) . '",
				INCOMPATIBLE: "' . __( 'Incompatible', ST_LIBRARY_TEXTDOMAIN ) . '",
				UNINSTALL_CONFIRM: "' . __( 'Are you sure you want to uninstall %s?', ST_LIBRARY_TEXTDOMAIN ) . '",
				AUTHENTICATING: "' . __( 'Verifying...', ST_LIBRARY_TEXTDOMAIN ) . '",
				INSTALLING: "' . __( 'Installing...', ST_LIBRARY_TEXTDOMAIN ) . '",
				UPDATING: "' . __( 'Updating...', ST_LIBRARY_TEXTDOMAIN ) . '",
				UNINSTALLING: "' . __( 'Uninstalling...', ST_LIBRARY_TEXTDOMAIN ) . '",
			}
		});';

ST_Pb_Init_Assets::inline( 'js', $script );
