<?php

/*
 * Parent class for sub elements
 */

class ST_Pb_Shortcode_Child extends ST_Pb_Shortcode_Element {

	/**
	 * Over write parent method
	 *
	 * @param string $content
	 * @param string $shortcode_data
	 * @param string $el_title
	 * @param int $index
	 * @param bool $inlude_sc_structure
	 * @param array $extra_params
	 * @return string
	 */
	public function element_in_pgbldr( $content = '', $shortcode_data = '', $el_title = '', $index = '', $inlude_sc_structure = true, $extra_params = array(), $extracted_params = array() ) {
		$this->config['sub_element'] = true;
		return parent::element_in_pgbldr( $content, $shortcode_data, $el_title, $index, $inlude_sc_structure, $extra_params );
	}


	/**
	 * Get params & structure of shortcode
	 */
	public function shortcode_data() {
		$params = ST_Pb_Helper_Shortcode::generate_shortcode_params( $this->items, null, null, false, true );

		

		$this->config['params'] = $params;

		// for content of param which has: role = content
		if( isset($this->config['params']['extract_shortcode_content']) )
			$params['extract_shortcode_content'] = $this->config['params']['extract_shortcode_content'];
		
		$this->config['shortcode_structure'] = ST_Pb_Helper_Shortcode::generate_shortcode_structure( $this->config['shortcode'], $params );
	}

}
