<?php

/*
 * Parent class for all elements of page builder
 */
class ST_Pb_Shortcode_Common {

	/**
	 * element type: layout/element
	 */
	public $type;

	/**
	 * config information of this element
	 */
	public $config;

	/**
	 * setting options of this element
	 */
	public $items;

	public function __construct() {
		// Register required assets
		add_filter( 'st-edit-element-required-assets', array( &$this, 'required_assets' ) );
	}

	/**
	 * Define required assets for shortcode settings form.
	 *
	 * @param   array  $assets  Current required assets.
	 *
	 * @return  array
	 */
	public function required_assets( $assets ) {
		if ( ! isset( $_GET['st_shortcode_preview'] ) || ! $_GET['st_shortcode_preview'] ) {
			// Register admin assets if required
			if ( @is_array( $this->config['exception'] ) && isset( $this->config['exception']['admin_assets'] ) ) {
				$assets[] = $this->config['exception']['admin_assets'];
			}
		} else {
			// Register front-end assets if required
			if ( @is_array( $this->config['exception'] ) && isset( $this->config['exception']['frontend_assets'] ) ) {
				$assets[] = $this->config['exception']['frontend_assets'];
			}
		}
		return $assets;
	}
	
	
	/**
	 * Common output for all shortcodes. CSS Filter add
	 *
	 * $output: Final output from elements and layouts
	 * @since 0.0.1
	 */
	public function common_wrapper($output, $atts, $content, $name='')
	{
		if(! is_array($output))
		{
			return $output;
		}
		
		$output['content'] .= ST_Pb_Utils_Css::generate_css($output['atts'], $this->items);
		
		return $output['content'];
	}

	/*
	 * HTML structure of an element in SELECT ELEMENT modal box
	 */

	public function element_button( $sort ) {

	}

	/*
	 * HTML structure of an element in Page Builder area
	 */

	public function element_in_pgbldr() {

	}
	
	
	/**
	 * DEFINE html structure of shortcode in Page Builder area
	 *
	 * @param string $content
	 * @param string $shortcode_data: string stores params (which is modified default value) of shortcode
	 * @param string $el_title: Element Title used to identifying elements in ProStyler Builder
	 * @param int $index
	 * @param bool $inlude_sc_structure
	 * @param array $extra_params
	 * Ex:  param-tag=h6&param-text=Your+heading&param-font=custom&param-font-family=arial
	 * @return string
	 */
	public function element_in_pgbldr_frontend( $output, $atts = '', $content = '' ) {

		$shortcode		  = $this->config['shortcode'];
		$is_sub_element   = ( isset( $this->config['sub_element'] ) ) ? true : false;
		$parent_shortcode = ( $is_sub_element ) ? str_replace( 'st_item_', '', $shortcode ) : $shortcode;
		$type			  = ! empty( $this->config['el_type'] ) ? $this->config['el_type'] : 'widget';



		$exception   = isset( $this->config['exception'] ) ? $this->config['exception'] : array();
		$modal_title = '';
		// if is widget
		if ( $type == 'widget' ) {
			global $St_Pb_Widgets;
			if ( isset( $St_Pb_Widgets[$shortcode] ) && is_array( $St_Pb_Widgets[$shortcode] ) && isset( $St_Pb_Widgets[$shortcode]['identity_name'] ) ) {
				$modal_title = $St_Pb_Widgets[$shortcode]['identity_name'];
			}
		}

		// element name
		$name = ucfirst( str_replace( 'st_', '', $shortcode ) );

		$shortcode_data  = ST_Pb_Helper_Shortcode::generate_shortcode_structure( $shortcode, $atts, $content );
		
		$element_wrapper = ! empty( $exception['item_wrapper'] ) ? $exception['item_wrapper'] : ( $is_sub_element ? 'li' : 'div' );
		//$content_class   = ( $is_sub_element ) ? 'jsn-item-content' : 'st-pb-element';
		$content_class   = 'jsn-item-content st-pb-element';
		$modal_title     = empty ( $modal_title ) ? ( ! empty( $exception['data-modal-title'] ) ? "data-modal-title='{$exception['data-modal-title']}'" : '' ) : $modal_title;
		$element_type    = "data-el-type='$type'";				
		$edit_using_ajax = $this->config['edit_using_ajax'] ? sprintf( "data-using-ajax='%s'", esc_attr( $this->config['edit_using_ajax'] ) ) : '';
		$data = array(
			'element_wrapper' => $element_wrapper,
			'modal_title' => $modal_title,
			'element_type' => $element_type,
			'edit_using_ajax' => $edit_using_ajax,
			'edit_inline' => isset( $this->config['edit_inline'] ) ? 1 : 0,
			'name' => $name,
			'shortcode' => $shortcode,
			'shortcode_data' => $shortcode_data,
			'content_class' => $content_class,
			'content' => $content,
			'action_btn' => empty( $exception['action_btn'] ) ? '' : $exception['action_btn'],
			'is_sub_element' => $is_sub_element,
		);
		// Merge extra params if it exists.
		if ( ! empty( $extra_params ) ) {
			$data = array_merge( $data, $extra_params );
		}
		$extra = array();


		$data = array_merge( $data, $extra );

		extract( $data );


		$enable_inline_edit = $edit_inline;

		$extra_class  = ST_Pb_Utils_Placeholder::get_placeholder( 'extra_class' );
		$custom_style = ST_Pb_Utils_Placeholder::get_placeholder( 'custom_style' );
		$other_class  = '';

		// Check if this element is deactivate
		preg_match_all( '/\[' . $shortcode . '\s+([A-Za-z0-9_-]+=\"[^"\']*\"\s*)*\s*\]/', $shortcode_data, $rg_sc_params );
		if ( ! empty( $rg_sc_params[0] ) ) {
			$sc_name_params = ! empty( $rg_sc_params[0][0] ) ? $rg_sc_params[0][0] : $rg_sc_params[0];
			if( strpos( $sc_name_params , 'disabled_el="yes"') !== false ) {
				$other_class = 'disabled';
			}
		}

		// ------------------------------------------------------
		//  yunus edit - removed this as we dont want empty values to be inserted back with STD value
		// ------------------------------------------------------
		// Remove empty value attributes of shortcode tag.
		//$shortcode_data = preg_replace( '/\[*([a-z_]*[\n\s\t]*=[\n\s\t]*""\s)/', '', $shortcode_data );


		// action buttons
		$edit_icon = 'icon-pencil';

		$edit_btn = apply_filters( 'edit_btn_class', 'element-edit', $shortcode );

		$buttons = array(
			'edit'       => '<a href="#" onclick="return false;" title="' . __( 'Edit element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="' . $edit_btn . ( $enable_inline_edit ? '-sub' : '' ) . '"><i class="' . $edit_icon . '"></i></a>',
			'clone'      => '<a href="#" onclick="return false;" title="' . __( 'Duplicate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-clone"><i class="icon-copy"></i></a>',
			'deactivate' => '<a href="#" onclick="return false;" title="' . __( 'Deactivate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-deactivate"><i class="icon-checkbox-unchecked"></i></a>',
			'delete'     => '<a href="#" onclick="return false;" title="' . __( 'Delete element', ST_PBL ) . '" class="element-delete"><i class="icon-trash"></i></a>'
			);

			if ( ! empty ( $other_class ) ) {
				$buttons = array_merge(
				$buttons, array(
					'deactivate' => '<a href="#" onclick="return false;" title="' . __( 'Activate element', ST_PBL ) . '" data-shortcode="' . $shortcode . '" class="element-deactivate"><i class="icon-checkbox-partial"></i></a>',
				)
				);
			}

			$action_btns = ( empty( $action_btn ) ) ? implode( '', $buttons ) : $buttons[$action_btn];
			$buttons     = apply_filters( 'st_pb_button_in_pagebuilder', "<div class='jsn-iconbar'>$action_btns</div>", $shortcode_data, $shortcode );

			$before_output = $after_output = '';
			
			
		
			switch($this->type)
			{
				case 'layout':
					$shortcode_data = explode( '][', $shortcode_data );
					$shortcode_data = $shortcode_data[0] . ']';
					$shortcode_data = esc_textarea($shortcode_data);
					
					//$shortcode_data = urlencode($shortcode_data);
					$shortcode_data = str_replace('[', '{{', $shortcode_data);
					$shortcode_data = str_replace(']', '}}', $shortcode_data);
		
					$before_output .= '<textarea class="hidden" data-sc-info="shortcode_content" name="shortcode_content[]" >' . $shortcode_data . '</textarea>';
					
					$after_output .= '<textarea class="hidden" data-sc-info="shortcode_content" name="shortcode_content[]" >[/' . $this->config['shortcode'] . ']</textarea>';
				break;
				default:
					$shortcode_data = esc_textarea($shortcode_data);
					$shortcode_data = str_replace('[', '{{', $shortcode_data);
					$shortcode_data = str_replace(']', '}}', $shortcode_data);
					
					$before_output .= '';
					$after_output .= '<textarea class="hidden" data-sc-info="shortcode_content" name="shortcode_content[]" >' . $shortcode_data . '</textarea>';
				break;
			}
			
			$after_output = "<$element_wrapper class='st_element_controls jsn-item jsn-element shortcode-container $extra_class $other_class' $modal_title $element_type $edit_using_ajax data-name='$name' $custom_style>
				$after_output
			
				$buttons
			</$element_wrapper>";
		
			
			$output = $before_output . $output . $after_output;

			return $output;
	}
	

	public function init_element() {

	}


	public function create_param_defaults()
	{
		$tabs = $this->items;

		foreach ( $tabs as $tab_key => $tab_fields ) // for each tabs
		{
			// $tabs[ $tab_key ]
			foreach ( $tab_fields as $field_k => $field_v ) // for each field in tab
			{
				$tabs[ $tab_key ][ $field_k ] = self::recur_add_default( $tabs[ $tab_key ][ $field_k ] );
			}
		}

		$this->items = $tabs;
	}

	public static function recur_add_default($field)
	{
		if(is_array($field) )
		{
			// for current field
			if(isset( $field['std'] ))
			{
				$field['default_val'] = $field['std'];
			}

			// for sub fields recrussivily do the same function for each
			if ( isset( $field['type'] ) && is_array($field['type']) ) 
			{
				foreach ( $field['type'] as $sub_field_key => $sub_field ) 
				{
					$field['type'][ $sub_field_key ] = self::recur_add_default( $sub_field );
				}
			}

			// for extended ids for fields like padding, margins etc
			if ( isset( $field['extended_ids'] ) && is_array($field['extended_ids']) ) 
			{
				foreach ( $field['extended_ids'] as $extended_id ) 
				{
					if(! isset($field[ $extended_id ])) continue;

					$val = $field[ $extended_id ];
					if(! isset( $val['std'] )) continue;
					
					$field[ $extended_id ]['default_val'] = $val['std'];
				}
			}
		}

		return $field;
	}

	/**
	 * Used by CSS Helper to generate css for wp head
	 * @param  array $atts    element params
	 * @param  string $content element content
	 * @return void          
	 */
	public function css_helper_hook_echo_extra_css( $atts = null, $content = null )
	{

	}


}
