<?php
/**
 * @version	$Id$
 * @package	ProStyler Builder
 * @author	 WooRockets Team <support@www.woorockets.com>
 * @copyright  Copyright (C) 2012 www.woorockets.com. All Rights Reserved.
 * @license	GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.www.woorockets.com
 * Technical Support:  Feedback - http://www.www.woorockets.com
 */
/*
 * Parent class for normal elements
 */

class ST_Pb_Shortcode_Element extends ST_Pb_Shortcode_Common
{
    public function __construct()
    {
        $this->type = 'element';
        $this->config['el_type'] = 'element';

        $this->element_config();

        // add shortcode
        add_shortcode($this->config['shortcode'], array( &$this, 'element_shortcode_start' ));
    }

    /**
     *
     *
     * @param array $atts
     * @param string $content
     */
    public function element_shortcode_start($atts = null, $content = null, $name = '')
    {
        // // performance test START
        // $start_time = microtime(true);
        // $start_memory = memory_get_usage();
        
		$atts = ST_Pb_Helper_Shortcode::check_and_assign_id($atts, $name);
        if (ST_Pb_Utils_Css::doing_css()) {
            return ST_Pb_Utils_Css::shortcode($this, $atts, $content);
        }

        $output = $this->element_shortcode($atts, $content, $name);

        // // performance test END
        // $end_time = microtime(true);
        // $end_memory = memory_get_usage();
        // $timeTaken = bcsub($end_time, $start_time, 4);
        // CBB_Init::$log[ $name ][] = array(
        //     'timeTaken' => $timeTaken
        // );

        return $output;
    }


    public function tiny_mce_plugins($plugins)
    {
        unset($plugins['wplink']);
        //echo '<pre>'.print_r($plugins, TRUE).'</pre>';
        $p = array();
        foreach ($plugins as $val) {
            //echo '<pre>'.print_r($val, TRUE).'</pre>';
            if ($val == 'wplink') {
                continue;
            }
            $p[] = $val;
        }

        _WP_Editors::$qt_buttons['link'];

        return $p;
    }

    /**
     * Method to call neccessary functions for initialyzing the backend
     */
    public function init_element()
    {
        //add_filter( 'tiny_mce_plugins', array($this, 'tiny_mce_plugins'), 9, 1 );
        $this->items['content'] = array();
        $this->items['styling'] = array();
        $this->items['mobile'] = array();
        $this->items['advance'] = array();


        $this->element_items();
        $this->element_items_extra();
        $this->create_param_defaults();
        $this->shortcode_data();

        do_action('st_pb_element_init');

        parent::__construct();

        // enqueue assets for current element in backend (modal setting iframe)
        if (ST_Pb_Helper_Functions::is_modal_of_element($this->config['shortcode'])) {
            add_action('pb_admin_enqueue_scripts', array( &$this, 'enqueue_assets_modal' ));
        }

        // enqueue assets for current element in backend (preview iframe)
        if (ST_Pb_Helper_Functions::is_preview()) {
            add_action('pb_admin_enqueue_scripts', array( &$this, 'enqueue_assets_frontend' ));
        }

        // ------------------------------------------------------
        //  yunus edit - since v1.86 - add link duplicate issue fix
        // ------------------------------------------------------
        if (isset($_GET['st-gadget'])) {
            add_action('wp_enqueue_editor', array($this, 'wplink'));
        }
    }

    // ------------------------------------------------------
    //  yunus edit - since v1.86 - add link duplicate issue fix
    // ------------------------------------------------------
    public function wplink()
    {
        wp_dequeue_script('wplink');
    }

    /**
     * Custom assets for frontend
     */
    public function custom_assets_frontend()
    {
        // enqueue custom assets here
    }

    /**
     * Enqueue scripts for frontend
     */
    public function enqueue_assets_frontend()
    {
        ST_Pb_Helper_Functions::shortcode_enqueue_assets($this, 'frontend_assets', '_frontend');
    }

    /**
     * Enqueue scripts for modal setting iframe
     *
     * @param type $hook
     */
    public function enqueue_assets_modal($hook)
    {
        ST_Pb_Helper_Functions::shortcode_enqueue_assets($this, 'admin_assets', '');
    }

    /**
     * Define configuration information of shortcode
     */
    public function element_config()
    {
    }

    /**
     * Define setting options of shortcode
     */
    public function element_items()
    {
    }

    /**
     * Add more options to all elements
     */
    public function element_items_extra()
    {
        $shotcode_name = $this->config['shortcode'];

        $disable_el = array(
            'name' => __('Disable', ST_PBL),
            'id' => 'disabled_el',
            'type' => 'radio',
            'std' => 'no',
            'options' => array( 'yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL) ),
            'wrap_class' => 'form-group control-group hidden clearfix',
        );

        $css_wrapper = $css_suffix = $id_wrapper = array();

        // if not child element
        if (strpos($shotcode_name, 'item_') === false || ! empty($this->config['use_wrapper'])) {
            $css_wrapper = array(
                'name'    => __('CSS', ST_PBL),
                'id'      => '',
                'type'    => 'fieldset',
            );
            $css_suffix = array(
                'name'    => __('Class', ST_PBL),
                'id'      => 'css_suffix',
                'type'    => 'text_field',
                'std'     => __('', ST_PBL),
                'tooltip' => __('Custom CSS Class for the wrapper div of this element', ST_PBL)
            );
            $id_wrapper = array(
                // 'name'    => __('ID', ST_PBL),
                'id'      => 'id_wrapper',
                'type' => 'hidden',
                'std'     => __('', ST_PBL),
                // 'tooltip' => __('Custom CSS ID for the wrapper div of this element', ST_PBL),
            );
        }

        // Copy style from other element.
        $style_copy = array(
            'name'    => __('Copy Style from...', ST_PBL),
            'id'      => 'copy_style_from',
            'type'    => 'select',
            'options' => array( '0' => __('Select element', ST_PBL) ),
            'std'     => __('0', ST_PBL),
            'tooltip' => __('Copy Styling prameters from other same type element', ST_PBL),
        );

        // Add Element Title
        if (isset($this->items['content']) && strpos($shotcode_name, 'item_') === false) {
            $this->items['content'] = array_merge(
                array(
                    array(
                        'name'    => __('Element Title', ST_PBL),
                        'id'      => 'el_title',
                        'type'    => 'text_field',
                        'class'   => 'input-sm',
                        'std'     => __('', ST_PBL),
                        'role'    => 'title',
                        'tooltip' => __('Set title for current element for identifying easily', ST_PBL)
                    ),
                ),
                $this->items['content']
            );
        }

        if (isset($this->items['styling'])) {
            $this->items['styling'] = array_merge(
                $this->items['styling'], array(
                    $disable_el,
                    // always at the end of array
                    array(
                        'name'            => __('Margin', ST_PBL),
                        'container_class'    => 'combo-group',
                        'id'            => 'div_margin',
                        'type'            => 'margin',
                        'extended_ids'    => array( 'div_margin_top', 'div_margin_bottom', 'div_margin_left', 'div_margin_right' ),
                        'div_margin_top'    => array( 'std' => '0' ),
                        'div_margin_bottom'    => array( 'std' => '0' ),
                        'div_margin_left'   => array( 'std' => '0' ),
                        'div_margin_right'  => array( 'std' => '0' ),
                        'margin_elements'    => 't, b, l, r',
                        'tooltip'            => __('External spacing with other elements', ST_PBL),
                        'append'               => 'px',
                        'css' => array(
                            array('', 'margin')
                        )
                    ),
                )
            );


						// ------------------------------------------------------
            //  YUNUS EDIT - NEW SECTION
            // ------------------------------------------------------
						if(! isset($this->items['mobile'])) $this->items['mobile'] = array();
						$this->items['mobile'] = array_merge(
								array(
                                    array(
                                        'name'            => __('Margin', ST_PBL),
                                        'container_class'    => 'combo-group',
                                        'id'            => 'm_div_margin',
                                        'type'            => 'margin',
                                        'extended_ids'    => array( 'm_div_margin_top', 'm_div_margin_bottom', 'm_div_margin_left', 'm_div_margin_right' ),
                                        'm_div_margin_top'    => array( 'std' => '' ),
                                        'm_div_margin_bottom'    => array( 'std' => '' ),
                                        'm_div_margin_left'   => array( 'std' => '' ),
                                        'm_div_margin_right'  => array( 'std' => '' ),
                                        'margin_elements'    => 't, b, l, r',
                                        'tooltip'            => __('External spacing with other elements', ST_PBL),
                                        'append'               => 'px',
                                        'css' => array(
                                            'media_query' => array(
                                                'query'=>'(max-width: 829px)',
                                                'css' => array(
                                                    array('', 'margin', '%value% !important')
                                                )
                                            )
                                        )
                                    ),
									array(
											'name'     => __('Hide on', ST_PBL),
											'id'       => 'responsive_hide',
											'type'     => 'radio',
											'std'      => 'no',
											'options'  => array(
													'no' => __('None', ST_PBL),
													'yes' => __('Small screens', ST_PBL),
													'desktop' => __('Desktop', ST_PBL),
											),
											'after_field' => '',
											'tooltip' => __('Allows you to hide element depending on screen size', ST_PBL)
									),

								),
								$this->items['mobile']
						);
            // ------------------------------------------------------
            //  YUNUS EDIT - NEW SECTION
            // ------------------------------------------------------
            $this->items['advance'] = array(

                array(
                    'name'            => __('Wrapper Padding', ST_PBL),
                    'container_class'    => 'combo-group',
                    'id'            => 'wrapper_padding',
                    'type'            => 'margin',
                    'extended_ids'    => array( 'wrapper_padding_top', 'wrapper_padding_bottom', 'wrapper_padding_left', 'wrapper_padding_right' ),
                    'wrapper_padding_top'    => array( 'std' => '' ),
                    'wrapper_padding_bottom'    => array( 'std' => '' ),
                    'wrapper_padding_left'   => array( 'std' => '' ),
                    'wrapper_padding_right'  => array( 'std' => '' ),
                    'margin_elements'    => 't, b, l, r',
                    'tooltip'            => __('Internal spacing', ST_PBL),
					'append'               => 'px',
					'css' => array(
						array('', 'padding')
					)
                ),

                array(
                    'name'    => __('Wrapper background color', ST_PBL),
                    'id'       => 'wrapper_bg_color',
                    'type'     => 'color_picker',
                    'std'      => '',
                    'css' => array('', 'background-color', array('opacity_from' => 'wrapper_bg_opacity')),
                ),

                array(
                    'name'    => __('Wrapper background opacity', ST_PBL),
                    'id'       => 'wrapper_bg_opacity',
                    'type'     => 'slider',
                    'class'        => 'st-slider',
                    'std_max'      => '100',
                    'std'      => '100',
                    'css' => array(''),
                ),

                array(
                    'name'            => __('Wrapper Border', ST_PBL),
                    'container_class'    => 'combo-group',
                    'id'            => 'wrapper_border',
                    'type'            => 'margin',
                    'extended_ids'    => array( 'wrapper_border_top', 'wrapper_border_bottom', 'wrapper_border_left', 'wrapper_border_right' ),
                    'wrapper_border_top'    => array( 'std' => '0' ),
                    'wrapper_border_bottom'    => array( 'std' => '0' ),
                    'wrapper_border_left'   => array( 'std' => '0' ),
                    'wrapper_border_right'  => array( 'std' => '0' ),
                    'margin_elements'    => 't, b, l, r',
                ),



                array(
                    'name' => __('Wrapper Border style', ST_PBL),
                    'type' => array(
                        array(
                            'id'           => 'wrapper_border_style',
                            'type'         => 'select',
                            'class'        => 'input-sm st-border-type',
                            'std'          => 'solid',
                            'options'      => ST_Pb_Helper_Type::get_border_styles(),
                            'parent_class' => 'combo-item'
                        ),
                        array(
                            'id'           => 'wrapper_border_color',
                            'type'         => 'color_picker',
                            'std'          => '',
                            'parent_class' => 'combo-item',
                        ),
                    ),
                    'container_class' => 'combo-group',
                ),


                array(
                    'name'            => __('Rounded corners', ST_PBL),
                    'container_class'    => 'combo-group',
                    'id'            => 'wrapper_rounded',
                    'type'            => 'border_radius',
                    'extended_ids'    => array( 'wrapper_rounded_topleft', 'wrapper_rounded_bottomleft', 'wrapper_rounded_topright', 'wrapper_rounded_bottomright' ),
                    'wrapper_rounded_topleft'    => array( 'std' => '0' ),
                    'wrapper_rounded_bottomleft'    => array( 'std' => '0' ),
                    'wrapper_rounded_topright'   => array( 'std' => '0' ),
                    'wrapper_rounded_bottomright'  => array( 'std' => '0' ),
                    'border_elements'    => 'tl, bl, tr, br',
                ),

                ST_Pb_Helper_Type::get_shadow_type('wrapper_shadow'),

                

                $css_wrapper,
                $css_suffix,
                $id_wrapper,


            );


            // ------------------------------------------------------
            //  yunus edit - New help section
            // ------------------------------------------------------
            global $st_pro;
            $builder_disable_help_tab = ST_Pb_Helper_Functions::get_settings('builder_disable_help_tab');

            // if unbranded is on then disable the help tab
            if (class_exists('st_pro') && isset($st_pro) && $st_pro->is_unbranded) {
                $builder_disable_help_tab = 1;
            }

            if ($builder_disable_help_tab != 1) {
                $this->items['help'] = array(

                    array(
                        'name'    => __('', ST_PBL),
                        'id'       => 'help_frame',
                        'type'     => 'html', // <= new field type for this
                        'std'      => apply_filters('st_help_tab', '', $this->config['name']), //<= in stencilor init file
                    ),
                );
            }

            array_unshift($this->items['styling'], $style_copy);
        } else {
            if (isset($this->items['Notab'])) {
                $this->items['Notab'] = array_merge(
                    $this->items['Notab'], array(
                        $css_suffix,
                        $id_wrapper,
                        $disable_el,
                    )
                );
            }
        }



    }

    /**
     * DEFINE html structure of shortcode in Page Builder area
     *
     * @param string $content
     * @param string $shortcode_data: string stores params (which is modified default value) of shortcode
     * @param string $el_title: Element Title used to identifying elements in ProStyler Builder
     * @param int $index
     * @param bool $inlude_sc_structure
     * @param array $extra_params
     * Ex:  param-tag=h6&param-text=Your+heading&param-font=custom&param-font-family=arial
     * @return string
     */
    public function element_in_pgbldr($content = '', $shortcode_data = '', $el_title = '', $index = '', $inlude_sc_structure = true, $extra_params = array(), $extracted_params = array())
    {



        // Init neccessary data to render element in backend.
        $this->init_element();

        $shortcode          = $this->config['shortcode'];
        $is_sub_element   = (isset($this->config['sub_element'])) ? true : false;
        $parent_shortcode = ($is_sub_element) ? str_replace('st_item_', '', $shortcode) : $shortcode;
        $type              = ! empty($this->config['el_type']) ? $this->config['el_type'] : 'widget';

        // Empty content if this is not sub element
        if (! $is_sub_element) {
            $content = '';
        }

        $exception   = isset($this->config['exception']) ? $this->config['exception'] : array();
        $content     = (isset($exception['default_content'])) ? $exception['default_content'] : $content;
        $modal_title = '';

        // if is widget
        if ($type == 'widget') {
            global $St_Pb_Widgets;
            if (isset($St_Pb_Widgets[$shortcode]) && is_array($St_Pb_Widgets[$shortcode]) && isset($St_Pb_Widgets[$shortcode]['identity_name'])) {
                $modal_title = $St_Pb_Widgets[$shortcode]['identity_name'];
                $content     = $this->config['exception']['data-modal-title'] = $modal_title;
            }
        }

        // if content is still empty, Generate it
        if (empty($content)) {
            if (! $is_sub_element) {
                $content = ucfirst(str_replace('st_', '', $shortcode));
            } else {
                if (isset($exception['item_text'])) {
                    if (! empty($exception['item_text'])) {
                        $content = ST_Pb_Utils_Placeholder::add_placeholder($exception['item_text'] . ' %s', 'index');
                    }
                } else {
                    $content = ST_Pb_Utils_Placeholder::add_placeholder((__(ucfirst($parent_shortcode), ST_PBL) . ' ' . __('Item', ST_PBL)) . ' %s', 'index');
                }
            }
        }
        $content = ! empty($el_title) ? ($content . ': ' . "<span class='st-el-title'>$el_title</span>") : $content;


        // add icon
        if (! $is_sub_element) {
            $content = self::el_icon($this->config) . $content;
        }




        // element name
        if ($type == 'element') {
            if (! $is_sub_element) {
                $name = ucfirst(str_replace('st_', '', $shortcode));
            } else {
                $name = __(ucfirst($parent_shortcode), ST_PBL) . ' ' . __('Item', ST_PBL);
            }
        } else {
            $name = $content;
        }
        if (empty($shortcode_data)) {
            $shortcode_data = $this->config['shortcode_structure'];
        }

        // Process index for subitem element
        if (! empty($index)) {
            $shortcode_data = str_replace('_ST_INDEX_', $index, $shortcode_data);
        }

        $shortcode_data  = stripslashes($shortcode_data);
        
        $element_wrapper = ! empty($exception['item_wrapper']) ? $exception['item_wrapper'] : ($is_sub_element ? 'li' : 'div');
        //$content_class   = ($is_sub_element) ? 'jsn-item-content' : 'st-pb-element';
        $content_class   = 'jsn-item-content st-pb-element';
        $modal_title     = empty($modal_title) ? (! empty($exception['data-modal-title']) ? "data-modal-title='{$exception['data-modal-title']}'" : '') : $modal_title;
        $element_type    = "data-el-type='$type'";
        $edit_using_ajax = (isset($this->config['edit_using_ajax']) && $this->config['edit_using_ajax']) ? sprintf("data-using-ajax='%s'", esc_attr($this->config['edit_using_ajax'])) : '';
        $data = array(
            'element_wrapper' => $element_wrapper,
            'modal_title' => $modal_title,
            'type' => $type, // original type 
            'element_type' => $element_type, // data-el-type='$type'
            'edit_using_ajax' => $edit_using_ajax,
            'edit_inline' => isset($this->config['edit_inline']) ? 1 : 0,
            'name' => $name,
            'shortcode' => $shortcode,
            'shortcode_data' => $shortcode_data,
            'content_class' => $content_class,
            'content' => $content,
            'action_btn' => empty($exception['action_btn']) ? '' : $exception['action_btn'],
            'is_sub_element' => $is_sub_element,
            'extracted_params' =>  $extracted_params // if any
            //'icon_html' => self::el_icon($config),
        );

        // Merge extra params if it exists.
        if (! empty($extra_params)) {
            $data = array_merge($data, $extra_params);
        }
        $extra = array();
        if (isset($this->config['exception']['disable_preview_container'])) {
            $extra = array(
                'has_preview' => false,
            );
        }

        $data = array_merge($data, $extra);
        $html_preview = ST_Pb_Helper_Functions::get_element_item_html($data, $inlude_sc_structure);

        return array(
        $html_preview
        );
    }





    /**
     * DEFINE shortcode content
     *
     * @param array $atts
     * @param string $content
     */
    public function element_shortcode_full($atts = null, $content = null)
    {
    }




    /**
     * return shortcode content: if shortcode is disable, return empty
     *
     * @param array $atts
     * @param string $content
     */
    public function element_shortcode($atts = null, $content = null, $name = '')
    {

        // backup data for later use
        $this->original_atts = $atts;
        $this->original_content = $content;

        // ------------------------------------------------------
        //  Yunus edit - let themes modify shortcode data
        // ------------------------------------------------------
        $atts = apply_filters('st_shortcode_attrs', $atts);
        $content = apply_filters('st_shortcode_content', $content);

        // ------------------------------------------------------
        //  Yunus edit - decode html entities
        // ------------------------------------------------------
        if ($atts && is_array($atts)) {
            $atts_raw = $atts;
            $atts = array();
            foreach ($atts_raw as $key=>$val) {
                if (is_string($val)) {
                    $val = ST_Pb_Helper_Functions::st_entities_decode($val);
                }
                $atts[ $key ] = $val;
            }
        }

        $this->init_element();

        $prefix = 'wp';

        // enqueue custom assets at footer of frontend/backend
        add_action("{$prefix}_footer", array( &$this, 'custom_assets_frontend' ));
        $arr_params = (shortcode_atts($this->config['params'], $atts));
        if ($arr_params['disabled_el'] == 'yes') {
            if (ST_Pb_Helper_Functions::is_preview()) {
                return ''; //_e( 'This element is deactivated. It will be hidden at frontend', ST_PBL );
            }

            return '';
        }

        // enqueue script for current element in frontend
        add_action('wp_footer', array( &$this, 'enqueue_assets_frontend' ), 1);
        // get full shortcode content

        // ------------------------------------------------------
        //  if php version higher than 5.4 then do utf-8 encoding
        // since version: 1.73
        // ------------------------------------------------------
/*
        if(version_compare(PHP_VERSION, '5.4') >= 0)
        {
            //$string  = htmlentities( $content, null, 'utf-8' );
            $string  = htmlspecialchars( $content );
        }
        else
        {
            $string  = htmlspecialchars( $content );
            //$string = $content;
        }
*/
        // lets just use htmlspecialchars to avoid encoding issue all together
        $string  = htmlspecialchars($content);


        $content = str_replace("&nbsp;", "", $string);
        $content = html_entity_decode($content);

        // for child items we give unfiltered params as parent elements could progmatically add params to shortcode
        // before passing child to do shortcode
        if (strpos($this->config['shortcode'], '_item')) {
            $arr_params = $atts;
        }



        //return $this->element_shortcode_full( $atts, $content );
        return $this->common_wrapper($this->element_shortcode_full($arr_params, $content), $atts, $content, $name);
    }

    /**
     * Wrap output html of a shortcode
     *
     * @param array $arr_params
     * @param string $html_element
     * @param string $extra_class
     * @return string
     */
    public function element_wrapper($html_element, $arr_params, $extra_class = '', $custom_style = '')
    {
        $shortcode_name = ST_Pb_Helper_Shortcode::shortcode_name($this->config['shortcode']);
        $styles = array();


        if (!empty($arr_params['wrapper_border_top']) or !empty($arr_params['wrapper_border_right']) or !empty($arr_params['wrapper_border_bottom']) or !empty($arr_params['wrapper_border_left'])) {
            $styles[] = 'border-width: '.intval($arr_params['wrapper_border_top']).'px '.intval($arr_params['wrapper_border_right']).'px '.intval($arr_params['wrapper_border_bottom']).'px '.intval($arr_params['wrapper_border_left']).'px';

            if (! empty($arr_params['wrapper_border_style'])) {
                $styles[] = 'border-style: '.$arr_params['wrapper_border_style'].'';
            }

            if (! empty($arr_params['wrapper_border_color'])) {
                $styles[] = 'border-color: '.$arr_params['wrapper_border_color'].'';
            }
        }



        $apply_hiddenOverflow = false;
        if (! empty($arr_params['wrapper_rounded_topleft'])) {
            $apply_hiddenOverflow = true;
            $styles[] = '-moz-border-radius-topleft: '.intval($arr_params['wrapper_rounded_topleft']).'px;
-webkit-border-top-left-radius: '.intval($arr_params['wrapper_rounded_topleft']).'px;
 border-top-left-radius: '.intval($arr_params['wrapper_rounded_topleft']).'px;';
        }

        if (! empty($arr_params['wrapper_rounded_topright'])) {
            $apply_hiddenOverflow = true;
            $styles[] = '-moz-border-radius-topright: '.intval($arr_params['wrapper_rounded_topright']).'px;
-webkit-border-top-right-radius: '.intval($arr_params['wrapper_rounded_topright']).'px;
border-top-right-radius: '.intval($arr_params['wrapper_rounded_topright']).'px;';
        }

        if (! empty($arr_params['wrapper_rounded_bottomright'])) {
            $apply_hiddenOverflow = true;
            $styles[] = '-moz-border-radius-bottomright: '.intval($arr_params['wrapper_rounded_bottomright']).'px;
-webkit-border-bottom-right-radius: '.intval($arr_params['wrapper_rounded_bottomright']).'px;
border-bottom-right-radius: '.intval($arr_params['wrapper_rounded_bottomright']).'px;';
        }

        if (! empty($arr_params['wrapper_rounded_bottomleft'])) {
            $apply_hiddenOverflow = true;
            $styles[] = '-moz-border-radius-bottomleft: '.intval($arr_params['wrapper_rounded_bottomleft']).'px;
-webkit-border-bottom-left-radius: '.intval($arr_params['wrapper_rounded_bottomleft']).'px;
border-bottom-left-radius: '.intval($arr_params['wrapper_rounded_bottomleft']).'px;';
        }

        if($apply_hiddenOverflow)
        {
            $styles[] = 'overflow:hidden;';
        }


        $style = count($styles) ? implode('; ', $styles) : '';
        if (! empty($style) || ! empty($custom_style)) {
            $style = "style='$style $custom_style'";
        }

        $class        = "jsn-bootstrap3 st-element-container clearfix st-element-$shortcode_name";
        $extra_class .= ! empty($arr_params['css_suffix']) ? ' ' . esc_attr($arr_params['css_suffix']) : '';
        $class       .= ! empty($extra_class) ? ' ' . ltrim($extra_class, ' ') : '';
        $extra_id     = ! empty($arr_params['id_wrapper']) ? ' ' . esc_attr($arr_params['id_wrapper']) : '';
        $extra_id     = ! empty($extra_id) ? "id='" . ltrim($extra_id, ' ') . "'" : '';

        // Element appearing animation
        $appearring_animation = '';
        if (! empty($arr_params['appearing_animation']) && $arr_params['appearing_animation'] != '0') {
            $animation_speed = '0.6';
            if (! empty($arr_params['appearing_animation_speed'])) {
                switch ($arr_params['appearing_animation_speed']) {
                    case 'Slow':
                        $animation_speed = '0.9';
                        break;
                    case 'Medium':
                        $animation_speed = '0.6';
                        break;
                    case 'Fast':
                        $animation_speed = '0.3';
                        break;
                }
            }
            switch ($arr_params['appearing_animation']) {
                case 'slide_from_top':
                    $appearring_animation   = ' data-scroll-reveal="enter top and move 150px over ' . $animation_speed . 's" ';
                    break;
                case 'slide_from_right':
                    $appearring_animation   = ' data-scroll-reveal="enter right and move 150px over ' . $animation_speed . 's" ';
                    break;
                case 'slide_from_bottom':
                    $appearring_animation   = ' data-scroll-reveal="enter bottom and move 150px over ' . $animation_speed . 's" ';
                    break;
                case 'slide_from_left':
                    $appearring_animation   = ' data-scroll-reveal="enter left and move 150px over ' . $animation_speed . 's" ';
                    break;
                case 'fade_in':
                    $appearring_animation   = ' data-scroll-reveal="ease-in 0px over ' . $animation_speed . 's" ';
                    break;
            }
        }

        if (isset($arr_params['responsive_hide'])) {
            switch ($arr_params['responsive_hide']) {
                case 'yes':
                    // Hide on mobile and small screens
                    $class .= ' hidden-xs hidden-sm';
                break;

                case 'desktop':
                    // Hide on desktop
                    $class .= ' hidden-lg hidden-md';
                break;

                default:
                    // Dont hide
                break;
            }
        }

  
        $html_element = apply_filters('st_element_html', $html_element, $this);

        $html = "<div  $extra_id class='$class' $style>" . balanceTags($html_element) . '</div>';
        if ($appearring_animation) {
            $html = "<div $appearring_animation>" . $html . "</div>";
        }

        //return $html	;
        return array(
            'content'=>$html,
            'atts'=>$arr_params
        );
    }

    /**
     * Define html structure of shortcode in "Select Elements" Modal
     *
     * @param string $data_sort The string relates to Provider name to sort
     * @return string
     */
    public function element_button($data_sort = '')
    {
        // Prepare variables
        $type  = 'element';
        $data_value = strtolower($this->config['name']);

        $extra = sprintf('data-value="%s" data-type="%s" data-sort="%s"', esc_attr($data_value), esc_attr($type), esc_attr($data_sort));

        return self::el_button($extra, $this->config);
    }

    /**
     * HTML output for a shortcode in Add Element popover
     *
     * @param string $extra
     * @param array $config
     * @return string
     */
    public static function el_button($extra, $config)
    {

        // skip depreciated elements
        if (preg_match('/(DEPRECIATED)/', $config['name'])) {
            return '';
        }

        // Generate icon if necessary
        $icon = self::el_icon($config);

        // Generate data-iframe attribute if needed
        $attr = '';

        if (isset($config['edit_using_ajax']) && $config['edit_using_ajax']) {
            $attr = ' data-use-ajax="1"';
        }

        return '<li class="el_button jsn-item"' . (empty($extra) ? '' : ' ' . trim($extra)) . '>
					<button data-shortcode="' . $config['shortcode'] . '" class="shortcode-item btn btn-default" title="' . $config['description'] . '"' . $attr . '>
						' . $icon . $config['name'] . '
							<p class="help-block">' . $config['description'] . '</p>
					</button>
				</li>';
    }


    /**
     * Outputs html with icon depending on its type (image, svg, font etc)
     * @param  array $config array with icon key
     * @return string         output html
     */
    public static function el_icon($config)
    {
        $icon = isset($config['icon']) ? $config['icon'] : 'st-icon-widget';

        if (preg_match('/^http/i', $icon)) {
            if (preg_match('/\.svg$/i', $icon)) {
                $icon = '<i class="st-icon-formfields img-icon"><object type="image/svg+xml" data="'.$icon.'"></object></i> ';
            } else {
                $icon = '<i class="st-icon-formfields img-icon"><img src="'.$icon.'" /></i> ';
            }
        } else {
            $icon = '<i class="st-icon-formfields ' . $icon . '"></i> ';
        }

        return $icon;
    }


    /**
     * Get params & structure of shortcode
     */
    public function shortcode_data()
    {
        $params = ST_Pb_Helper_Shortcode::generate_shortcode_params($this->items, null, null, false, true);
        // add Margin parameter for Not child shortcode
        $this->config['params'] = array_merge(array( 'div_margin_top' => '10', 'div_margin_bottom' => '10', 'disabled_el' => 'no', 'css_suffix' => '', 'id_wrapper' => '' ), $params);

        //echo '<pre>'.print_r($this->config['shortcode'], TRUE).'</pre>';
        // if($this->config['shortcode'] == 'st_item_accordion')
        // {
        // 	echo '<pre>'.print_r($this->config['params'], TRUE).'</pre>';die();
        // }

        // @since 0.0.1, removed params as we dont want default params in shortcode
        $params = array();
        // for content of param which has: role = content
        if (isset($this->config['params']['extract_shortcode_content'])) {
            $params['extract_shortcode_content'] = $this->config['params']['extract_shortcode_content'];
        }

        $this->config['shortcode_structure'] = ST_Pb_Helper_Shortcode::generate_shortcode_structure($this->config['shortcode'], $params);
    }
}
