<?php

/*
 * Parent class for layout elements
 */

class ST_Pb_Shortcode_Layout extends ST_Pb_Shortcode_Common {

	public $nest_level;

	public function __construct() {
		$this->type = 'layout';
		$this->config['el_type'] = 'element';

		$this->element_config();
		$this->element_items();
		$this->create_param_defaults();
		$this->shortcode_data();

		/* add shortcode */
		add_shortcode( $this->config['shortcode'], array( &$this, '_element_shortcode' ) );
		add_shortcode( $this->config['shortcode'].'_2', array( &$this, '_element_shortcode_nested_2' ) );
		add_shortcode( $this->config['shortcode'].'_3', array( &$this, '_element_shortcode_nested_3' ) );
		add_shortcode( $this->config['shortcode'].'_4', array( &$this, '_element_shortcode_nested_4' ) );

		// enqueue custom script for current element
		if ( ST_Pb_Helper_Functions::is_modal_of_element( $this->config['shortcode'] ) ) {
			ST_Pb_Helper_Functions::shortcode_enqueue_assets( $this, 'admin_assets', '' );
		}

		// enqueue assets for current element in backend (preview iframe)
		if ( ST_Pb_Helper_Functions::is_preview() ) {
			add_action( 'pb_admin_enqueue_scripts', array( &$this, 'enqueue_assets_frontend' ) );
		}

		parent::__construct();
	}

	/**
	 * Enqueue scripts for frontend
	 */
	public function enqueue_assets_frontend() {
		ST_Pb_Helper_Functions::shortcode_enqueue_assets( $this, 'frontend_assets', '_frontend' );
	}


	/**
	 * Add more options to all layouts
	 */
	public function element_items_extra($inner_div = '> .row-inner', $default_padding = array('0','0','0','0'))
	{
		if(! isset($this->items['mobile'])) $this->items['mobile'] = array();

		$this->items['mobile'] = array_merge(
				array(
					array(
						'name'               => __( 'Padding', ST_PBL ),
						'container_class'    => 'combo-group',
						'id'                 => 'm_padding',
						'type'               => 'margin',
						'extended_ids'       => array( 'm_padding_top', 'm_padding_bottom', 'm_padding_right', 'm_padding_left' ),
						'm_padding_top'    => array( 'std' => $default_padding[0] ),
						'm_padding_bottom' => array( 'std' => $default_padding[1] ),
						'm_padding_right'  => array( 'std' => $default_padding[2] ),
						'm_padding_left'   => array( 'std' => $default_padding[3] ),
						'append'               => 'px',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 829px)',
								'css' => array(
									array($inner_div, 'padding')
								)
							)
						) // end css
					) // end field
				),
				$this->items['mobile']
		);
	}

	/**
	 * html structure of item in List item
	 * @return type
	 */
	public function element_button( $sort ) {

	}

	/**
	 * html structure of element in Page Builder area
	 */
	public function element_in_pgbldr($content = '', $shortcode_data = '')
	{
		if(isset($this->config['wp_shortcode_name']))
			$this->config['shortcode'] = $this->config['wp_shortcode_name'];

		return $this->_element_in_pgbldr($content, $shortcode_data);
	}



	/**
	 * DEFINE shortcode content
	 *
	 * @param array $atts
	 * @param string $content
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {

	}


	/**
	 * Wrap output html of a shortcode
	 *
	 * @param array $arr_params
	 * @param string $html_element
	 * @param string $extra_class
	 * @return string
	 */
	public function layout_wrapper( $html_element, $arr_params, $extra_class = '', $custom_style = '' ) {

		$html_element = apply_filters('st_element_html', $html_element, $this);

		return array(
			'content'=>$html_element,
			'atts'=>$arr_params
		);
	}


	/**
	 * get params & structure of shortcode
	 */
	public function shortcode_data() {

	}


	/**
	 * DEFINE shortcode content
	 *
	 * @param type $atts
	 * @param type $content
	 */
	public function _element_shortcode( $atts = null, $content = null, $name='' )
	{
		$atts = ST_Pb_Helper_Shortcode::check_and_assign_id($atts, $name);
		if(ST_Pb_Utils_Css::doing_css())
		{
			return ST_Pb_Utils_Css::shortcode($this, $atts, $content);
		}

		$this->nest_level = 1;

		// backup data for later use
		$this->original_atts = $atts;
		$this->original_content = $content;

		// fill in default vals where not exists
		$atts = ( shortcode_atts( $this->config['params'], $atts ) );

		// ------------------------------------------------------
		//  MAIN ELEMENT ID
		// ------------------------------------------------------
		//$atts['elm_id'] = uniqid();

		return $this->common_wrapper(  $this->element_shortcode_full( $atts, $content ), $atts, $content );
	}


	public function _element_shortcode_nested( $atts = null, $content = null, $name='', $nest_level = 2 )
	{
		$atts = ST_Pb_Helper_Shortcode::check_and_assign_id($atts, $name);
		if(ST_Pb_Utils_Css::doing_css())
		{
			return ST_Pb_Utils_Css::shortcode($this, $atts, $content);
		}

		$this->nest_level = $nest_level;

		// backup data for later use
		$this->original_atts = $atts;
		$this->original_content = $content;

		// fill in default vals where not exists
		$atts = ( shortcode_atts( $this->config['params'], $atts ) );

		// ------------------------------------------------------
		//  MAIN ELEMENT ID
		// ------------------------------------------------------
		//$atts['elm_id'] = uniqid();

		// for nested rows, we restrict width to boxed only
		// otherwise it overlaps other rows content
		$atts['nested'] = 'yes';
		$atts['width'] = 'boxed';
		return $this->common_wrapper(  $this->element_shortcode_full( $atts, $content ), $atts, $content );
	}


	public function _element_shortcode_nested_2( $atts = null, $content = null, $name='' )
	{
		return $this->_element_shortcode_nested( $atts, $content, $name, 2 );
	}

	public function _element_shortcode_nested_3( $atts = null, $content = null, $name='' )
	{
		return $this->_element_shortcode_nested( $atts, $content, $name, 3 );
	}

	public function _element_shortcode_nested_4( $atts = null, $content = null, $name='' )
	{
		return $this->_element_shortcode_nested( $atts, $content, $name, 4 );
	}



	/**
	 * Return CSS for background-repeat
	 *
	 * @param string $bg_repeat
	 * @return string
	 */
	static function background_repeat( $bg_repeat ) {
		$background_repeat = '';

		switch ( $bg_repeat ) {
			case 'full':
				$background_repeat = 'repeat';
				break;
			case 'vertical':
				$background_repeat = 'repeat-y';
				break;
			case 'horizontal':
				$background_repeat = 'repeat-x';
				break;
		}

		return $background_repeat;
	}


}
