<?php

/*
 * Define a column shortcode
 */
if (!class_exists('ST_Column')) {

	class ST_Column extends ST_Pb_Shortcode_Layout {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Column', ST_PBL);
			$this->config['extract_param'] = array('span');
			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * contain setting items of this element (use for modal box)
		 *
		 */
		function element_items() {
			$default_padding = '0';

			$this->items = array(
				'styling' => array(
					array(
						'type' => 'preview',
						'bg' => 'transparent',
						'size' => 'col',
					),

					// is filled in by $.HandleSetting.traverseParam
					array(
						'id' => 'span',
						'class' => 'st_col_span_param',
						'type' => 'hidden',
						'std' => '',
					),

					array(
						'name' => __('Background', ST_PBL),
						'id' => 'background',
						'type' => 'select',
						'std' => 'none',
						'class' => 'input-sm',
						'options' => array(
							'none' => __('None (transparent)', ST_PBL),
							'solid' => __('Color', ST_PBL),
							'image' => __('Image', ST_PBL),
							'pattern' => __('Pattern', ST_PBL),
							'video' => __('Youtube Video', ST_PBL),
							'video_hosted' => __('Direct Video', ST_PBL),
						),
						'has_depend' => '1',
					),

					array(
						'name' => __('Enable Parallax', ST_PBL),
						'id' => 'paralax',
						'type' => 'radio',
						'std' => 'no',
						'options' => array('yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL)),
						'dependency' => array('background', '=', 'pattern__#__image'),
						'has_depend' => '1',
					),

					array(
						'name' => __('Background Color', ST_PBL),
						'id' => 'solid_color_value',
						'type' => 'color_picker',
						'std' => '#ffffff',
						'dependency' => array('background', '=', 'solid'),
						'css' => array('', 'background-color', array('opacity_from' => 'row_bg_opacity')),
					),
					array(
						'name' => __('Background color opacity', ST_PBL),
						'id' => 'row_bg_opacity',
						'type' => 'slider',
						'class' => 'st-slider',
						'std_max' => '100',
						'std' => '100',
						'dependency' => array('background', '=', 'solid'),
						'css' => array(''),
					),
					array(
						'name' => __('Pattern', ST_PBL),
						'id' => 'pattern',
						'type' => 'select_media',
						'std' => '',
						'class' => 'jsn-input-large-fluid',
						'dependency' => array('background', '=', 'pattern'),
					),
					array(
						'name' => __('Repeat', ST_PBL),
						'id' => 'repeat',
						'type' => 'radio_button_group',
						'std' => 'full',
						'options' => array(
							'full' => __('Full', ST_PBL),
							'vertical' => __('Vertical', ST_PBL),
							'horizontal' => __('Horizontal', ST_PBL),
						),
						'dependency' => array(
							array('background', '=', 'pattern'),
							array('paralax', '!=', 'yes'),
						),
					),
					array(
						'name' => __('Image', ST_PBL),
						'id' => 'image',
						'type' => 'select_media',
						'std' => '',
						'class' => 'jsn-input-large-fluid',
						'dependency' => array('background', '=', 'image'),
					),

					array(
						'name' => __('Repeat', ST_PBL),
						'id' => 'img_repeat',
						'type' => 'radio',
						'std' => 'cover',
						'options' => array(
							'cover' => __('Cover whole row', ST_PBL),
							'full' => __('All', ST_PBL),
							'vertical' => __('Vertically', ST_PBL),
							'horizontal' => __('Horizontally', ST_PBL),
						),
						'dependency' => array(
							array('background', '=', 'image'),
							array('paralax', '!=', 'yes'),
						),
						'has_depend' => '1',
					),

					array(
						'name' => __('Video url', ST_PBL),
						'id' => 'video_url',
						'type' => 'text_field',
						'std' => '',
						'placeholder' => 'Youtube video url',
						'dependency' => array('background', '=', 'video'),
						'tooltip' => __('e.g https://www.youtube.com/watch?v=a87GC4ahmjA', ST_PBL),
					),

					array(
						'id' => 'video_mp4',
						'name' => __('Video url (MP4)', ST_PBL),
						'type' => 'select_media',
						'filter_type' => 'video',
						'media_type' => 'video',
						'class' => 'jsn-input-large-fluid',
						'placeholder' => '.mp4 Video url',
						'dependency' => array('background', '=', 'video_hosted'),
					),

					array(
						'id' => 'video_webm',
						'name' => __('Video url (WebM)', ST_PBL),
						'type' => 'select_media',
						'filter_type' => 'video',
						'media_type' => 'video',
						'class' => 'jsn-input-large-fluid',
						'placeholder' => '.mp4 Video url',
						'dependency' => array('background', '=', 'video_hosted'),
					),

					array(
						'name' => __('Position', ST_PBL),
						'id' => 'position',
						'type' => 'radio',
						'label_type' => 'image',
						'dimension' => array(23, 23),
						'std' => 'center center',
						'options' => array(
							'left top' => array('left top'),
							'center top' => array('center top'),
							'right top' => array('right top', 'linebreak' => true),
							'left center' => array('left center'),
							'center center' => array('center center'),
							'right center' => array('right center', 'linebreak' => true),
							'left bottom' => array('left bottom'),
							'center bottom' => array('center bottom'),
							'right bottom' => array('right bottom'),
						),
						'dependency' => array(
							array('background', '=', 'image'),
							//array( 'img_repeat', '!=', 'cover' ),
							array('paralax', '!=', 'yes'),
						),
					),

					array(
						'name' => __('Show overlay over background', ST_PBL),
						'id' => 'show_overlay',
						'type' => 'radio',
						'std' => 'no',
						'options' => array(
							'yes' => __('Yes', ST_PBL),
							'no' => __('No', ST_PBL),
						),
						'dependency' => array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
						'has_depend' => '1',
					),

					array(
						'name' => __('Overlay Color', ST_PBL),
						'id' => 'overlay_color',
						'type' => 'color_picker',
						'std' => '#000000',
						'dependency' => array(
							array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
							array('show_overlay', '=', 'yes'),
						),
					),
					array(
						'name' => __('Overlay color opacity', ST_PBL),
						'id' => 'overlay_opacity',
						'type' => 'slider',
						'class' => 'st-slider',
						'std_max' => '100',
						'std' => '50',
						'dependency' => array(
							array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
							array('show_overlay', '=', 'yes'),
						),
					),

					array(
						'name' => __('Border', ST_PBL),
						'type' => array(
							array(
								'id' => 'border_width_value_',
								'type' => 'text_append',
								'type_input' => 'number',
								'class' => 'input-mini',
								'std' => '0',
								'append' => 'px',
								'validate' => 'number',
								'parent_class' => 'input-group-inline',
							),
							array(
								'id' => 'border_style',
								'type' => 'select',
								'class' => 'input-sm st-border-style',
								'std' => 'solid',
								'options' => ST_Pb_Helper_Type::get_border_styles(),
								'parent_class' => 'combo-item',
							),
							array(
								'id' => 'border_color',
								'type' => 'color_picker',
								'std' => '',
								'parent_class' => 'combo-item',
							),
						),
						'container_class' => 'combo-group',
					),

					array(
						'name' => __('Rounded corners', ST_PBL),
						'id' => 'border_radius',
						'type' => 'slider',
						'class' => 'st-slider',
						'std_max' => '100',
						'std' => '0',
						'append' => 'px',
						'validate' => 'number',
						'dependency' => array(
							array('background', '!=', 'video'),
							array('background', '!=', 'video_hosted'),
						),
						'css' => array(
							array('', 'border-radius'),
							array('> .cbb-bg-overlay', 'border-radius'),
						),
					),

					array(
						'name' => __('Override text Color', ST_PBL),
						'id' => 'text_color',
						'type' => 'color_picker',
						'std' => '',
						'tooltip' => __('If set, all the elements inside this column will use this text color.', ST_PBL),
						'css' => array('', 'color'),
					),
					array(
						'name' => __('Padding', ST_PBL),
						'container_class' => 'combo-group',
						'id' => 'div_padding',
						'type' => 'margin',
						'extended_ids' => array('div_padding_top', 'div_padding_bottom', 'div_padding_right', 'div_padding_left'),
						'div_padding_top' => array('std' => $default_padding),
						'div_padding_bottom' => array('std' => $default_padding),
						'div_padding_right' => array('std' => 10),
						'div_padding_left' => array('std' => 10),
						'append' => 'px',
						'css' => array(
							array('', 'padding'),
						),
					),

					ST_Pb_Helper_Type::get_shadow_type('shadow'),

					array(
						'name' => __('Custom CSS', ST_PBL),
						'id' => '',
						'type' => 'fieldset',
					),
					array(
						'name' => __('Class', ST_PBL),
						'id' => 'css_suffix',
						'type' => 'text_field',
						'std' => __('', ST_PBL),
						'tooltip' => __('Custom CSS Class for the wrapper div of this element', ST_PBL),
					),
					array(
						'name' => __('ID', ST_PBL),
						'id' => 'id_wrapper',
						'type' => 'text_field',
						'std' => __('', ST_PBL),
						'tooltip' => __('Custom CSS ID for the wrapper div of this element', ST_PBL),
					),
				),
			); // items array end

			$this->items['mobile'] = array(

				array(
					'name' => __('Width', ST_PBL),
					'id' => 'm_width',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '100',
					'std' => '100',
					'append' => '%',
					'css' => array(
						'media_query' => array(
							'query' => '(max-width: 829px)',
							'css' => array(
								array('', 'width'),
							),
						),
					), // end css
				),

				array(
					'type' => 'skip_to_next_section',
				),

			);

			$this->element_items_extra('', array('', '', '', ''));

		} // method end

		/**
		 *
		 * @param type $content			 : inner shortcode elements of this column
		 * @param string $shortcode_data
		 * @return string
		 */
		public function _element_in_pgbldr($content = '', $shortcode_data = '') {

			$column_html = empty($content) ? '' : ST_Pb_Helper_Shortcode::do_shortcode_admin($content, true);
			$span = (!empty($this->params['span'])) ? $this->params['span'] : 'span12';

			if (empty($shortcode_data)) {
				$shortcode_data = '[' . $this->config['shortcode'] . ' span="' . $span . '"]';
			} else {
				$shortcode_data = explode(']', $shortcode_data);
				$shortcode_data = $shortcode_data[0] . ']';
			}

			//$shortcode_data = '[' . $this->config['shortcode'] . ' span="' . $span . '"]';

			// Remove empty value attributes of shortcode tag.
			$shortcode_data = preg_replace('/\[*([a-z_]*[\n\s\t]*=[\n\s\t]*"")/', '', $shortcode_data);

			// title for modal panel
			$modal_title = isset($this->config['name']) ? "data-modal-title='{$this->config['name']}'" : '';

			$rnd_id = ST_Pb_Utils_Common::random_string();
			$column[] = '<div class="jsn-column-container clearafter shortcode-container " style="width:0;" ' . $modal_title . '>
							<div class="jsn-column ' . $span . '">
								<div class="thumbnail clearafter">
									<textarea class="hidden" data-sc-info="shortcode_content" name="shortcode_content[]" >' . $shortcode_data . '</textarea>
									<div class="cbb-col-percent">100%</div>
									<div class="jsn-column-content item-container" data-column-class="' . $span . '" >
										<div class="jsn-handle-drag jsn-horizontal jsn-iconbar-trigger">
											<span class="st_drag_handle"><i class="fa fa-bars"></i></span>
											<div class="jsn-iconbar layout">
												<span class="st-iconbar-title">' . __('Column: ', ST_PBL) . '</span>
												<a href="javascript:void(0);" title="Edit column" data-shortcode="' . $this->config['shortcode'] . '" class="element-edit st_column_edit" data-use-ajax="' . ($this->config['edit_using_ajax'] ? 1 : 0) . '"><i class="icon-pencil"></i></a>
												<a class="item-delete column" onclick="return false;" title="' . __('Delete column', ST_PBL) . '" href="#"><i class="icon-trash"></i></a>

											</div>
										</div>
										<div class="jsn-element-container item-container-content cbb-sortable-container">
											' . $column_html . '</div>
										<div class="clearfix"></div>
										<div class="jsn-action-btns">
											<a title="' . __('Insert Element to column', ST_PBL) . '" class="jsn-add-more st-more-element" href="javascript:void(0);"><i class="icon-plus"></i>' . __('Insert Element', ST_PBL) . '</a>
											<a title="' . __('Insert Row to column', ST_PBL) . '" class="jsn-add-row" href="javascript:void(0);"><i class="st-icon-add-row"></i>' . __('Insert Row', ST_PBL) . '</a>
										</div>
									</div>
									<textarea class="hidden" name="shortcode_content[]" >[/' . $this->config['shortcode'] . ']</textarea>
								</div>
							</div>
						</div>';
			return $column;
		}

		/**
		 * get params & structure of shortcode
		 */
		public function shortcode_data() {
			$this->config['params'] = ST_Pb_Helper_Shortcode::generate_shortcode_params($this->items, null, null, false, true);

			// @since 0.0.1, removed params as we dont want default params in shortcode
			$params = array();
			// for content of param which has: role = content
			if (isset($this->config['params']['extract_shortcode_content'])) {
				$params['extract_shortcode_content'] = $this->config['params']['extract_shortcode_content'];
			}

			$this->config['shortcode_structure'] = ST_Pb_Helper_Shortcode::generate_shortcode_structure($this->config['shortcode'], $params);
		}

		/**
		 * define shortcode structure of element
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			static $i;
			global $wp_scripts;

			// define main html tags / elements
			$_wrapper = array(
				'tag' => 'div',
				'id' => !empty($atts['id_wrapper']) ? esc_attr($atts['id_wrapper']) : ST_Pb_Utils_Common::random_string(),
				'class' => 'col',
				'style' => '',
				'content' => '',
				'before_content' => '',
				'after_content' => '',
				'attr' => '',
			);
			$_inner = array(
				'tag' => 'div',
				'id' => '',
				'class' => 'col-inner',
				'style' => '',
				'content' => '',
				'before_content' => '',
				'after_content' => '',
				'attr' => '',
			);

			// column span classes
			if (!isset($atts['span']) || !$atts['span']) {
				$atts['span'] = 'span12';
			}

			$span = intval(substr($atts['span'], 4));
			$_wrapper['class'] .= " col-md-$span col-sm-$span";

			$_wrapper['class'] .= ' col-xs-12';

			// extra classes
			$_wrapper['class'] .= !empty($atts['css_suffix']) ? ' ' . esc_attr($atts['css_suffix']) : '';

			// Parallax background
			if (isset($atts['paralax']) && $atts['paralax'] == 'yes') {
				$paralax_ratio = '0.2'; // default
				if (isset($atts['paralax_ratio']) && is_numeric($atts['paralax_ratio'])) {
					$paralax_ratio = $atts['paralax_ratio'];
				}

				$parallax = ' data-stellar-background-ratio="' . $paralax_ratio . '"';
			}

			// Border
			$border_styles = '';
			if (isset($atts['border_width_value_']) && intval($atts['border_width_value_'])) {
				$border = array();
				$border[] = $atts['border_width_value_'] . 'px';
				$border[] = $atts['border_style'];
				$border[] = $atts['border_color'];
				$border_styles = sprintf('border:%1$s;', implode(' ', $border));
			}

			// background types
			switch ($atts['background']) {
			case 'none':
				$_wrapper['style'] .= 'background: none;';
				break;

			case 'bg_alt-color':
				$_wrapper['class'] .= ' bg_alt-color';

				break;

			case 'pattern':
				$pattern_img = $atts['pattern'];
				$background = "background-image:url('$pattern_img');";

				$background_repeat = self::background_repeat($atts['repeat']);
				if (!empty($background_repeat)) {
					$background .= "background-repeat:$background_repeat;";
				}

				$_wrapper['style'] .= $background;

				// Parallax background
				if (isset($parallax)) {
					$_wrapper['attr'] = $parallax;
				}

				$parallax = $background = '';
				break;

			case 'image':
				$image = $atts['image'];
				$image_position = $atts['position'];
				$background = 'background-image: url(\'' . $image . '\');';
				if ($image_position) {
					$background .= 'background-position: ' . $image_position . ';';
				}

				// Background repeat
				if ($atts['img_repeat'] == 'cover') {
					$background .= '-webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover; background-repeat: no-repeat;';
				} else {
					$background_repeat = self::background_repeat($atts['img_repeat']);
					if (!empty($background_repeat)) {
						$background .= 'background-repeat: ' . $background_repeat . ';';
					}
				}

				$_wrapper['data-image-src'] = $image;
				$_wrapper['style'] .= $background;

				// Parallax background
				if (isset($parallax)) {
					$_wrapper['attr'] = $parallax;
				}

				break;

			case 'video': // youtube video
				$url = $atts['video_url'];

				// If not Youtube video then skip
				// pattern sourced from
				// https://gist.github.com/simplethemes/7591414
				if (preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $match)) {
					$youtube_id = $match[1];

					$_wrapper['before_content'] .= '<div class="cb-row-video-bg"></div>';
					$_wrapper['before_content'] .= ST_Pb_Helper_Functions::script_box("
						$('#{$_wrapper['id']} > .cb-row-video-bg').YTPlayer({
						    fitToBackground: false,
						    width: $('#{$_wrapper['id']}').width(),
						    videoId: '{$youtube_id}',
						    playerVars: {
							  disablekb: 1,
							  iv_load_policy: 1,
						      modestbranding: 1,
						      autoplay: 1,
						      controls: 0,
						      showinfo: 0,
						      branding: 0,
						      rel: 0,
						      autohide: 0,
						      origin: window.location.origin
						    }
						});
						");

					wp_enqueue_script('cb-youtube-video');
				}
				break;

			case 'video_hosted':
				$_video_wrapper = array(
					'tag' => 'div',
					'id' => '',
					'class' => 'cbb-row-video-wrapper',
					'style' => 'position: absolute; top:0; bottom:0; left: 0; right: 0; width: 100%; overflow:hidden;',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
				);

				$_video = array(
					'tag' => 'video',
					'id' => '',
					'class' => 'cbb-row-video',
					'style' => 'top: 0; bottom: 0; left: 0px; position: absolute; width: 100%;',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
					'width' => '1800',
					'height' => '700',
					'muted' => ' ',
					'autoplay' => ' ',
					'loop' => ' ',
					'preload' => 'auto',
				);

				$video_mp4 = $atts['video_mp4'];
				$video_webm = $atts['video_webm'];

				if ($video_mp4) {
					$_video['content'] .= '<source src="' . $video_mp4 . '" type="video/mp4">';
				}

				if ($video_webm) {
					$_video['content'] .= '<source src="' . $video_webm . '" type="video/webm">';
				}

				$_video_wrapper['content'] .= ST_Pb_Helper_Html::html_tag($_video);
				$_wrapper['before_content'] .= ST_Pb_Helper_Html::html_tag($_video_wrapper);
				break;
			}

			// overlay
			if ($atts['show_overlay'] == 'yes' &&
				(
					$atts['background'] == 'pattern'
					OR $atts['background'] == 'image'
					OR $atts['background'] == 'video'
					OR $atts['background'] == 'video_hosted'
				)) {
				$_overlay = array(
					'tag' => 'div',
					'id' => '',
					'class' => 'cbb-bg-overlay',
					'style' => '',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
				);

				if ($atts['overlay_opacity'] > 0) {
					$atts['overlay_opacity'] /= 100;
				}

				$_overlay['style'] .= 'background-color: ' . ST_Pb_Helper_Functions::hex2rgba($atts['overlay_color'], $atts['overlay_opacity']) . ';';

				$_wrapper['before_content'] .= ST_Pb_Helper_Html::html_tag($_overlay);
			}

			// apply border
			if ($border_styles) {
				$_wrapper['style'] .= $border_styles;
			}

			// perform content process
			$content = ST_Pb_Helper_Shortcode::remove_autop($content);
			//$content = 'TEMP NO CONTENT'; // TEMP

			// insert tags into their parents
			$_inner['content'] = $content;
			$_wrapper['content'] = $_inner;

			// generate html / markup
			$output = ST_Pb_Helper_Html::html_tag($_wrapper);

			//$output = '<pre>'.print_r(htmlentities( $output ), TRUE).'</pre>' . $output;
			//$output .= '<pre>'.print_r(htmlentities( $temp_old_row ), TRUE).'</pre>' . $temp_old_row; // TEMP

			return $this->layout_wrapper($output, $atts);
		} // end element_shortcode

		/**
		 * define shortcode structure of element
		 */
		function BK_element_shortcode($atts = null, $content = null) {
			extract(shortcode_atts(array('span' => 'span6', 'style' => ''), $atts));
			$style = empty($style) ? '' : "style='$style'";
			$span = intval(substr($span, 4));
			$class = "col-md-$span col-sm-$span col-xs-12";

			$content = ST_Pb_Helper_Shortcode::remove_autop($content);

			return '<div class="' . $class . '" ' . $style . '>' . $content . '</div>';
		}

		/**
		 * Return CSS for background-repeat
		 *
		 * @param string $bg_repeat
		 * @return string
		 */
		static function background_repeat($bg_repeat) {
			$background_repeat = '';

			switch ($bg_repeat) {
			case 'full':
				$background_repeat = 'repeat';
				break;
			case 'vertical':
				$background_repeat = 'repeat-y';
				break;
			case 'horizontal':
				$background_repeat = 'repeat-x';
				break;
			}

			return $background_repeat;
		}

		/**
		 * Enqueue scripts of 3rd-party libraries for Full width video background
		 */
		static function enqueue_player_scripts() {
			wp_enqueue_style('YTPlayer-css', ST_Pb_Helper_Functions::path('assets/3rd-party/YTPlayer') . '/YTPlayer.css');
			//wp_enqueue_script( 'YTPlayer-js', ST_Pb_Helper_Functions::path( 'assets/3rd-party/YTPlayer' ) . '/jquery.mb.YTPlayer.js' );
		}

		/**
		 * Custom script for Video background
		 */
		static function print_player_scripts() {
			//echo ST_Pb_Helper_Functions::script_box("$('.st_video_bg').mb_YTPlayer(); $('.st_video_bg').click(function(){ $(this).playYTP() });");
		}

	}
}
