<?php

if (!class_exists('ST_Subrow')):

	class ST_Subrow extends ST_Pb_Shortcode_Layout {

		/* default layouts for Subrow */
		static $layouts = array(
			array(6, 6),
			array(4, 4, 4),
			array(3, 3, 3, 3),
			array(4, 8),
			array(8, 4),
			array(3, 9),
			array(9, 3),
			array(3, 6, 3),
			array(3, 3, 6),
			array(6, 3, 3),
			array(2, 2, 2, 2, 2, 2),
		);

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Subrow', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'admin_assets' => array(
					// Shortcode initialization
					'row.js',
				),
				'frontend_assets' => array(
					'cbb-frontend-js',
					'cb-youtube-video-js',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * contain setting items of this element ( use for modal box )
		 *
		 */
		function element_items() {
			$default_padding = '0';

			$this->items['styling'] = array(
				array(
					'type' => 'preview',
					'size' => 'full',
					'bg' => 'transparent',
				),
				array(
					'name' => __('Width', ST_PBL),
					'id' => 'width',
					'type' => 'radio',
					'std' => 'boxed',
					'options' => array(
						'boxed' => __('Boxed', ST_PBL),
						'full' => __('Full (boxed content)', ST_PBL),
						'wide' => __('Full (wide content)', ST_PBL),
					),
				),
				array(
					'name' => __('Height', ST_PBL),
					'id' => 'height',
					'type' => 'radio',
					'std' => 'auto',
					'options' => array(
						'auto' => __('Auto (Default)', ST_PBL),
						'window' => __('Window Height', ST_PBL),
						'window_center' => __('Window height (cantered content)', ST_PBL),
					),
					'tooltip' => __('', ST_PBL),
				),

				array(
					'name' => __('Background', ST_PBL),
					'id' => 'background',
					'type' => 'select',
					'std' => 'none',
					'class' => 'input-sm',
					'options' => array(
						'none' => __('None (transparent)', ST_PBL),
						'solid' => __('Color', ST_PBL),
						'bg_alt-color' => __('Alternative Color', ST_PBL),
						'image' => __('Image', ST_PBL),
						'pattern' => __('Pattern', ST_PBL),
						'video' => __('Youtube Video', ST_PBL),
						'video_hosted' => __('Direct Video', ST_PBL),
					),
					'has_depend' => '1',
				),

				array(
					'name' => __('Enable Parallax', ST_PBL),
					'id' => 'paralax',
					'type' => 'radio',
					'std' => 'no',
					'options' => array('yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL)),
					'dependency' => array('background', '=', 'pattern__#__image'),
					'has_depend' => '1',
				),

				array(
					'name' => __('Background Color', ST_PBL),
					'id' => 'solid_color_value',
					'type' => 'color_picker',
					'std' => '#ffffff',
					'dependency' => array('background', '=', 'solid'),
				),
				array(
					'name' => __('Background color opacity', ST_PBL),
					'id' => 'row_bg_opacity',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '100',
					'std' => '100',
					'dependency' => array('background', '=', 'solid'),
				),
				array(
					'name' => __('Pattern', ST_PBL),
					'id' => 'pattern',
					'type' => 'select_media',
					'std' => '',
					'class' => 'jsn-input-large-fluid',
					'dependency' => array('background', '=', 'pattern'),
				),
				array(
					'name' => __('Repeat', ST_PBL),
					'id' => 'repeat',
					'type' => 'radio_button_group',
					'std' => 'full',
					'options' => array(
						'full' => __('Full', ST_PBL),
						'vertical' => __('Vertical', ST_PBL),
						'horizontal' => __('Horizontal', ST_PBL),
					),
					'dependency' => array(
						array('background', '=', 'pattern'),
						array('paralax', '!=', 'yes'),
					),
				),
				array(
					'name' => __('Image', ST_PBL),
					'id' => 'image',
					'type' => 'select_media',
					'std' => '',
					'class' => 'jsn-input-large-fluid',
					'dependency' => array('background', '=', 'image'),
				),
				array(
					'name' => __('Repeat', ST_PBL),
					'id' => 'img_repeat',
					'type' => 'radio',
					'std' => 'cover',
					'options' => array(
						'cover' => __('Cover whole row', ST_PBL),
						'full' => __('All', ST_PBL),
						'vertical' => __('Vertically', ST_PBL),
						'horizontal' => __('Horizontally', ST_PBL),
					),
					'dependency' => array(
						array('background', '=', 'image'),
						array('paralax', '!=', 'yes'),
					),
					'has_depend' => '1',
				),

				array(
					'name' => __('Video url', ST_PBL),
					'id' => 'video_url',
					'type' => 'text_field',
					'std' => '',
					'placeholder' => 'Youtube video url',
					'dependency' => array('background', '=', 'video'),
					'tooltip' => __('e.g https://www.youtube.com/watch?v=a87GC4ahmjA', ST_PBL),
				),

				array(
					'id' => 'video_mp4',
					'name' => __('Video url (MP4)', ST_PBL),
					'type' => 'select_media',
					'filter_type' => 'video',
					'media_type' => 'video',
					'class' => 'jsn-input-large-fluid',
					'placeholder' => '.mp4 Video url',
					'dependency' => array('background', '=', 'video_hosted'),
				),

				array(
					'id' => 'video_webm',
					'name' => __('Video url (WebM)', ST_PBL),
					'type' => 'select_media',
					'filter_type' => 'video',
					'media_type' => 'video',
					'class' => 'jsn-input-large-fluid',
					'placeholder' => '.mp4 Video url',
					'dependency' => array('background', '=', 'video_hosted'),
				),

				array(
					'name' => __('Position', ST_PBL),
					'id' => 'position',
					'type' => 'radio',
					'label_type' => 'image',
					'dimension' => array(23, 23),
					'std' => 'center center',
					'options' => array(
						'left top' => array('left top'),
						'center top' => array('center top'),
						'right top' => array('right top', 'linebreak' => true),
						'left center' => array('left center'),
						'center center' => array('center center'),
						'right center' => array('right center', 'linebreak' => true),
						'left bottom' => array('left bottom'),
						'center bottom' => array('center bottom'),
						'right bottom' => array('right bottom'),
					),
					'dependency' => array(
						array('background', '=', 'image'),
						array('img_repeat', '!=', 'cover'),
						array('paralax', '!=', 'yes'),
					),
				),

				array(
					'name' => __('Show overlay over background', ST_PBL),
					'id' => 'show_overlay',
					'type' => 'radio',
					'std' => 'no',
					'options' => array(
						'yes' => __('Yes', ST_PBL),
						'no' => __('No', ST_PBL),
					),
					'dependency' => array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
					'has_depend' => '1',
				),

				array(
					'name' => __('Overlay Color', ST_PBL),
					'id' => 'overlay_color',
					'type' => 'color_picker',
					'std' => '#000000',
					'dependency' => array(
						array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
						array('show_overlay', '=', 'yes'),
					),
				),
				array(
					'name' => __('Overlay color opacity', ST_PBL),
					'id' => 'overlay_opacity',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '100',
					'std' => '50',
					'dependency' => array(
						array('background', '=', 'video__#__video_hosted__#__image__#__pattern'),
						array('show_overlay', '=', 'yes'),
					),
				),

				array(
					'name' => __('Stick to top on scroll', ST_PBL),
					'id' => 'sticky',
					'type' => 'radio',
					'std' => 'no',
					'options' => array(
						'yes' => __('Yes', ST_PBL),
						'no' => __('No', ST_PBL),
					),
					'tooltip' => __('Subrow will stick to top when scrolling. Useful when row is acting as a header.', ST_PBL),
				),

				array(
					'name' => __('Border', ST_PBL),
					'type' => array(
						array(
							'id' => 'border_width_value_',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '0',
							'append' => 'px',
							'validate' => 'number',
							'parent_class' => 'input-group-inline',
						),
						array(
							'id' => 'border_style',
							'type' => 'select',
							'class' => 'input-sm st-border-style',
							'std' => 'solid',
							'options' => ST_Pb_Helper_Type::get_border_styles(),
							'parent_class' => 'combo-item',
						),
						array(
							'id' => 'border_color',
							'type' => 'color_picker',
							'std' => '',
							'parent_class' => 'combo-item',
						),
					),
					'container_class' => 'combo-group',
				),

				array(
					'name' => __('Override text Color', ST_PBL),
					'id' => 'text_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('If set, all the elements inside this row will use this text color.', ST_PBL),
					'css' => array('', 'color'),
				),
				array(
					'name' => __('Padding', ST_PBL),
					'container_class' => 'combo-group',
					'id' => 'div_padding',
					'type' => 'margin',
					'extended_ids' => array('div_padding_top', 'div_padding_bottom', 'div_padding_right', 'div_padding_left'),
					'div_padding_top' => array('std' => $default_padding),
					'div_padding_bottom' => array('std' => $default_padding),
					'div_padding_right' => array('std' => $default_padding),
					'div_padding_left' => array('std' => $default_padding),
					'append' => 'px',
					'css' => array(
						array('> .row-inner', 'padding'),
					),
				),
				array(
					'name' => __('Custom CSS', ST_PBL),
					'id' => 'elm-custom-css',
					'type' => 'fieldset',
				),
				array(
					'name' => __('Class', ST_PBL),
					'id' => 'css_suffix',
					'type' => 'text_field',
					'std' => __('', ST_PBL),
					'tooltip' => __('Custom CSS Class for the wrapper div of this element', ST_PBL),
				),
				array(
					'name' => __('ID', ST_PBL),
					'id' => 'id_wrapper',
					'type' => 'text_field',
					'std' => __('', ST_PBL),
					'tooltip' => __('Custom CSS ID for the wrapper div of this element', ST_PBL),
				),
			);

		}

		/**
		 *
		 * @param type $content		: inner shortcode elements of this row
		 * @param type $shortcode_data : not used
		 * @return string
		 */
		public function _element_in_pgbldr($content = '', $shortcode_data = '') {
			$sub_rows_html = '';

			if (empty($content)) {
				$column = new ST_Column();
				$column_html = $column->element_in_pgbldr();
				$column_html = $column_html[0];
			} else {

				$column_html = ST_Pb_Helper_Shortcode::do_shortcode_admin($content);

			}
			if (empty($shortcode_data)) {
				$shortcode_data = $this->config['shortcode_structure'];
			}

			// remove [/st_row][st_column...] from $shortcode_data
			$shortcode_data = explode('][', $shortcode_data);
			$shortcode_data = $shortcode_data[0] . ']';

			// Remove empty value attributes of shortcode tag.
			$shortcode_data = preg_replace('/\[*([a-z_]*[\n\s\t]*=[\n\s\t]*"")/', '', $shortcode_data);

			// title for modal panel
			$modal_title = isset($this->config['name']) ? "data-modal-title='{$this->config['name']}'" : '';

			$custom_style = ST_Pb_Utils_Placeholder::get_placeholder('custom_style');
			$row[] = '<div class="jsn-row-container jsn-subrow ui-sortable row-fluid shortcode-container" ' . $custom_style . ' ' . $modal_title . ' >
				<textarea class="hidden" data-sc-info="shortcode_content" name="shortcode_content[]" >' . $shortcode_data . '</textarea>
				<div class="jsn-iconbar left cbb-sort-handle">
					<span class="st_drag_handle"><i class="fa fa-bars"></i></span>
					<a href="javascript:void(0);" title="Edit row" data-shortcode="' . $this->config['shortcode'] . '" class="element-edit row" data-use-ajax="' . ($this->config['edit_using_ajax'] ? 1 : 0) . '"><i class="icon-pencil"></i></a>

					<a href="javascript:void(0);" class="add-container" title="' . __('Add column', ST_PBL) . '"><i class="st-icon-add-col"></i></a>

					<a href="javascript:void(0);" class="item-delete row" title="' . __('Delete row', ST_PBL) . '"><i class="icon-trash"></i></a>
				</div>
				<div class="st-row-content">
				' . $column_html . '
				</div>
				<textarea class="hidden" name="shortcode_content[]" >[/' . $this->config['shortcode'] . ']</textarea>
			</div>';
			return $row;
		}

		/**
		 * get params & structure of shortcode
		 */
		public function shortcode_data() {
			$this->config['params'] = ST_Pb_Helper_Shortcode::generate_shortcode_params($this->items, null, null, false, true);

			// @since 0.0.1, removed params as we dont want default params in shortcode
			$params = array();
			// for content of param which has: role = content
			if (isset($this->config['params']['extract_shortcode_content'])) {
				$params['extract_shortcode_content'] = $this->config['params']['extract_shortcode_content'];
			}

			$this->config['shortcode_structure'] = ST_Pb_Helper_Shortcode::generate_shortcode_structure($this->config['shortcode'], $params);
		}

		/**
		 * define shortcode structure of element
		 */
		function element_shortcode_full($atts = null, $content = null) {
			static $i;
			global $st_no_row_count, $wp_scripts;
			wp_enqueue_script('cbb-frontend');

			// define main html tags / elements
			$_wrapper = array(
				'tag' => 'div',
				'id' => '',
				'class' => 'jsn-bootstrap3 cbb-row-wrapper cbb-subrow',
				'style' => '',
				'content' => '',
				'before_content' => '',
				'after_content' => '',
				'attr' => '',
			);
			$_row = array(
				'tag' => 'div',
				'id' => !empty($atts['id_wrapper']) ? esc_attr($atts['id_wrapper']) : ST_Pb_Utils_Common::random_string(),
				'class' => 'subrow row' . (!empty($atts['css_suffix']) ? ' ' . esc_attr($atts['css_suffix']) : ''),
				'style' => '',
				'content' => '',
				'before_content' => '',
				'after_content' => '',
				'attr' => '',
			);
			$_inner = array(
				'tag' => 'div',
				'id' => '',
				'class' => 'clearfix row-inner',
				'style' => '',
				'content' => '',
				'before_content' => '',
				'after_content' => '',
				'attr' => '',
			);

			// Create id and assign it to wrapper element
			if ($st_no_row_count) {
				$_wrapper['id'] = "cbb-row-no-id-" . rand(100, 999);
			} else {
				$i++;
				$_wrapper['id'] = "cbb-row-no-$i";
			}

			// sticky
			if (isset($atts['sticky']) && $atts['sticky'] == 'yes') {
				$_wrapper['class'] .= ' sticky-holder do-sticky';
			}

			// Parallax background
			if (isset($atts['paralax']) && $atts['paralax'] == 'yes') {
				$paralax_ratio = '0.2'; // default
				if (isset($atts['paralax_ratio']) && is_numeric($atts['paralax_ratio'])) {
					$paralax_ratio = $atts['paralax_ratio'];
				}

				$parallax = ' data-stellar-background-ratio="' . $paralax_ratio . '"';
			}

			// Border
			$border_styles = '';
			if (isset($atts['border_width_value_']) && intval($atts['border_width_value_'])) {
				$border = array();
				$border[] = $atts['border_width_value_'] . 'px';
				$border[] = $atts['border_style'];
				$border[] = $atts['border_color'];
				$border_styles = sprintf('border-top:%1$s; border-bottom:%1$s;', implode(' ', $border));
			}

			// row width styles
			switch ($atts['width']) {
			case 'full':
				$_row['class'] .= ' st_fullwidth';

				$_row['style'] .= '-webkit-box-sizing: content-box;-moz-box-sizing: content-box;box-sizing: content-box;width: 100%;padding-left: 1000px;padding-right: 1000px;margin:0 -1000px;';
				break;

			case 'wide':
				$_row['class'] .= ' full_wide_content';
				break;

			case 'boxed':

				break;
			}

			// background types
			switch ($atts['background']) {
			case 'none':
				$_row['style'] .= 'background: none;';
				break;

			case 'bg_alt-color':
				$_row['class'] .= ' bg_alt-color';

				break;

			case 'solid':
				$bg_opacity = 100;
				if (isset($atts['row_bg_opacity']) && is_numeric($atts['row_bg_opacity'])) {
					$bg_opacity = $atts['row_bg_opacity'];
				}

				if ($bg_opacity > 0) {
					$bg_opacity /= 100;
				}

				$solid_color = $atts['solid_color_value'];
				$solid_color_rgba = ST_Pb_Helper_Functions::hex2rgba($solid_color, $bg_opacity);

				$_row['style'] .= "background-color: $solid_color; background-color: $solid_color_rgba;";
				break;

			case 'pattern':
				$pattern_img = $atts['pattern'];
				$background = "background-image:url('$pattern_img');";

				$background_repeat = self::background_repeat($atts['repeat']);
				if (!empty($background_repeat)) {
					$background .= "background-repeat:$background_repeat;";
				}

				$_row['style'] .= $background;

				// Parallax background
				if (isset($parallax)) {
					$_row['attr'] = $parallax;
				}

				$parallax = $background = '';
				break;

			case 'image':
				$image = $atts['image'];
				$image_position = $atts['position'];
				$background = 'background-image: url(\'' . $image . '\');';
				if ($image_position) {
					$background .= 'background-position: ' . $image_position . ';';
				}

				// Background repeat
				if ($atts['img_repeat'] == 'cover') {
					$background .= '-webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover; background-repeat: no-repeat;';
				} else {
					$background_repeat = self::background_repeat($atts['img_repeat']);
					if (!empty($background_repeat)) {
						$background .= 'background-repeat: ' . $background_repeat . ';';
					}
				}

				if ($atts['width'] == 'full') {
					$_full_bg = array(
						'tag' => 'div',
						'id' => '',
						'class' => 'full_wide_content cbb-row-bg-full',
						'style' => $border_styles . $background,
						'content' => '',
						'before_content' => '',
						'after_content' => '',
						'attr' => '',
					);

					// Parallax background
					if (isset($parallax)) {
						$_full_bg['attr'] = $parallax;
					}

					$background = $border_styles = '';

					$_row['before_content'] .= ST_Pb_Helper_Html::html_tag($_full_bg);

				} else {
					$_row['data-image-src'] = $image;
					$_row['style'] .= $background;

					// Parallax background
					if (isset($parallax)) {
						$_row['attr'] = $parallax;
					}

				}
				break;

			case 'video': // youtube video
				$url = $atts['video_url'];

				// If not Youtube video then skip
				// pattern sourced from
				// https://gist.github.com/simplethemes/7591414
				if (preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $match)) {
					$youtube_id = $match[1];

					$_row['before_content'] .= '<div class="cb-row-video-bg ' . (($atts['width'] == 'full') ? 'full_wide_content' : '') . '"></div>';
					$_wrapper['before_content'] .= ST_Pb_Helper_Functions::script_box("
									$('#{$_wrapper['id']} > .row > .cb-row-video-bg').YTPlayer({
									    fitToBackground: false,
									    width: $('#{$_wrapper['id']} > .row').width(),
									    videoId: '{$youtube_id}',
									    playerVars: {
										  disablekb: 1,
										  iv_load_policy: 1,
									      modestbranding: 1,
									      autoplay: 1,
									      controls: 0,
									      showinfo: 0,
									      branding: 0,
									      rel: 0,
									      autohide: 0,
									      origin: window.location.origin
									    }
									});
									");

					wp_enqueue_script('cb-youtube-video');
				}
				break;

			case 'video_hosted':
				$_video_wrapper = array(
					'tag' => 'div',
					'id' => '',
					'class' => 'cbb-row-video-wrapper',
					'style' => 'position: absolute; top:0; bottom:0; width: 100%; overflow:hidden;',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
				);

				$_video = array(
					'tag' => 'video',
					'id' => '',
					'class' => 'cbb-row-video',
					'style' => 'top: 0; bottom: 0; left: 0px; position: absolute; width: 100%;',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
					'width' => '1800',
					'height' => '700',
					'muted' => ' ',
					'autoplay' => ' ',
					'loop' => ' ',
					'preload' => 'auto',
				);

				if ($atts['width'] == 'full') {
					$_video_wrapper['class'] .= ' full_wide_content';
					$_video_wrapper['style'] .= $border_styles;
					$border_styles = '';
				}

				$video_mp4 = $atts['video_mp4'];
				$video_webm = $atts['video_webm'];

				if ($video_mp4) {
					$_video['content'] .= '<source src="' . $video_mp4 . '" type="video/mp4">';
				}

				if ($video_webm) {
					$_video['content'] .= '<source src="' . $video_webm . '" type="video/webm">';
				}

				$_video_wrapper['content'] .= ST_Pb_Helper_Html::html_tag($_video);
				$_row['before_content'] .= ST_Pb_Helper_Html::html_tag($_video_wrapper);
				break;
			}

			// overlay
			if ($atts['show_overlay'] == 'yes' &&
			(
				$atts['background'] == 'pattern'
				OR $atts['background'] == 'image'
				OR $atts['background'] == 'video'
				OR $atts['background'] == 'video_hosted'
			)) {
				$_overlay = array(
					'tag' => 'div',
					'id' => '',
					'class' => 'cbb-bg-overlay',
					'style' => '',
					'content' => '',
					'before_content' => '',
					'after_content' => '',
					'attr' => '',
				);

				if ($atts['width'] == 'full') {
					$_overlay['class'] .= ' full_wide_content';
				}

				if ($atts['overlay_opacity'] > 0) {
					$atts['overlay_opacity'] /= 100;
				}

				$_overlay['style'] .= 'background-color: ' . ST_Pb_Helper_Functions::hex2rgba($atts['overlay_color'], $atts['overlay_opacity']) . ';';

				$_row['before_content'] .= ST_Pb_Helper_Html::html_tag($_overlay);
			}

			// apply border
			if ($border_styles) {
				$_row['style'] .= $border_styles;
			}


			// row height
			if (isset($atts['height']) && $atts['height'] != 'auto') {
				if ($atts['height'] == 'window_center') {
					$atts['height'] = 'window row_content_center';
				}

				//$_wrapper['class'] .= ' row_snap';
				$_row['class'] .= ' row_height_' . $atts['height'];
			}

			// perform content process
			$content = ST_Pb_Helper_Shortcode::remove_autop($content);
			$content = balanceTags($content);
			//$content = 'TEMP NO CONTENT'; // TEMP

			// insert tags into their parents
			$_inner['content'] = $content;
			$_row['content'] = $_inner;
			$_wrapper['content'] = $_row;

			// generate html / markup
			$output = ST_Pb_Helper_Html::html_tag($_wrapper);

			//$output = '<pre>'.print_r(htmlentities( $output ), TRUE).'</pre>' . $output;
			//$output .= '<pre>'.print_r(htmlentities( $temp_old_row ), TRUE).'</pre>' . $temp_old_row; // TEMP

			return $this->layout_wrapper($output, $atts);
		} // end DRY_element_shortcode

	}

endif;
