<?php
/**
 * ProStyler Builder Common functions
 *
 * Common functions (pure data, don't relate to IGPB shortcodes)
 *
 * @author         WooRockets Team <support@www.woorockets.com>
 * @package        IGPGBLDR
 * @version        $Id$
 */

class ST_Pb_Utils_Common {

	/**
	 * Delete meta keys
	 *
	 * @global type $wpdb
	 * @param type $keys
	 * @param type $post_id
	 * @return type
	 */
	static function delete_meta_key( $keys, $post_id = null ) {
		if ( empty ( $keys ) || ! count( $keys ) ) {
			return false;
		}
		global $wpdb;
		$extra = ! empty ( $post_id ) ? 'post_id = ' . esc_sql( $post_id ) . ' AND' : '';
		$sql = "DELETE FROM $wpdb->postmeta WHERE $extra meta_key IN (".implode(', ', array_fill(0, count($keys), '%s')).")";
		// Call $wpdb->prepare passing the values of the array as separate arguments
		$query = call_user_func_array(array($wpdb, 'prepare'), array_merge(array($sql), $keys));
		$wpdb->query( $query );
		// del all blog
		if( is_network_admin() ){
			// get list id blog all
			$list_prefix_musite = $wpdb->get_results(
				"SELECT blog_id FROM $wpdb->blogs",
				ARRAY_A
			);
			if($list_prefix_musite && count($list_prefix_musite) > 1){
				foreach ($list_prefix_musite as $key => $value) {
					if ($value['blog_id'] == 1) continue;
					$prefix = $wpdb->prefix.$value['blog_id'].'_';
					$sql = "DELETE FROM {$prefix}postmeta WHERE $extra meta_key IN (".implode(', ', array_fill(0, count($keys), '%s')).")";
					// Call $wpdb->prepare passing the values of the array as separate arguments
					$query = call_user_func_array(array($wpdb, 'prepare'), array_merge(array($sql), $keys));
					$wpdb->query( $query );
				}
			}
		}
	}

	/**
	 * Remove cache folder
	 *
	 * @return type
	 */
	static function remove_cache_folder() {
		$cache_dir = WP_CONTENT_DIR . '/uploads' . '/igcache/pagebuilder';
		ST_Pb_Utils_Common::recursive_delete( $cache_dir );

		// if directory still exits, false
		if ( is_dir( $dir ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Remove directory
	 *
	 * @param type $dir
	 */
	static function recursive_delete( $dir ) {
		if ( is_dir( $dir ) ) {
			global $wp_filesystem;

			if ( ! function_exists( 'WP_Filesystem' ) ) {
				include_once ABSPATH . 'wp-admin/includes/file.php';
			}
			if ( ! $wp_filesystem ) {
				WP_Filesystem();
			}
			$deleted = $wp_filesystem->delete( $dir, true );

			return $deleted;
		}
	}

	/**
	 * Generate random string
	 *
	 * @param type $length
	 * @param type $is_lower_no_number
	 *
	 * @return string
	 */
	static function random_string( $length = 6, $is_lower_no_number = false ) {
		if ( ! $is_lower_no_number ) {
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		} else {
			$characters = 'abcdefghijklmnopqrstuvwxyz';
		}

		$randomString = '';
		for ( $i = 0; $i < $length; $i ++ ) {
			$randomString .= $characters[rand( 0, strlen( $characters ) - 1 )];
		}

		return $randomString;
	}

	/**
	 * remove ' and " from string
	 *
	 * @param type $str
	 *
	 * @return type
	 */
	static function remove_quotes( $str ) {
		$str    = stripslashes( $str );
		$result = preg_replace( "/[\'\"]+/", '', $str );

		return $result;
	}

	/**
	 * Slice to get nth-child first word
	 *
	 * @param type $content
	 */
	static function slice_content( $content ) {
		$content = urldecode( $content );
		$content = strip_tags( $content );
		$arr     = explode( ' ', $content );
		$arr     = array_slice( $arr, 0, 10 );

		return implode( ' ', $arr );
	}

	/**
	 * Trim content to : $limit_count $limit_type ( 5 words, 20 characters ... )
	 *
	 * @param type $content
	 * @param type $limit_count
	 * @param type $limit_type
	 */
	static function trim_content( $content, $limit_count, $limit_type ) {
		if ( empty( $limit_count ) ) {
			return $content;
		}
		$content = trim( $content );
		$content = strip_tags( $content );
		if ( $limit_type == 'words' ) {
			$content = implode( ' ', array_slice( explode( ' ', $content ), 0, intval( $limit_count ) ) );
		} else {
			if ( $limit_type == 'characters' ) {
				$content = substr( $content, 0, intval( $limit_count ) );
			}
		}

		return balanceTags( $content );
	}

	/**
	 * Generate random lorem ipsum text
	 *
	 * @param type $word_count
	 *
	 * @return type
	 * @changelog
	 * v0.0.1 - Replaced with english lorem and sentencing forming with fullstops
	 */
	static function lorem_text( $word_count = 50, $lorem_start = false ) {
		$words  = array( 'leverage', 'agile', 'frameworks', 'to', 'provide', 'a', 'robust', 'synopsis', 'for', 'high', 'level', 'overviews', 'iterative', 'approaches', 'to', 'corporate', 'strategy', 'foster', 'collaborative', 'thinking', 'to', 'further', 'the', 'overall', 'value', 'proposition', 'organically', 'grow', 'the', 'holistic', 'world', 'view', 'of', 'disruptive', 'innovation', 'via', 'workplace', 'diversity', 'and', 'empowerment', 'Bring', 'to', 'the', 'table', 'win-win', 'survival', 'strategies', 'to', 'ensure', 'proactive', 'domination', 'At', 'the', 'end', 'of', 'the', 'day,', 'going', 'forward,', 'a', 'new', 'normal', 'that', 'has', 'evolved', 'from', 'generation', 'X', 'is', 'on', 'the', 'runway', 'heading', 'towards', 'a', 'streamlined', 'cloud', 'solution', 'User', 'generated', 'content', 'in', 'real-time', 'will', 'have', 'multiple', 'touchpoints', 'for', 'offshoring', );
		$result = array();
		if ( $lorem_start ) {
			$result[]    = 'lorem';
			$word_count -= 1;
		}
		$already_done = array(); $new_sentence = true;
		for ( $i = 0; $i < $word_count; $i ++ ) {
			$random_index = rand( 0, $word_count );
			
			if(in_array($random_index, $already_done))
			{
				$i--;
				continue;
			}
			 
			if($new_sentence) 
			{
				// cap word for new sentence
				$words[$random_index] = ucfirst($words[$random_index]);
				// reset
				$already_done = array();
			}
			
			$new_sentence = false;
			
			// full stop after every 10 words
			if ($i!=0 && $i<($word_count-8) && $i % 10 == 0 && strlen($words[$random_index])>3)
			{
				$words[$random_index] .= '.';
				// next word will be start of new sentence
				$new_sentence = true;
			}
			
			$already_done[] = $random_index;
			$result[]     = $words[$random_index];
		}

		return implode( ' ', $result ).'.';
	}
}