<?php

require_once ST_FRAMEWORK_PATH . '/includes/less.php/Less.php';
/**
 * Handles Dynamic CSS generation of Elements
 */
if (!class_exists('ST_Pb_Utils_Css')) {
	class ST_Pb_Utils_Css {
		private static $debug = false;
		public static $load_cache = true; // for debug

		public static $doing_css = false;
		private static $less_parser;
		private static $log = array();
		public static $cached_embedded_pages = array();

		/**
		 * Called by wp_head at the core to embed/echo current page, post, template CSS
		 * @return void
		 */
		public static function head_css() {
			//return;
			// performance test START
			// $start_time = microtime(true);
			// $start_memory = memory_get_usage();
			// echo '</head><body>';

			self::$doing_css = true;

			// start filter
			add_filter('pre_do_shortcode_tag', array('ST_Pb_Utils_Css', 'filter_shortcodes'), 10, 4);

			echo '<style>';

			// do for custom template
			self::currentTemplateStyles();

			// do for current post(s)/page
			self::currentPostsStyles();

			// stop filter
			remove_filter('pre_do_shortcode_tag', array('ST_Pb_Utils_Css', 'filter_shortcodes'));

			echo '</style>';

			self::$doing_css = false;

			// performance test END
			// $end_time = microtime(true);
			// $end_memory = memory_get_usage();
			// echo "time: ", bcsub($end_time, $start_time, 4), "\n";
			// echo "memory (start): ",  ($start_memory) , "\n";
			// echo "memory (end): ",  ($end_memory) , "\n";
			// echo "memory (byte): ",  ($end_memory - $start_memory) , "\n";
		}

		/**
		 * Echo CSS of current post, page (or loop)
		 * @return void
		 */
		static function currentPostsStyles() {
			global $posts;

			// do for current post/page
			foreach ($posts as $post) {
				echo self::getCSS('', $post);
			}
		}

		/**
		 * Echo CSS from current page,post custom template
		 * @return [type] [description]
		 */
		static function currentTemplateStyles() {
			global $custom_template, $custom_template_content;
			if (!$custom_template OR !$custom_template_content) {
				return;
			}

			echo self::getCSS('', $custom_template, $custom_template_content);
		}

		/**
		 * Get given page css from either cache or generate new css
		 * @param  int $postID        [WIP]optional: if no post object then give post id
		 * @param  array  $post          wp post object
		 * @param  string $final_content optionally give final post content to make css from
		 * @return string                generated css
		 */
		static function getCSS($postID, $post = array(), $final_content = '') {
			// if no post data supplied, use postID to get it
			if (!$post) {
				$post = get_post( $postID );
			}

			if (!$post) {
				return;
			}

			// get post css cache
			$cached_css = get_post_meta($post->ID, '_st_builder_css_cache', true);
			if (self::$load_cache && $cached_css) {
				// check modified time againist current
				if ($cached_css['post_modified'] == $post->post_modified) {

					// check for embed pages if their cache is older then the embed page's modified date
					if(isset( $cached_css['embedded_pages'] ) && ! empty($cached_css['embedded_pages']))
					{
						foreach($cached_css['embedded_pages'] as $embedded_page_id => $embedded_page_cache_date)
						{
							$embedded_page = get_post( $embedded_page_id );
							if (!$embedded_page) continue;

							// if cache is older then dont load from cache
							if ($embedded_page_cache_date != $embedded_page->post_modified)
							{
								self::$load_cache = false;
							}
						}
					}

					if (self::$load_cache)
					{
						// merge the logs so we dont generate their css in the markup later
						self::$log = array_merge(self::$log, $cached_css['elements_log']);
						return $cached_css['generated_css'];
					}
				}
			}

			// == if no valid cache then generate

			if ($final_content) {
				$content = $final_content;
			} else {
				$content = $post->post_content;
				$content = ST_Pb_Helper_Shortcode::get_builder_tab_content($content, $post);
			}

			if (!$content) {
				return;
			}

			// keep copy of original log
			$log_before = self::$log;
			// reset original log so we only keep log for this post
			self::$log = array();

			ob_start();
			//echo do_shortcode($content);
			echo ST_Pb_Helper_Shortcode::doshortcode_content( $content );
			$output = ob_get_contents();
			ob_end_clean();

			$log_after = self::$log;
			// merge it back
			self::$log = array_merge($log_before, $log_after);



			// save the generated css to post's css cache
			update_post_meta($post->ID, '_st_builder_css_cache', array(
				'post_modified' => $post->post_modified,
				'generated_css' => $output,
				'elements_log' => $log_after,
				'embedded_pages' => self::$cached_embedded_pages,
			));


			return $output;
		}

		/**
		 * Gives red light to shortcodes which dont belong to builder
		 * @param  string $shortcode_name
		 * @param  string $m              regex
		 * @return bool                 true to stop a shortcode and false to let it carry on
		 */
		public static function filter_shortcodes($return, $shortcode_name, $shortcode_attr, $m) {
			$content = isset($m[5]) ? $m[5] : null;

			// only allow st_ shortcodes
			if (!preg_match('/^st_/', $shortcode_name)) {
				// dont process this shortcode further
				return true;
			}

			//echo '<pre>filter_shortcodes: '.print_r($shortcode_name, TRUE).'</pre>';

			return false;
		}

		/**
		 * Sets flag when css generation has started
		 * @return [type] [description]
		 */
		public static function doing_css() {
			return self::$doing_css;
		}

		/**
		 * Called by elements when they see the flag for css generation and pass on here
		 * @param  object $instance current shortcode instance
		 * @param  array $atts     shortcode params
		 * @param  string $content  shortcode content
		 * @return string           generated css of current element
		 */
		public static function shortcode($instance, $atts = null, $content = null) {
			static $i;
			$i++;

			// if css is already performed then ignore this element
			if (self::in_log($atts) == true) {
				return '';
			}


			if (isset($instance->type) && $instance->type == 'layout') {
				do_shortcode($content);
				$content = '';
			} else {
				$instance->element_items();
				$instance->element_items_extra();
				$instance->shortcode_data();
			}

			//$atts = ST_Pb_Helper_Shortcode::check_and_assign_id($atts);
			$atts = (shortcode_atts($instance->config['params'], $atts));

			$css = ST_Pb_Utils_Css::generate_css($atts, $instance->items, false);

			echo $css;

			// if element has generate_content_css method then let it echo css
			$instance->css_helper_hook_echo_extra_css($atts, $content);

			// for child shortcodes
			if(preg_match('/\[st_/', $content))
			{
				do_shortcode($content);
				return '';
			}

			return $content;
		}

		/**
		 * Generates css with element attributes and fields for reference
		 * @param  array  $attrs      shortcode params WITH defaults
		 * @param  array  $fields     shortcode options tab and their fields
		 * @param  boolean $style_tags return <style> tags or not
		 * @return string              generated css
		 */
		public static function generate_css($attrs, $fields, $style_tags = true) {
			// if css is already performed then ignore this element
			if (self::in_log($attrs) == true) {
				return '';
			}

			$fields_original = $fields;

			// flatten tabs to fields
			$fields = array();
			foreach ($fields_original as $tab) {
				$fields = array_merge($fields, $tab);
			}

			$elm_id = (isset($attrs['id_wrapper'])) ? $attrs['id_wrapper'] : '';

			if (!$elm_id) {
				$elm_id = (isset($attrs['elm_id'])) ? $attrs['elm_id'] : '';
			}

			$elm_id_original = $elm_id;

			// element id to css id
			if ($elm_id) {
				$elm_id = '#' . $elm_id . ' ';
			}

			// flatten combo fields so all fields are top level arrays
			foreach ($fields as $index => $item) {
				if (isset($item['type']) && is_array($item['type'])) {
					foreach ($item['type'] as $field) {
						if (isset($item['dependency'])) {
							$field['dependency'] = $item['dependency'];
						}

						$fields[] = $field;
					}
					unset($fields[$index]);
				}
			}

			// here we make array grouped into css elements with their properties
			$elements = array();
			$has_margin = 0;
			foreach ($fields as $item) {
				if (!isset($item['id']) or !isset($item['css'])) {
					continue;
				}

				if (trim($attrs['style'])) {
					$item['id'] = str_replace($attrs['style'] . '_', '', $item['id']);
				}

				// dependency check, if fails then skip
				if (ST_Pb_Helper_Shortcode::field_dependency_check($item, $attrs) === false) {
					continue;
				}

				// check if this element has Margin param (1)
				if (isset($item['name']) && $item['name'] == __('Margin', ST_PBL) && $item['id'] != 'div_margin') {
					$has_margin = 1;
				}

				// if (1), don't use the 'auto extended margin ( top, bottom ) item'
				if (isset($has_margin) && $has_margin && isset($item['id']) && $item['id'] == 'div_margin') {
					continue;
				}

				$get_opacity_from = '';
				if (isset($item['get_opacity_from']) && $item['get_opacity_from']) {
					$get_opacity_from = $item['get_opacity_from'];
				}

				// if append is specified then pass on
				$append = '';
				if (isset($item['append'])) {
					$append = $item['append'];
				}

				// if media query
				if (isset($item['css']['media_query'])) {
					$query = $item['css']['media_query']['query'];
					//echo '<pre>'.print_r($item['css'], TRUE).'</pre>';
					foreach ($item['css']['media_query']['css'] as $elms) {
						if (!is_array($elements['media_query'][$query][$elms[0]])) {
							$elements['media_query'][$query][$elms[0]] = array();
						}

						$value_placeholder = isset($elms[2]) ? $elms[2] : '';
						$dependency = isset($elms[3]) ? $elms[3] : '';

						if ($return = self::_set_element_padding_margin($item, $elms[1], $value_placeholder, $dependency, $append)) {
							$elements['media_query'][$query][$elms[0]] = array_merge($elements['media_query'][$query][$elms[0]], $return);
						} else {
							$elements['media_query'][$query][$elms[0]][] = array(
								'attr' => $item['id'],
								'property' => $elms[1],
								'value_placeholder' => $value_placeholder,
								'dependency' => $dependency,
								'get_opacity_from' => $get_opacity_from,
								'append' => $append);
						}
					}

					continue;

					//echo '<pre>'.print_r($t, TRUE).'</pre>';
				}

				// === if normal properties ==

				// if not multi dependencies then create multi array so loop works normally
				if (!is_array($item['css'][0])) {
					$item['css'] = array($item['css']);
				}
				foreach ($item['css'] as $elms) {

					if (!$elms[0] && !$elms[1]) {
						continue;
					}

					if (!is_array($elements[$elms[0]])) {
						$elements[$elms[0]] = array();
					}

					$value_placeholder = isset($elms[2]) ? $elms[2] : '';

					$dependency = isset($elms[3]) ? $elms[3] : '';
					if ($return = self::_set_element_padding_margin($item, $elms[1], $value_placeholder, $dependency, $append)) {
						$elements[$elms[0]] = array_merge($elements[$elms[0]], $return);
					} else {
						$elements[$elms[0]][] = array(
							'attr' => $item['id'],
							'property' => $elms[1],
							'value_placeholder' => $value_placeholder,
							'dependency' => $dependency,
							'get_opacity_from' => $get_opacity_from,
							'append' => $append);
					}
				}
			}

			self::log($attrs);
			if (empty($elements)) {
				return '';
			}

			// make final css output
			$css = '';
			if ($style_tags) {
				$css = '<style id="style-' . $elm_id_original . '">';
			}
			if (self::$debug) {
				$css .= "\n";
			}

			//$generated_css = self::parse_less(self::elements_to_css($elements, $elm_id, $attrs));
			$generated_css = self::elements_to_css($elements, $elm_id, $attrs);
			if (!trim($generated_css)) {
				return '';
			}

			$css .= $generated_css;

			if ($style_tags) {
				$css .= '</style>';
			}
			if (self::$debug) {
				$css .= "\n";
			}

			return $css;
		}

		/**
		 * Grouped code for padding and margins fields to be split
		 * and added to array
		 * @param array $item              current field
		 * @param string $property          css property
		 * @param string/callback $value_placeholder css value placeholder for property
		 * @param array $dependency        css dependency for this property
		 * @param string $append            to append after css value
		 */
		private static function _set_element_padding_margin($item, $property, $value_placeholder, $dependency, $append) {
			if (isset($item['extended_ids'])
				&& $item['extended_ids']
				&& ($item['type'] == 'margin' || $item['type'] == 'padding')) {
			} else {
				return false;
			}

			$scope = array();
			$scope[] = array(
				'attr' => $item['id'] . '_top',
				'property' => $property . '-top',
				'value_placeholder' => $value_placeholder,
				'dependency' => $dependency,
				'append' => $append,
			);

			$scope[] = array(
				'attr' => $item['id'] . '_right',
				'property' => $property . '-right',
				'value_placeholder' => $value_placeholder,
				'dependency' => $dependency,
				'append' => $append,
			);

			$scope[] = array(
				'attr' => $item['id'] . '_bottom',
				'property' => $property . '-bottom',
				'value_placeholder' => $value_placeholder,
				'dependency' => $dependency,
				'append' => $append,
			);

			$scope[] = array(
				'attr' => $item['id'] . '_left',
				'property' => $property . '-left',
				'value_placeholder' => $value_placeholder,
				'dependency' => $dependency,
				'append' => $append,
			);

			return $scope;
		}

		/**
		 * Generates css
		 * @param  array $elements prepared elements array
		 * @param  string $elm_id   shortcode's id
		 * @param  array $attrs    shortcode's params
		 * @return string           generated css
		 */
		public static function elements_to_css($elements, $elm_id, $attrs) {
			$css_elements = '';

			// dependency check, if fails then skip
			// if(ST_Pb_Helper_Shortcode::field_dependency_check($item, $attrs) === false)
			// {
			// 	continue;
			// }
			//
			//echo '</style><pre>'.print_r($elements, TRUE).'</pre>';
			// each css class/element
			foreach ($elements as $element => $items) {

				// for media queries
				if ($element == 'media_query') {
					foreach ($items as $media_query => $media_items) {
						$css_element_single = '@media ' . $media_query . ' { ';
						if (self::$debug) {
							$css_element_single .= "\n";
						}

						$css_properties = self::elements_to_css($media_items, $elm_id, $attrs);
						if (!trim($css_properties)) {
							continue;
						}

						$css_element_single .= $css_properties;
						$css_element_single .= '}';

						//echo '<pre>'.print_r($css_element_single, TRUE).'</pre>';

						$css_elements .= $css_element_single;
					}

					continue;
				}

				// put in element id where and if placeholder

				$css_element_single = $elm_id . $element;
				if (preg_match('/%id%/i', $element)) {
					$css_element_single = str_replace('%id%', trim($elm_id), $element);
				}

				$css_element_single = $css_element_single . ' { ';

				if (self::$debug) {
					$css_element_single .= "\n";
				}

				$css_properties = '';

				// each css property
				foreach ($items as $item) {
					if (!isset($item['attr']) or !$item['attr']) {
						continue;
					}

					// css item dependency check, if fails then skip
					if (ST_Pb_Helper_Shortcode::field_dependency_check($item, $attrs) === false) {
						continue;
					}

					// for color attributes, empty means transparent
					if (!$attrs[$item['attr']] && preg_match('/color/', $item['property'])) {
						continue;
					}

					// for properties which are array, we compare with current value and use its defined output
					if (is_array($item['property'])) {
						if (isset($item['property'][$attrs[$item['attr']]])) {
							$css_properties .= $item['property'][$attrs[$item['attr']]];
						}
					} else {
						// if no value and not even numeric zero then skip
						if (!is_numeric($attrs[$item['attr']]) && !$attrs[$item['attr']]) {
							continue;
						}

						$css_properties .= self::apply_value_placeholder($item, $attrs);
					}
					if (self::$debug) {
						$css_properties .= "\n";
					}
				}

				// if no properties in element skip element
				if (!trim($css_properties)) {
					continue;
				}

				$css_element_single .= $css_properties;

				$css_element_single .= '}';
				if (self::$debug) {
					$css_element_single .= "\n";
				}

				$css_elements .= $css_element_single;
			}

			// if no elements/classes in css output nothing
			if (!trim($css_elements)) {
				return '';
			}

			return $css_elements;
		}

		/**
		 * Puts the given value inside given placeholder
		 * to make final css value
		 * @param  string $value       css value
		 * @param  string $placeholder
		 * @return string              css value
		 */
		public static function apply_value_placeholder($item, $attrs) {
			$value = $attrs[$item['attr']] . $item['append'];
			$placeholder = $item['value_placeholder'];

			if (!$placeholder) {
				return $item['property'] . ': ' . $value . ';';
			}

			// if css needs opacity from another field
			if (is_array($placeholder)
				&& isset($placeholder['opacity_from'])
				&& isset($attrs[$placeholder['opacity_from']])) {
				$opacity = $attrs[$placeholder['opacity_from']];
				if ($opacity > 0) {
					$opacity /= 100;
				} else {
					$opacity = 0;
				}

				$rgba = ST_Pb_Helper_Functions::hex2rgba($value, $opacity);

				// return normal for older browsers fallback and rgba for modern
				return $item['property'] . ': ' . $value . '; ' . $item['property'] . ': ' . $rgba . '; ';
			}

			return $item['property'] . ': ' . str_replace('%value%', $value, $placeholder) . ';';
		}

		/**
		 * CSS to LESS Parser
		 * @param  string $css CSS/LESS Formated CSS. lol
		 * @return string      standard css
		 */
		public static function parse_less($css) {
			if (!self::$less_parser) {
				self::$less_parser = new Less_Parser(array('compress' => (self::$debug) ? false : true));
			} else {
				self::$less_parser->reset();
			}
			self::$less_parser->parse($css);
			return self::$less_parser->getCss();
		}

		/**
		 * Checks if css for element is already done or not
		 * @param  array $attrs elements params
		 * @return bool        true if exists false otherwise
		 */
		public static function in_log($attrs) {
			if (isset($attrs['id_wrapper']) && in_array($attrs['id_wrapper'], self::$log)) {
				// echo '<pre>skipped: '.print_r($attrs['id_wrapper'], TRUE).'</pre>';
				return true;
			}

			// echo '<pre>log: '.print_r(self::$log, TRUE).'</pre>';
			// echo '<pre>id_wrapper: '.print_r($attrs['id_wrapper'], TRUE).'</pre>';

			return false;
		}

		/**
		 * Log elements for which css is done
		 * @param  array $attrs element params
		 * @return void
		 */
		public static function log($attrs) {
			if (!isset($attrs['id_wrapper'])) {
				return '';
			}

			self::$log[] = $attrs['id_wrapper'];
		}
	} // end class ST_Pb_Utils_Css
} // end class exist check
