<?php


if ( ! class_exists( 'ST_Accordion' ) ) :

/**
 * Create accordion element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Accordion extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'Accordion', ST_PBL );
		$this->config['cat']              = __( 'Interactive Elements', ST_PBL );
		$this->config['icon']             = 'cbi-Accordian';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Vertically stacked and tabbed content', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'admin_assets' => array(
				'st-pb-joomlashine-iconselector-js',
			),
			'frontend_assets' => array(
					// Bootstrap 3
					'st-pb-bootstrap-css',
					'st-pb-bootstrap-js',
					// Font IcoMoon
					'st-pb-font-icomoon-css',
					// Load css front_end for this element.
					'accordion_frontend.css'
				),
			);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;

		// Edit inline supplement
		add_action( 'st_pb_modal_footer', array( 'ST_Pb_Objects_Modal', '_modal_footer' ) );
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'action' => array(
				array(
					'id'      => 'btn_convert',
					'type'    => 'button_group',
					'bound'   => 0,
					'actions' => array(
						array(
							'std'         => __( 'Tab', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'accordion_to_tab',
						),
						array(
							'std'         => __( 'Carousel', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'accordion_to_carousel',
						),
						array(
							'std'         => __( 'List', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'accordion_to_list',
						),
					)
				),
			),
			'content' => array(
				array(
					'id'            => 'accordion_items',
					'type'          => 'group',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '' ),
						array( 'std' => '' ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'     => __( 'Initial Open', ST_PBL ),
					'id'       => 'initial_open',
					'type'     => 'text_number',
					'std'      => '1',
					'class'    => 'input-mini',
					'validate' => 'number',
					'tooltip'  => __( 'Set which item will be opened first', ST_PBL ),
				),
				array(
					'name'    => __( 'Allow Multiple Opening', ST_PBL ),
					'id'      => 'multi_open',
					'type'    => 'radio',
					'std'     => 'no',
					'options' => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'tooltip' => __( 'Keep previous item opened when clicking on another one', ST_PBL ),
				),
				array(
					'name'    => __( 'Enable Filter', ST_PBL ),
					'id'      => 'filter',
					'type'    => 'radio',
					'std'     => 'no',
					'options' => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'tooltip' => __( 'Filter based on items\' tags name. Please set tag for item first.', ST_PBL ),
				),

				array(
					'name'    => __( 'Heading', ST_PBL ),
					'type'    => 'group_open',
				),

				array(
					'name'    => __( 'Text color', ST_PBL ),
					'id'       => 'h_text_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .panel-group > .panel > .panel-heading', 'color'),
					),
				),

				array(
					'name'    => __( 'Background color', ST_PBL ),
					'id'       => 'h_bg_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .panel-group > .panel > .panel-heading', 'background-color'),
					),
				),

				array(
					'name'    => __( 'Border color', ST_PBL ),
					'id'       => 'border_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .panel-group > .panel-default', 'border-color'),
						array('> .panel-group > .panel-default > .panel-heading + .panel-collapse > .panel-body', 'border-top-color'),
					),
				),

				array(
					'type'    => 'group_close',
				),

				array(
					'name'    => __( 'Content Background color', ST_PBL ),
					'id'       => 'bg_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .panel-group > .panel', 'background-color'),
					),
				),

				array(
					'name' => __( 'Rounded corners', ST_PBL ),
					'id'           => 'border_radius',
					'type'     => 'slider',
					'class'        => 'st-slider',
					'std_max'      => '20',
					'std'          => '0',
					'append'       => 'px',
					'validate'     => 'number',
					'css' => array(
						array('> .panel-group > .panel > .panel-heading', 'border-top-right-radius'),
						array('> .panel-group > .panel > .panel-heading', 'border-top-left-radius'),
						array('> .panel-group > .panel', 'border-radius'),
					),
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		
		$arr_params   = shortcode_atts( $this->config['params'], $atts );
		$initial_open = intval( $arr_params['initial_open'] );
		$multi_open   = $arr_params['multi_open'];
		$filter       = $arr_params['filter'];
		$random_id    = ST_Pb_Utils_Common::random_string();
		$script       = '';

		extract( $arr_params );

		if ( $multi_open == 'no' ) {
			$script .= "<script type='text/javascript'>( function ($) {
				$( document ).ready( function ()
				{
					// Bind event click accordion
					$( '#accordion_$random_id .panel-title a' ).on('click', function (e) {
						e.preventDefault();
						$('#accordion_$random_id .in').collapse('hide');
					});
				});
			} )( jQuery )</script>";
		}

		$sub_shortcode = do_shortcode( $content );
		$items = explode( '<!--seperate-->', $sub_shortcode );

		// remove empty element
		$items = array_filter( $items );

		// update id, class for each item
		$initial_open = ( $initial_open > count( $items ) ) ? 1 : $initial_open;
		foreach ( $items as $idx => $item ) {
			$open         = ( $idx + 1 == $initial_open ) ? 'in' : '';
			$item = str_replace( '{index}', $random_id . $idx, $item );
			$item = str_replace( '{show_hide}', $open, $item );

			// replace content of tab with page embed
			if(preg_match('/'.preg_quote('<!--page_embed=[').
				'([a-z0-9]+(?:-[a-z0-9]+)*)'
				.preg_quote(']-->').'/i', $item, $page_embed) 
				&& isset($page_embed[1]) )
			{
				$page_embed = $page_embed[1];
				$tab_content = do_shortcode( $this->get_page_content( $page_embed ) );

				$item = str_replace('<!--page_embed=['.$page_embed.']-->', $tab_content, $item);
			}

			$items[$idx] = $item;
		}
		$sub_shortcode = implode( '', $items );

		$filter_html = '';
		if ( $filter == 'yes' ) {
			$sub_sc_data = ST_Pb_Helper_Shortcode::extract_sub_shortcode( $content );
			$sub_sc_data = reset( $sub_sc_data );

			// tags to filter item
			$tags = array( 'all' );

			foreach ( $sub_sc_data as $shortcode ) {
				$extract_params = shortcode_parse_atts( $shortcode );
				$tags[] = $extract_params['tag'];
			}
			$tags = array_filter( $tags );

			if ( count( $tags ) > 1 ) {

				$tags = implode( ',', $tags );
				$tags = explode( ',', $tags );
				$tags = array_unique( $tags );
				$filter_html = ST_Pb_Helper_Shortcode::render_parameter( 'filter_list', $tags, $random_id );

				// remove "All" tag
				array_shift( $tags );
				$inner_tags = implode( ',', $tags );
				$script .= "<script type='text/javascript'>( function ($) {
				$( document ).ready( function ()
				{
					window.parent.jQuery.noConflict()( '#jsn_view_modal').contents().find( '#st_share_data' ).text( '{$inner_tags}')
					var parent_criteria = '#filter_$random_id'
					var clientsClone = $( '#accordion_$random_id' );
					var tag_to_filter = 'div';
					var class_to_filter = '.panel-default';

					$( parent_criteria + ' a' ).click( function(e ) {
						// stop running filter
						$( class_to_filter ).each(function(){
							$( this ).stop( true )
						})
						e.preventDefault();

						//active clicked criteria
						$( parent_criteria + ' li' ).removeClass( 'active' );
						$( this ).parent().addClass( 'active' );

						var filterData = $( this ).attr( 'class' );
						var filters;
						if( filterData == 'all' ){
							filters = clientsClone.find( tag_to_filter );
						} else {
							filters = clientsClone.find( tag_to_filter + '[data-tag~='+ filterData +']' );
						}
						clientsClone.find( class_to_filter ).each(function(){
							$( this ).fadeOut()
						});
						filters.each(function(){
							$( this ).fadeIn()
						});
					});
				});
			} )( jQuery )</script>";
			}
		}

		$html = '<div class="panel-group" id="accordion_{ID}">' . $sub_shortcode . '</div>';
		$html = str_replace( '{ID}', $random_id, $html );

		return $this->element_wrapper( $filter_html . $html . $script, $arr_params );
	}



	function get_page_content($id, $echo_css = true)
	{
		$page = get_page_by_path($id,OBJECT,'page');
		
		if(! $page OR !isset($page->ID)) return false;

		// Get what tab (Classic - Pagebuilder) is active when Save content of this post
		$st_page_active_tab = get_post_meta( $page->ID, '_wr_page_active_tab', true );
		$st_deactivate_pb = get_post_meta( $page->ID, '_wr_deactivate_pb', true );

		$content = $page->post_content;
		$content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
			$content, 
			$page, 
			$st_page_active_tab,
			$st_deactivate_pb
		);

		// if not deactivate pagebuilder on this post/page then add its css etc
		if ( empty( $st_deactivate_pb ) ) 
		{

			$custom_css_data = ST_Pb_Helper_Functions::custom_css_data( isset ( $page->ID ) ? $page->ID : NULL );
			extract( $custom_css_data );

			if($css_custom)
			{
				$css_custom = html_entity_decode( stripslashes( $css_custom ) );

				$this->page_css = balanceTags( "<style id='st-pb-custom-{$post->ID}-css'>\n$css_custom\n</style>\n" );
				if($echo_css) echo $this->page_css;
			}
		}

		if(! trim($content)) return false;
		
		return $content;
	}

}

endif;
