<?php
/**
 * @version    $Id$
 * @package    ProStyler Builder Shortcodes
 * @author     WooRockets Team <support@stencilor.com>
 * @copyright  Copyright (C) 2012 woorockets.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.woorockets.com
 * Technical Support:  Feedback - http://www.woorockets.com
 */
if ( ! class_exists( 'ST_Item_Accordion' ) ) {

	/**
	 * Create accordion child element.
	 *
	 * @package  ProStyler Builder Shortcodes
	 * @since    1.0.0
	 */
	class ST_Item_Accordion extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'data-modal-title' => __( 'Accordion Item', ST_PBL ),

			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
								'name'  => __( 'Heading', ST_PBL ),
								'id'    => 'heading',
								'type'  => 'text_field',
								'class' => 'input-sm',
								'role'  => 'title',
								'std'   => __( ST_Pb_Utils_Placeholder::add_placeholder( 'Accordion Item %s', 'index' ), ST_PBL ),
								'default_avoid'=>false, // stops from excluding from shortcode when default value
					),

					array(
						'name'       => __( 'Content Source', ST_PBL ),
						'id'         => 'content_source',
						'type'       => 'radio',
						'std'        => 'editor',
						'options'    => array( 'editor' => __( 'Editor', ST_PBL ), 'page_embed' => __( 'Page embed', ST_PBL ) ),
						'has_depend' => '1',
					),

					array(
						'name'    => __( 'Select Page', ST_PBL ),
						'id'      => 'page',
						'type'    => 'select',
						'std'     => '',
						'role'=>'title',
						'options' => ST_Pb_Helper_Functions::pages_array(),
						'dependency'      => array( 'content_source', '=', 'page_embed' ),
					),

					array(
								'name' => __( 'Content Editor', ST_PBL ),
								'id'   => 'body',
								'role' => 'content',
								'type' => 'tiny_mce',
								//'container_class' => 'st_tinymce_replace',
								'std'  => ST_Pb_Helper_Type::lorem_text(),
								'dependency'      => array( 'content_source', '=', 'editor' ),
					),
					array(
								'name'      => __( 'Icon', ST_PBL ),
								'id'        => 'icon',
								'type'      => 'icons',
								'std'       => '',
								'role'      => 'title_prepend',
								'title_prepend_type' => 'icon',
					),
					array(
								'name' => __( 'Tag Name', ST_PBL ),
								'id'   => 'tag',
								'type' => 'tag',
								'std'  => '',
                        'tooltip' => __( 'Used for items filtering', ST_PBL ),
					),
				)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) {
			extract( shortcode_atts( $this->config['params'], $atts ) );

			// tag1,tag2 => tag1 tag2 , to filter
			$tag = str_replace( ' ', '_', $tag );
			$tag = str_replace( ',', ' ', $tag );
	
			// replaced with
			//$inner_content = ST_Pb_Helper_Shortcode::remove_autop( $content );
			// this, add wpautop to content
			$inner_content = '';
			if($content_source == 'page_embed')
			{
				if(isset($page) && trim($page))
				{	
					$inner_content = '<!--page_embed=['.$page.']-->';
				}
			}
			else
			{
				$inner_content = chiedolabs_shortcode_autop( $content );
			}
			
			ST_Pb_Helper_Functions::heading_icon( $heading, $icon );
			return "
			<div class='panel panel-default' data-tag='$tag'>
				<div class='panel-heading'>
					<h4 class='panel-title'>
						<a data-toggle='collapse' href='#collapse{index}'>
							<i class='$icon'></i>$heading
							<i class='st-icon-accordion'></i>
						</a>
					</h4>
				</div>
				<div id='collapse{index}' class='panel-collapse collapse {show_hide}'>
				  <div class='panel-body'>
				  {$inner_content}
				  </div>
				</div>
			</div><!--seperate-->";
		}

	}

}
