<?php
if (!class_exists('ST_Blog')):

/**
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
	class ST_Blog extends ST_Pb_Shortcode_Element {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Blog', ST_PBL);
			$this->config['cat'] = __('Content', ST_PBL);
			$this->config['icon'] = 'cbi-Blog';
			$this->config['description'] = __('Easily embed blog posts in your pages', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(

				'frontend_assets' => array(
					'cbb-isotope-js',
					'blog_frontend.css',
					'blog_frontend.js',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {

			$categories = get_categories();
			$categories_list = array();

			$categories_list[''] = 'All';
			if ($categories) {
				foreach ($categories as $cat) {
					$categories_list[$cat->term_id] = $cat->name;
				}
			}

			//echo '<pre>'.print_r($categories_list, TRUE).'</pre>';

			$this->items['content'] = array(

				array(
					'name' => __('Order By', ST_PBL),
					'id' => 'order_by',
					'type' => 'select',
					'std' => 'date',
					'options' => array(
						"date" => "Date",
						'ID' => 'ID',
						'author' => 'Author',
						'title' => 'Title',
						'modified' => 'Date Modified',
						'rand' => 'Random',
						'comment_count' => '# of Comments',
						'menu_order' => 'Menu order',
					),
				),

				array(
					'name' => __('Order', ST_PBL),
					'id' => 'order',
					'type' => 'select',
					'std' => 'DESC',
					'options' => array(
						"DESC" => "Descending",
						"ASC" => "ascending",
					),
				),

				array(
					'name' => __('Count (Per page if pagination shown)', ST_PBL),
					'id' => 'count',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '10',
					'append' => 'posts',
					'validate' => 'number',
				),

				array(
					'name' => __('Filter by Tags (e.g tag1,tag2) - Optional', ST_PBL),
					'id' => 'tags',
					'type' => 'text_field',
					'std' => '',
					'tooltip' => __('Limit by Tags.', ST_PBL),
				),

				array(
					'name' => __('Filter by Category', ST_PBL),
					'id' => 'category',
					'type' => 'select',
					'std' => '',
					'options' => $categories_list,
				),

			);

			$this->items['styling'] = array(
				array(
					'type' => 'preview',
				),

				array(
					'name' => __('Columns', ST_PBL),
					'id' => 'columns',
					'type' => 'select',
					'std' => '3',
					'options' => array(
						"1" => "1",
						"2" => "2",
						"3" => "3",
						"4" => "4",
						"5" => "5",
					),
				),

				array(
					'name' => __('Show Pagination', ST_PBL),
					'id' => 'pagination',
					'type' => 'radio',
					'std' => 'yes',
					'options' => array('yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL)),
				),

				array(
					'name' => __('Layout mode', ST_PBL),
					'id' => 'layout_mode',
					'type' => 'select',
					'std' => 'masonry',
					'options' => array(
						"masonry" => "Masonry",
						"fitRows" => "Fit rows",
						"list" => "List",
					),
					'has_depend' => '1',
				),

				array(
					'name' => __('Excerpt text length', ST_PBL),
					'id' => 'excerpt_length',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '150',
					'append' => 'characters',
					'validate' => 'number',
				),

				array(
					'name' => __('Elements', ST_PBL),
					'id' => 'elements',
					'type' => 'items_list',
					'std' => 'image__#__title__#__author__#__date__#__excerpt',
					'options' => array(
						'image' => __('Image', ST_PBL),
						'title' => __('Title', ST_PBL),
						'author' => __('Author', ST_PBL),
						'date' => __('Date', ST_PBL),
						'excerpt' => __('Excerpt', ST_PBL),
					),
					'options_type' => 'checkbox',
					'popover_items' => array('title', 'button'),
					'tooltip' => __('Elements to display on promotion box', ST_PBL),
					'style' => array('height' => '200px'),
					'container_class' => 'unsortable content-elements',
				),
				array(
					'type' => 'skip_to_next_section',
				),

				ST_Pb_Helper_Type::get_shadow_type('shadow', '.cbb-blog-item', array(
                    array('.cbb-blog-item', 'border-bottom-width', '1px', array(
                        array('shadow', '!=', ''),
                        array('border_width', '=', ''),
                    )),
				)),

				array(
					'name' => 'Colors',
					'type' => 'group_open',
				),

				array(
					'name' => __('Title color', ST_PBL),
					'id' => 'title_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array('.cbb-blog-item .cbb-blog-title a', 'color'),
				),

				array(
					'name' => __('Links color', ST_PBL),
					'id' => 'link_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('Applies to Body text links, Author and Date', ST_PBL),
					'css' => array('.cbb-blog-item a', 'color'),
				),

				array(
					'name' => __('Text color', ST_PBL),
					'id' => 'text_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.cbb-blog-item', 'color'),
						array('.cbb-blog-item .byline', 'color'),
					),
				),

				array(
					'name' => __('Background color', ST_PBL),
					'id' => 'bg_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array('.cbb-blog-item', 'background-color'),
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				array(
					'type' => 'group_close',
				),

				array(
					'name' => 'Read more link',
					'type' => 'group_open',
				),

				array(
					'name' => __('Link style', ST_PBL),
					'id' => 'read_more_style',
					'type' => 'select',
					'std' => 'dots',
					'options' => array(
						"dots" => "Dots [...]",
						"button" => "Button",
					),
					'has_depend' => 1,
				),

				array(
					'name' => __('Text', ST_PBL),
					'id' => 'rmb_text',
					'type' => 'text_field',
					'std' => 'Read more',
					'dependency' => array('read_more_style', '=', 'button'),
				),

				array(
					'name' => __('Button Style', ST_PBL),
					'id' => 'rmb_style',
					'type' => 'select',
					'std' => 'default',
					'options' => array(
						'default' => __('Default', ST_PBL),
						'default-no-fill' => __('Default No Fill', ST_PBL),
						'rounded' => __('Rounded', ST_PBL),
						'rounded-no-fill' => __('Rounded No Fill', ST_PBL),
					),
					'dependency' => array('read_more_style', '=', 'button'),
				),
				array(
					'name' => __('Button Color', ST_PBL),
					'id' => 'rmb_color',
					'type' => 'select',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_button_color()),
					'options' => ST_Pb_Helper_Type::get_button_color(),
					//'container_class'   => 'color_select2',
					'tooltip' => __('Select the color of the button', ST_PBL),
					'dependency' => array('read_more_style', '=', 'button'),
				),

				array(
					'type' => 'group_close',
				),

				array(
					'name' => 'Hover styles',
					'type' => 'group_open',
				),

				array(
					'name' => __('Title color', ST_PBL),
					'id' => 'hover_title_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array('.cbb-blog-item:hover .cbb-blog-title a', 'color'),
				),

				array(
					'name' => __('Links color', ST_PBL),
					'id' => 'hover_link_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('Applies to Body text links, Author and Date', ST_PBL),
					'css' => array('.cbb-blog-item:hover a', 'color'),
				),

				array(
					'name' => __('Text color', ST_PBL),
					'id' => 'hover_text_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.cbb-blog-item:hover', 'color'),
						array('.cbb-blog-item:hover .byline', 'color'),
					),
				),

				array(
					'name' => __('Background color', ST_PBL),
					'id' => 'hover_bg_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array('.cbb-blog-item:hover', 'background-color'),
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				array(
					'name' => __('Border color', ST_PBL),
					'id' => 'hover_border_color',
					'type' => 'color_picker',
					'std' => '',
					'tooltip' => __('', ST_PBL),
					'css' => array('.cbb-blog-item:hover', 'border-color'),
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				ST_Pb_Helper_Type::get_shadow_type('hover_shadow', '.cbb-blog-item:hover'),

				array(
					'type' => 'group_close',
				),

				array(
					'name' => __('Border', ST_PBL),
					'type' => array(
						array(
							'id' => 'border_width',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '',
							'append' => 'px',
							'validate' => 'number',
							'parent_class' => 'combo-item input-append-inline',
							'css' => array('.cbb-blog-item', 'border-width'),
						),
						array(
							'id' => 'border_style',
							'type' => 'select',
							'class' => 'input-sm st-border-type',
							'std' => '',
							'options' => ST_Pb_Helper_Type::get_border_styles(),
							'parent_class' => 'combo-item',
							'css' => array('.cbb-blog-item', 'border-style'),
						),
						array(
							'id' => 'border_color',
							'type' => 'color_picker',
							'std' => '',
							'parent_class' => 'combo-item',
							'css' => array('.cbb-blog-item', 'border-color'),
						),
					),
					'container_class' => 'combo-group',
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				array(
					'name' => __('Rounded corners', ST_PBL),
					'id' => 'border_radius',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '',
					'append' => 'px',
					'validate' => 'number',
					'css' => array('.cbb-blog-item', 'border-radius'),
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				array(
					'name' => __('Spacing between posts', ST_PBL),
					'id' => 'spacing',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '',
					'append' => 'px',
					'validate' => 'number',
					'tooltip' => __('Left right spacing between posts', ST_PBL),
					'css' => array(
						array('.cbb-blog-item', 'margin-right'),
						array('.cbb-blog-item', 'margin-left'),
					),
					'dependency' => array('layout_mode', '!=', 'list'),
				),

				// array(
				//     'name'    => __( 'Mobile Title color', ST_PBL ),
				//     'id'       => 'mobile_title_color',
				//     'type'     => 'color_picker',
				//     'std'      => 'red',
				//     'tooltip' => __( '', ST_PBL ),
				//     'css' => array(
				//         'media_query' => array(
				//             'query'=>'(max-width: 829px)',
				//             'css' => array(
				//                 array('.cbb-blog-item .cbb-blog-title a', 'color')
				//             )
				//         )
				//     ),
				// ),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			);
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			$arr_params = (shortcode_atts($this->config['params'], $atts));
			extract($arr_params);

			$elements = explode('__#__', $elements);

			$this->id = $arr_params['elm_id'];
			$this->columns = (int) $columns;

			$page = get_query_var('paged');
			if (!$page) {
				$page = get_query_var('page');
			}

			$page = !empty($page) ? intval($page) : 1;

			$args = array(
				'posts_per_page' => $count,
				'offset' => $count * ($page - 1),
				'orderby' => $order_by,
				'order' => $order,
				'include' => '',
				'exclude' => '',
				'meta_key' => '',
				'meta_value' => '',
				'post_type' => 'post',
				'post_mime_type' => '',
				'post_parent' => '',
				'post_status' => 'publish',
				'suppress_filters' => true,
			);

			if ($category) {
				$args['cat'] = $category;
			}

			if ($tags) {
				$args['tag'] = $tags;
			}

			global $post;
			$the_query = get_posts($args);

			if (!$the_query) {
				return __('Sorry, no posts matched the criteria.', ST_PBL);
			}

			$columns_class = 'col-md-' . floor(12 / $columns);
			$columns_class_xs = '';

			if ($columns > 3) {
				$columns_class_xs = 'col-sm-6 col-xs-12';
			} elseif ($columns > 1) {
			$columns_class_xs = 'col-sm-6 col-xs-12';
		}

		$isotope_layout_mode = $layout_mode;
		if ($layout_mode == 'list') {
			$isotope_layout_mode = '';
			$columns_class = $columns_class_xs = '';
		}

		$this->layout_mode = $layout_mode;

		$output = '<div id="' . $this->id . '" class="cbb-blog-instance" data-layout_mode="' . $isotope_layout_mode . '">';

		$output .= '<ul id="cbb-blog-' . $this->id . '" class="cbb-blog cbb-blog-layout-' . $layout_mode . ' row ' . implode(' cbb-blog-has-', $elements) . '">';

		$output .= $items;
		foreach ($the_query as $post): setup_postdata($post);

			$image = '';

			if (in_array('image', $elements)) {
				$image = $this->post_image($columns, $layout_mode);
			}

			$output .= '<li class="isotope-blog-item ' . $columns_class . ' ' . $columns_class_xs . '"><div class="cbb-blog-item">';

			//echo '<pre>'.print_r($image, TRUE).'</pre>';

			if ($image) {
				$output .= '<a class="cbb-blog-img" href="' . get_the_permalink() . '">' . $image . '</a>';
			}

			$output .= '<div class="cbb-blog-item-inner ' . ((!$image) ? 'cbb-blog-item-no-image' : '') . '">';

			if (in_array('title', $elements)) {
				$output .= '<h3 class="cbb-blog-title"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>';
			}

			if (in_array('author', $elements) or in_array('date', $elements)) {
				$output .= '<p class="byline vcard">';

				if (in_array('author', $elements) && function_exists('bones_get_the_author_posts_link')) {
					$output .= 'by <span class="author">' . bones_get_the_author_posts_link() . '</span>';
				}

				if (in_array('author', $elements) && in_array('date', $elements)) {
					$output .= ' - ';
				}

				if (in_array('date', $elements)) {
					$output .= '<time class="updated" datetime="' . esc_attr(get_the_date('c')) . '">' . get_the_time(get_option('date_format')) . '</time>';
				}

				$output .= '</span>';
			}

			//echo '<pre>'.print_r($post, TRUE).'</pre>';

			if (in_array('excerpt', $elements)) {
				if ($post->post_excerpt) {
					$excerpt = $post->post_excerpt;
				} else {
					$excerpt = $post->post_content;

					$excerpt_tab_content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
						null,
						$post,
						null,
						null,
						null,
						false// dont process content as we only use it to make excerpt
					);

					if ($excerpt_tab_content) {
						// only get text element
						// TO-DO: dont match till ending [/st_text]
						preg_match_all('/\[st_text[^\]]*]([^\[]*)\[\/st_text[^\]]*]/uis', $excerpt_tab_content, $matches);
						$excerpt = implode('<br />', $matches[1]);
					}
				}

				$excerpt_end = '';
				$excerpt_url = get_the_permalink();
				if ($excerpt_url) {
					switch ($read_more_style) {
					case 'button':
						$btn_class = 'cbb-blog-btn btn btn-sm';
						$btn_class .= ' btn-style-' . $rmb_style;
						$btn_class .= ' ' . $rmb_color;
						$excerpt_end = '<div class="clearfix"></div><a href="' . $excerpt_url . '" class="' . $btn_class . '">' . $rmb_text . '</a><div class="clearfix">';
						break;

					default:
						$excerpt_end = '<a href="' . $excerpt_url . '">[...]</a>';
						break;
					}

				}

				$output .= '<div class="cbb-blog-text">' . $this->the_excerpt_max_charlength($excerpt_length, strip_tags(do_shortcode($excerpt)), $excerpt_end) . '</div>';
			}

			$output .= '</div>';

			$output .= '</div></li>';

		endforeach;

		$output .= '</ul>';

		if ($pagination == 'yes' && function_exists("emm_paginate")) {
			$args['posts_per_page'] = '-1';
			$args['offset'] = '0';
			$the_query = get_posts($args);

			$pages = intval(ceil(count($the_query) / $count));
			$output .= emm_paginate(array(
				'page' => $page,
				'pages' => $pages,
				'echo' => 0,
			));
		}

		$output .= '</div>';

		wp_reset_postdata();

		$html_elements = $output;

		//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';

		return $this->element_wrapper($html_elements, $arr_params);
	}

	public function post_image($columns) {
		$attach_id = get_post_thumbnail_id(get_the_ID());

		if (!$attach_id) {
			return;
		}

		$img_size = $this->get_size($columns);
		$post_thumbnail = ST_Pb_Helper_Functions::getImageBySize(array(
			'attach_id' => $attach_id,
			'thumb_size' => $img_size,
			'class' => $thumb_style,
		));

		if (!$post_thumbnail) {
			return;
		}

		return $post_thumbnail['thumbnail'];
	}

	public function get_size($columns, $container_size = 1100) {
		//$container_size -= $this->columns * 30;
		if ($this->layout_mode == 'list') {
			return '200x200';
		}

		$size = $container_size / $columns;
		$size = floor($size);
		//echo '<pre>'.print_r(ceil($size), TRUE).'</pre>';
		$size_h = $size_w = $size;
		if ($size_h > 400) {
			$size_h = 400;
		}

		return $size_w . 'x' . $size_h;
	}

	public function the_excerpt_max_charlength($charlength, $excerpt, $excerpt_end = '') {
		$out = '';

		if (!$charlength) {
			return;
		}

		//$excerpt = get_the_excerpt();
		$charlength++;

		if (mb_strlen($excerpt) > $charlength) {
			$subex = mb_substr($excerpt, 0, $charlength - 5);
			$exwords = explode(' ', $subex);
			$excut = -(mb_strlen($exwords[count($exwords) - 1]));
			if ($excut < 0) {
				$out .= mb_substr($subex, 0, $excut);
			} else {
				$out .= $subex;
			}

			if ($excerpt_end) {
				$out .= $excerpt_end;
			} else {
				$out .= '[...]';
			}

		} else {
			$out .= $excerpt;
		}

		return $out;
	}

}

endif;
