<?php

if (!class_exists('ST_Button')):

/**
 * Create button elements
 *
 * @package  ProStyler Builder Shortcodes
 * @since    2.1.0
 */
	class ST_Button extends ST_Pb_Shortcode_Element {

		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Button', ST_PBL);
			$this->config['cat'] = __('Basic,Content', ST_PBL);
			$this->config['icon'] = 'cbi-Button';
			$this->config['description'] = __('Eye catching button for hyperlinks', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'default_content' => __('Button', ST_PBL),
				'data-modal-title' => __('Button', ST_PBL),

				'admin_assets' => array(
					// Shortcode initialization
					'st-linktype.js',
					'button.js',
				),

				'frontend_assets' => array(
					// Bootstrap 3
					'st-pb-bootstrap-css',
					'st-pb-bootstrap-js',

					'cbb-prettyphoto-js',
					'cbb-prettyphoto-css',
					// Font IcoMoon
					'st-pb-font-icomoon-css',

					// Fancy Box
					//'st-pb-jquery-fancybox-css',
					//'st-pb-jquery-fancybox-js',
					// Shortcode style
					'button_frontend.css',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {
			$this->items = array(
				'content' => array(

					array(
						'name' => __('Text', ST_PBL),
						'id' => 'button_text',
						'type' => 'text_field',
						'std' => __('Button', ST_PBL),
						'role' => 'title',
					),
					array(
						'name' => __('On Click', ST_PBL),
						'id' => 'link_type',
						'type' => 'select',
						'class' => 'input-sm',
						'std' => 'url',
						'options' => ST_Pb_Helper_Type::get_link_types(),
						'has_depend' => '1',
						'tooltip' => __('Select link types: link to post, page, category...', ST_PBL),
					),
					array(
						'name' => __('URL', ST_PBL),
						'id' => 'button_type_url',
						'type' => 'text_field',
						'class' => 'input-sm',
						'std' => 'http://',
						'dependency' => array('link_type', '=', 'url'),
					),
					array(
						'name' => __('Single Item', ST_PBL),
						'id' => 'single_item',
						'type' => 'type_group',
						'std' => '',
						'items' => ST_Pb_Helper_Type::field_data_source(array(
							'callback' => 'ST_Pb_Helper_Type::get_single_item_button_bar',
							'args' => array(
								'link_type',
								array(
									'type' => 'items_list',
									'options_type' => 'select',
									'ul_wrap' => false,
								)
							)
						)),
					),
					array(
						'name' => __('Open in', ST_PBL),
						'id' => 'open_in',
						'type' => 'select',
						'class' => 'input-sm',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_open_in_options()),
						'options' => ST_Pb_Helper_Type::get_open_in_options(),
						'dependency' => array('link_type', '!=', 'no_link'),
						'has_depend' => '1',
						'tooltip' => __('Select type of opening action when click on element', ST_PBL),
					),

					// yunus edit - lightbox size option, same is applied to button type field
					array(
						'name' => __('Lightbox size', ST_PBL),
						'container_class' => 'combo-group dimension-inline',
						'id' => 'lb',
						'type' => 'dimension',
						'extended_ids' => array('lb_width', 'lb_height', 'lb_width_unit', 'lb_height_unit'),
						'lb_width' => array('std' => '100'),
						'lb_height' => array('std' => '100'),
						'lb_width_unit' => array(
							'options' => array('px' => 'px', '%' => '%'),
							'std' => '%',
						),
						'lb_height_unit' => array(
							'options' => array('px' => 'px', '%' => '%'),
							'std' => '%',
						),
						'tooltip' => __('Set width and height of lightbox window', ST_PBL),
						'dependency' => array('open_in', '=', 'lightbox'),
					),

					array(
						'name' => __('Icon', ST_PBL),
						'id' => 'icon',
						'type' => 'icons',
						'std' => '',
						'role' => 'title_prepend',
						'title_prepend_type' => 'icon',
					),
				),
				'styling' => array(
					array(
						'type' => 'preview',
					),
					array(
						'name' => __('Alignment', ST_PBL),
						'id' => 'button_alignment',
						'type' => 'radio_button_group',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
						'options' => ST_Pb_Helper_Type::get_text_align(),
						'class' => 'input-sm',
					),
					array(
						'name' => __('Margin', ST_PBL),
						'container_class' => 'combo-group',
						'id' => 'button_margin',
						'type' => 'margin',
						'extended_ids' => array('button_margin_top', 'button_margin_right', 'button_margin_bottom', 'button_margin_left'),
						'button_margin_top' => array('std' => '0'),
						'button_margin_right' => array('std' => '0'),
						'button_margin_bottom' => array('std' => '0'),
						'button_margin_left' => array('std' => '0'),
						'tooltip' => __('External spacing with other elements', ST_PBL),
                       'append'               => 'px',
                        'css' => array(
                            array('', 'margin')
                        )
					),

					array(
						'name' => __('Style', ST_PBL),
						'id' => 'style',
						'type' => 'select',
						'std' => 'default',
						'options' => array(
							'default' => __('Default', ST_PBL),
							'default-no-fill' => __('Default No Fill', ST_PBL),
							'rounded' => __('Rounded', ST_PBL),
							'rounded-no-fill' => __('Rounded No Fill', ST_PBL),
						),
					),

					array(
						'name' => __('Size', ST_PBL),
						'id' => 'button_size',
						'type' => 'select',
						'class' => 'input-sm',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_button_size()),
						'options' => ST_Pb_Helper_Type::get_button_size(),
					),
					array(
						'name' => __('Color', ST_PBL),
						'id' => 'button_color',
						'type' => 'select',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_button_color()),
						'options' => ST_Pb_Helper_Type::get_button_color(),
						//'container_class'   => 'color_select2',
						'tooltip' => __('Select the color of the button', ST_PBL),
						'has_depend' => '1',
					),

					array(
						'name' => __('Custom color', ST_PBL),
						'id' => 'custom_color',
						'type' => 'color_picker',
						'std' => '',
						'css' => array(
							array('.btn', 'background-color', '%value% !important', array(
								array('style', '!=', 'default-no-fill'),
								array('style', '!=', 'rounded-no-fill'),
							)),
							array('.btn:hover', 'background-color', '%value% !important'),
							array('.btn', 'border-color', '%value% !important'),
						),
						'dependency' => array('button_color', '=', 'btn-default'),
					),

					array(
						'name' => __('Text color', ST_PBL),
						'id' => 'text_color',
						'type' => 'color_picker',
						'std' => '',
						'css' => array(
							array('.btn', 'color', '%value% !important'),
							array('.btn .fa:before', 'color', '%value% !important'),
						),
						'dependency' => array('button_color', '=', 'btn-default'),
					),

					array(
						'name' => __('Custom hover color', ST_PBL),
						'id' => 'custom_h_color',
						'type' => 'color_picker',
						'std' => '',
						'css' => array(
							array('.btn:hover', 'background-color', '%value% !important'),
							array('.btn:hover', 'border-color', '%value% !important'),
						),
					),

					array(
						'name' => __('Hover Text color', ST_PBL),
						'id' => 'h_text_color',
						'type' => 'color_picker',
						'std' => '',
						'css' => array(
							array('.btn:hover', 'color', '%value% !important'),
							array('.btn:hover .fa:before', 'color', '%value% !important'),
						),
						'dependency' => array('button_color', '=', 'btn-default'),
					),

					ST_Pb_Helper_Type::get_apprearing_animations(),
					ST_Pb_Helper_Type::get_animation_speeds(),
				),
			);

			$this->items['mobile'] = array(
				array(
					'name' => __('Alignment', ST_PBL),
					'id' => 'm_button_alignment',
					'type' => 'radio_button_group',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
					'options' => ST_Pb_Helper_Type::get_text_align(),
					'class' => 'input-sm',
				),
				array(
					'name' => __('Size', ST_PBL),
					'id' => 'm_button_size',
					'type' => 'select',
					'class' => 'input-sm',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_button_size()),
					'options' => ST_Pb_Helper_Type::get_button_size(),
				),
			);

		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			$arr_params = shortcode_atts($this->config['params'], $atts);
			extract($arr_params);
			$button_text = (!$button_text) ? '' : $button_text;
			$button_size = (!$button_size || strtolower($button_size) == 'default') ? '' : $button_size;
			$m_button_size = (!$m_button_size || strtolower($m_button_size) == 'default') ? '' : 'm_' . $m_button_size;
			$button_color = (!$button_color || strtolower($button_color) == 'default') ? '' : $button_color;
			$button_icon = (!$icon) ? '' : "<i class='{$icon}'></i>";
			$tag = 'a';
			$href = '';
			$single_item = explode('__#__', $single_item);
			$single_item = $single_item[0];

			if (isset($lb_width_unit) && $lb_width_unit == 'px') {
				$lb_width_unit = '';
			}

			if (isset($lb_height_unit) && $lb_height_unit == 'px') {
				$lb_height_unit = '';
			}

			$lightbox_w = (isset($lb_width) && $lb_width) ? $lb_width . $lb_width_unit : '100%';
			$lightbox_h = (isset($lb_height) && $lb_height) ? $lb_height . $lb_height_unit : '100%';

			if (!empty($link_type)) {
				$taxonomies = ST_Pb_Helper_Type::get_public_taxonomies();
				$post_types = ST_Pb_Helper_Type::get_post_types();
				// single post
				if (array_key_exists($link_type, $post_types)) {
					$permalink = get_permalink($single_item);

					if ($open_in == 'lightbox') {
						$permalink = add_query_arg('iframe=true&width=' . $lightbox_w . '&height=' . $lightbox_h, '', $permalink);
					}

					$href = (!$single_item) ? ' href="#"' : " href='{$permalink}'";
				}
				// taxonomy
			else if (array_key_exists($link_type, $taxonomies)) {
				$permalink = get_term_link(intval($single_item), $link_type);
				if (!is_wp_error($permalink)) {
					//if($open_in == 'lightbox') $permalink .= '?iframe=true&width=100%&height=100%';
					if ($open_in == 'lightbox') {
						$permalink = add_query_arg('iframe=true&width=' . $lightbox_w . '&height=' . $lightbox_h, '', $permalink);
					}

					$href = (!$single_item) ? ' href="#"' : " href='{$permalink}'";
				}
			} else {
				switch ($link_type) {
				case 'no_link':
					$tag = 'button';
					break;
				case 'url':

					//if($open_in == 'lightbox') $button_type_url .= '?iframe=true&width=100%&height=100%';

					if ($open_in == 'lightbox') {
						$button_type_url = add_query_arg('iframe=true&width=' . $lightbox_w . '&height=' . $lightbox_h, '', $button_type_url);
					}

					$href = (!$button_type_url) ? ' href="#"' : " href='{$button_type_url}'";
					break;
				}
			}
		}
		$target = '';
		if ($open_in) {
			switch ($open_in) {
			case 'current_browser':
				$target = '';
				break;
			case 'new_browser':
				$target = ' target="_blank"';
				break;
			case 'new_window':
				$cls_button_fancy = 'st-button-new-window';
				$script = ST_Pb_Helper_Functions::new_window(".$cls_button_fancy", array('width' => '75%', 'height' => '75%'));
				break;
			case 'lightbox':
				$cls_button_fancy = 'prettyphoto';
				//$script = ST_Pb_Helper_Functions::fancybox( ".$cls_button_fancy", array( 'type' => 'iframe', 'width' => '75%', 'height' => '75%' ) );
				break;
			}
		}
		$button_type = ($tag == 'button') ? " type='button'" : '';
		$cls_button_fancy = (!isset($cls_button_fancy)) ? '' : $cls_button_fancy;
		$script = (!isset($script)) ? '' : $script;

		$cls_alignment = $custom_style = $wrapper_class = '';
		if (strtolower($arr_params['button_alignment']) != 'inherit') {
			if (strtolower($arr_params['button_alignment']) == 'left') {
				$cls_alignment .= ' pull-left';
			}

			if (strtolower($arr_params['button_alignment']) == 'right') {
				$cls_alignment .= ' pull-right';
			}

			if (strtolower($arr_params['button_alignment']) == 'center') {
				$wrapper_class .= ' text-center';
			}

		}

		if (strtolower($arr_params['m_button_alignment']) != 'inherit') {
			if (strtolower($arr_params['m_button_alignment']) == 'left') {
				$cls_alignment .= ' m_pull-left';
			}

			if (strtolower($arr_params['m_button_alignment']) == 'right') {
				$cls_alignment .= ' m_pull-right';
			}

			if (strtolower($arr_params['m_button_alignment']) == 'center') {
				$wrapper_class .= ' m_text-center';
			}

		}

		if (isset($arr_params['button_margin_top'])) {
			$arr_params['div_margin_top'] = $arr_params['button_margin_top'];
		}

		if (isset($arr_params['button_margin_left'])) {
			$arr_params['div_margin_left'] = $arr_params['button_margin_left'];
		}

		if (isset($arr_params['button_margin_right'])) {
			$arr_params['div_margin_right'] = $arr_params['button_margin_right'];
		}

		if (isset($arr_params['button_margin_bottom'])) {
			$arr_params['div_margin_bottom'] = $arr_params['button_margin_bottom'];
		}

		if ($button_icon && $button_text) {
			$cls_alignment .= ' btn-icon-text';
		}

		if (isset($style) && $style) {
			$cls_alignment .= ' btn-style-' . $style;
		}

		$html_element = $script . "<{$tag} class='btn {$cls_alignment} {$button_size} {$m_button_size} {$button_color} {$cls_button_fancy}'{$href}{$target}{$button_type}>{$button_icon}{$button_text}</{$tag}>";
		return $this->element_wrapper($html_element, $arr_params, $wrapper_class, $custom_style);
	}

}

endif;
