<?php

if (!class_exists('ST_Buttonbar')):

/**
 * Create a bar of buttons
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
	class ST_Buttonbar extends ST_Pb_Shortcode_Parent {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Button Bar', ST_PBL);
			$this->config['cat'] = __('Content', ST_PBL);
			$this->config['icon'] = 'cbi-ButtonBar';
			$this->config['has_subshortcode'] = 'ST_Item_' . str_replace('ST_', '', __CLASS__);
			$this->config['description'] = __('Bar of buttons', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'default_content' => __('Button Bar', ST_PBL),
				'data-modal-title' => __('Button Bar', ST_PBL),

				'admin_assets' => array(
					'st-pb-joomlashine-iconselector-js',
					'st-linktype.js',
				),
				'frontend_assets' => array(
					// Bootstrap 3
					'st-pb-bootstrap-css',
					'st-pb-bootstrap-js',

					// Font IcoMoon
					'st-pb-font-icomoon-css',

					// Fancy Box
					'cbb-prettyphoto-js',
					'cbb-prettyphoto-css',
					//'st-pb-jquery-fancybox-css',
					//'st-pb-jquery-fancybox-js',

					// Shortcode style
					'buttonbar_frontend.css',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {
			$this->items = array(
				'content' => array(

					array(
						'id' => 'buttonbar_items',
						'type' => 'group',
						'shortcode' => ucfirst(__CLASS__),
						'sub_item_type' => $this->config['has_subshortcode'],
						'sub_items' => array(
							array('std' => ''),
							array('std' => ''),
							array('std' => ''),
						),
					),
				),
				'styling' => array(
					array(
						'type' => 'preview',
					),
					array(
						'name' => __('Alignment', ST_PBL),
						'id' => 'buttonbar_alignment',
						'type' => 'radio_button_group',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
						'options' => ST_Pb_Helper_Type::get_text_align(),
					),
					array(
						'name' => __('Margin', ST_PBL),
						'container_class' => 'combo-group',
						'id' => 'buttonbar_margin',
						'type' => 'margin',
						'extended_ids' => array('buttonbar_margin_top', 'buttonbar_margin_right', 'buttonbar_margin_bottom', 'buttonbar_margin_left'),
						'buttonbar_margin_top' => array('std' => '0'),
						'buttonbar_margin_right' => array('std' => '0'),
						'buttonbar_margin_bottom' => array('std' => '0'),
						'buttonbar_margin_left' => array('std' => '0'),
						'tooltip' => __('External spacing with other elements', ST_PBL),
                       'append'               => 'px',
                        'css' => array(
                            array('', 'margin')
                        )
					),
					array(
						'name' => __('Horizontal space between items', ST_PBL),
						'type' => array(
							array(
								'id' => 'distance_between',
								'type' => 'text_append',
								'type_input' => 'number',
								'class' => 'input-mini',
								'std' => '',
								'append' => 'px',
								'validate' => 'number',
								'css' => array(
									array('.btn', 'margin-right'),
								),
							),
						),
					),
					array(
						'name' => __('Vertical space between items', ST_PBL),
						'type' => array(
							array(
								'id' => 'distance_v',
								'type' => 'text_append',
								'type_input' => 'number',
								'class' => 'input-mini',
								'std' => '',
								'append' => 'px',
								'validate' => 'number',
								'css' => array(
									array('.btn', 'margin-bottom'),
								),
							),
						),
					),
					array(
						'name' => __('', ST_PBL),
						'container_class' => 'group-checkbox',
						'id' => 'buttonbar_show_title',
						'type' => 'checkbox',
						'std' => 'yes',
						'options' => array('yes' => __('Show Title', ST_PBL)),
					),
					array(
						'name' => __('', ST_PBL),
						'container_class' => 'group-checkbox',
						'id' => 'buttonbar_show_icon',
						'type' => 'checkbox',
						'std' => 'yes',
						'options' => array('yes' => __('Show Icon', ST_PBL)),
					),
					array(
						'name' => __('', ST_PBL),
						'container_class' => 'group-checkbox',
						'id' => 'buttonbar_group',
						'type' => 'checkbox',
						'std' => '',
						'options' => array('yes' => __('Show Group Buttons', ST_PBL)),
					),
					ST_Pb_Helper_Type::get_apprearing_animations(),
					ST_Pb_Helper_Type::get_animation_speeds(),
				),
			);

			$this->items['mobile'] = array(
				array(
					'name' => __('Alignment', ST_PBL),
					'id' => 'm_buttonbar_alignment',
					'type' => 'radio_button_group',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
					'options' => ST_Pb_Helper_Type::get_text_align(),
				),
				array(
					'name' => __('Horizontal space between items', ST_PBL),
					'type' => array(
						array(
							'id' => 'm_distance_between',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '',
							'append' => 'px',
							'validate' => 'number',
							'css' => array(
                                'media_query' => array(
                                    'query'=>'(max-width: 829px)',
                                    'css' => array(
                                        array('.btn', 'margin-right'),
                                    )
                                )
							),
						),
					),
				),
				array(
					'name' => __('Vertical space between items', ST_PBL),
					'type' => array(
						array(
							'id' => 'm_distance_v',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '',
							'append' => 'px',
							'validate' => 'number',
							'css' => array(
                                'media_query' => array(
                                    'query'=>'(max-width: 829px)',
                                    'css' => array(
                                        array('.btn', 'margin-bottom'),
                                    )
                                )
							),
						),
					),
				),
			);

		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			$arr_params = shortcode_atts($this->config['params'], $atts);
			$html_element = '';
			$sub_shortcode = ST_Pb_Helper_Shortcode::remove_autop($content, false);
			$items = explode('<!--seperate-->', $sub_shortcode);
			// remove empty element
			$items = array_filter($items);
			$initial_open = (!isset($initial_open) || $initial_open > count($items)) ? 1 : $initial_open;
			foreach ($items as $idx => $item) {
				$open = ($idx + 1 == $initial_open) ? 'in' : '';
				$items[$idx] = $item;
			}
			$sub_shortcode = implode('', $items);
			$sub_htmls = $sub_shortcode;
			if ($arr_params['buttonbar_show_title'] == 'no') {
				$pattern = '\\[(\\[?)(title)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
				$sub_htmls = preg_replace('/' . $pattern . '/s', '', $sub_htmls);
			} else {
				$sub_htmls = str_replace('[title]', '', $sub_htmls);
				$sub_htmls = str_replace('[/title]', '', $sub_htmls);
			}
			if ($arr_params['buttonbar_show_icon'] == 'no') {
				$pattern = '\\[(\\[?)(icon)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
				$sub_htmls = preg_replace('/' . $pattern . '/s', '', $sub_htmls);
			} else {
				$sub_htmls = str_replace('[icon]', '', $sub_htmls);
				$sub_htmls = str_replace('[/icon]', '', $sub_htmls);
			}


			if ($arr_params['buttonbar_group'] == 'yes__#__ ') {
				$html_element = "<div class='btn-group'>" . $sub_htmls . '</div>';
			} else {
				$html_element = $sub_htmls;
			}

			$cls_alignment = '';
			if (strtolower($arr_params['buttonbar_alignment']) != 'inherit') {
				if (strtolower($arr_params['buttonbar_alignment']) == 'left') {
					$cls_alignment .= ' pull-left';
				}

				if (strtolower($arr_params['buttonbar_alignment']) == 'right') {
					$cls_alignment .= ' pull-right';
				}

				if (strtolower($arr_params['buttonbar_alignment']) == 'center') {
					$cls_alignment .= ' text-center';
				}

			}

			// mobile
			if (strtolower($arr_params['m_buttonbar_alignment']) != 'inherit') {
				if (strtolower($arr_params['m_buttonbar_alignment']) == 'left') {
					$cls_alignment .= ' m_pull-left';
				}

				if (strtolower($arr_params['m_buttonbar_alignment']) == 'right') {
					$cls_alignment .= ' m_pull-right';
				}

				if (strtolower($arr_params['m_buttonbar_alignment']) == 'center') {
					$cls_alignment .= ' m-text-center';
				}

			}

			$html_element = "<div class='btn-toolbar {$cls_alignment}'>{$html_element}</div>";

			// Set button bar margin
			if (isset($arr_params['buttonbar_margin_top'])) {
				$arr_params['div_margin_top'] = $arr_params['buttonbar_margin_top'];
			}

			if (isset($arr_params['buttonbar_margin_left'])) {
				$arr_params['div_margin_left'] = $arr_params['buttonbar_margin_left'];
			}

			if (isset($arr_params['buttonbar_margin_right'])) {
				$arr_params['div_margin_right'] = $arr_params['buttonbar_margin_right'];
			}

			if (isset($arr_params['buttonbar_margin_bottom'])) {
				$arr_params['div_margin_bottom'] = $arr_params['buttonbar_margin_bottom'];
			}

			return $this->element_wrapper($html_element, $arr_params);
		}
	}

endif;
