<?php

if ( ! class_exists( 'ST_Item_Buttonbar' ) ) {

	class ST_Item_Buttonbar extends ST_Pb_Shortcode_Child {

		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'data-modal-title' => __('Button Bar Item', ST_PBL),
				'admin_assets' => array(
					'st-linktype.js',
				),
			);
			$this->config['use_wrapper'] = true;

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name'    => __( 'Text', ST_PBL ),
						'id'      => 'button_text',
						'type'    => 'text_field',
						'std'     => __( ST_Pb_Utils_Placeholder::add_placeholder( 'ButtonBar Item %s', 'index' ), ST_PBL ),
						'role'    => 'title',
					),
					array(
						'name'       => __( 'On Click', ST_PBL ),
						'id'         => 'link_type',
						'type'       => 'select',
						'class'      => 'input-sm',
						'std'        => 'url',
						'options'    => ST_Pb_Helper_Type::get_link_types(),
						'has_depend' => '1',
                        'tooltip' => __( 'Select link types: link to post, page, category...', ST_PBL ),
					),
					array(
						'name'       => __( 'URL', ST_PBL ),
						'id'         => 'button_type_url',
						'type'       => 'text_field',
						'class'      => 'input-sm',
						'std'        => 'http://',
						'dependency' => array( 'link_type', '=', 'url' ),
					),
					array(
						'name'  => __( 'Single Item', ST_PBL ),
						'id'    => 'single_item',
						'type'  => 'type_group',
						'std'   => '',
						'items' => ST_Pb_Helper_Type::field_data_source(array(
							'callback' => 'ST_Pb_Helper_Type::get_single_item_button_bar',
							'args' => array(
								'link_type',
								array(
									'type'         => 'items_list',
									'options_type' => 'select',
									'class'        => 'select2-select',
									'ul_wrap'      => false,
								)
							)
						)),
					),
					array(
						'name'       => __( 'Open in', ST_PBL ),
						'id'         => 'open_in',
						'type'       => 'select',
						'class'      => 'input-sm',
						'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_open_in_options() ),
						'options'    => ST_Pb_Helper_Type::get_open_in_options(),
						'dependency' => array( 'link_type', '!=', 'no_link' ),
                        'tooltip' => __( 'Select type of opening action when click on element', ST_PBL ),
					),
					array(
						'name'      => __( 'Icon', ST_PBL ),
						'id'        => 'icon',
						'type'      => 'icons',
						'std'       => '',
						'role'      => 'title_prepend',
						'title_prepend_type' => 'icon',
					),
					array(
						'name'    => __( 'Size', ST_PBL ),
						'id'      => 'button_size',
						'type'    => 'select',
						'class'   => 'input-sm',
						'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_size() ),
						'options' => ST_Pb_Helper_Type::get_button_size(),
						'has_depend' => '1',
					),
					array(
						'name' => __('Custom dimensions', ST_PBL),
						'id' => 'custom_dimensions',
						'type' => array(
							array(
								'id' => 'button_width',
								'type' => 'text_append',
								'type_input' => 'number',
								'class' => 'jsn-input-number input-mini',
								'parent_class' => 'input-group-inline',
								'std' => '',
								'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Width', ST_PBL ) . '</i>',
								'append' => 'px',
								'validate' => 'number',
							),
							array(
								'id' => 'button_height',
								'type' => 'text_append',
								'type_input' => 'number',
								'class' => 'jsn-input-number input-mini',
								'parent_class' => 'input-group-inline',
								'std' => '',
								'append_before' => '<i class="input-mini st-label-prefix">' . __( 'Height', ST_PBL ) . '</i>',
								'append' => 'px',
								'validate' => 'number',
							),
						),
						'container_class' => 'combo-group',
						'dependency' => array( 'button_size', '=', 'custom' ),
					),
					
					array(
						'name'    => __( 'Style', ST_PBL ),
						'id'      => 'style',
						'type'    => 'select',
						'std'     => 'default',
						'options' => array(
							'default' => __( 'Default', ST_PBL ),
							'default-no-fill' => __( 'Default No Fill', ST_PBL ),
							'rounded' => __( 'Rounded', ST_PBL ),
							'rounded-no-fill' => __( 'Rounded No Fill', ST_PBL ), 
						),
					),
				
					array(
						'name'    => __( 'Color', ST_PBL ),
						'id'      => 'button_color',
						'type'    => 'select',
						'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_color() ),
						'options' => ST_Pb_Helper_Type::get_button_color(),
						//'container_class'   => 'color_select2',
                        'tooltip' => __( 'Select the color of the button', ST_PBL ),
                        'has_depend' => '1',
					),


					array(
						'name'    => __( 'Custom color', ST_PBL ),
						'id'       => 'custom_color',
						'type'     => 'color_picker',
						'std'      => '',
						'css' => array(
							array('%id%.btn', 'background-color', '%value% !important', array(
								array('style', '!=', 'default-no-fill'),
								array('style', '!=', 'rounded-no-fill')
							)),
							array('%id%:hover', 'background-color', '%value% !important'),
							array('%id%', 'border-color', '%value% !important'),
						),
						'dependency'      => array( 'button_color', '=', 'btn-default' ),
					),

					array(
						'name'    => __( 'Text color', ST_PBL ),
						'id'       => 'text_color',
						'type'     => 'color_picker',
						'std'      => '',
						'css' => array(
							array('%id%', 'color', '%value% !important'),
							array('%id% .fa:before', 'color', '%value% !important'),
						),
						'dependency'      => array( 'button_color', '=', 'btn-default' ),
					),

					array(
						'name'    => __( 'Custom hover color', ST_PBL ),
						'id'       => 'custom_h_color',
						'type'     => 'color_picker',
						'std'      => '',
						'css' => array(
							array('%id%:hover', 'background-color', '%value% !important'),
							array('%id%:hover', 'border-color', '%value% !important'),
						),
					),

					array(
						'name'    => __( 'Hover Text color', ST_PBL ),
						'id'       => 'h_text_color',
						'type'     => 'color_picker',
						'std'      => '',
						'css' => array(
							array('%id%:hover', 'color', '%value% !important'),
							array('%id%:hover .fa:before', 'color', '%value% !important'),
						),
						'dependency'      => array( 'button_color', '=', 'btn-default' ),
					),

				)
			);
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full( $atts = null, $content = null ) {
			$arr_params   = shortcode_atts( $this->config['params'], $atts );
			extract( $arr_params );
			$button_text  = ( ! $button_text ) ? '' : $button_text;
			$button_size  = ( ! $button_size || strtolower( $button_size ) == 'default' ) ? '' : $button_size;
			$button_color = ( ! $button_color || strtolower( $button_color ) == 'default' ) ? '' : $button_color;
			$button_icon  = ( ! $icon ) ? '' : "<i class='{$icon}'></i>";
			$tag          = 'a';
			$href         = '';
			$single_item  = explode( '__#__', $single_item );
			$single_item  = $single_item[0];
			if ( ! empty( $link_type ) ) {
				$taxonomies = ST_Pb_Helper_Type::get_public_taxonomies();
				$post_types = ST_Pb_Helper_Type::get_post_types();
				// single post
				if ( array_key_exists( $link_type, $post_types ) ) {
					
					$permalink = get_permalink($single_item);
					
					if($open_in == 'lightbox') $permalink = add_query_arg( 'iframe=true&width=100%&height=100%', '', $permalink );
					
					$href      = ( ! $single_item ) ? ' href="#"' : " href='{$permalink}'";
				}
				// taxonomy
				else if ( array_key_exists( $link_type, $taxonomies ) ) {
					$permalink = get_term_link( intval( $single_item ), $link_type );
					if ( ! is_wp_error( $permalink ) )
					{
						if($open_in == 'lightbox') $permalink = add_query_arg( 'iframe=true&width=100%&height=100%', '', $permalink );
						
						$href = ( ! $single_item ) ? ' href="#"' : " href='{$permalink}'";
					}
				}
				else {
					switch ( $link_type ) {
						case 'no_link':
							$tag = 'button';
							break;
						case 'url':
							if($open_in == 'lightbox') $button_type_url = add_query_arg( 'iframe=true&width=100%&height=100%', '', $button_type_url );
						
							$href = ( ! $button_type_url ) ? ' href="#"' : " href='{$button_type_url}'";
							break;
					}
				}
			}
			$target = '';
			if ( $open_in ) {
				switch ( $open_in ) {
					case 'current_browser':
						$target = '';
						break;
					case 'new_browser':
						$target = ' target="_blank"';
						break;
					case 'new_window':
						$cls_button_fancy = 'st-button-new-window';
						$script = ST_Pb_Helper_Functions::new_window( ".$cls_button_fancy", array( 'width' => '75%', 'height' => '75%' ) );
						break;
					case 'lightbox':
						$cls_button_fancy = 'prettyphoto';
						//$cls_button_fancy = 'st-button-fancy';
						//$script = ST_Pb_Helper_Functions::fancybox( ".$cls_button_fancy", array( 'type' => 'iframe', 'width' => '75%', 'height' => '75%' ) );
						break;
				}
			}
			$button_type      = ( $tag == 'button' ) ? " type='button'" : '';
			$cls_button_fancy = ( ! isset( $cls_button_fancy ) ) ? '' : $cls_button_fancy;
			$script           = ( ! isset( $script ) ) ? '' : $script;

			// custom style
			$cs_stype = array();
			if ( ! empty( $button_width ) ) {
				$cs_stype[] = "width: {$button_width}px;";
			}
			if ( ! empty( $button_height ) ) {
				$cs_stype[] = "height: {$button_height}px;";
				$padding_top = intval( $button_height )/2 - 12;
				$cs_stype[] = "padding-top: {$padding_top}px;";
			}

			$cs_stype = sprintf( 'style="%s"', implode( '', $cs_stype ) );

			// Process CSS Class and CSS ID wrapper
			$extra_class  = ! empty ( $arr_params['css_suffix'] ) ? esc_attr( $arr_params['css_suffix'] ) : '';
			$extra_class  = ! empty ( $extra_class ) ? ' ' . ltrim( $extra_class, ' ' ) : '';
			$extra_id     = ! empty ( $arr_params['id_wrapper'] ) ? esc_attr( $arr_params['id_wrapper'] ) : '';
			$extra_id     = ! empty ( $extra_id ) ? "id='" . ltrim( $extra_id, ' ' ) . "'" : '';
			
			if($button_icon && $button_text) $extra_class .= ' btn-icon-text';
			if(isset($style) && $style) $extra_class .= ' btn-style-'.$style;
			
			

			$html_result      = "<{$tag} {$extra_id} {$cs_stype} class='btn {$extra_class} {$button_size} {$button_color} {$cls_button_fancy}'{$href}{$target}{$button_type}>[icon]{$button_icon}[/icon][title]{$button_text}[/title]</{$tag}>";

			//return $html_result . $script . '<!--seperate-->';
			// Allows css generator to work from common wrapper
	        return array(
	            'content'=> $html_result . $script . '<!--seperate-->',
	            'atts'=>$arr_params
	        );
		}

	}

}