<?php

if (!class_exists('ST_Call_To_Action')):

/**
 * Create Promobox element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
	class ST_Call_To_Action extends ST_Pb_Shortcode_Element {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Call To Action', ST_PBL);
			$this->config['cat'] = __('Content', ST_PBL);
			$this->config['icon'] = 'cbi-CallToAction';
			$this->config['description'] = __('Styled box designed to make vistors take action', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'default_content' => __('Call To Action', ST_PBL),
				'data-modal-title' => __('Call To Action', ST_PBL),

				'frontend_assets' => array(
					// Shortcode style and script initialization
					'call_to_action_frontend.css',

					'cbb-prettyphoto-js',
					'cbb-prettyphoto-css',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {

			$this->items['content'] = array(

				array(
					'name' => __('Text', ST_PBL),
					'id' => 'text',
					'type' => 'text_field',
					'std' => 'Change this text',
				),

			);

			$this->items['content'] = array_merge(
				$this->items['content'],
				ST_Pb_Helper_Type::get_button_type('cta_button')
			);

			$this->items['styling'] = array(
				array(
					'type' => 'preview',
					'size' => 'full',
				),

				array(
					'name' => __('Text color', ST_PBL),
					'id' => 'text_color',
					'type' => 'color_picker',
					'std' => '#fff',
					'tooltip' => __('Color of text.', ST_PBL),
				),

				array(
					'name' => __('Background color', ST_PBL),
					'id' => 'bg_color',
					'type' => 'select',
					'std' => 'orange',
					'options' => array(
						'orange' => __('Orange', ST_PBL),
						'blue' => __('Blue', ST_PBL),
						'grey' => __('Grey', ST_PBL),
						'green' => __('Green', ST_PBL),
						'red' => __('Red', ST_PBL),
						"black" => __('Black', ST_PBL),
						"custom" => __('Custom', ST_PBL),
					),
					'has_depend' => '1',
				),

				array(
					'name' => __('Background custom color', ST_PBL),
					'id' => 'bg_custom_color',
					'type' => 'color_picker',
					'std' => '#FF8A00',
					'dependency' => array('bg_color', '=', 'custom'),
				),

				array(
					'name' => __('Size', WR_PBL),
					'id' => 'size',
					'type' => 'select',
					'std' => 'full',
					'options' => array(
						"full" => "Full Width",
						"container" => "Container Width",
					),
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			);
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			// do not remove, used in element_wrapper
			$arr_params = (shortcode_atts($this->config['params'], $atts));
			extract($arr_params);

			$extra_class = $script = $styles = $output = '';

			switch ($size) {
			case 'full':
				$extra_class .= ' st_fullwidth';

				// some overwrite css to enable row full width
				$script = "$('body').addClass('st-full-width');";
				$script = ST_Pb_Helper_Functions::script_box($script);

				$styles .= '-webkit-box-sizing: content-box;-moz-box-sizing: content-box;box-sizing: content-box;width: 100%;padding-left: 1000px;padding-right: 1000px;margin:0 -1000px;';
				break;
			}

			$styles .= 'color: ' . $text_color . ';';
			if ($bg_color == 'custom') {
				$styles .= 'background-color: ' . $bg_custom_color . '; border-color: ' . $bg_custom_color . ';';
			}

			$output .= '
				<div style="' . $styles . '" class="clearfix cbb-call_to_action cbb-content_element cta_align_right bg_color-' . $bg_color . '">
					<div class="inner clearfix">

						<h2 class="cbb-call_text">' . $text . '</h2>

						' . ST_Pb_Helper_Premade::button('cta_button', $atts) . '
					</div>
				</div>
			';

			$html_element = $script . $output;

			return $this->element_wrapper($html_element, $arr_params);
		}
	}

endif;
