<?php

if ( ! class_exists( 'ST_Content' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Content extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Content Placeholder', ST_PBL );
		$this->config['cat']         = __( 'Content', ST_PBL );
		$this->config['icon']        = 'cbi-ContentPlaceholder';
		$this->config['description'] = __( 'Used with pages being used as template. Filled with content automatically', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		
		$this->items['content'] = array(

			array(
				'name'     => __( 'Section ID', ST_PBL ),
				'id'       => 'msg',
				'type'     => 'html',
				'std'      => 'This element will be filled with content of your post or woocommerce product',
				'tooltip' => __( '', ST_PBL ),
			),

		);
		
		$this->items['styling'] = array(
		
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),
		);

	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		
		global $post, $stencilor_no_detech_active, $cbt_options;
		
		// for stencilor theme with template engine
		//return '<span id="cbb-content-placeholder"> sdada dasd asd</span>';

		
		ob_start();
		if ( post_password_required() ) {
			global $custom_template_password_protected_form;

			if(isset($custom_template_password_protected_form) && $custom_template_password_protected_form)
			{
				echo $custom_template_password_protected_form;
			}
		}
		elseif(function_exists('is_woocommerce') && is_woocommerce())
		{
			if(is_product())
			{
					/**
					 * woocommerce_before_main_content hook
					 *
					 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
					 * @hooked woocommerce_breadcrumb - 20
					 */
					do_action( 'woocommerce_before_main_content' );
				?>
			
			
						<?php wc_get_template_part( 'content', 'single-product' ); ?>
			
			
				<?php
					/**
					 * woocommerce_after_main_content hook
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action( 'woocommerce_after_main_content' );
			}
			else
			{
				woocommerce_content();
			}
		}
		elseif(is_single())
		{
			
			$stencilor_no_detech_active = false;
			$content = $post->post_content;
			$content = do_shortcode(ST_Pb_Core::pagebuilder_to_frontend($content));
			//$html = $content;
		?>
		
	      <?php $hide_post_header = get_post_meta( $post->ID, 'st_hide_post_header', true );?>
	      <?php if(! $hide_post_header):?>
			<header class="article-header">
				<div class="titlewrap clearfix">
					<h1 class="post-title entry-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
					<p class="byline vcard">
						<?php if( $cbt_options['posts_hide_author'] != '1'):?>
						by <span class="author"><em><?php echo bones_get_the_author_posts_link() ?></em></span>
						<?php endif; ?>
						<?php if( $cbt_options['posts_hide_author'] != '1' && $cbt_options['posts_hide_date'] != '1'):?>
						 - 
						 <?php endif; ?>
						<?php if( $cbt_options['posts_hide_date'] != '1'):?>
						<time class="updated" datetime="<?php echo esc_attr( get_the_date( 'c' ) ) ?>"><?php echo get_the_time(get_option('date_format')) ?></time>
						<?php endif; ?>
						<span class="sticky-ind pull-right"><i class="fa fa-star"></i></span>
					</p>
				</div>
	
			</header> <?php // end article header ?>
	      <?php endif; ?>
	
			<?php if( $cbt_options['featured'] == '2' || ( $cbt_options['featured'] == '4' && is_single() ) || ( $cbt_options['featured'] == '3' && is_home() ) ) { ?>
				<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'post-featured' ); ?>
				<?php if ( $image[1] < '750' && has_post_thumbnail() ) { ?>
					<section class="featured-content featured-img featured-img-bg" style="background: url('<?php echo $image[0]; ?>')">
				<?php } // end if 
				else { ?>
					<section class="featured-content featured-img">
						<?php if ( has_post_thumbnail() ) { ?>
	                        <a class="featured-img" href="<?php the_permalink(); ?>">
	                        	<?php the_post_thumbnail( 'post-featured' ); ?>
	                        </a>
	                    <?php } // end if 
						else { ?>
	                    	<hr>
	                    <?php } //end else?>
	            <?php } // end else ?>
			<?php } // end if 
			else { ?>
				<section class="featured-content featured-img">
			<?php } // end else ?>
	
			</section>
	
			<section class="entry-content single-content clearfix" itemprop="articleBody">
				<?php echo $content; ?>
				<?php wp_link_pages(
	            	array(
	
	                    'before' => '<div class="page-link"><span>' . __( 'Pages:', 'cbt' ) . '</span>',
	                    'after' => '</div>'
	            	) 
	            ); ?>
			</section> <?php // end article section ?>
	
			<footer class="article-footer clearfix">
				<span class="tags pull-left">
					<?php if( $cbt_options['posts_hide_categories'] != '1'):?>
						<?php printf( '<span class="">' . __( 'in %1$s&nbsp;&nbsp;', 'cbt' ) . '</span>', get_the_category_list(', ') ); ?> 
					<?php endif; ?>
					<?php if( $cbt_options['posts_hide_tags'] != '1'):?>
						<?php the_tags( '<span class="tags-title">' . __( '<i class="fa fa-tags"></i>', 'cbt' ) . '</span> ', ', ', '' ); ?>
					<?php endif; ?>
				</span>
				<?php if( $cbt_options['posts_hide_comments_count'] != '1'):?>
						<span class="commentnum pull-right"><a href="<?php comments_link(); ?>"><?php comments_number( '<i class="fa fa-comment"></i> 0', '<i class="fa fa-comment"></i> 1', '<i class="fa fa-comment"></i> %' ); ?></a></span>
					<?php endif; ?>
			</footer> <?php // end article footer ?>
	
	
		<?php get_template_part( 'author-info' ); ?>
		
		<?php if ( is_single() ) {?>
		  <div id="single-post-nav">
		    <ul class="pager">
		
		      <?php $trunc_limit = 30; ?>
		
		      <?php if( '' != get_previous_post() ) { ?>
		        <li class="previous">
		          <?php previous_post_link( '<span class="previous-page">%link</span>', __( '<i class="fa fa-caret-left"></i>', 'bones' ) . '&nbsp;' . brew_truncate_text( get_previous_post()->post_title, $trunc_limit ) ); ?>
		        </li>
		      <?php } // end if ?>
		
		      <?php if( '' != get_next_post() ) { ?>
		        <li class="next">
		          <?php next_post_link( '<span class="no-previous-page-link next-page">%link</span>', '&nbsp;' . brew_truncate_text( get_next_post()->post_title, $trunc_limit ) . '&nbsp;' . __( '<i class="fa fa-caret-right"></i>', 'bones' ) ); ?>
		        </li>
		      <?php } // end if ?>
		
		    </ul>
		  </div><!-- /#single-post-nav -->
		<?php } ?>
		
		<?php comments_template(); ?>
	
		<?php	
		}
		else
		{
			global $stencilor_no_detech_active;
	
			$stencilor_no_detech_active = false;
	
			if(is_archive())
			{
				echo '<div class="clearfix">';
					get_template_part( 'template_parts/archive_titles' );
				echo '</div>';
				
				echo '<div class="clearfix">';
					get_template_part( 'template_parts/archive' );
				echo '</div>';
			}
			elseif(is_page())
			{
				return;
			}
			else
			{
				echo '<div class="clearfix">';
					get_template_part( 'template_parts/posts' );
				echo '</div>';
			}
		}
		
		$html = ob_get_contents();
		ob_end_clean();
		
		return $this->element_wrapper( $html, $arr_params );
	}
}

endif;
