<?php


if ( ! class_exists( 'ST_Countdown' ) ) :

/**
 * Create Promobox element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Countdown extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Countdown', ST_PBL ); //(DEPRECIATED)
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-Countdown';
		$this->config['description'] = __( 'Display a custom countdown timer on your page', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

			'frontend_assets' => array(
				// Shortcode style and script initialization
				'countdown_frontend.js',
				'countdown_frontend.css',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		
		$this->items['content'] = array(

			
			array(
				'name'     => __( 'Date And Time', ST_PBL ),
				'id'       => 'date_time',
				'type'     => 'time_picker',
				'std'      => date('m/d/Y H:i', time()+5000),
			),
			
/*
			array(
				'name'     => __( 'Counting Direction', ST_PBL ),
				'id'       => 'counting_direction',
				'type'     => 'radio',
				'std'      => 'countdown',
				'options'  => array( 'countdown' => __( 'Countdown', ST_PBL ), 'countup' => __( 'Countup', ST_PBL ) ),
			),
			
*/
			array(
				'name'     => __( 'Show seconds', ST_PBL ),
				'id'       => 'show_seconds',
				'type'     => 'radio',
				'std'      => 'yes',
				'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
			),
			
			array(
				'name'    => __( 'Action on clock stop', ST_PBL ),
				'id'      => 'action',
				'type'    => 'select',
				'std'     => 'none',
				'options' => array(
					"none"=>"Do nothing",
					"message"=>"Show Message",
					"redirect"=>"Redirect to URL",
				),
				'tooltip' => __( 'What to do when clock reaches its target time', ST_PBL ),
				'has_depend' => '1',
			),	
			
			array(
				'name' => __( 'URL', ST_PBL ),
				'id'           => 'url',
				'type'         => 'text_field',
				'std'          => 'http://',
				'dependency'      => array( 'action', '=', 'redirect' ),
			),
			
			array(
				'name' => __( 'Message', ST_PBL ),
				'id'           => 'message',
				'type'         => 'text_area',
				'std'          => 'http://',
				'std'      => 'The times up !',
				'dependency'      => array( 'action', '=', 'message' ),
			),
			
			array(
				'name'    => __( 'Language', ST_PBL ),
				'id'      => 'language',
				'type'    => 'select',
				'std'     => 'english',
				'options' => array(
					"en"=>"English",
					"ar"=>"Arabic",
					"da"=>"Danish",
					"de"=>"German",
					"es"=>"Spanish",
					"fi"=>"Finnish",
					"fr"=>"French",
					"it"=>"Italian",
					"lv"=>"Latvian",
					"nl"=>"Dutch",
					"no"=>"Norwegian",
					"pt"=>"Portuguese",
					"ru"=>"Russian",
					"sv"=>"Swedish",
				),
			),

		);
		
		
		$this->items['styling'] = array(
			array(
						'type' => 'preview',
			),
			
			array(
				'name'    => __( 'Digits color', ST_PBL ),
				'id'       => 'digits_color',
				'type'     => 'color_picker',
				'std'      => '#CCCCCC',
			),
			
			array(
				'name'    => __( 'Labels &amp; Separators color', ST_PBL ),
				'id'       => 'labels_color',
				'type'     => 'color_picker',
				'std'      => '#323434',
			),
			
			array(
				'name'    => __( 'Background color', ST_PBL ),
				'id'       => 'bg_color',
				'type'     => 'color_picker',
				'std'      => '#333333',
			),
			
			array(
				'name'    => __( 'Style', ST_PBL ),
				'id'      => 'style',
				'type'    => 'select',
				'std'     => 'flick-clock',
				'options' => array(
					'flick-clock' => __( 'Flip Clock', ST_PBL ),
					'block' => __( 'Block', ST_PBL ),
				),
			),	
			
			array(
				'name'    => __( 'Size', ST_PBL ),
				'id'      => 'size',
				'type'    => 'select',
				'std'     => 'big',
				'options' => array(
					"big"=>"Big",
					"medium"=>"Medium",
					"small"=>"Small",
				),
			),	

					
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),				
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		extract( $arr_params );
		
		$extra_class = $script = $styles = $output = '';
		
		$counting_direction = 'countdown';
		$id = "cbb-flip-clock-".rand(1, 999);
		
		if(! $date_time) return 'No date/time provided !';
		
		$seconds = strtotime($date_time) - time();
		if(! $seconds OR ! is_numeric($seconds)) return 'Invalid date/time provided !';
		
		if($counting_direction == 'countdown' && $seconds < 0) 
		{
			$seconds = 0;
		}
		
		$seconds = @abs($seconds);
		
		$counter_params = '';
		if($seconds > 14400) $counter_params .= 'clockFace: "DailyCounter",';
		
		if($show_seconds == 'no') $counter_params .= 'showSeconds: false,';
		
		if($language && $language != 'en') $counter_params .= 'language: "'.$language.'",';

		
		$do_action = '';
		switch($action)
		{
			case 'message':
				$do_action = 'alert("'.$message.'")';
				if(! $message) $do_action = '';
			break;
			case 'redirect':
				$do_action = 'window.location = "'.$url.'"';
				if(! $url OR $url=='http://') $do_action = '';
			break;
		}
		
		
		if($do_action && $counting_direction == 'countdown' && $seconds <= 0) 
		{
			$script .= '<script type="text/javascript">'.$do_action.'</script>';
		}
		
		
		$script .= '
<script type="text/javascript">	
jQuery(document).ready(function($) 
{
	$("#'.$id.'").FlipClock('.$seconds.', 
	{ 
		'.$counter_params.'
		countdown: '.(($counting_direction == 'countdown')?'true':'false').',
		callbacks: 
		{
			stop: function ()
			{
				'.$do_action.'
			}
		}
	});
});
</script>
		';
		
		
		// CSS START
		$styles = '<style>';
				
			if($style == 'block') 
			{
				$styles .= '#'.$id.', #'.$id.' ul { background: '.$bg_color.'; }';
			}
				
			$styles .= '#'.$id.' ul li a div div.inn { background: '.$bg_color.'; color: '.$digits_color.'; }';
			
			$styles .= '
			#'.$id.' .flip-clock-divider .flip-clock-label
			{ 
				color: '.$labels_color.'; 
			}';
			
			$styles .= '
			#'.$id.' .flip-clock-dot
			{ 
				background: '.$labels_color.'; 
			}';
			
		$styles .= '</style>';
		// CSS END
		
		
		$output = '<div id="'.$id.'-wrapper" class="cbb-flip-clock-wrapper">
			<div id="'.$id.'" class="cbb-flip-clock cbb-flip-clock-style-'.$style.' cbb-flip-clock-size-'.$size.'"></div>
			<div class="clearfix"></div>
		</div>';


		$html_element = $script . $styles . $output;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;

