<?php
if ( ! class_exists( 'ST_Countdown2' ) ) :

/**
 * Creates Countdown element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Countdown2 extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Countdown v2 (DEPRECIATED)', ST_PBL );
		$this->config['cat']         = __( 'Typography', ST_PBL );
		$this->config['icon']        = 'cbi-Countdown';
		$this->config['description'] = __( 'Display a custom countdown timer on your page', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'admin_assets' => array(
				// Shortcode initialization
								'countdown2.js',
				
			),

			'frontend_assets' => array(
				//  Bootstrap 3
				
				'countdown2_frontend.js',
				'countdown2_frontend.css',
				 'st-pb-bootstrap-css',
				 'st-pb-bootstrap-js',
			 ),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}
	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
	
	
	    $add='ul li a div div.inn';
		
		/*----------  This section will contain main fields for content e.g date time input in this example ----------*/
		$this->items['content'] = array(

			/*----------  EXAMPLE CONTENT FIELD  ----------*/
		
			array(
				'name'     => __( 'Date And Time', ST_PBL ),
				'id'       => 'date_time',
				'type'     => 'time_picker',
				
			),

			
/*
			array(
				'name'     => __( 'Counting Direction', ST_PBL ),
				'id'       => 'counting_direction',
				'type'     => 'radio',
				'std'      => 'countdown',
				'options'  => array( 'countdown' => __( 'Countdown', ST_PBL ), 'countup' => __( 'Countup', ST_PBL ) ),
			),
*/			
			/*array(
					'name'       => __( 'On Click', ST_PBL ),
					'id'         => 'link_type',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_image_link_types() ),
					'options'    => ST_Pb_Helper_Type::get_image_link_types(),
					'tooltip'    => __( 'Set link type of image', ST_PBL ),
					'has_depend' => '1',
		),*/
			array(
				'name'     => __( 'Show seconds', ST_PBL ),
				'id'       => 'show_seconds',
				'type'     => 'radio',
				'std'      => 'yes',
				'options'  => array(  'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ),),
			),
			array(
				'name'     => __( 'Show minutes', ST_PBL ),
				'id'       => 'show_minutes',
				'type'     => 'radio',
				'std'      => 'yes',
				'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ), ),
			),
			
			array(
				'name'     => __( 'Show hours', ST_PBL ),
				'id'       => 'show_hours',
				'type'     => 'radio',
				'std'      => 'yes',
				'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ), ),
			),
			
			array(
				'name'    => __( 'Action on clock stop', ST_PBL ),
				'id'      => 'action',
				'type'    => 'select',
				'std'     => 'none',
				'options' => array(
					"none"=>"Do nothing",
					"message"=>"Show Message",
					"redirect"=>"Redirect to URL",
				),
				'tooltip' => __( 'What to do when clock reaches its target time', ST_PBL ),
				'has_depend' => '1',
			),	
			
			array(
				'name' => __( 'URL', ST_PBL ),
				'id'           => 'url',
				'type'         => 'text_field',
				'std'          => 'http://',
				'dependency'      => array( 'action', '=', 'redirect' ),
			),
			
			array(
				'name' => __( 'Message', ST_PBL ),
				'id'           => 'message',
				'type'         => 'text_area',
				'std'          => 'http://',
				'std'      => 'The times up !',
				'dependency'      => array( 'action', '=', 'message' ),
			),
			
			array(
				'name'    => __( 'Language', ST_PBL ),
				'id'      => 'language',
				'type'    => 'select',
				
				'options' => array(
					"en"=>"English",
					
					"da"=>"Danish",
					"de"=>"German",
					"es"=>"Spanish",
					"fr"=>"French",
					"it"=>"Italian",
					"lv"=>"Latvian",
					"nl"=>"Dutch",
					"no"=>"Norwegian",
					"pt"=>"Portuguese",
					"sv"=>"Swedish",
				),
			),

		);
		
		
		/*----------  This section will contain all styling related fields  ----------*/
		$this->items['styling'] = array(
			array(
						'type' => 'preview',
			),
			
			/*----------  EXAMPLE STYLING FIELD  ----------*/
			// see other elements and builder/core/helper/html directory for all field types
			
			array(
				'name'    => __( 'Digits colour', ST_PBL ),
				'id'       => 'digits_color',
				'type'     => 'color_picker',
				'std'      => '#e23030',
			),
			array(
				'name'    => __( 'Digits Font Size', ST_PBL ),
				'id'       => 'digits_size',
				'type'    => 'select',
				'std'     => '40px',
				'options' => array(
					"20px"=>"20px",
					"30px"=>"30px",
					"40px"=>"40px",
					"50px"=>"50px",
					"60px"=>"60px",
					"70px"=>"70px",
					
				),
			),
			
			array(
					'name'       => __( 'Font', ST_PBL ),
					'id'         => 'font',
					'type'       => 'radio',
					'std'        => 'inherit',
					'options'    => array( 'inherit' => __( 'Inherit', ST_PBL ), 'custom' => __( 'Custom', ST_PBL ) ),
					'has_depend' => '1',
					//'class'      => 'input-sm',
				),
				
			/*array(
					'name' => __( 'Color', ST_PBL ),
					'id'           => 'normal_font_color',
					'type'         => 'color_picker',
					'std'          => '#626B75',
					'dependency'      => array( 'font', '=', 'inherit' ),
				),*/
				
			array(
					'name' => __( 'Font Face', ST_PBL ),
					'id'   => 'font_family',
					'type' => array(
						array(
							'id'           => 'font_face_type',
							'type'         => 'jsn_select_font_type',
							'class'        => 'input-sm',
							'std'          => 'standard fonts',
							'options'      => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'font_face_value',
							'type'         => 'jsn_select_font_value',
							'class'        => 'input-sm',
							'std'          => 'Verdana',
							'options'      => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'      => array( 'font', '=', 'custom' ),
					'container_class' => 'combo-group',
				),
				
				array(
					'name' => __( 'Font Attributes', ST_PBL ),
					'type' => array(
						
						array(
							'id'           => 'font_style',
							'type'         => 'select',
							'class'        => 'input-sm st-mini-input',
							'std'          => 'bold',
							'options'      => ST_Pb_Helper_Type::get_font_styles(),
							'parent_class' => 'combo-item',
						),
						
					),
					'dependency'      => array( 'font', '=', 'custom' ),
					'container_class' => 'combo-group',
				),
			array(
				'name'    => __( 'Labels &amp; Separators color', ST_PBL ),
				'id'       => 'labels_color',
				'type'     => 'color_picker',
				'std'      => '#323434',
			),
			array(
				'name'    => __( 'Labels Font Size', ST_PBL ),
				'id'       => 'labels_size',
				'type'    => 'select',
				'std'     => '16px',
				'options' => array(
					"13px"=>"13px",
					"16px"=>"16px",
					"20px"=>"20px",
					"23px"=>"23px",
					
					
				),
			),
			
			array(
				'name'    => __( 'Dots color', ST_PBL ),
				'id'       => 'dot_color',
				'type'     => 'color_picker',
				'std'      => '#e23030',
			),
			
			array(
				'name'    => __( 'Background color', ST_PBL ),
				'id'       => 'bg_color',
				'type'     => 'color_picker',
				'std'      => '#f7f6f6',
			),
			array(
				'name'    => __( 'Flip color', ST_PBL ),
				'id'       => 'flip_color',
				'type'     => 'color_picker',
				'std'      => '#f5bcbc',
			),
			array(
						'name'    => __('Flip Width', ST_PBL),
						'id'       => 'desktop_flp_width',
						'type'     => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '86',
						'std_min'      => '18',
						'std'      => '36',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('ul.flip', 'width')
								)
							)
						) // end css
				),
			
			array(
				'name'    => __( 'Style', ST_PBL ),
				'id'      => 'fl_bl',
				'type'    => 'select',
				'std'     => 'flick-clock',
				'options' => array(
					'flick-clock' => __( 'Flip Clock', ST_PBL ),
					'block' => __( 'Block', ST_PBL ),
				),
			),	
			
			array(
				'name'    => __( 'Size', ST_PBL ),
				'id'      => 'size',
				'type'    => 'select',
				'std'     => 'big',
				'options' => array(
					"big"=>"Big",
					"medium"=>"Medium",
					"small"=>"Small",
				),
			),	
			
			array(
						'name'               => __( 'Days Labels Position', ST_PBL ),
						'id'                 => 'days_label',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '70',
						'std_min'      => '-50',
						'std'     => '-25',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.days span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Hours Label Position', ST_PBL ),
						'id'                 => 'hrs_label',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '70',
						'std_min'      => '-40',
						'std'     => '-9',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Minutes Label Position', ST_PBL ),
						'id'                 => 'mins_label',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '70',
						'std_min'      => '-40',
						'std'     => '-6',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.minutes span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Seconds Label Position', ST_PBL ),
						'id'                 => 'secs_label',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '70',
						'std_min'      => '-40',
						'std'     => '-8',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.seconds span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Bottom Dot Position', ST_PBL ),
						'id'                 => 'btm_dot_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '100',
						'std_min'      => '10',
						'std'     => '60',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-dot.top,span.flip-clock-divider.minutes span.flip-clock-dot.bottom,span.flip-clock-divider.seconds span.flip-clock-dot.bottom', 'top'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Top Dot Position', ST_PBL ),
						'id'                 => 'topp_dot_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '100',
						'std_min'      => '10',
						'std'     => '40',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(min-width: 769px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-dot.bottom,span.flip-clock-divider.minutes span.flip-clock-dot.top,span.flip-clock-divider.seconds span.flip-clock-dot.top', 'top'),
								),
							),
						), // end css
					), // end field			
			
					
			// these are helper types, showing animation related fields
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),				
		);
		
		
		
		
		
		$this->items['mobile'] = array(
			
			array(
						'name'    => __('Flip Width', ST_PBL),
						'id'       => 'me_width',
						'type'     => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '26',
						'std_min'      => '8',
						'std'      => '26',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('ul.flip', 'width')
								)
							)
						) // end css
				),
			
			array(
						'name'               => __( 'Digits Font Size', ST_PBL ),
						'id'                 => 'df_size',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '46',
						'std_min'      => '10',
						'std'     => '25',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('ul li a div div.inn', 'font-size'),
								),
							),
						), // end css
					), // end field
					
					
			array(
						'name'               => __( 'Labels Font Size', ST_PBL ),
						'id'                 => 'lblf_size',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '19',
						'std_min'      => '10',
						'std'     => '13',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('.flip-clock-label', 'font-size'),
								),
							),
						), // end css
					), // end field		
					
			array(
						'name'               => __( 'Days Labels Position', ST_PBL ),
						'id'                 => 'dlbl_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '30',
						'std_min'      => '-50',
						'std'     => '-17',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.days span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Hours Label Position', ST_PBL ),
						'id'                 => 'hlbl_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '30',
						'std_min'      => '-40',
						'std'     => '-4',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Minutes Label Position', ST_PBL ),
						'id'                 => 'minlbl_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '30',
						'std_min'      => '-40',
						'std'     => '-4',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.minutes span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Seconds Label Position', ST_PBL ),
						'id'                 => 'mlbl_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '30',
						'std_min'      => '-40',
						'std'     => '-2',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.seconds span.flip-clock-label', 'margin-left'),
								),
							),
						), // end css
					), // end field	
			
			array(
						'name'               => __( 'Bottom Dot Position', ST_PBL ),
						'id'                 => 'dot_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '100',
						'std_min'      => '10',
						'std'     => '63',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-dot.top,span.flip-clock-divider.minutes span.flip-clock-dot.bottom,span.flip-clock-divider.seconds span.flip-clock-dot.bottom', 'top'),
								),
							),
						), // end css
					), // end field	
					
			array(
						'name'               => __( 'Top Dot Position', ST_PBL ),
						'id'                 => 'top_dot_pos',
						'type'               => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '100',
						'std_min'      => '10',
						'std'     => '42',
						'append' => 'px !important',
						'css' => array(
							'media_query' => array(
								'query'=>'(max-width: 768px)',
								'css' => array(
									array('span.flip-clock-divider.hours span.flip-clock-dot.bottom,span.flip-clock-divider.minutes span.flip-clock-dot.top,span.flip-clock-divider.seconds span.flip-clock-dot.top', 'top'),
								),
							),
						), // end css
					), // end field	
				
			array(
				'name'    => __( 'Labels Margin Top', ST_PBL ),
				'id'       => 'label_top',
				'type'    => 'select',
				'std'     => '10px',
				'options' => array(
					"-30px"=>"-30px",
					"-20px"=>"-20px",
					"-10px"=>"-10px",
					"0px"=>"0px",
					"10px"=>"10px",
					
				),
			),
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		//$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		//extract( $arr_params );
	
		ST_Pb_Helper_Shortcode::generate_shortcode_params( $this->items, NULL, $atts );

		$arr_params     = ( shortcode_atts( $this->config['params'], $atts ) );
		extract($arr_params);
		$style          = array();
		$exclude_params = array( 'tag', 'text', 'preview' );
		$stylesheet     = $font_style = '';
		
		
		
		// Debugger: uncomment to check available params passed through shortcode
		//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';

		/*----------  HTML CODE, PER INSTANCE JAVASCRIPT ETC CAN GO HERE  ----------*/
		
		$extra_class = $script = $styles = $styles2 = $output = '';
		
		$counting_direction = 'countdown';
		$id = "cbb-flip-clock-".rand(1, 999);
		
		if(! $date_time) return 'No date/time provided !';
				$st2 = '<style>';
					$st2 .='.flip-clock-label { font-size: '.$labels_size.' !important}';
			$st2.= '</style>';
		
		if($show_seconds == 'no'){
			
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.seconds { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(11) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(12) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		$counter_params .= 'showSeconds: "false",';
		}
		
		
		if($show_minutes == 'no'){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.minutes { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(8) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(9) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		
		$counter_params .= 'showMinutes: "false",';
		}
		if($show_seconds == 'no' && $show_minutes == 'no'){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.seconds { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(11) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(12) { display: none !important; }';
			$stylessss .=  'span.flip-clock-divider.minutes { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(8) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(9) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		$counter_params .= 'showSeconds: "false",';
		}
		if($show_hours == 'no'){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.hours { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(5) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(6) { display: none !important; }';
			/*$stylessss .=  'span.flip-clock-divider.minutes span:nth-child(2), span.flip-clock-divider.minutes span:last-child { display: none !important; }';*/
		$stylessss .= '</style>';
		
		
		$counter_params .= 'showMinutes: "false",';
		}
		
		if($show_minutes == 'no' && $show_hours == 'no' ){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.minutes { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(8) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(9) { display: none !important; }';
			$stylessss .=  'span.flip-clock-divider.hours { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(5) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(6) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		
		$counter_params .= 'showMinutes: "false",';
		}
		if($show_seconds == 'no' && $show_hours == 'no' ){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.seconds { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(11) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(12) { display: none !important; }';
			$stylessss .=  'span.flip-clock-divider.hours { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(5) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(6) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		
		$counter_params .= 'showMinutes: "false",';
		}
		if($show_minutes == 'no' && $show_hours == 'no' && $show_seconds=='no' ){
		
		$stylessss = '<style>';
			$stylessss .=  'span.flip-clock-divider.minutes { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(8) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(9) { display: none !important; }';
			$stylessss .=  'span.flip-clock-divider.hours { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(5) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(6) { display: none !important; }';
			$stylessss .=  'span.flip-clock-divider.seconds { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(11) { display: none !important; }';
			$stylessss .=  '.flip-clock-wrapper ul:nth-child(12) { display: none !important; }';
		$stylessss .= '</style>';
		
		
		
		$counter_params .= 'showMinutes: "false",';
		}
		
		
		$seconds = strtotime($date_time) - time();
		if(! $seconds OR ! is_numeric($seconds)) return 'Invalid date/time provided !';
		
		/*if($counting_direction == 'countdown' && $seconds < 0) 
		{
			$seconds = 0;
		}*/
		
		$seconds = @abs($seconds);
		
		$counter_params = '';
		if($seconds > 14400) $counter_params .= 'clockFace: "DailyCounter",';
		
		
		
		if($language && $language != 'en') $counter_params .= 'language: "'.$language.'",';
		
		if ( ! empty( $arr_params ) AND is_array( $arr_params ) ) {
			if ( $arr_params['font'] == 'inherit' || $arr_params['font'] == 'Inherit' ) {
				unset( $arr_params['font'] );
				unset( $arr_params['font_face_type'] );
				unset( $arr_params['font_face_value'] );
				unset( $arr_params['font_size_value_'] );
				unset( $arr_params['font_style'] );
				unset( $arr_params['color'] );
				
				if($arr_params['normal_font_color'])
					$arr_params['color'] = $arr_params['normal_font_color'];

				if($arr_params['normal_font_size'])
					$arr_params['font_size_value_'] = $arr_params['normal_font_size'];						
			}

			if ( isset( $arr_params['font'] ) && $arr_params['font'] == 'custom' ) {
				unset( $arr_params['font'] );
				if ( isset( $arr_params['font_style'] ) && strtolower( $arr_params['font_style'] ) == 'bold' ) {
					$arr_params['font_weight'] = '700';
					unset( $arr_params['font_style'] );
				}
				if ( isset( $arr_params['font_style'] ) && strtolower( $arr_params['font_style'] ) == 'normal' ) {
					$arr_params['font_weight'] = 'normal';
					unset( $arr_params['font_style'] );
				}
			}

			if ( isset( $arr_params['font_size_value_'] ) && $arr_params['font_size_value_'] == '' ) {
				unset( $arr_params['font_size_value_'] );
			}

			if ( $arr_params['border_bottom_width_value_'] == '' ) {
				unset( $arr_params['border_bottom_width_value_'] );
				unset( $arr_params['border_bottom_style'] );
				unset( $arr_params['border_bottom_color'] );
			}

			if ( $arr_params['padding_bottom_value_'] == '' ) {
				unset( $arr_params['padding_bottom_value_'] );
			}

			if ( $arr_params['text_align'] == 'inherit' || $arr_params['text_align'] == 'Inherit' ) {
				unset( $arr_params['text_align'] );
			}
		}
		
		foreach ( $arr_params as $key => $value ) {
			if ( $value != '' ) {
				if ( $key == 'font_face_type' ) {
					if ( $value == __( 'Standard fonts', ST_PBL ) || $value == 'standard fonts' ) {
						$font_style = 'font-family:' . $arr_params['font_face_value'];
						$set=$arr_params['font_face_value'];
						$stylesss2 = '<style>';
							$stylesss2 .=  '.flip-clock-divider:first-child { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.hours { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.minutes { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.seconds { font-family:
							'.$set.' }';
						$stylesss2 .= '</style>';
					} elseif ( $value == __( 'Google fonts', ST_PBL ) || $value == 'google fonts' ) {
						$script     = ST_Pb_Helper_Functions::add_google_font_link_tag( $arr_params['font_face_value'] );
						$font_style = 'font-family:' . $arr_params['font_face_value'];
						$set=$arr_params['font_face_value'];
						$stylesss2 = '<style>';
							$stylesss2 .=  '.flip-clock-divider:first-child { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.hours { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.minutes { font-family:
							'.$set.' }';
							$stylesss2 .=  'span.flip-clock-divider.seconds { font-family:
							'.$set.' }';
						$stylesss2 .= '</style>';
						
					}
				} elseif ( $key != 'font_face_value' ) {
					$key = ST_Pb_Helper_Functions::remove_tag( $key );
					if ( ! in_array( $key, $exclude_params ) ) {
						switch ( $key ) {
							case 'border_bottom_width_value_':
								$style[$key] = 'border-bottom-width:' . $value . 'px';
								break;

							case 'text_align':
								$style[$key] = 'text-align:' . $value;
								break;

							case 'font_size_value_':
								$style[$key] = 'font-size:' . $value . 'px';
								break;

							case 'font_style':
								$style[$key] = 'font-style:' . $value;
								$stylesss2 = '<style>';
									$stylesss2 .=  '.flip-clock-divider:first-child { font-style:'.$value.' }';
									$stylesss2 .=  'span.flip-clock-divider.hours { font-style:'.$value.' }';
									$stylesss2 .=  'span.flip-clock-divider.minutes { font-style:'.$value.' }';
									$stylesss2 .=  'span.flip-clock-divider.seconds { font-style:'.$value.' }';
								$stylesss2 .= '</style>';
								break;

							case 'border_bottom_style':
								$style[$key] = 'border-bottom-style:' . $value;
								break;

							case 'border_bottom_color':
								$style[$key] = 'border-bottom-color:' . $value;
								break;

							case 'padding_bottom_value_':
								$style[$key] = 'padding-bottom:' . $value . 'px';
								break;

							case 'font_weight':
								$style[$key] = 'font-weight:' . $value;
								break;

							case 'color':
								$style[$key] = 'color:' . $value;
								break;
						}
					}
				}
			}
		}
		
		
		$do_action = '';
		switch($action)
		{
			case 'message':
				$do_action = 'alert("'.$message.'")';
				if(! $message) $do_action = '';
			break;
			case 'redirect':
				$do_action = 'window.location = "'.$url.'"';
				if(! $url OR $url=='http://') $do_action = '';
			break;
		}
		
		
		if($do_action && $counting_direction == 'countdown' && $seconds <= 0) 
		{
			$script .= '<script type="text/javascript">'.$do_action.'</script>';
		}
		
	$script .= '
					<script type="text/javascript">	
						jQuery(document).ready(function($) 
						{ 
							
								
							$("#'.$id.'").FlipClock('.$seconds.', 
							{ 
								'.$counter_params.'
								countdown: '.(($counting_direction == 'countdown')?'true':'false').',
								callbacks: 
								{
									stop: function ()
									{
										'.$do_action.'
									}
								}
							});
							
							jQuery("#ui-datepicker-div").datepicker({
								dateFormat: "y-m-d", 
								defaultDate:"17-4-25"
							});


						});
					</script>
		';
		
		// CSS START
		$styles = '<style>';
				
			$styles .= '#'.$id.', #'.$id.' ul { background: '.$bg_color.'; }';
			$styles .= '#'.$id.' ul li a div div.inn { background: '.$flip_color.' !important; color:'.$digits_color.'; }';
			$styles .= '#'.$id.' ul li a div div.inn { font-size:'.$digits_size.'; }';
			$styles .= '#'.$id.' .flip-clock-dot { background:'.$dot_color.' !important; }';
			$styles .= '#'.$id.' ul.flip { width:'.$flip_demo.' !important; }';
			$styles .= '#'.$id.' .flip-clock-label { margin-top:'.$label_top.' !important; }';
					
			//$styles .= '#'.$id.' .flip-clock-label { font-size:'.$mobile_demo.'; }';
			
			$styles .= '
			#'.$id.' .flip-clock-divider .flip-clock-label
			{ 
				color:'.$labels_color.'; 
			}';
			
			if($labels_size!='26px')
			{
				$styles .= '
				#'.$id.' .flip-clock-divider .flip-clock-label
				{ 
					font-size:'.$labels_size.'; 
				}';
			}
			$styles .= '
			#'.$id.' .flip-clock-dot
			{ 
				background: '.$labels_color.'; 
			}';
			
		$styles .= '</style>';
		// CSS END
		
		
		
		
		// Add element ID to the wrapper so Dynamic CSS could be applied
		// elm_id is generated dynamically by ST_Pb_Helper_Shortcode::generate_shortcode_params() on load
	$output2 = '<div id="'.$id.'-wrapper" class="cbb-flip-clock-wrapper" style="margin-top: 24px !important;">
			<div id="'.$id.'" class="cbb-flip-clock cbb-flip-clock-style-'.$fl_bl.' cbb-flip-clock-size-'.$size.'"></div>
			<div class="clearfix"></div>
		</div>';
	
		$html_element = $script . $styles  . $output2 .$stylessss4 . $stylesss . $stylesss2 . $stylessss .$st5 .$st2 .$st3 .$st6 .$st7;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;

