<?php


if ( ! class_exists( 'ST_Divider' ) ) :

/**
 * Horizontal line element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Divider extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Divider', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-Divider';
		$this->config['description'] = __( 'Horizontal line for dividing sections', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
	
		$align_options = ST_Pb_Helper_Type::get_text_align();
		unset($align_options['inherit']);
		unset($align_options['right']);
		
		$this->items = array(
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name' => __( 'Border', ST_PBL ),
					'type' => array(
						array(
							'id'           => 'div_border_width',
							'type'         => 'text_append',
							'type_input'   => 'number',
							'class'        => 'input-mini',
							'std'          => '2',
							'append'       => 'px',
							'validate'     => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id'           => 'div_border_style',
							'type'         => 'select',
							'class'        => 'input-sm st-border-type',
							'std'          => 'solid',
							'options'      => ST_Pb_Helper_Type::get_border_styles(),
							'parent_class' => 'combo-item'
						),
						array(
							'id'           => 'div_border_color',
							'type'         => 'color_picker',
							'std'          => '#E0DEDE',
							'parent_class' => 'combo-item',
						),
					),
					'container_class' => 'combo-group',
				),
				array(
					'name'         => __( 'Divider Width', ST_PBL ),
					'id'           => 'divider_width',
					'type'         => 'select',
					'class'        => 'input-mini-m input-sm st-select2-editor',
					'std'          => '100',
					'options'      => array(
						'100' => __( '100', ST_PBL ),
						'80'  => __( '80', ST_PBL ),
						'70'  => __( '70', ST_PBL ),
						'60'  => __( '60', ST_PBL ),
						'50'  => __( '50', ST_PBL ),
						'30'  => __( '30', ST_PBL ),
						'20'  => __( '20', ST_PBL ),
					),
					'parent_class'    => 'combo-item input-append select-append input-group input-select-append st-input-append',
					'append_text'     => '%',
					'container_class' => 'combo-group',
					'disable_select2' => true
				),
				array(
					'name'    => __( 'Alignment', ST_PBL ),
					'id'      => 'align',
					'type'    => 'radio_button_group',
					'std'     => 'left',
					'options' => $align_options,
					'class'   => 'input-sm',
				),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );
		$styles = array();
		
		if($align == 'center')
		{
			$styles[] = 'margin-left: auto;margin-right: auto;';
		}
		
		$divider_width  = ( $divider_width ) ? ( int ) $divider_width : '';
		if ( $divider_width ) {
			$styles[] = 'width: ' . intval( $divider_width ) . '%';
		}
		if ( $div_border_width ) {
			$styles[] = 'border-bottom-width:' . intval( $div_border_width ) . 'px';
		}
		if ( $div_border_style ) {
			$styles[] = 'border-bottom-style:' . $div_border_style;
		}
		if ( $div_border_color ) {
			$styles[] = 'border-bottom-color:' . urldecode( $div_border_color );
		}
		if ( $div_margin_top ) {
			$styles[] = 'margin-top:' . intval( $div_margin_top ) . 'px';
		}
		if ( $div_margin_bottom ) {
			$styles[] = 'margin-bottom:' . intval( $div_margin_bottom ) . 'px';
		}
		if ( count( $styles ) > 0 ) {
			$html_element = '<div style="' . implode( ';', $styles ) . '"></div>';
		} else {
			$html_element = '';
		}
		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
