<?php


if ( ! class_exists( 'ST_Essentialgrid' ) 
	&& is_plugin_active( 'essential-grid/essential-grid.php' ) ) :

/**
 * Create element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Essentialgrid extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Essential Grid', ST_PBL );
		$this->config['cat']         = __( 'Wordpress Plugins', ST_PBL );
		$this->config['icon']        = 'cbi-Table';
		$this->config['description'] = __( 'Embed grids from Essential grid', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Essential Grid', ST_PBL ),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		global $wpdb;
		
		$data = $wpdb->get_results(
			"
SELECT handle, name
FROM " . $wpdb->prefix . Essential_Grid::TABLE_GRID. "
ORDER BY name ASC LIMIT 999
"
		);
		$items = array();
		if ( $data ) {
			foreach ( $data as $item ) {
				$items[$item->handle] = $item->name;
			}
		} else {
			$items[0] = __( 'No Grids found', ST_PBL );
		}	
		
		$this->items = array(
			'content' => array(

				array(
					'name'    => __( 'Grid', ST_PBL ),
					'id'      => 'slug',
					'type'    => 'select',
					'std'     => '',
					'options' => $items,
					'tooltip' => __( 'Select your grid.', ST_PBL ),
				),	
				
			),
			
			'styling' => array(	
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),				
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		if ( isset( $_GET['st_shortcode_preview'] ) )
		{
			return '<center>['.$this->config['name'].' element is not shown in the preview]</center>';
		}
		
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		
		extract( shortcode_atts( array(
		    'slug' => '',
		), $atts ) );
		

		$html_element = do_shortcode('[ess_grid alias="'.$slug.'"]');

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
