<?php


if ( ! class_exists( 'ST_Flip_box' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Flip_box extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Flip Box', ST_PBL );
		$this->config['cat']         = __( 'Interactive Elements', ST_PBL );
		$this->config['icon']        = 'cbi-FlipBox';
		$this->config['description'] = __( 'Create boxes that flip over on mouse hover', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'frontend_assets' => array(
				// Shortcode style
				'flip_box_frontend.css',
				'flip_box_frontend.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		
		$this->items['content'] = array(


			array(
				'name'     => __( 'Title on Front', ST_PBL ),
				'id'       => 'front_title',
				'type'     => 'text_field',
				'std'      => 'Flip box title',
				'tooltip' => __( 'Perhaps, this is the most highlighted text.', ST_PBL ),
			),
			
			array(
				'name'     => __( 'Description on Front', ST_PBL ),
				'id'       => 'front_desc',
				'type'     => 'text_area',
				'std'      => 'Box Description goes here',
				'tooltip' => __( 'Keep it short and simple!', ST_PBL ),
			),
		
			
			
			array(
				'name'     => __( 'Title on Back', ST_PBL ),
				'id'       => 'back_title',
				'type'     => 'text_field',
				'std'      => 'Box back title',
				'tooltip' => __( 'Some nice heading for the back side of the flip.', ST_PBL ),
			),	

			array(
				'name'     => __( 'Description on Back', ST_PBL ),
				'id'       => 'back_desc',
				'type'     => 'text_area',
				'std'      => 'Text here will be followed by a button. So make it catchy!',
			),

		);
		
		$this->items['content'] = array_merge(
			$this->items['content'], 
			ST_Pb_Helper_Type::get_icon_type('box_icon', null, array(), __( 'Click to configure icon or image', ST_PBL ), true)
		);
		
		$this->items['content'] = array_merge(
			$this->items['content'], 
			ST_Pb_Helper_Type::get_button_type('box_button')
		);
		
		
		$this->items['styling'] = array(
			array(
						'type' => 'preview',
			),
			
			array(
				'name'    => __( 'Text color', ST_PBL ),
				'id'       => 'text_color',
				'type'     => 'color_picker',
				'std'      => '#000',
				'tooltip' => __( 'Color of title & description text.', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Size of Box Border (px)', ST_PBL ),
				'id'       => 'border_size',
				'type'         => 'text_append',
				'type_input'   => 'number',
				'class'        => 'input-mini',
				'std'          => '2',
				'append'       => 'px',
				'validate'     => 'number',
			),	
			
			array(
				'name'    => __( 'Border color', ST_PBL ),
				'id'       => 'border_color',
				'type'     => 'color_picker',
				'std'      => '#000',
				'tooltip' => __( 'Select the color for border on front.', ST_PBL ),
			),

			
			array(
				'name'    => __( 'Background color', ST_PBL ),
				'id'       => 'background_color',
				'type'     => 'color_picker',
				'std'      => '#efefef',
				'tooltip' => __( 'Light colors look better for background.', ST_PBL ),
			),
			
			
			array(
				'name'     => __( 'Height', ST_PBL ),
				'id'       => 'height',
				'type'     => 'radio',
				'std'      => 'auto',
				'options'  => array( 'auto' => __( 'Auto', ST_PBL ), 'fixed' => __( 'Fixed (specify)', ST_PBL ) ),
				'has_depend' => 1
			),
			
			array(
				'name'    => __( 'Height of Box (px)', ST_PBL ),
				'id'       => 'height_value',
				'type'         => 'text_append',
				'type_input'   => 'number',
				'class'        => 'input-mini',
				'std'          => '300',
				'append'       => 'px',
				'validate'     => 'number',
				'dependency'  => array( 'height', '=', 'fixed' ),
			),	
			
			array(
				'name'			=> __( 'Rounded corners', ST_PBL ),
				'container_class' 	=> 'combo-group',
				'id'			=> 'border_radius',
				'type'			=> 'border_radius',
				'extended_ids'	=> array( 'border_radius_topleft', 'border_radius_bottomleft', 'border_radius_topright', 'border_radius_bottomright' ),
				'border_radius_topleft'	=> array( 'std' => '0' ),
				'border_radius_bottomleft'	=> array( 'std' => '0' ),
				'border_radius_topright'   => array( 'std' => '0' ),
				'border_radius_bottomright'  => array( 'std' => '0' ),
				'border_elements'	=> 'tl, bl, tr, br',
			),
					
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),				
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 

		$output = $title = $alias = $el_class = '';
		extract( shortcode_atts( array(
		    'icon' => '',
		    'icon_size' => '',
		    'front_title' => '',
		    'front_desc' => '',
		    'back_title' => '',
		    'back_desc' => '',
		    
		    'icon_color' => '',
		    'icon_style' => '',
		    'icon_bg' => '',
		    'text_color' => '',
		    'border_size' => '',
		    'border_color' => '',
		    'background_color' => '',
		    'height' => 'auto', 
		    'height_value' => '',
		), $atts ) );
		
		$html_element  = '';
		
		$box_styles = '';
		$box_styles .= 'background: '.$background_color.';';
		
		if($border_size) 
			$box_styles_front = 'border: '.$border_size.'px solid '.$border_color.';';
			
		if($height == 'fixed' && $height_value && is_numeric($height_value))
		{
			$box_styles .= 'height: '.$height_value.'px;';
		}
		
		
		$border_radius = '';
		if ( ! empty ( $arr_params['border_radius_topleft'] ) ) 
			$border_radius .= '-moz-border-radius-topleft: '.intval($arr_params['border_radius_topleft']).'px;
-webkit-border-top-left-radius: '.intval($arr_params['border_radius_topleft']).'px;
 border-top-left-radius: '.intval($arr_params['border_radius_topleft']).'px;';
 		
 		if ( ! empty ( $arr_params['border_radius_topright'] ) ) 
 			$border_radius .= '-moz-border-radius-topright: '.intval($arr_params['border_radius_topright']).'px;
-webkit-border-top-right-radius: '.intval($arr_params['border_radius_topright']).'px;
border-top-right-radius: '.intval($arr_params['border_radius_topright']).'px;';
		
		if ( ! empty ( $arr_params['border_radius_bottomright'] ) ) 
			$border_radius .= '-moz-border-radius-bottomright: '.intval($arr_params['border_radius_bottomright']).'px;
-webkit-border-bottom-right-radius: '.intval($arr_params['border_radius_bottomright']).'px;
border-bottom-right-radius: '.intval($arr_params['border_radius_bottomright']).'px;';

		if ( ! empty ( $arr_params['border_radius_bottomleft'] ) ) 
			$border_radius .= '-moz-border-radius-bottomleft: '.intval($arr_params['border_radius_bottomleft']).'px;
-webkit-border-bottom-left-radius: '.intval($arr_params['border_radius_bottomleft']).'px;
border-bottom-left-radius: '.intval($arr_params['border_radius_bottomleft']).'px;';
		
		if($border_radius)
		{
			$box_styles .= $border_radius;
		}
		
		$output .= '
			<div class="cbb-flipbox flip flip-container '.(($height == 'fixed')?'cbb-flipbox-fixed-height':'cbb-flipbox-auto-height').'" ontouchstart="this.classList.toggle(\'hover\');">
				<div class="card flipper"> 
					<div class="face front"> 
						<div style="'.$box_styles.$box_styles_front.'" class="inner">
							<div class="flipbox-icon">
								'.ST_Pb_Helper_Premade::icon('box_icon', $atts).'
							</div>
							<h3 style="color: '.$text_color.';">'.$front_title.'</h3>
							<p style="color: '.$text_color.';">'.nl2br($front_desc).'</p>
						</div>
					</div> 
					<div class="face back"> 
						<div style="'.$box_styles.'" class="inner">
							<h3 style="color: '.$text_color.';">'.$back_title.'</h3>
							<p style="color: '.$text_color.';">'.nl2br($back_desc).'</p>
							<div class="flipbox-link">
								'.ST_Pb_Helper_Premade::button('box_button', $atts).'
							</div>
						</div>
					</div>
				</div>	 
			</div>
		';


		$html_element = $output;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
