<?php


if ( ! class_exists( 'ST_Gallery' ) ) :

/**
 * Create List of items element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Gallery extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'Gallery', ST_PBL );
		$this->config['cat']              = __( 'Media', ST_PBL );
		$this->config['icon']             = 'cbi-Gallery';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Insert a gallery or portfolio in your page', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'frontend_assets' => array(
				'cbb-isotope-js',
				'cbb-prettyphoto-js',
				'cbb-prettyphoto-css',
				
				'gallery_frontend.css',
				'gallery_frontend.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(
				array(
					'id'            => 'gallery_items',
					'type'          => 'group',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '' ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
					'size' => 'full',
				),
				
				array(
					'name'     => __( 'Show Filters', ST_PBL ),
					'id'       => 'filters',
					'type'     => 'radio',
					'std'      => 'yes',
					'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
				),

				array(
					'name'    => __( 'Columns', ST_PBL ),
					'id'      => 'columns',
					'type'    => 'select',
					'std'     => '3',
					'options' => array(
							"1" => "1",
							"2" => "2",
							"3" => "3",
							"4" => "4",
							"5" => "5",
					),
				),	
				
				array(
					'name'    => __( 'Thumbnails style', ST_PBL ),
					'id'      => 'thumb_style',
					'type'    => 'select',
					'std'     => 'thumbnail',
					'options' => array(
							"thumbnail" => "Border",
							"img-circle" => "Circle",
							"img-rounded" => "Rounded",
							"none-thumb-style" => "None",
					),
				),	
				
				array(
					'name'    => __( 'Items bottom spacing', ST_PBL ),
					'id'           => 'items_spacing',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '15',
					'append'       => 'px',
					'validate'     => 'number',
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$arr_params = ( shortcode_atts( $this->config['params'], $atts ) );
		extract($arr_params);
		
		// remove any previous tags
		ST_Item_Gallery::$tags = array();
		
		$params_to_send = array(
			'columns',
			'thumb_style',
			'items_spacing',
		);
		
		$params_string = ST_Pb_Helper_Functions::make_shortcode_params($params_to_send, $arr_params);
		
		$content = str_replace('[st_item_gallery', '[st_item_gallery '.$params_string, $content);
		
		//echo '<pre>'.print_r($content, TRUE).'</pre>';
		
		//echo '<pre>'.print_r($content, TRUE).'</pre>';

		$this->portfolio_id = rand();
		$this->columns = (int) $columns;
		ST_Item_Gallery::$pretty_rel_random = ' rel="prettyPhoto[rel-' . $this->portfolio_id . ']"';
		
		$items = do_shortcode($content);
		
		$output = '<div class="cbb-portfolio-instance">';


			if($filters=='yes' && ST_Item_Gallery::$tags && is_array(ST_Item_Gallery::$tags))
			{
				$output .= '<div class="cbb-portfolio-filters btn-group col-md-12 col-xs-12">';
				
					$output .= '<button class="btn btn-primary" data-filter="#cbb-portfolio-'.$this->portfolio_id.' *">'.__('Show all', 'cbt').'</button>';
	
					foreach(ST_Item_Gallery::$tags as $tag_key=>$tag)
					{
						$output .= '<button class="btn btn-primary" data-filter="#cbb-portfolio-'.$this->portfolio_id.' .cbb-portfolio-filter-'.$tag_key.'">'.ucfirst($tag).'</button>';
					}
				
				$output .= '</div><div class="clearfix"></div>';
			}
			
			$output .= '<ul id="cbb-portfolio-'.$this->portfolio_id.'" class="cbb-portfolio row cbb-thumbs-style-'.$thumb_style.'">';
				$output .= $items;
				
			$output .= '</ul>';
		
		$output .= '</div>';
			
		
		

			
		
		$html_elements = $output;

		return $this->element_wrapper( $html_elements, $arr_params );
	}
}

endif;
