<?php

if ( ! class_exists( 'ST_Item_Gallery' ) ) {

	class ST_Item_Gallery extends ST_Pb_Shortcode_Child {
		
		static $tags;
		static $pretty_rel_random;
		

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'data-modal-title' => __( 'Image', ST_PBL ),
			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
								'name'    => __( 'Image File', ST_PBL ),
								'id'      => 'image_file',
								'type'    => 'select_media',
								'std'     => '',
								'class'   => 'jsn-input-large-fluid',
					),
					
					array(
						'name'    => __( 'Caption', ST_PBL ),
						'id'      => 'caption',
						'type'    => 'text_field',
						'std'     => '',
						'role'    => 'title',
					),
					
					array(
								'name'       => __( 'On Click', ST_PBL ),
								'id'         => 'link_type',
								'type'       => 'select',
								'class'      => 'input-sm',
								'std'        => 'large_image',
								'options'    => array(
									'large_image' => __( 'Show Large Image', ST_PBL ),
									'url' => __( 'Go to URL', ST_PBL ),
									'none' => __( 'Do nothing', ST_PBL ),
								),
								'tooltip'    => __( 'Set link type of image', ST_PBL ),
								'has_depend' => '1',
					),

					array(
								'name'       => __( 'URL', ST_PBL ),
								'id'         => 'link',
								'type'       => 'text_field',
								'class'      => 'input-sm',
								'std'        => 'http://',
								'dependency' => array( 'link_type', '=', 'url' ),
								'tooltip'    => __( 'Url of link when click on image', ST_PBL ),
					),
					
					
					array(
						'name'    => __( 'Tags (e.g tag1, tag2, tag3)', ST_PBL ),
						'id'      => 'tags',
						'type'    => 'text_field',
						'std'     => '',
						'tooltip'     => __("Will be used for filters. Images will be grouped by tags. e.g tag1, tag2, tag3", ST_PBL ),
					),
				)
			);
		}
		
		
		
		public function element_shortcode_full( $atts = null, $content = null ) 
		{
			// add params coming from parent to defaults
			$this->config['params']['columns'] = '';
			$this->config['params']['thumb_style'] = '';
			$this->config['params']['items_spacing'] = '';
			
			$atts = shortcode_atts( $this->config['params'], $atts );
			extract( $atts );

			$arr_params     = $atts;
			$html_elemments = '';

			$tags = $this->tags_to_array($tags);
			$tags_class = '';
			if(! empty($tags)) foreach($tags as $tag_key=>$tag)
			{
				$tags_class .= ' cbb-portfolio-filter-'.$tag_key;
			}
			
			$columns_class = 'col-md-'.floor(12/$columns);
			$columns_class_xs = '';
			
			if($columns > 3) 
				$columns_class_xs = 'col-sm-6 col-xs-12';
			elseif($columns > 1) 
				$columns_class_xs = 'col-sm-6 col-xs-12';
			
			$item_style = 'margin-bottom:'.$items_spacing.'px;';
			
			$el_start = '<li style="'.$item_style.'" class="isotope-item '.$columns_class.' '.$columns_class_xs.' '.$tags_class.'">';
			$el_end = '</li>';
			
			
			$attach_id = ST_Pb_Helper_Functions::get_image_id( $image_file );

			$img_size = $this->get_size($columns);

			
			
			// ------------------------------------------------------
			//  yunus edit - if file attachment not found with original url then try to find it relatively
			// ------------------------------------------------------
			if ( ! $attach_id )
			{
				$try = preg_match('/wp\-content\/uploads\/sites\/[0-9]+\/.+/i', $image_file, $match);
				
				if($try)
				{
					$match = $match[0];
					$match = preg_replace('/\/sites\/[0-9]+/', '', $match);
				}
				else
				{
					$try = preg_match('/wp\-content\/uploads\/.+/i', $image_file, $match);
					
					if($try)
					{
						$match = $match[0];
						$match = preg_replace('/\/sites\/[0-9]+/', '', $match);
					}
				}
				
				if($try)
				{
					if ( is_multisite() )
					{
						$upload_dir = wp_upload_dir();
						$match = preg_replace('/wp\-content\/uploads\//i', '', $match);
						$match = $upload_dir['baseurl'].'/'.$match;
					}
					else
					{
						$match = site_url($match);
					}
					
					$attach_id = ST_Pb_Helper_Functions::get_image_id( $match );
				}
				
				//die();
			}

			if ( $attach_id > 0 ) {
				$post_thumbnail = ST_Pb_Helper_Functions::getImageBySize( array( 
					'attach_id' => $attach_id, 
					'thumb_size' => $img_size,
					'class' => $thumb_style,
				) );
			} else {
/*
				$post_thumbnail = ST_Pb_Helper_Functions::getImageBySize( array( 
					'attach_id' => $attach_id, 
					'thumb_size' => $img_size,
					'class' => $thumb_style,
				) );
*/
				$post_thumbnail = array(
					'thumbnail'=>'<img class="'.$thumb_style.'" src="'.$image_file.'" width="'.$this->size['width'].'" height="'.$this->size['width'].'" />',
					'p_img_large'=>array($image_file),
				);
			}
			
			//echo '<pre>'.print_r($img_size, TRUE).'</pre>';
			//echo '<pre>'.print_r($post_thumbnail, TRUE).'</pre>';
		
			$thumbnail = $post_thumbnail['thumbnail'];
			$p_img_large = $post_thumbnail['p_img_large'];
			$link_start = $link_end = '';
		
			if ($link_type == 'large_image') 
			{
				$link_start = '<a title="'.esc_attr($caption).'" class="prettyphoto" href="' . $p_img_large[0] . '" ' . self::$pretty_rel_random . '>'; //' . self::$pretty_rel_random . '
				$link_end = '</a>';
			}
			elseif ($link_type == 'none') 
			{
				$link_start = '<span class="thumb-no-link" ' . self::$pretty_rel_random . '>'; //' . self::$pretty_rel_random . '
				$link_end = '</span>';
			} 
			else {
				$link_start = '<a title="'.esc_attr($caption).'" href="' . $link . '">';
				$link_end = '</a>';
			}
			
			if($caption) $caption = '<span class="cbb-portfolio-caption"><p>'.$caption.'</p></span>';
			
			$output = $el_start . $link_start . '<div class="cbb-thumb-wrap">' . $thumbnail . $caption . '</div>'. $link_end . $el_end;
	
			
			return $output;
			
		}
		
		
		
		function get_size($columns, $container_size = 1100)
		{
			//$container_size -= $this->columns * 30;
			
			$size = $container_size / $columns;
			$size = floor($size);
			//echo '<pre>'.print_r(ceil($size), TRUE).'</pre>';
			
			$this->size = array(
				'width'=>$size,
				'height'=>$size,
			);
			
			return $size.'x'.$size;
		}
		
		
		function tags_to_array($tags)
		{
			if(! $tags) return array();
			
			$tags = strip_tags(stripslashes($tags));
			
			$tags = preg_replace('/__#__/i', ',', $tags);
			
			$raw_tags = explode(',', $tags);
			
			
			$array = array();
			foreach($raw_tags as $raw)
			{
				$raw = trim($raw);
				if(! $raw) continue;
				
				$array[ sanitize_key($raw) ] = $raw;
			}
			
			// collect all tags in static property
			self::$tags = array_merge(self::$tags, $array);
			
			return $array;
		}
		

	}

}
