<?php

if ( ! class_exists( 'ST_Item_GoogleMap' ) ) {

	class ST_Item_GoogleMap extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'item_text'        => __( 'Marker', ST_PBL ),
				'data-modal-title' => __( 'Google Maps Item', ST_PBL ),

				'admin_assets' => array(
					// Shortcode initialization
					'item_googlemap.css',
				),
			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name'    => __( 'Title', ST_PBL ),
						'id'      => 'gmi_title',
						'type'    => 'text_field',
						'role'    => 'title',
						'std'     => __( ST_Pb_Utils_Placeholder::add_placeholder( 'Marker %s', 'index' ), ST_PBL ),
						'tooltip' => __( 'Title', ST_PBL )
					),
					array(
						'name'    => __( 'Description', ST_PBL ),
						'id'      => 'gmi_desc_content',
						'role'    => 'content',
						'type'    => 'text_area', // Edit inline supplement
						'std'     => __( 'Description of marker', ST_PBL ),
						'tooltip' => __( 'Description', ST_PBL ),
						'container_class' => 'st_tinymce_replace',
					),
					array(
						'name'    => __( 'Link URL', ST_PBL ),
						'id'      => 'gmi_url',
						'type'    => 'text_field',
						'std'     => 'http://',
						'tooltip' => __( 'Link URL', ST_PBL )
					),
					array(
						'name'        => __( 'Image', ST_PBL ),
						'id'          => 'gmi_image',
						'type'        => 'select_media',
						'std'         => '',
						'class'       => 'jsn-input-large-fluid',
						'tooltip'     => __( 'Image', ST_PBL ),
						'filter_type' => 'image',
					),
					array(
						'name' => __( 'Location', ST_PBL ),
						'id'   => 'gmi_location',
						'type' => array(
							array(
								'id'            => 'gmi_long',
								'type'          => 'text_append',
								'input_type'    => 'number',
								'class'         => 'jsn-input-number input-small',
								'std'           => rand(0, 10),
								'parent_class'  => 'input-group-inline',
								'append_before' => __( 'Long', ST_PBL )
							),
							array(
								'id'            => 'gmi_lat',
								'type'          => 'text_append',
								'input_type'    => 'number',
								'class'         => 'jsn-input-number input-small',
								'std'           => rand(0, 10),
								'parent_class'  => 'input-group-inline',
								'append_before' => __( 'Lat', ST_PBL )
							),
							
						),
						'tooltip'         => __( 'Location', ST_PBL ),
						'container_class' => 'combo-group',
						'after_field'=>'<a target="_blank" class="button" href="http://www.latlong.net/convert-address-to-lat-long.html">Find longitude & latitude for address</a> ',
					),
					array(
						'name'       => __( 'Enable Direction', ST_PBL ),
						'id'         => 'gmi_enable_direct',
						'type'       => 'radio',
						'std'        => 'no',
						'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
						'tooltip'    => 'Enable Direction',
						'has_depend' => '1',
					),
					array(
						'name'        => __( 'Destination', ST_PBL ),
						'id'         => 'gmi_destination',
						'type'       => 'destination',
						'tooltip'    => __( 'Destination', ST_PBL ),
						'dependency' => array( 'gmi_enable_direct', '=', 'yes' )
					),
				)
			);
		}

		public function element_shortcode_full( $atts = null, $content = null ) {
			$params = shortcode_atts( $this->config['params'], $atts );
			// reassign value for description from content of shortcode
			$params['gmi_desc_content'] = $content;

			$html_element = "<input type='hidden' value='" . json_encode( $params ) . "' class='st-gmi-lat-long' />";
			$html_element .= '<!--seperate-->';
			return $html_element;
		}

	}

}