<?php

if (!class_exists('ST_Heading')):

/**
 * Heading element for ProStyler Builder.
 *
 * @since  1.0.0
 */
	class ST_Heading extends ST_Pb_Shortcode_Element {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Heading', ST_PBL);
			$this->config['cat'] = __('Basic,Content', ST_PBL);
			$this->config['icon'] = 'cbi-heading';
			$this->config['description'] = __('Creates custom headlines with icons', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'admin_assets' => array(
					// Shortcode initialization
					'heading.js',
				),

				'frontend_assets' => array(
					// Bootstrap 3
					'st-pb-bootstrap-css',
					'st-pb-bootstrap-js',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {
			$this->items['content'] = array(

				array(
					'name' => __('Tag', ST_PBL),
					'id' => 'tag',
					'type' => 'select',
					'class' => 'input-sm st-heading-type',
					'std' => 'h2',
					'options' => array('h1' => 'H1', 'h2' => 'H2', 'h3' => 'H3', 'h4' => 'H4', 'h5' => 'H5', 'h6' => 'H6'),
					'tooltip' => __('Support tags: H1, H2, H3, H4, H5, H6', ST_PBL),
				),
				array(
					'name' => __('Text', ST_PBL),
					'id' => 'text',
					'type' => 'text_field',
					'role' => 'content',
					'class' => 'input-sm',
					'std' => __('Your heading text', ST_PBL),
				),
				array(
					'type' => 'skip_to_next_section',
				),
			);

			$this->items['content'] = array_merge(
				$this->items['content'],
				ST_Pb_Helper_Type::get_icon_type('heading_icon', array(

					'icon' => '',
					'size' => '32',
					'color' => '',
					'style' => 'simple',
					'bg' => '#EFEFEF',
				),
					array(
						array(
							'name' => __('Icon position', ST_PBL),
							'id' => 'heading_icon_position',
							'type' => 'select',
							'std' => 'left',
							'options' => array(
								"left" => "left",
								"top" => "top",
								"right" => "right",
							),
						),

						array(
							'name' => __('Icon distance from heading (px)', ST_PBL),
							'id' => 'icon_margin',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '10',
							'append' => 'px',
							'validate' => 'number',
						),
					))
			);

			$this->items['styling'] = array(
				array(
					'type' => 'preview',
				),
				array(
					'name' => __('Alignment', ST_PBL),
					'id' => 'text_align',
					'type' => 'radio_button_group',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
					'options' => ST_Pb_Helper_Type::get_text_align(),
					'class' => 'input-sm',
				),
				// array(
				// 	'name'            => __( 'Margin', ST_PBL ),
				// 	'container_class' => 'combo-group',
				// 	'id'              => 'heading_margin',
				// 	'type'            => 'margin',
				// 	'extended_ids'    => array( 'heading_margin_top', 'heading_margin_right', 'heading_margin_bottom', 'heading_margin_left' ),
				// 	'heading_margin_top'    => array( 'std' => '5' ),
				// 	'heading_margin_bottom' => array( 'std' => '25' ),
				// 	'tooltip'               => __( 'External spacing with other elements', ST_PBL )
				// ),
				array(
					'name' => __('Font', ST_PBL),
					'id' => 'font',
					'type' => 'radio',
					'std' => 'inherit',
					'options' => array('inherit' => __('Inherit', ST_PBL), 'custom' => __('Custom', ST_PBL)),
					'has_depend' => '1',
					//'class'      => 'input-sm',
				),
				array(
					'name' => __('Color', ST_PBL),
					'id' => 'normal_font_color',
					'type' => 'color_picker',
					'std' => '#626B75',
					'dependency' => array('font', '=', 'inherit'),
				),
				array(
					'name' => __('Text size', ST_PBL),
					'id' => 'inherit_font_size',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '25',
					'append' => 'px',
					'validate' => 'number',
					'dependency' => array('font', '=', 'inherit'),
					'css' => array(
						array('h2', 'font-size'),
					),
				),
				array(
					'name' => __('Font Face', ST_PBL),
					'id' => 'font_family',
					'type' => array(
						array(
							'id' => 'font_face_type',
							'type' => 'jsn_select_font_type',
							'class' => 'input-sm',
							'std' => 'standard fonts',
							'options' => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id' => 'font_face_value',
							'type' => 'jsn_select_font_value',
							'class' => 'input-sm',
							'std' => 'Verdana',
							'options' => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency' => array('font', '=', 'custom'),
					'container_class' => 'combo-group',
				),
				array(
					'name' => __('Font Attributes', ST_PBL),
					'type' => array(
						array(
							'id' => 'font_size_value_',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '18',
							'append' => 'px',
							'validate' => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id' => 'font_style',
							'type' => 'select',
							'class' => 'input-sm st-mini-input',
							'std' => 'bold',
							'options' => ST_Pb_Helper_Type::get_font_styles(),
							'parent_class' => 'combo-item',
						),
						array(
							'id' => 'color',
							'type' => 'color_picker',
							'std' => '#000000',
							'parent_class' => 'combo-item',
						),
					),
					'dependency' => array('font', '=', 'custom'),
					'container_class' => 'combo-group',
				),
				array(
					'name' => __('Enable Underline', ST_PBL),
					'id' => 'enable_underline',
					'type' => 'radio',
					'std' => 'yes',
					'options' => array('yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL)),
					'has_depend' => '1',
				),
				array(
					'name' => __('Underline Style', ST_PBL),
					'type' => array(
						array(
							'id' => 'border_bottom_width_value_',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '',
							'append' => 'px',
							'validate' => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id' => 'border_bottom_style',
							'type' => 'select',
							'class' => 'input-sm st-border-type',
							'std' => 'solid',
							'options' => ST_Pb_Helper_Type::get_border_styles(),
							'parent_class' => 'combo-item',
						),
						array(
							'id' => 'border_bottom_color',
							'type' => 'color_picker',
							'std' => '',
							'parent_class' => 'combo-item',
						),
					),
					'container_class' => 'combo-group',
					'dependency' => array('enable_underline', '=', 'yes'),
				),
				array(
					'name' => __('Underline Padding', ST_PBL),
					'type' => array(
						array(
							'id' => 'padding_bottom_value_',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '',
							'append' => 'px',
							'validate' => 'number',
						),
					),
					'dependency' => array('enable_underline', '=', 'yes'),
				),
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),

			);

			
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			$script = '';

			if (!empty($atts) AND is_array($atts)) {
				if (!isset($atts['border_bottom_width_value_'])) {
					$atts['border_bottom_width_value_'] = '';
					$atts['border_bottom_style'] = '';
					$atts['border_bottom_color'] = '';
				}

				if (!isset($atts['padding_bottom_value_'])) {
					$atts['padding_bottom_value_'] = '';
				}

				if (!isset($attrs['font_size_value_'])) {
					$attrs['font_size_value_'] = '';
				}
			}

			// Reload shortcode params: because we get Heading Text from "text" param
			ST_Pb_Helper_Shortcode::generate_shortcode_params($this->items, NULL, $atts);

			$arr_params = (shortcode_atts($this->config['params'], $atts));
			extract($arr_params);
			$style = array();
			$exclude_params = array('tag', 'text', 'preview');
			$stylesheet = $font_style = '';

			// Override custom style
			if (!empty($arr_params) AND is_array($arr_params)) {
				if ($arr_params['font'] == 'inherit' || $arr_params['font'] == 'Inherit') {
					unset($arr_params['font']);
					unset($arr_params['font_face_type']);
					unset($arr_params['font_face_value']);
					unset($arr_params['font_size_value_']);
					unset($arr_params['font_style']);
					unset($arr_params['color']);

					if ($arr_params['normal_font_color']) {
						$arr_params['color'] = $arr_params['normal_font_color'];
					}

				}

				if (isset($arr_params['font']) && $arr_params['font'] == 'custom') {
					unset($arr_params['font']);
					if (isset($arr_params['font_style']) && strtolower($arr_params['font_style']) == 'bold') {
						$arr_params['font_weight'] = '700';
						unset($arr_params['font_style']);
					}
					if (isset($arr_params['font_style']) && strtolower($arr_params['font_style']) == 'normal') {
						$arr_params['font_weight'] = 'normal';
						unset($arr_params['font_style']);
					}
				}

				if (isset($arr_params['font_size_value_']) && $arr_params['font_size_value_'] == '') {
					unset($arr_params['font_size_value_']);
				}

				if ($arr_params['border_bottom_width_value_'] == '') {
					unset($arr_params['border_bottom_width_value_']);
					unset($arr_params['border_bottom_style']);
					unset($arr_params['border_bottom_color']);
				}

				if ($arr_params['padding_bottom_value_'] == '') {
					unset($arr_params['padding_bottom_value_']);
				}

				if ($arr_params['text_align'] == 'inherit' || $arr_params['text_align'] == 'Inherit') {
					unset($arr_params['text_align']);
				}
			}

			foreach ($arr_params as $key => $value) {
				if ($value != '') {
					if ($key == 'font_face_type') {
						if ($value == __('Standard fonts', ST_PBL) || $value == 'standard fonts') {
							$font_style = 'font-family:' . $arr_params['font_face_value'];
						} elseif ($value == __('Google fonts', ST_PBL) || $value == 'google fonts') {
						$script = ST_Pb_Helper_Functions::add_google_font_link_tag($arr_params['font_face_value']);
						$font_style = 'font-family:' . $arr_params['font_face_value'];
					}
				} elseif ($key != 'font_face_value') {
					$key = ST_Pb_Helper_Functions::remove_tag($key);
					if (!in_array($key, $exclude_params)) {
						switch ($key) {
						case 'border_bottom_width_value_':
							$style[$key] = 'border-bottom-width:' . $value . 'px';
							break;

						case 'text_align':
							$style[$key] = 'text-align:' . $value;
							break;

						case 'font_size_value_':
							$style[$key] = 'font-size:' . $value . 'px';
							break;

						case 'font_style':
							$style[$key] = 'font-style:' . $value;
							break;

						case 'border_bottom_style':
							$style[$key] = 'border-bottom-style:' . $value;
							break;

						case 'border_bottom_color':
							$style[$key] = 'border-bottom-color:' . $value;
							break;

						case 'padding_bottom_value_':
							$style[$key] = 'padding-bottom:' . $value . 'px';
							break;

						case 'font_weight':
							$style[$key] = 'font-weight:' . $value;
							break;

						case 'color':
							$style[$key] = 'color:' . $value;
							break;
						}
					}
				}
			}
		}

		// Finalize style
		$style = implode(';', $style) . ';' . $font_style;

		if ($style == ';') {
			$style = '';
		}

		extract($arr_params);

		if ($enable_underline == 'yes') {

		}

		// Process heading margins
		if (isset($arr_params['heading_margin_top'])) {
			$arr_params['div_margin_top'] = $arr_params['heading_margin_top'];
		}

		if (isset($arr_params['heading_margin_bottom'])) {
			$arr_params['div_margin_bottom'] = $arr_params['heading_margin_bottom'];
		}

		if (isset($arr_params['heading_margin_right'])) {
			$arr_params['div_margin_right'] = $arr_params['heading_margin_right'];
		}

		if (isset($arr_params['heading_margin_left'])) {
			$arr_params['div_margin_left'] = $arr_params['heading_margin_left'];
		}

		$icon = ST_Pb_Helper_Premade::icon('heading_icon', $arr_params);

		// HTML code
		$true_element = "<{$arr_params['tag']} class='{$extra_classes}' style='{$style}'>";

		if ($icon) {
			if ($heading_icon_position == 'left') {
				$true_element .= '<span style="margin-right: ' . $icon_margin . 'px;">' . $icon . '</span>';
			}

			if ($heading_icon_position == 'top') {
				$true_element .= '<div style="margin-bottom: ' . $icon_margin . 'px;">' . $icon . '</div>';
			}

			$true_element .= '<span>' . do_shortcode($content) . '</span>';

			if ($heading_icon_position == 'right') {
				$true_element .= '<span style="margin-left: ' . $icon_margin . 'px;">' . $icon . '</span>';
			}

		} else {
			$true_element .= do_shortcode($content);
		}

		$true_element .= "</{$arr_params['tag']}>";

		return $this->element_wrapper($script . $stylesheet . $true_element, $arr_params);
	}
}

endif;
