<?php


if ( ! class_exists( 'ST_Icons_List' ) ) :

/**
 * Create List of items element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Icons_List extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'Icons List', ST_PBL );
		$this->config['cat']              = __( 'Content', ST_PBL );
		$this->config['icon']             = 'cbi-iconlist';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Create a list of icons', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Icon list', ST_PBL ),
			'data-modal-title' => __( 'Icon list', ST_PBL ),

			'admin_assets' => array(
				'st-pb-joomlashine-iconselector-js',
				'wp-color-picker',
				'st-pb-colorpicker-js', 
			),
			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
				// Shortcode style
				'icons_list_frontend.css',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		$align_options = ST_Pb_Helper_Type::get_text_align();
		unset($align_options['inherit']);
		
		$this->items = array(
			'content' => array(
				array(
					'id'            => 'icons_items',
					'type'          => 'group',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '' ),
						array( 'std' => '' ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				
				array(
					'name'    => __( 'Layout', ST_PBL ),
					'id'      => 'layout',
					'type'    => 'select',
					'std'     => 'horizontal',
					'options' => array(
							"horizontal" => "Horizontal",
							"vertical" => "Vertical",
					),
				),	

				array(
					'name'    => __( 'Size of icons', ST_PBL ),
					'id'           => 'icon_size',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '32',
					'append'       => 'px',
					'validate'     => 'number',
				),
	
				
				array(
					'name'    => __( 'Icons Style', ST_PBL ),
					'id'      => 'icon_style',
					'type'    => 'select',
					'std'     => 'simple',
					'options' => array(
						"simple"=>"Simple",
						"circle"=>"Circle Background",
						"square"=>"Square Background",
					),
					'has_depend' => '1',
				),	
				
				array(
					'name'    => __( 'Space between icons', ST_PBL ),
					'id'           => 'space',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '20',
					'append'       => 'px',
					'validate'     => 'number',
				),
				
				array(
					'name'    => __( 'Alignment', ST_PBL ),
					'id'      => 'align',
					'type'    => 'radio_button_group',
					'std'     => 'left',
					'options' => $align_options,
					'class'   => 'input-sm',
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$arr_params = ( shortcode_atts( $this->config['params'], $atts ) );
		extract($arr_params);
		
		$id = 'cbb-icons-list-'.rand(1,999);

		$params_to_send = array(
			'icon_size',
			'icon_style',
			'space',
			'layout',
		);
		
		$params_string = ST_Pb_Helper_Functions::make_shortcode_params($params_to_send, $arr_params);
		
		$content = str_replace('[st_item_icons_list', '[st_item_icons_list '.$params_string, $content);

		
		$items = do_shortcode($content);
		
		$output = '<div class="cbb-icons-list-instance">';
			
			$output .= '<ul id="'.$id.'" class="cbb-icons-list cbb-icons-list-align-'.$align.' cbb-icons-list-layout-'.$layout.'">';
			
				$output .= $items;
				
			$output .= '</ul>';
		
		$output .= '</div>';
			
		
		

			
		
		$html_elements = $output;

		return $this->element_wrapper( $html_elements, $arr_params );
	}
}

endif;
