<?php

if ( ! class_exists( 'ST_Item_Icons_List' ) ) {

	class ST_Item_Icons_List extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				//'default_content'  => __( 'Icon Item', ST_PBL ),
				'data-modal-title' => __( 'Icon Item', ST_PBL ),
			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name'      => __( 'Icon', ST_PBL ),
						'id'        => 'icon',
						'type'      => 'icons',
						'std'       => 'fa fa-star-o',
						'role'      => 'title_prepend',
						'title_prepend_type' => 'icon',
					),
				
					array(
						'name'    => __( 'Icon color', ST_PBL ),
						'id'       => 'icon_color',
						'type'     => 'color_picker',
						'std'      => '#000000',
					),	
					
					array(
						'name'    => __( 'Icon background color', ST_PBL ),
						'id'       => 'icon_bg',
						'type'     => 'color_picker',
						'std'      => '#fff',
						'tooltip' => __( 'Background color for icon.', ST_PBL ),
					),
				
					array(
						'name'    => __( 'URL', ST_PBL ),
						'id'      => 'url',
						'type'    => 'text_field',
						'class'   => 'jsn-input-xxlarge-fluid',
						'std'     => '',
						'tooltip' => __( 'Clicking on the icon will open this url. This is optional.', ST_PBL ),
					),
					
					array(
						'name'    => __( 'Open URL in', ST_PBL ),
						'id'      => 'open_in',
						'type'    => 'select',
						'std'     => 'horizontal',
						'class'      => 'input-sm',
						'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_open_in_options() ),
						'options'    => ST_Pb_Helper_Type::get_open_in_options(),
						'tooltip' => __( 'Select type of opening action when click on element', ST_PBL ),
					),	
				)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) 
		{
			// add params coming from parent to defaults
			$this->config['params']['space'] = '';
			$this->config['params']['layout'] = '';
			$this->config['params']['icon_size'] = '';
			$this->config['params']['icon_style'] = '';

			$atts = shortcode_atts( $this->config['params'], $atts );
			extract( $atts );

			$classes = $style = '';
			
			if($space && is_numeric($space))
			{
				$space = $space / 2;
				
				if(is_rtl())
				{
					if($layout == 'horizontal') $style .= 'padding: 0 0 '.$space.'px '.$space.'px';
					if($layout == 'vertical') $style .= 'padding: '.$space.'px 0';
				}
				else
				{
					if($layout == 'horizontal') $style .= 'padding: 0 '.$space.'px '.$space.'px';
					if($layout == 'vertical') $style .= 'padding: '.$space.'px 0';
				}
			}
			
			
			$atts['icon_icon'] = $icon;
			$icon = ST_Pb_Helper_Premade::icon('icon', $atts);
			
			$output = '<li style="'.$style.'"><div class="cbb-list-icon">';
			
			if($url)
			{
				if ( $open_in ) {
					switch ( $open_in ) {
						case 'current_browser':
							$target = '';
							break;
						case 'new_browser':
							$target = '_blank';
							break;
						case 'new_window':
							$target = '_blank';
							break;
						case 'lightbox':
							$classes .= ' prettyphoto';
							$url .= '?iframe=true&width=100%&height=100%';
							break;
					}
				}
				
				$output .= '<a href="'.$url.'" class="'.$classes.'" target="'.$target.'">';
			}
			
			$output .= $icon;
			
			if($url)
				$output .= '</a>';
			
			$output .= '</div></li>';
			
			
			return $output;
		}

	}

}
