<?php

if (!class_exists('ST_Image')):

/**
 * Create Image element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
	class ST_Image extends ST_Pb_Shortcode_Element {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Image', ST_PBL);
			$this->config['cat'] = __('Basic,Media', ST_PBL);
			$this->config['icon'] = 'cbi-Image';
			$this->config['description'] = __('Simple image with animation', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'admin_assets' => array(
					// Link Type
					'st-linktype.js',

					// Shortcode initialization
					'image.js',
				),

				'frontend_assets' => array(
					// Bootstrap 3
					'st-pb-bootstrap-css',
					'st-pb-bootstrap-js',

					// Fancy Box
					//'st-pb-jquery-fancybox-css',
					//'st-pb-jquery-fancybox-js',
					'cbb-prettyphoto-js',
					'cbb-prettyphoto-css',

					// Lazy Load
					'st-pb-jquery-lazyload-js',

					// Shortcode initialization
					'image_frontend.js',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {
			$this->items = array(
				'content' => array(

					array(
						'name' => __('Image File', ST_PBL),
						'id' => 'image_file',
						'type' => 'select_media',
						'std' => '',
						'class' => 'jsn-input-large-fluid',
					),
					array(
						'name' => __('Image Size', ST_PBL),
						'id' => 'image_size',
						'type' => 'large_image',
						'tooltip' => __('Set image size', ST_PBL),
					),
					array(
						'type' => 'skip_to_next_section',
					),
					array(
						'name' => __('Alt Text', ST_PBL),
						'id' => 'image_alt',
						'type' => 'text_field',
						'class' => 'input-sm',
						'std' => '',
						'tooltip' => __('Set alt text for image', ST_PBL),
					),

					array(
						'name' => __('On Click', ST_PBL),
						'id' => 'link_type',
						'type' => 'select',
						'class' => 'input-sm',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_image_link_types()),
						'options' => ST_Pb_Helper_Type::get_image_link_types(),
						'tooltip' => __('Set link type of image', ST_PBL),
						'has_depend' => '1',
					),
					array(
						'name' => __('Large Image Size', ST_PBL),
						'id' => 'image_image_size',
						'type' => 'large_image',
						'tooltip' => __('Choose image size', ST_PBL),
						'dependency' => array('link_type', '=', 'large_image'),
					),
					array(
						'name' => __('URL', ST_PBL),
						'id' => 'image_type_url',
						'type' => 'text_field',
						'class' => 'input-sm',
						'std' => 'http://',
						'dependency' => array('link_type', '=', 'url'),
						'tooltip' => __('Url of link when click on image', ST_PBL),
					),
					array(
						'name' => __('Single Item', ST_PBL),
						'id' => 'single_item',
						'type' => 'type_group',
						'std' => '',
						'items' => ST_Pb_Helper_Type::field_data_source(array(
							'callback' => 'ST_Pb_Helper_Type::get_single_item_button_bar',
							'args' => array(
								'link_type',
								array(
									'type' => 'items_list',
									'options_type' => 'select',
									'ul_wrap' => false,
								)
							)
						)),
					),
					array(
						'name' => __('Open in', ST_PBL),
						'id' => 'open_in',
						'type' => 'select',
						'std' => 'lightbox',
						'options' => ST_Pb_Helper_Type::get_open_in_options(),
						'dependency' => array(
							array('link_type', '!=', 'no_link'),
							array('link_type', '!=', 'lightbox_video'),
						),
						'tooltip' => __('Select type of opening action when click on element', ST_PBL),
					),

					array(
						'id' => 'video_url',
						'name' => __('Video', ST_PBL),
						'placeholder' => __('Select or paste Youtube url or Vimeo URL', ST_PBL),
						'type' => 'select_media',
						'filter_type' => 'video',
						'media_type' => 'video',
						'class' => 'jsn-input-large-fluid',
						'dependency' => array(
							array('link_type', '=', 'lightbox_video'),
						),
						'tooltip' => __('Select video from gallery or paste Youtube or Vimeo Video URL', ST_PBL),
					),

					array(
						'name' => __('Video size', ST_PBL),
						'container_class' => 'combo-group dimension-inline',
						'id' => 'video_size',
						'type' => 'dimension',
						'extended_ids' => array('video_size_width', 'video_size_height', 'video_size_width_unit'),
						'video_size_width' => array('std' => ''),
						'video_size_height' => array('std' => ''),
						'video_size_width_unit' => array(
							'options' => array('px' => 'px', '%' => '%'),
							'std' => 'px',
						),
						'tooltip' => __('Set width and height of lightbox window', ST_PBL),
						'dependency' => array(
							array('link_type', '=', 'lightbox_video'),
						),
					),

					array(
						'name' => __('Video caption', ST_PBL),
						'desc' => __('', ST_PBL),
						'id' => 'video_caption',
						'type' => 'text_Area',
						'std' => '',
						'rows' => 4,
						'dependency' => array(
							array('link_type', '=', 'lightbox_video'),
						),
					),

				),
				'styling' => array(
					array(
						'type' => 'preview',
					),
					array(
						'name' => __('Container Style', ST_PBL),
						'id' => 'image_container_style',
						'type' => 'select',
						'class' => 'input-sm',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_container_style()),
						'options' => ST_Pb_Helper_Type::get_container_style(),
						'has_depend' => '1',
					),
					array(
						'name' => __('Alignment', ST_PBL),
						'id' => 'image_alignment',
						'class' => 'input-sm',
						'type' => 'radio_button_group',
						'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_text_align()),
						'dependency' => array(
							array('image_container_style', '!=', 'img-circle'),
						),
						'options' => array_merge( ST_Pb_Helper_Type::get_text_align(), array(
							'fit'   => __( '<i class="fa fa-align-justify" title="Fit to sides"></i>', ST_PBL )
						) ),
						'css' => array(
						    array('.st-img-container img', 'width', '100%', array(
						        array('image_alignment', '=', 'fit'),
						    )),
						    array('.st-img-container', 'float', 'left', array(
						        array('image_alignment', '=', 'left'),
						    )),
						    array('.st-img-container', 'float', 'right', array(
						        array('image_alignment', '=', 'right'),
						    )),
						    array('.st-img-container', 'text-align', 'center', array(
						        array('image_alignment', '=', 'center'),
						    )),
						),
					),
					array(
						'name' => __('Alignment', ST_PBL),
						'id' => 'circle_center',
						'class' => 'input-sm',
						'type' => 'radio_button_group',
						'std' => '',
						'options' => array(
							'' => __( 'Default', ST_PBL ),
							'center'  => __( '<i class="st-icon-align-center" title="Center"></i>', ST_PBL ),
						),
						'dependency' => array(
							array('image_container_style', '=', 'img-circle'),
						),
						'css' => array(
						    array('.st-img-container', 'margin', '0 auto', array(
						        array('circle_center', '=', 'center'),
						    )),
						),
					),
					array(
						'name' => __('Margin', ST_PBL),
						'container_class' => 'combo-group',
						'id' => 'image_margin',
						'type' => 'margin',
						'extended_ids' => array('image_margin_top', 'image_margin_right', 'image_margin_bottom', 'image_margin_left'),
						'image_margin_top' => array('std' => ''),
						'image_margin_bottom' => array('std' => ''),
						'tooltip' => __('External spacing with other elements', ST_PBL),
                        'append'               => 'px',
                        'css' => array(
                            array('', 'margin')
                        )
					),
					ST_Pb_Helper_Type::get_apprearing_animations(),
					ST_Pb_Helper_Type::get_animation_speeds(),

				),
			);
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			$arr_params = shortcode_atts($this->config['params'], $atts);
			extract($arr_params);
			$html_elemments = $script = '';
			$alt_text = ($image_alt) ? " alt='{$image_alt}'" : '';


			$class_img = ($image_container_style != 'no-styling') ? $image_container_style : '';
			$class_img = ($image_effect == 'yes') ? $class_img . ' image-scroll-fade' : $class_img;
			$class_img = (!empty($class_img)) ? ' class="' . $class_img . '"' : '';

			if ($image_file) {
				$image_id = ST_Pb_Helper_Functions::get_image_id($image_file);

				// ------------------------------------------------------
				//  yunus edit - if file attachment not found with original url then try to find it relatively
				// ------------------------------------------------------
				if (!$image_id) {
					$try = preg_match('/wp\-content\/uploads\/sites\/[0-9]+\/.+/i', $image_file, $match);

					if ($try) {
						$match = $match[0];
						$match = preg_replace('/\/sites\/[0-9]+/', '', $match);
					} else {
						$try = preg_match('/wp\-content\/uploads\/.+/i', $image_file, $match);

						if ($try) {
							$match = $match[0];
							$match = preg_replace('/\/sites\/[0-9]+/', '', $match);
						}
					}

					if ($try) {
						if (is_multisite()) {
							$upload_dir = wp_upload_dir();
							$match = preg_replace('/wp\-content\/uploads\//i', '', $match);
							$match = $upload_dir['baseurl'] . '/' . $match;
						} else {
							$match = site_url($match);
						}

						// change protocol to site protocol
						//$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
						//$match = str_ireplace(array('http://', 'https://'), $protocol, $match);

						$image_id = ST_Pb_Helper_Functions::get_image_id($match);
					}

					//die();
				}

				$attachment = wp_prepare_attachment_for_js($image_id);
				$image_file = (!empty($attachment['sizes'][$image_size]['url'])) ? $attachment['sizes'][$image_size]['url'] : $image_file;

				$data = array();
				$script = '';
				$target = '';

				// ------------------------------------------------------
				//  YUNUS EDIT - only use image if the file is local
				// ------------------------------------------------------
				if ($attachment) {
					$data = getimagesize($image_file);

					$width = $data[0];
					$height = $data[1];
					$html_elemments .= "<img width='{$width}' height='{$height}' src='{$image_file}'{$alt_text}{$class_img} />";

					$script = '';
					$target = '';

					if ($image_effect == 'yes' AND !isset($_POST['action'])) {
						$html_elemments = "<img src='" . ST_Pb_Helper_Functions::path('assets/3rd-party') . '/jquery-lazyload/grey.gif' . "' data-original='{$image_file}' width='{$width}' height='{$height}' {$alt_text} {$class_img}/>";
					}
				} else {
					$html_elemments .= "<img src='{$image_file}'{$alt_text}{$class_img} />";

					if ($image_effect == 'yes' AND !isset($_POST['action'])) {
						$html_elemments = "<img src='" . ST_Pb_Helper_Functions::path('assets/3rd-party') . '/jquery-lazyload/grey.gif' . "' data-original='{$image_file}' {$alt_text} {$class_img}/>";
					}
				}

				$rel = '';

				if ($open_in) {
					switch ($open_in) {
					case 'current_browser':
						$target = '';
						break;
					case 'new_browser':
						$target = ' target="_blank"';
						break;
					case 'new_window':
						$cls_button_fancy = 'st-button-new-window';
						$script = ST_Pb_Helper_Functions::new_window(".$cls_button_fancy", array('width' => '75%', 'height' => '75%'));
						break;
					case 'lightbox':
						$cls_button_fancy = 'prettyphoto';
						$rel = 'rel="prettyPhoto[rel-' . rand() . ']"';
						break;
					}
				}

				$class = (isset($cls_button_fancy) && !empty($cls_button_fancy)) ? " class='{$cls_button_fancy}'" : '';

				// get Single Item and check type to get right link
				$single_item = explode('__#__', $single_item);
				$single_item = $single_item[0];
				$taxonomies = ST_Pb_Helper_Type::get_public_taxonomies();
				$post_types = ST_Pb_Helper_Type::get_post_types();
				// single post
				if (array_key_exists($link_type, $post_types)) {
					$permalink = get_permalink($single_item);

					if ($open_in == 'lightbox') {
						$permalink .= '?iframe=true&width=100%&height=100%';
					}

					$html_elemments = "<a {$rel} href='{$permalink}'{$target}{$class}>" . $html_elemments . '</a>';
				}
				// taxonomy
			else if (array_key_exists($link_type, $taxonomies)) {
				$permalink = get_term_link(intval($single_item), $link_type);
				if (!is_wp_error($permalink)) {
					if ($open_in == 'lightbox') {
						$permalink .= '?iframe=true&width=100%&height=100%';
					}

					$html_elemments = "<a {$rel} href='{$permalink}'{$target}{$class}>" . $html_elemments . '</a>';}
			} else {
				switch ($link_type) {
				case 'url':
					if ($open_in == 'lightbox') {
						$image_type_url .= '?iframe=true&width=100%&height=100%';
					}

					$html_elemments = "<a {$rel} href='{$image_type_url}'{$target}{$class}>" . $html_elemments . '</a>';
					break;
				case 'large_image':
					$image_id = ST_Pb_Helper_Functions::get_image_id($image_file);
					$attachment = wp_prepare_attachment_for_js($image_id);
					$image_url = (!empty($attachment['sizes'][$image_image_size]['url'])) ? $attachment['sizes'][$image_image_size]['url'] : $image_file;
					$html_elemments = "<a {$rel} href='{$image_url}'{$target}{$class}>" . $html_elemments . '</a>';
					break;
				case 'lightbox_video':
					if (!$video_url) {
						break;
					}

					$url_args = array();
					switch (ST_Pb_Helper_Functions::get_video_type($video_url)) {
					case 'youtube':
							
						break;

					default:
						$url_args['iframe'] = 'true';
						break;
					}

					if ($video_size_width) {
						$url_args['width'] = $video_size_width . $video_size_width_unit;
					}

					if ($video_size_height) {
						$url_args['height'] = $video_size_height;
					}

					// add all args to url
					$video_url = add_query_arg($url_args, $video_url);

					$html_elemments = '<a href="' . $video_url . '" rel="prettyPhoto" title="' . esc_attr($video_caption) . '">' . $html_elemments . '</a>';
					break;

				}
			}

			$container_style = '';
			if($image_container_style == 'img-circle')
			{
				$html_elemments = '<span>'.$html_elemments.'</span>';
				$container_style .= ' max-width:'.$width.'px';
			}


			$html_elemments = "<div class='st-img-container {$image_container_style}-container' style='{$container_style}'>" . $html_elemments . '</div>';
		}

		return $this->element_wrapper($html_elemments . $script, $arr_params);
	}
}

endif;
